/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ+\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJsParsingHelper;", "", "whiteSpace", "Lcom/intellij/psi/tree/IElementType;", "semicolon", "identifier", "keywordClass", "Ljava/lang/Class;", "referenceExpression", "useStatement", "showStatement", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Ljava/lang/Class;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;)V", "parseShowStatement", "", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseUseStatement", "rawLookup", "toSkip", "", "(Lcom/intellij/lang/PsiBuilder;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/tree/IElementType;", "Companion", "intellij.database.dialects.mongo"})
public final class MongoJsParsingHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType whiteSpace;
    @NotNull
    private final IElementType semicolon;
    @NotNull
    private final IElementType identifier;
    @NotNull
    private final Class<?> keywordClass;
    @NotNull
    private final IElementType referenceExpression;
    @NotNull
    private final IElementType useStatement;
    @NotNull
    private final IElementType showStatement;
    @NotNull
    private static final String[] SHOW_COMMANDS;

    public MongoJsParsingHelper(@NotNull IElementType whiteSpace, @NotNull IElementType semicolon, @NotNull IElementType identifier, @NotNull Class<?> keywordClass, @NotNull IElementType referenceExpression, @NotNull IElementType useStatement, @NotNull IElementType showStatement) {
        Intrinsics.checkNotNullParameter((Object)whiteSpace, (String)"whiteSpace");
        Intrinsics.checkNotNullParameter((Object)semicolon, (String)"semicolon");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(keywordClass, (String)"keywordClass");
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        Intrinsics.checkNotNullParameter((Object)useStatement, (String)"useStatement");
        Intrinsics.checkNotNullParameter((Object)showStatement, (String)"showStatement");
        this.whiteSpace = whiteSpace;
        this.semicolon = semicolon;
        this.identifier = identifier;
        this.keywordClass = keywordClass;
        this.referenceExpression = referenceExpression;
        this.useStatement = useStatement;
        this.showStatement = showStatement;
    }

    private final IElementType rawLookup(PsiBuilder builder, IElementType ... toSkip) {
        int i2 = 1;
        IElementType type = builder.rawLookup(i2);
        while (type != null) {
            if (!ArrayUtil.contains((Object)type, (Object[])Arrays.copyOf(toSkip, toSkip.length))) {
                return type;
            }
            type = builder.rawLookup(++i2);
        }
        return null;
    }

    public final boolean parseShowStatement(@NotNull PsiBuilder builder) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType[] iElementTypeArray = new IElementType[]{this.whiteSpace};
        if (!Intrinsics.areEqual((Object)this.rawLookup(builder, iElementTypeArray), (Object)this.identifier)) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker stmt2 = marker;
        builder.advanceLexer();
        while (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)this.identifier)) {
            builder.advanceLexer();
        }
        String text2 = builder.getTokenText();
        if (!ArrayUtil.contains((String)text2, (String[])Arrays.copyOf(objectArray = SHOW_COMMANDS, objectArray.length))) {
            objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.toString(SHOW_COMMANDS), (String)"toString(...)");
            objectArray[1] = text2;
            builder.error(SqlBundle.message((String)"parse.error.one.of.expected", (Object[])objectArray));
        }
        builder.advanceLexer();
        stmt2.done(this.showStatement);
        return true;
    }

    public final boolean parseUseStatement(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType[] iElementTypeArray = new IElementType[]{this.whiteSpace};
        IElementType type = this.rawLookup(builder, iElementTypeArray);
        if (!Intrinsics.areEqual((Object)type, (Object)this.identifier) && !this.keywordClass.isInstance(type)) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker stmt2 = marker;
        builder.advanceLexer();
        PsiBuilder.Marker marker2 = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker idMarker = marker2;
        PsiBuilder.Marker marker3 = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
        PsiBuilder.Marker idToken = marker3;
        while (!(builder.eof() || Intrinsics.areEqual((Object)builder.rawLookup(1), (Object)this.whiteSpace) || Intrinsics.areEqual((Object)builder.rawLookup(1), (Object)this.semicolon))) {
            builder.advanceLexer();
        }
        builder.advanceLexer();
        idToken.collapse(this.identifier);
        idMarker.done(this.referenceExpression);
        stmt2.done(this.useStatement);
        return true;
    }

    static {
        String[] stringArray = new String[]{"collections", "users", "roles", "profile", "profile", "dbs"};
        SHOW_COMMANDS = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJsParsingHelper$Companion;", "", "()V", "SHOW_COMMANDS", "", "", "getSHOW_COMMANDS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.database.dialects.mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getSHOW_COMMANDS() {
            return SHOW_COMMANDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

