/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cockroach;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.cockroach.CRoachElementFactory;
import com.intellij.sql.dialects.cockroach.CRoachElementTypes;
import com.intellij.sql.dialects.cockroach.CRoachTokens;
import com.intellij.sql.dialects.cockroach.CRoachTypes;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CRoachDialect
extends Pg83Dialect {
    public static final CRoachDialect INSTANCE = new CRoachDialect();

    public CRoachDialect() {
        super("Cockroach");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(CRoachTokens.class);
        if (tokensHelper == null) {
            CRoachDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COCKROACH;
        if (dbms == null) {
            CRoachDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "geography", "geography", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "uuid", "uuid", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CRoachDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection2 = LazyData.MAJOR_CHILD_KINDS;
        if (collection2 == null) {
            CRoachDialect.$$$reportNull$$$0(3);
        }
        return collection2;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == CRoachElementTypes.Kinds.FAMILY) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.PARTITION) {
            result2.add((ObjectKind)ObjectKind.INDEX);
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        return super.getParentDbTypes(result2, type);
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            CRoachDialect.$$$reportNull$$$0(4);
        }
        return (res2 = CRoachElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            CRoachDialect.$$$reportNull$$$0(5);
        }
        return super.isTableAliasAllowedAt(element2) || PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlInsertStatement.class}) != null;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition2 = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition2 == null) {
            CRoachDialect.$$$reportNull$$$0(6);
        }
        return condition2;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            CRoachDialect.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            CRoachDialect.$$$reportNull$$$0(8);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor2)) {
            return false;
        }
        return SqlImplUtil.processExcludedRefInInsertConflict(name2, place, resolve2, processor2, LazyData.RE_EXCLUDED);
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            CRoachDialect.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cockroach/CRoachDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cockroach/CRoachDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlCommonTokens.SQL_QUESTION_MARK, CRoachTypes.CROACH_OP_ABS, SqlCommonTokens.SQL_OP_NOT2, CRoachTypes.CROACH_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_CONCAT, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.PG_OP_PRIME, CRoachTypes.CROACH_OP_CUSTOM, SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_DIV_INT, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_PLUS_EQ, SqlCommonTokens.SQL_OP_MINUS_EQ, SqlCommonTokens.SQL_OP_MUL_EQ, SqlCommonTokens.SQL_OP_DIV_EQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQEQ, SqlCommonTokens.SQL_OP_NEQ3, SqlCommonTokens.SQL_OP_MODULO_EQ, SqlCommonTokens.SQL_OP_BITWISE_AND_EQ, SqlCommonTokens.SQL_OP_BITWISE_OR_EQ, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2);
        static final ReservedEntity RE_EXCLUDED = new ReservedEntity(Dbms.POSTGRES, "excluded", ObjectKind.TABLE);
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.KEY, ObjectKind.INDEX);

        LazyData() {
        }
    }
}

