/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.clickhouse.types.CHouseMapType;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Case;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.clickhouse.CHouseElementTypes;
import com.intellij.sql.dialects.clickhouse.CHouseLexer;
import com.intellij.sql.dialects.clickhouse.CHouseOptionalKeywords;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.clickhouse.CHouseTypes;
import com.intellij.sql.dialects.clickhouse.refactoring.CHouseExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseDialect
extends SqlLanguageDialectBase {
    public static final CHouseDialect INSTANCE = new CHouseDialect();

    public CHouseDialect() {
        super("ClickHouse");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        return new TokensHelper(CHouseTokens.class, new SuffixedBuiltinFunctions());
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.ANY_NA);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.STRING_OR_TOKEN);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.STRING_OR_SCHEMA);
        SqlFunctionsUtil.addSimpleType(myTypes, "UInt8", "UInt8", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "UInt16", "UInt16", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "UInt32", "UInt32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "UInt64", "UInt64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "UInt256", "UInt256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int8", "Int8", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int16", "Int16", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int32", "Int32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int64", "Int64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int128", "Int128", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Int256", "Int256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Float32", "Float32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Float64", "Float64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Decimal", "Decimal", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Decimal32", "Decimal32", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Decimal64", "Decimal64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Decimal128", "Decimal128", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Decimal256", "Decimal256", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Date", "Date", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "DateTime", "DateTime", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "DateTime64", "DateTime64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalSecond", "IntervalSecond", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalMinute", "IntervalMinute", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalHour", "IntervalHour", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalDay", "IntervalDay", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalWeek", "IntervalWeek", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalMonth", "IntervalMonth", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalQuarter", "IntervalQuarter", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IntervalYear", "IntervalYear", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "String", "String", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "FixedString", "FixedString", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.ARRAY);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.TUPLE);
        SqlFunctionsUtil.addSimpleType(myTypes, "Enum", "Enum", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "UUID", "UUID", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Expression", "Expression", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "LowCardinality", "LowCardinality", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "Map", "Map", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IPv4", "IPv4", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "IPv6", "IPv6", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.AGGREGATE_FUNCTION);
        SqlFunctionsUtil.addSimpleType(myTypes, Types.SIMPLE_AGGREGATE_FUNCTION);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        if (processor2.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity.Typed entity : LazyData.RE_COLUMNS) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple(entity, entity.type, name2, place, resolve2, processor2, true, true)) continue;
                return false;
            }
        }
        if (place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity type : LazyData.ourObjects) {
                if (CHouseDialect.processReservedEntitiesWithTypeSimple(type, DasTypeSystemBase.REFERENCE, name2, place, resolve2, processor2, true, resolve2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CHouseDialect.getDefaultNamespace(dataSource2, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                CHouseDialect.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource2, dsNames, true);
        if (treePattern == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        return treePattern;
    }

    public static SqlTableType filterComputedColumns(@NotNull SqlTableType type) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        SqlTableType resultType = type;
        int i2 = 0;
        while (i2 < resultType.getColumnCount()) {
            PsiElement columnSource = resultType.getSourceColumnElement(i2);
            if (columnSource instanceof PsiColumn && SqlImplUtil.isComputedVal((PsiColumn)columnSource)) {
                resultType = SubtractedSqlTableTypeImpl.subtract(resultType, i2);
                continue;
            }
            ++i2;
        }
        return resultType;
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        return CHouseDialect.isOpIn(place) && !(place.getParent() instanceof SqlReferenceExpression);
    }

    @Override
    @NotNull
    public Set<BuiltinFunction.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression, SqlReferenceExpression.class);
        if (ref2 != null) {
            ObjectKind kind = ref2.getReferenceElementType().getTargetKind();
            if (kind == CHouseElementTypes.Kinds.TABLE_ENGINE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.TABLE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(8);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DATABASE_ENGINE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DATABASE_ENGINE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(9);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.CODEC) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.CODEC_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(10);
                }
                return enumSet;
            }
            if (kind == SqlDbElementType.INDEXTYPE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.INDEX_TYPE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(11);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DICTIONARY_SOURCE) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DICTIONARY_SOURCE_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(12);
                }
                return enumSet;
            }
            if (kind == CHouseElementTypes.Kinds.DICTIONARY_LAYOUT) {
                EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.DICTIONARY_LAYOUT_SPEC);
                if (enumSet == null) {
                    CHouseDialect.$$$reportNull$$$0(13);
                }
                return enumSet;
            }
        }
        Set<BuiltinFunction.Location> set = super.getExpectedFunctionLocations(expression);
        if (set == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        return CHouseLexer.isValidRawToken(text2);
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        return LazyData.SPECIAL_FUNCTION_REFERENCES.contains(elementType);
    }

    @Override
    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        DasObject parent2;
        DasObject object = symbol != null ? symbol.getDasObject() : null;
        DasObject dasObject = parent2 = object != null ? object.getDasParent() : null;
        if (object instanceof SqlRoutineDefinition) {
            return super.shouldHide(symbol, place);
        }
        return object instanceof DasRoutine && parent2 != null && parent2.getKind() == ObjectKind.ROOT;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return res2;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        if ((type == ObjectKind.VIEW || type == ObjectKind.MAT_VIEW || type == CHouseElementTypes.Kinds.DICTIONARY) && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && (expectedTypes.contains(CHouseElementTypes.Kinds.TABLE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.DATABASE_ENGINE) || expectedTypes.contains(CHouseElementTypes.Kinds.CODEC) || expectedTypes.contains(SqlDbElementType.INDEXTYPE) || expectedTypes.contains(CHouseElementTypes.Kinds.DICTIONARY_SOURCE) || expectedTypes.contains(CHouseElementTypes.Kinds.DICTIONARY_LAYOUT))) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref2) {
        if (ref2 == null) {
            CHouseDialect.$$$reportNull$$$0(19);
        }
        return !this.getKeywords().contains(ref2);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != ObjectKind.FORMAT && type != ObjectKind.PARTITION && super.shallResolve(o2, type);
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiReference ref2) {
        SqlReferenceExpression prevRef;
        if (processor2 == null) {
            CHouseDialect.$$$reportNull$$$0(20);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        if (ref2 == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (!CHouseDialect.processAliases(processor2, state, ref2)) {
            return false;
        }
        PsiElement place = ref2.getElement();
        if (SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.TABLE) && ObjectUtils.tryCast((Object)place.getParent(), SqlExpressionList.class) != null && (prevRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)place, SqlExpression.class), SqlReferenceExpression.class)) != null && prevRef.getReferenceElementType().getTargetKind() == ObjectKind.SCHEMA && !SqlImplUtil.processQualifier(prevRef, processor2, state, place)) {
            return false;
        }
        return super.processUnqualifiedResolve(processor2, state, ref2);
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull SqlReference ref2, @NotNull DasType qualifierType) {
        if (processor2 == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        if (state == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        if (ref2 == null) {
            CHouseDialect.$$$reportNull$$$0(25);
        }
        if (qualifierType == null) {
            CHouseDialect.$$$reportNull$$$0(26);
        }
        if (SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.COLUMN)) {
            if (qualifierType instanceof DasArrayType) {
                DasArrayType arrayType = (DasArrayType)qualifierType;
                return this.processQualifiedResolve(processor2, state, ref2, arrayType.getComponentType());
            }
            if (qualifierType instanceof CHouseMapType) {
                for (ReservedEntity entity : LazyData.RE_MAP_COLUMNS) {
                    if (CHouseDialect.processReservedEntitiesWithTypeSimple(entity, null, ref2.getReferenceName(), ref2.getElement(), true, processor2, true, true)) continue;
                    return false;
                }
            }
        }
        return super.processQualifiedResolve(processor2, state, ref2, qualifierType);
    }

    @Override
    public boolean processTypeExtra(SqlTableType type, SqlScopeProcessor processor2, ResolveState state, PsiElement place) {
        for (DasSymbol pc : CHouseDialect.getParentColumnObjects(place.getContainingFile(), type)) {
            if (processor2.execute(pc, state)) continue;
            return false;
        }
        return super.processTypeExtra(type, processor2, state, place);
    }

    @Override
    @NotNull
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        CHouseExtractFunctionHelper cHouseExtractFunctionHelper = CHouseExtractFunctionHelper.INSTANCE;
        if (cHouseExtractFunctionHelper == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        return cHouseExtractFunctionHelper;
    }

    private static boolean isOpIn(@Nullable PsiElement place) {
        SqlBinaryExpression exp;
        SqlBinaryExpression sqlBinaryExpression = exp = place == null ? null : (SqlBinaryExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlBinaryExpression.class);
        if (exp == null || exp.getROperand() != place) {
            return place == null;
        }
        return exp.getOpSign() == SqlCommonKeywords.SQL_IN;
    }

    @NotNull
    public static List<DasSymbol> getParentColumnObjects(@NotNull PsiFile file, @Nullable SqlTableType type) {
        if (file == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        if (type == null || type.getTypeElement() instanceof MyAggColumnDefinition) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(29);
            }
            return list;
        }
        HashMap<String, List> grouped = null;
        int c2 = type.getColumnCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            String name2 = type.getColumnName(i2);
            int dotIdx = name2.indexOf(46);
            if (dotIdx == -1) continue;
            if (grouped == null) {
                grouped = new HashMap<String, List>();
            }
            grouped.computeIfAbsent(name2.substring(0, dotIdx), __ -> new ArrayList()).add((PsiElement)ObjectUtils.chooseNotNull((Object)type.getSourceColumnElement(i2), (Object)type.getColumnElement(i2)));
        }
        if (grouped == null) {
            List<DasSymbol> list = Collections.emptyList();
            if (list == null) {
                CHouseDialect.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList<DasSymbol> res2 = new ArrayList<DasSymbol>(grouped.size());
        ConcurrentMap caches = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)CollectionFactory.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        for (Map.Entry entry : grouped.entrySet()) {
            res2.add((DasSymbol)((Object)caches.computeIfAbsent(Pair.create((Object)((String)entry.getKey()), (Object)((List)entry.getValue())), param -> new MyAggColumnDefinition((PsiElement)((List)param.second).get(0), (String)param.first, (List)param.second))));
        }
        ArrayList<DasSymbol> arrayList = res2;
        if (arrayList == null) {
            CHouseDialect.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public static boolean isNestedType(@NotNull SqlColumnDefinition o1) {
        SqlTypeElement type;
        if (o1 == null) {
            CHouseDialect.$$$reportNull$$$0(32);
        }
        if (PsiUtilCore.getElementType((PsiElement)(type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)o1, SqlTypeElement.class))) != SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT) {
            return false;
        }
        SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)type, SqlReferenceExpression.class);
        return ref2 != null && ref2.getName().equals("Nested");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 7, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractFunctionHelper";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentColumnObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterComputedColumns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentColumnObjects";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNestedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 6, 7, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 32 -> new IllegalArgumentException(string);
        };
    }

    private static class SuffixedBuiltinFunctions
    implements SqlLanguageDialectEx.BuiltinFunctions {
        private final SqlLanguageDialectEx.BuiltinFunctions myDelegate = SqlFunctionsUtil.loadFunctionDefinition(INSTANCE);
        private final Map<String, BuiltinFunction> myCache = ConcurrentFactoryMap.create(this::computeDef, ContainerUtil::createConcurrentSoftValueMap);

        private SuffixedBuiltinFunctions() {
        }

        @Override
        @Nullable
        public BuiltinFunction get(@Nullable String name2) {
            if (name2 == null) {
                return null;
            }
            BuiltinFunction base = this.getImpl(name2);
            if (base != null && !"true".equals(base.getDialectAttribute("aggregate"))) {
                return base;
            }
            return this.myCache.get(name2);
        }

        @Nullable
        private BuiltinFunction computeDef(@NotNull String name2) {
            if (name2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(0);
            }
            BuiltinFunction base = this.getImpl(name2);
            BuiltinFunction suffixed = this.getSuffixed(name2);
            if (base == null) {
                return suffixed;
            }
            if (suffixed == null) {
                return base;
            }
            BuiltinFunction.Prototype[] baseProtos = base.getPrototypes();
            BuiltinFunction.Prototype[] suffixProtos = suffixed.getPrototypes();
            ArrayList<BuiltinFunction.Prototype> newProtos = new ArrayList<BuiltinFunction.Prototype>(baseProtos.length + suffixProtos.length);
            Collections.addAll(newProtos, baseProtos);
            for (BuiltinFunction.Prototype proto2 : suffixProtos) {
                BuiltinFunction.Prototype newProto = new BuiltinFunction.Prototype(proto2.getFunction(), proto2.getReturnType(), proto2.getPrototypeId() + baseProtos.length, proto2.getHeadBlock(), proto2.getParams(), proto2.getAttributes());
                newProtos.add(newProto);
            }
            return new BuiltinFunction(base.getName(), base.getAliasedFunction(), base.getDialectAttrs(), newProtos, base.getDbms());
        }

        @Nullable
        private BuiltinFunction getSuffixed(@NotNull String name2) {
            Suffix suffix2;
            if (name2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(1);
            }
            if ((suffix2 = Suffix.find(name2)) == null) {
                return null;
            }
            BuiltinFunction def = this.myDelegate.get(name2 = suffix2.trim(name2));
            if (def != null && !"true".equals(def.getDialectAttribute("aggregate"))) {
                return null;
            }
            if (def == null) {
                def = this.getSuffixed(name2);
            }
            return def == null ? null : suffix2.modify(def);
        }

        @Override
        public boolean contains(@Nullable String name2) {
            if (this.getImpl(name2) != null) {
                return true;
            }
            while (name2 != null) {
                Suffix suffix2 = Suffix.find(name2);
                if (suffix2 == null) {
                    return false;
                }
                BuiltinFunction def = this.myDelegate.get(name2 = suffix2.trim(name2));
                if (def == null) continue;
                return "true".equals(def.getDialectAttribute("aggregate"));
            }
            return false;
        }

        @Nullable
        private BuiltinFunction getImpl(@Nullable String name2) {
            BuiltinFunction def = this.myDelegate.get(name2);
            if (def != null || name2 == null) {
                return def;
            }
            def = this.myDelegate.get(Case.LOWER.apply(name2));
            return def != null && "true".equals(def.getDialectAttribute("insensitive")) ? def : null;
        }

        @Override
        @NotNull
        public Iterable<BuiltinFunction> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(2);
            }
            Iterable<BuiltinFunction> iterable = this.myDelegate.byMatcher(matcher);
            if (iterable == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(3);
            }
            return iterable;
        }

        @Override
        @NotNull
        public Collection<BuiltinFunction> forTokens() {
            Collection<BuiltinFunction> collection2 = this.myDelegate.forTokens();
            if (collection2 == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(4);
            }
            return collection2;
        }

        @Override
        @Nullable
        public SqlLanguageDialectEx.BuiltinFunctions typeMethods(@NotNull String typeName, boolean forInstance) {
            if (typeName == null) {
                SuffixedBuiltinFunctions.$$$reportNull$$$0(5);
            }
            return this.myDelegate.typeMethods(typeName, forInstance);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeDef";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuffixed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "typeMethods";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static enum Suffix {
            If{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Parameter[] oldParams = p2.getParams();
                    boolean broken = oldParams.length != 0 && 1.isGreedy(oldParams[oldParams.length - 1]);
                    BuiltinFunction.Parameter[] params2 = new BuiltinFunction.Parameter[oldParams.length + (broken ? 1 : 2)];
                    System.arraycopy(oldParams, 0, params2, 0, oldParams.length);
                    BuiltinFunction.Parameter[] argSeq = broken ? new BuiltinFunction.Parameter[2] : params2;
                    argSeq[argSeq.length - 2] = COMMA.copyWithPrototype(p2.getPrototypeId());
                    argSeq[argSeq.length - 1] = COND.copyWithPrototype(p2.getPrototypeId());
                    if (broken) {
                        params2[params2.length - 1] = new BuiltinFunction.ParameterBlock(p2.getPrototypeId(), BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE, argSeq, false);
                    }
                    return new BuiltinFunction.Prototype(null, p2.getReturnType(), p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }

                private static boolean isGreedy(BuiltinFunction.Parameter param) {
                    if (param.isMany()) {
                        return true;
                    }
                    BuiltinFunction.ParameterBlock block = (BuiltinFunction.ParameterBlock)ObjectUtils.tryCast((Object)param, BuiltinFunction.ParameterBlock.class);
                    if (block == null || block.getBlockType() == BuiltinFunction.ParameterBlockType.CHOICE) {
                        return false;
                    }
                    if (block.getBlockType() == BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE) {
                        return true;
                    }
                    BuiltinFunction.Parameter[] params2 = block.getParams();
                    return params2.length == 0 || 1.isGreedy(params2[params2.length - 1]);
                }
            }
            ,
            Array{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Parameter[] params2 = Suffix.makeArrayParams(p2.getParams());
                    BuiltinFunction.Type ret = p2.getReturnType();
                    if (ret instanceof BuiltinFunction.ParamType) {
                        ret = SqlFunctionsUtil.ANY;
                    }
                    return new BuiltinFunction.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            }
            ,
            Map{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Parameter[] params2 = Suffix.makeMapParams(p2.getParams());
                    return new BuiltinFunction.Prototype(null, Types.TUPLE, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            }
            ,
            SimpleState{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    return new BuiltinFunction.Prototype(null, Types.SIMPLE_AGGREGATE_FUNCTION, p2.getPrototypeId(), p2.getHeadBlock(), p2.getParams(), p2.getAttributes());
                }
            }
            ,
            State{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    return new BuiltinFunction.Prototype(null, Types.AGGREGATE_FUNCTION, p2.getPrototypeId(), p2.getHeadBlock(), p2.getParams(), p2.getAttributes());
                }
            }
            ,
            Merge{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Type ret = p2.getReturnType();
                    if (ret instanceof BuiltinFunction.ParamType) {
                        ret = SqlFunctionsUtil.ANY;
                    }
                    return new BuiltinFunction.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), new BuiltinFunction.Parameter[]{STATE.copyWithPrototype(p2.getPrototypeId())}, p2.getAttributes());
                }
            }
            ,
            ForEach{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Parameter[] params2 = Suffix.makeArrayParams(p2.getParams());
                    return new BuiltinFunction.Prototype(null, Types.ARRAY, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            }
            ,
            OrDefault{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Type ret = p2.getReturnType();
                    BuiltinFunction.Parameter[] params2 = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p2.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            }
            ,
            OrNull{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Type ret = p2.getReturnType();
                    BuiltinFunction.Parameter[] params2 = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p2.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            }
            ,
            Distinct{

                @Override
                protected BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype p2) {
                    BuiltinFunction.Type ret = p2.getReturnType();
                    BuiltinFunction.Parameter[] params2 = (BuiltinFunction.Parameter[])ArrayUtil.copyOf((Object[])p2.getParams());
                    return new BuiltinFunction.Prototype(null, ret, p2.getPrototypeId(), p2.getHeadBlock(), params2, p2.getAttributes());
                }
            };

            private static final BuiltinFunction.Parameter COMMA;
            private static final BuiltinFunction.Parameter COND;
            private static final BuiltinFunction.Parameter STATE;
            private final Map<BuiltinFunction, BuiltinFunction> myCache = ConcurrentFactoryMap.create(this::modifyDef, ContainerUtil::createConcurrentSoftValueMap);

            boolean at(String s2) {
                return this.name().length() < s2.length() && s2.endsWith(this.name());
            }

            String trim(String s2) {
                return s2.substring(0, s2.length() - this.name().length());
            }

            BuiltinFunction modify(@NotNull BuiltinFunction def) {
                if (def == null) {
                    Suffix.$$$reportNull$$$0(0);
                }
                return this.myCache.get(def);
            }

            private BuiltinFunction modifyDef(BuiltinFunction def) {
                BuiltinFunction.Prototype[] protos = def.getPrototypes();
                ArrayList<BuiltinFunction.Prototype> newProtos = new ArrayList<BuiltinFunction.Prototype>(protos.length);
                for (BuiltinFunction.Prototype proto2 : protos) {
                    newProtos.add(this.modifyProto(proto2));
                }
                return new BuiltinFunction(def.getName() + this.name(), def.getAliasedFunction(), def.getDialectAttrs(), newProtos, def.getDbms());
            }

            protected abstract BuiltinFunction.Prototype modifyProto(BuiltinFunction.Prototype var1);

            @NotNull
            private static BuiltinFunction.Parameter[] makeArrayParams(BuiltinFunction.Parameter[] oldParams) {
                BuiltinFunction.Parameter[] parameterArray = (BuiltinFunction.Parameter[])ContainerUtil.map2Array((Object[])oldParams, BuiltinFunction.Parameter.class, param -> Suffix.makeArrayParam(param));
                if (parameterArray == null) {
                    Suffix.$$$reportNull$$$0(1);
                }
                return parameterArray;
            }

            @NotNull
            private static BuiltinFunction.Parameter[] makeMapParams(BuiltinFunction.Parameter[] oldParams) {
                BuiltinFunction.Parameter[] parameterArray = (BuiltinFunction.Parameter[])ContainerUtil.map2Array((Object[])oldParams, BuiltinFunction.Parameter.class, param -> Suffix.makeMapParam(param));
                if (parameterArray == null) {
                    Suffix.$$$reportNull$$$0(2);
                }
                return parameterArray;
            }

            private static BuiltinFunction.Parameter makeArrayParam(BuiltinFunction.Parameter p2) {
                if (p2 instanceof BuiltinFunction.SimpleParameter) {
                    return new BuiltinFunction.SimpleParameter(p2.getPrototypeId(), ((BuiltinFunction.SimpleParameter)p2).getName(), Types.ARRAY, p2.isMany());
                }
                if (p2 instanceof BuiltinFunction.ParameterBlock) {
                    return new BuiltinFunction.ParameterBlock(p2.getPrototypeId(), ((BuiltinFunction.ParameterBlock)p2).getBlockType(), Suffix.makeArrayParams(((BuiltinFunction.ParameterBlock)p2).getParams()), p2.isMany());
                }
                return p2;
            }

            private static BuiltinFunction.Parameter makeMapParam(BuiltinFunction.Parameter p2) {
                if (p2 instanceof BuiltinFunction.SimpleParameter) {
                    return new BuiltinFunction.SimpleParameter(p2.getPrototypeId(), ((BuiltinFunction.SimpleParameter)p2).getName(), Types.TUPLE, p2.isMany());
                }
                if (p2 instanceof BuiltinFunction.ParameterBlock) {
                    return new BuiltinFunction.ParameterBlock(p2.getPrototypeId(), ((BuiltinFunction.ParameterBlock)p2).getBlockType(), Suffix.makeMapParams(((BuiltinFunction.ParameterBlock)p2).getParams()), p2.isMany());
                }
                return p2;
            }

            @Nullable
            static Suffix find(@NotNull String s2) {
                if (s2 == null) {
                    Suffix.$$$reportNull$$$0(3);
                }
                for (Suffix suffix2 : Suffix.values()) {
                    if (!suffix2.at(s2)) continue;
                    return suffix2;
                }
                return null;
            }

            static {
                COMMA = new BuiltinFunction.SyntaxParameter(0, ",");
                COND = new BuiltinFunction.SimpleParameter(0, "cond", INSTANCE.getBuiltInTypes().get("B"), false);
                STATE = new BuiltinFunction.SimpleParameter(0, "state", Types.AGGREGATE_FUNCTION, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "def";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$SuffixedBuiltinFunctions$Suffix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeArrayParams";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeMapParams";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "modify";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "find";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
    }

    static final class Types {
        static final BuiltinFunction.Type ANY_NA = SqlFunctionsUtil.newType("ANY_NA", DataTypeFactory.of("any"));
        static final BuiltinFunction.Type STRING_OR_TOKEN = SqlFunctionsUtil.newType("StringOrToken", DataTypeFactory.of("String"));
        static final BuiltinFunction.Type STRING_OR_SCHEMA = SqlFunctionsUtil.newType("StringOrSchema", DataTypeFactory.of("String"));
        static final BuiltinFunction.Type ARRAY = SqlFunctionsUtil.newType("Array", DataTypeFactory.of("Array"));
        static final BuiltinFunction.Type TUPLE = SqlFunctionsUtil.newType("Tuple", DataTypeFactory.of("Tuple"));
        static final BuiltinFunction.Type AGGREGATE_FUNCTION = SqlFunctionsUtil.newType("AggregateFunction", DataTypeFactory.of("AggregateFunction"));
        static final BuiltinFunction.Type SIMPLE_AGGREGATE_FUNCTION = SqlFunctionsUtil.newType("SimpleAggregateFunction", DataTypeFactory.of("SimpleAggregateFunction"));

        Types() {
        }
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{CHouseTypes.CH_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, CHouseOptionalKeywords.CH_SOUNDS);
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final List<ReservedEntity.Typed> RE_COLUMNS;
        static final List<ReservedEntity> RE_MAP_COLUMNS;
        static final TokenSet SPECIAL_FUNCTION_REFERENCES;

        LazyData() {
        }

        static {
            RE_MAP_COLUMNS = Arrays.asList(new ReservedEntity(Dbms.CLICKHOUSE, "keys", ObjectKind.COLUMN), new ReservedEntity(Dbms.CLICKHOUSE, "values", ObjectKind.COLUMN));
            DasTypeSystemBase typeSystem = DasTypeSystems.getTypeSystem(Dbms.CLICKHOUSE);
            RE_COLUMNS = Arrays.asList(new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part", ObjectKind.COLUMN, typeSystem.getStringType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_part_index", ObjectKind.COLUMN, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_sample_factor", ObjectKind.COLUMN, typeSystem.getRealType()), new ReservedEntity.Typed(Dbms.CLICKHOUSE, "_table", ObjectKind.COLUMN, typeSystem.getStringType()));
            SPECIAL_FUNCTION_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{CHouseElementTypes.Extra.CH_TABLE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_DATABASE_ENGINE_REFERENCE, CHouseElementTypes.Extra.CH_CODEC_REFERENCE, CHouseElementTypes.Extra.CH_INDEX_TYPE_REFERENCE, CHouseElementTypes.Extra.CH_DICTIONARY_SOURCE_REFERENCE, CHouseElementTypes.Extra.CH_DICTIONARY_LAYOUT_REFERENCE});
        }
    }

    private static class MyAggColumnDefinition
    extends MyColumnDefinition {
        private final List<PsiElement> myColumns;

        MyAggColumnDefinition(PsiElement parent2, String name2, List<PsiElement> columns2) {
            super(parent2, name2);
            this.myColumns = columns2;
        }

        @Override
        @NotNull
        public DasType getDasType() {
            String preName = this.getName();
            ArrayList<MyColumnDefinition> columns2 = new ArrayList<MyColumnDefinition>(this.myColumns.size());
            for (PsiElement column2 : this.myColumns) {
                String name2 = column2 instanceof DasObject ? ((DasObject)column2).getName() : "";
                String cName = name2.length() <= preName.length() ? name2 : name2.substring(preName.length() + 1);
                columns2.add((MyColumnDefinition)((Object)CachedValuesManager.getCachedValue((PsiElement)column2, () -> CachedValueProvider.Result.create((Object)((Object)new MyColumnDefinition(column2, cName)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))));
            }
            return new TableBasedSqlTableTypeImpl(columns2, (PsiElement)this);
        }
    }

    private static class MyColumnDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        MyColumnDefinition(PsiElement parent2, String name2) {
            super(parent2, name2);
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.CLICKHOUSE;
            if (dbms == null) {
                MyColumnDefinition.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public Language getLanguage() {
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(this.getParent());
            if (sqlLanguageDialectEx == null) {
                MyColumnDefinition.$$$reportNull$$$0(1);
            }
            return sqlLanguageDialectEx;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.getParent();
            if (psiElement == null) {
                MyColumnDefinition.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public boolean isNameQuoted() {
            return false;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnDefinition.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @NotNull
        public DasType getDasType() {
            PsiElement parent2 = this.getParent();
            DasType dasType = INSTANCE.getTypeSystem().getDasType(null, parent2, DasSymbolUtil.getSymbolByPsi(parent2));
            if (dasType == null) {
                MyColumnDefinition.$$$reportNull$$$0(4);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return true;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/clickhouse/CHouseDialect$MyColumnDefinition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

