/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.bigquery.BigQueryTokens;
import com.intellij.sql.dialects.bigquery.psi.BigQueryAsExpressionImpl;
import com.intellij.sql.dialects.bigquery.psi.BigQueryParenthesizedExpression;
import com.intellij.sql.dialects.bigquery.refactoring.BigQueryExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BigQueryDialect
extends SqlLanguageDialectBase {
    public static final BigQueryDialect INSTANCE = new BigQueryDialect();

    public BigQueryDialect() {
        super("BigQuery");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(BigQueryTokens.class);
        if (tokensHelper == null) {
            BigQueryDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.BIGQUERY;
        if (dbms == null) {
            BigQueryDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            BigQueryDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            BigQueryDialect.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            BigQueryDialect.$$$reportNull$$$0(4);
        }
        if (processor2.isExpected(ObjectKind.VARIABLE)) {
            for (ReservedEntity var : LazyData.systemVars) {
                if (!SqlImplUtil.equalsInsensitiveOrTrue(name2, var.name, resolve2) || processor2.executeTarget((DasSymbol)var, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            BigQueryDialect.$$$reportNull$$$0(5);
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.TABLE)) {
            BigQueryAsExpressionImpl as;
            PsiElement psi = DasSymbolUtil.getSinglePsiSource(symbol);
            return psi instanceof BigQueryAsExpressionImpl && (as = (BigQueryAsExpressionImpl)psi).isUnnestExpression();
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            BigQueryDialect.$$$reportNull$$$0(6);
        }
        if (type == ObjectKind.VIRTUAL_TABLE && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            BigQueryAsExpressionImpl as;
            PsiElement psi = DasSymbolUtil.getSinglePsiSource(symbol);
            if (psi != null && psi.getParent() instanceof BigQueryParenthesizedExpression) {
                return true;
            }
            return psi instanceof BigQueryAsExpressionImpl && (as = (BigQueryAsExpressionImpl)psi).isUnnestExpression();
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "INT64", "INT64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "FLOAT64", "FLOAT64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "NUMERIC", "NUMERIC", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "ARRAY", "ARRAY", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "BYTES", "BYTES", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "STRING", "STRING", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "GEOGRAPHY", "GEOGRAPHY", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "BIGNUMERIC", "BIGNUMERIC", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "JSON", "JSON", (SqlLanguageDialectEx)this);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type == ObjectKind.TABLE) {
            res2.add((ObjectKind)ObjectKind.TABLE);
        }
        return res2;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != ObjectKind.PACKAGE && type != ObjectKind.CONNECTION && super.shallResolve(o2, type);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames) {
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, TreePatternUtils.create(Arrays.asList(ObjectName.plain("main"), ObjectName.plain("temp")), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern2) {
        if (pattern2 == null) {
            BigQueryDialect.$$$reportNull$$$0(7);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern2, dsNames, Arrays.asList(ObjectName.plain("main"), ObjectName.plain("temp")), true, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            BigQueryDialect.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false)));
    }

    @Override
    @NotNull
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        BigQueryExtractFunctionHelper bigQueryExtractFunctionHelper = BigQueryExtractFunctionHelper.INSTANCE;
        if (bigQueryExtractFunctionHelper == null) {
            BigQueryDialect.$$$reportNull$$$0(9);
        }
        return bigQueryExtractFunctionHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractFunctionHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        private static final Set<String> ourSystemVarsWithTypes = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final List<ReservedEntity> systemVars = ContainerUtil.map(ourSystemVarsWithTypes, name2 -> {
            int colon = name2.indexOf(58);
            String n = colon == -1 ? name2 : name2.substring(0, colon);
            String type = colon == -1 ? null : name2.substring(colon + 1);
            return type == null ? new ReservedEntity(Dbms.BIGQUERY, n, ObjectKind.VARIABLE) : new ReservedEntity.Typed(Dbms.BIGQUERY, n, ObjectKind.VARIABLE, DasUnresolvedTypeReference.of(DataTypeFactory.of(type)));
        });
        static final Set<String> ourSystemVars = ContainerUtil.map2Set(systemVars, var -> var.name);
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;

        LazyData() {
        }
    }
}

