/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.editor.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDeepSyntaxHighlighter
extends SqlSyntaxHighlighter {
    private final Map<String, SyntaxHighlighter> myHighlighters;
    private final IElementType myInjectionTokenType;
    @NotNull
    private final Factory<? extends Lexer> myBaseLexerFactory;

    public SqlDeepSyntaxHighlighter(@NotNull SqlLanguageDialect dialect, @Nullable Project project, @Nullable VirtualFile file, @NotNull Factory<? extends Lexer> factory, @Nullable IElementType injectionTokenType) {
        if (dialect == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        super(dialect, project, file);
        this.myHighlighters = ConcurrentFactoryMap.createMap(l -> SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)l), (Object)Language.ANY)), (Project)this.getProject(), null));
        this.myBaseLexerFactory = factory;
        this.myInjectionTokenType = (IElementType)ObjectUtils.notNull((Object)injectionTokenType, (Object)SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        PsiLanguageInjectionHost host = this.findInjectionHost();
        Language hostLanguage = SqlPreprocessingLexer.getHostLanguage((PsiElement)host);
        return new MyLayeredLexer((Lexer)this.myBaseLexerFactory.create(), Objects.requireNonNull(this.getDialect()), hostLanguage, new LayersCache());
    }

    @Override
    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        Language language;
        if (tokenType instanceof SqlTokenType.SqlInjectionMark) {
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(this.myInjectionTokenType);
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        Language language2 = language = tokenType == null ? Language.ANY : tokenType.getLanguage();
        if (!(language instanceof SqlLanguageDialect) && language != SqlLanguage.INSTANCE && language != Language.ANY) {
            SyntaxHighlighter highlighter = this.myHighlighters.get(language.getID());
            TextAttributesKey[] textAttributesKeyArray = highlighter == null ? SqlDeepSyntaxHighlighter.pack(null) : highlighter.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(4);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/SqlDeepSyntaxHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/SqlDeepSyntaxHighlighter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class MyLayeredLexer
    extends SqlSyntaxHighlighter.MyLayeredLexer {
        private final LayersCache myCache;

        MyLayeredLexer(@NotNull Lexer lexer, @NotNull SqlLanguageDialect dialect, @Nullable Language hostLanguage, @NotNull LayersCache cache2) {
            if (lexer == null) {
                MyLayeredLexer.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyLayeredLexer.$$$reportNull$$$0(1);
            }
            if (cache2 == null) {
                MyLayeredLexer.$$$reportNull$$$0(2);
            }
            super(SqlPreprocessingLexer.withPreprocessingIfNeeded(lexer, (Language)dialect, hostLanguage, DatabaseSettings.getSettings()), dialect.getDbms());
            this.myCache = cache2;
        }

        @Nullable
        protected Lexer findLayerLexer(IElementType baseTokenType) {
            Lexer lexer = super.findLayerLexer(baseTokenType);
            if (lexer != null) {
                return lexer;
            }
            if (baseTokenType instanceof SqlTokenType.SqlInjectionMark) {
                String injection2 = ((SqlTokenType.SqlInjectionMark)baseTokenType).getInjection();
                if (injection2.equals("sql") || injection2.equals("pgsql")) {
                    return (Lexer)this.myCache.recursiveLexers.get((Object)this);
                }
                return this.myCache.terminalLexers.get(injection2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cache";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/base/SqlDeepSyntaxHighlighter$MyLayeredLexer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LayersCache {
        Map<String, Lexer> terminalLexers = FactoryMap.create(inj -> {
            SqlLanguageDialect dialect = Objects.requireNonNull(SqlDeepSyntaxHighlighter.this.getDialect());
            Pair<Language, String> spec2 = SqlFunctionBodyInjector.getBlockByLangSpec(inj, null, (Language)dialect);
            if (spec2 == null || spec2.first == null) {
                return null;
            }
            LightVirtualFile file = spec2.second == null ? null : new LightVirtualFile("inj." + (String)spec2.second, (Language)spec2.first, (CharSequence)"");
            return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((Language)spec2.first), (Project)SqlDeepSyntaxHighlighter.this.getProject(), (VirtualFile)file).getHighlightingLexer();
        });
        Map<MyLayeredLexer, MyLayeredLexer> recursiveLexers = FactoryMap.create(l -> new MyLayeredLexer((Lexer)SqlDeepSyntaxHighlighter.this.myBaseLexerFactory.create(), Objects.requireNonNull(SqlDeepSyntaxHighlighter.this.getDialect()), (Language)SqlDeepSyntaxHighlighter.this.getDialect(), l.myCache));

        private LayersCache() {
        }
    }
}

