/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlImportUtil {
    public static final ObjectKind DATA_SOURCE = ObjectKind.ROOT;
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted("SOME NON MATCHING NAME");
    public static final ObjectName[] NON_MATCHING_NAMES = (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{NON_MATCHING_NAME});

    private SqlImportUtil() {
    }

    @NotNull
    public static ObjectName getDataSourceName(@NotNull DasDataSource dataSource2) {
        String id;
        if (dataSource2 == null) {
            SqlImportUtil.$$$reportNull$$$0(0);
        }
        ObjectName objectName = ObjectName.quoted(StringUtil.isEmpty((String)(id = dataSource2.getUniqueId())) ? dataSource2.getName() : id);
        if (objectName == null) {
            SqlImportUtil.$$$reportNull$$$0(1);
        }
        return objectName;
    }

    public static ObjectName @Nullable [] getRealDsNames(@Nullable DbDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        if (!(dataSource2.getDelegate() instanceof SqlDataSource)) {
            return (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{SqlImportUtil.getDataSourceName(dataSource2)});
        }
        SmartList res2 = new SmartList();
        do {
            res2.add(SqlImportUtil.getDataSourceName(dataSource2));
        } while ((dataSource2 = dataSource2.getDelegate() instanceof SqlDataSource ? ((SqlDataSource)dataSource2.getDelegate()).getParentDataSource() : null) != null);
        return ObjectName.toArray((Iterable<ObjectName>)res2);
    }

    @NotNull
    public static TreePatternNode.Group createDataSources(ObjectName @Nullable [] names2, TreePatternNode.Group ... groups2) {
        TreePatternNode.Group group2 = TreePatternUtils.create(names2 == null ? NON_MATCHING_NAMES : names2, DATA_SOURCE, groups2);
        if (group2 == null) {
            SqlImportUtil.$$$reportNull$$$0(2);
        }
        return group2;
    }

    @NotNull
    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile sqlFile) {
        SqlDataSource sqlDs2;
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(3);
        }
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(4);
        }
        if ((sqlDs2 = SqlImportUtil.getSqlDataSource(ds, sqlFile)) != null) {
            TreePattern pattern2 = SqlImportUtil.createSqlDataSourceScopeIfAny(ds, sqlDs2, language, sqlFile);
            TreePattern treePattern = pattern2 != null ? pattern2 : language.getDefaultImports(ds);
            if (treePattern == null) {
                SqlImportUtil.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = language.getDefaultImports(ds);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static SqlDataSource getSqlDataSource(@Nullable DbDataSource ds, @NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(7);
        }
        SqlDataSource sqlDs2 = ds == null ? null : (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
        return sqlDs2 != null && sqlDs2.containsFile(sqlFile.getVirtualFile()) ? sqlDs2 : null;
    }

    @Nullable
    public static TreePattern createScopePatternIfAny(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile sqlFile) {
        SqlDataSource sqlDs2;
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(8);
        }
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(9);
        }
        return (sqlDs2 = SqlImportUtil.getSqlDataSource(ds, sqlFile)) != null ? SqlImportUtil.createSqlDataSourceScopeIfAny(ds, sqlDs2, language, sqlFile) : null;
    }

    @Nullable
    private static TreePattern createSqlDataSourceScopeIfAny(@NotNull DbDataSource dbDs, @NotNull SqlDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile file) {
        VirtualFile vfile;
        ObjectPath scope;
        if (dbDs == null) {
            SqlImportUtil.$$$reportNull$$$0(10);
        }
        if (ds == null) {
            SqlImportUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(12);
        }
        if (file == null) {
            SqlImportUtil.$$$reportNull$$$0(13);
        }
        ObjectPath objectPath = scope = (vfile = file.getVirtualFile()) == null ? null : ds.getScope(vfile, language.getDbms());
        if (scope != null) {
            ObjectName[] names2 = SqlImportUtil.getRealDsNames(dbDs);
            TreePattern res2 = SqlDialectImplUtilCore.createObjectPattern(names2, language.getDbms(), scope, (TreePatternNode.Group[])null);
            return language.applyImplicitImports(names2, res2);
        }
        return null;
    }

    @NotNull
    public static TreePattern processResolveScopePattern(@NotNull TreePattern resolvePattern, @Nullable TreePattern defaultPattern) {
        if (resolvePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(14);
        }
        TreePatternUtils.GroupedGroupFactory factory = new TreePatternUtils.GroupedGroupFactory(){
            private boolean myAccept = false;
            private TreePatternNode.Group myUnAccept = null;

            @Override
            protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups2) {
                TreePatternNode.Group second;
                TreePatternNode.Group first2;
                if (this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it2 = groups2.iterator();
                TreePatternNode.Group group2 = first2 = it2.hasNext() ? it2.next() : null;
                if (first2 != null) {
                    return;
                }
                TreePatternNode.Group group3 = second = it2.hasNext() ? it2.next() : null;
                if (second == null) {
                    return;
                }
                this.myAccept = true;
                this.myUnAccept = second;
            }

            @Override
            protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups2) {
                TreePatternNode.Group second;
                if (!this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it2 = groups2.iterator();
                if (it2.hasNext()) {
                    it2.next();
                }
                TreePatternNode.Group group2 = second = it2.hasNext() ? it2.next() : null;
                if (second != this.myUnAccept) {
                    return;
                }
                this.myAccept = false;
                this.myUnAccept = null;
            }

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterator<TreePatternNode.Group> it2 = value2.iterator();
                return this.myAccept || it2.hasNext() && it2.next() != null;
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Iterator<TreePatternNode> it2 = value2.iterator();
                return this.myAccept || it2.hasNext() && it2.next() != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            @Override
            public boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups2) {
                return !1.containsNotNull(groups2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        List<TreePattern> patterns2 = defaultPattern != null ? Arrays.asList(resolvePattern, defaultPattern) : Collections.singletonList(resolvePattern);
        TreePattern treePattern = factory.merge(patterns2);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(15);
        }
        return treePattern;
    }

    private static TreePatternNode.Group @Nullable [] removeNulls(TreePatternNode.Group @Nullable [] groups2) {
        if (groups2 == null) {
            return null;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group group2 : groups2) {
            if (group2 == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return TreePatternNode.NO_GROUPS;
        }
        if (nonNulls == groups2.length) {
            return groups2;
        }
        TreePatternNode.Group[] newGroups = new TreePatternNode.Group[nonNulls];
        int i2 = 0;
        for (TreePatternNode.Group group3 : groups2) {
            if (group3 == null) continue;
            newGroups[i2++] = group3;
        }
        return newGroups;
    }

    @NotNull
    public static TreePattern createPattern(@NotNull List<?> names2, @NotNull List<ObjectKind> kinds, TreePatternNode.Group @Nullable [] tail) {
        if (names2 == null) {
            SqlImportUtil.$$$reportNull$$$0(16);
        }
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(17);
        }
        TreePatternNode.Group[] children2 = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)SqlImportUtil.removeNulls(tail), (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names2.size(); ++i2) {
            TreePatternNode n;
            Object name2 = names2.get(i2);
            ObjectKind kind = kinds.get(i2);
            if (name2 == null) {
                n = new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, children2);
            } else {
                TreePatternNode.PositiveNaming naming;
                if (name2 instanceof ObjectName) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName)name2);
                } else if (name2 instanceof ObjectName[]) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName[])name2);
                } else if (name2 instanceof Iterable) {
                    naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)name2));
                } else {
                    throw new AssertionError((Object)("Unexpected: " + name2.getClass().getSimpleName()));
                }
                n = new TreePatternNode(naming, children2);
            }
            children2 = new TreePatternNode.Group[]{new TreePatternNode.Group(kind, new TreePatternNode[]{n})};
        }
        return new TreePattern(children2);
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull Dbms dbms) {
        BasicMetaModel<?> metaModel;
        JBIterable<List<ObjectKind>> roots2;
        ArrayList<ObjectKind> root2;
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(18);
        }
        if (dbms == null) {
            SqlImportUtil.$$$reportNull$$$0(19);
        }
        if ((root2 = (ArrayList<ObjectKind>)(roots2 = (metaModel = DbImplUtilCore.getMetaModel(dbms)).getPathsToRoot(kind)).first()) == null || root2.isEmpty() || !roots2.skip(1).isEmpty()) {
            Logger.getInstance(metaModel.getClass()).warn("To many roots from " + kind);
            return null;
        }
        root2 = new ArrayList<ObjectKind>(root2);
        assert (!root2.isEmpty());
        assert (root2.get(root2.size() - 1) == ObjectKind.ROOT);
        root2.set(root2.size() - 1, DATA_SOURCE);
        return root2;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref2, @NotNull ObjectKind refKind, @NotNull Dbms dbms) {
        if (ref2 == null) {
            SqlImportUtil.$$$reportNull$$$0(20);
        }
        if (refKind == null) {
            SqlImportUtil.$$$reportNull$$$0(21);
        }
        if (dbms == null) {
            SqlImportUtil.$$$reportNull$$$0(22);
        }
        assert (refKind != SqlDbElementType.ANY);
        List<ObjectKind> kinds = SqlImportUtil.getSingleRootPath(refKind, dbms);
        if (kinds == null) {
            return null;
        }
        SmartList names2 = new SmartList();
        names2.add(new ObjectName(ref2.getName(), !ref2.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref2.getQualifierExpression(), SqlReferenceExpression.class);
        while (names2.size() < kinds.size()) {
            names2.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtil.createPattern(names2, kinds, null);
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    @Nullable
    public static TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name2, @NotNull ObjectKind kind, TreePatternNode.Group ... groups2) {
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(23);
        }
        return name2 == null ? null : TreePatternUtils.create(name2, kind, groups2);
    }

    @Nullable
    public static TreePattern getResolveScopePattern(@NotNull SqlFile file) {
        if (file == null) {
            SqlImportUtil.$$$reportNull$$$0(24);
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(file.getProject());
        VirtualFile vFile = SqlImplUtil.getTopLevelFile((PsiFile)file);
        return (TreePattern)mapping.getMapping(vFile);
    }

    @NotNull
    public static TreePatternNode.Group createPositiveDatabase(@NotNull ObjectName name2, TreePatternNode.Group ... groups2) {
        if (name2 == null) {
            SqlImportUtil.$$$reportNull$$$0(25);
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(name2, ObjectKind.DATABASE, groups2);
        if (group2 == null) {
            SqlImportUtil.$$$reportNull$$$0(26);
        }
        return group2;
    }

    @Nullable
    public static TreePatternNode.Group createPositiveDatabase(boolean useNonMatching, @Nullable ObjectName name2, TreePatternNode.Group ... groups2) {
        return name2 == null && !useNonMatching ? null : TreePatternUtils.create((ObjectName)ObjectUtils.chooseNotNull((Object)name2, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups2);
    }

    @NotNull
    public static TreePattern createAddPattern(ObjectName @Nullable [] ds, ObjectKind @NotNull [] kinds) {
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(27);
        }
        TreePatternNode.Group[] children2 = TreePatternNode.NO_GROUPS;
        for (int i2 = kinds.length - 1; i2 >= 0; --i2) {
            children2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{kinds[i2] == DATA_SOURCE && ds != null ? SqlImportUtil.createDataSources(ds, children2) : TreePatternUtils.create((ObjectName)null, kinds[i2], children2)});
        }
        return new TreePattern(children2);
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull TreePattern pattern2, ObjectName @Nullable [] dsNames, @NotNull List<ObjectName> names2, boolean atBegin, ObjectKind ... path) {
        if (pattern2 == null) {
            SqlImportUtil.$$$reportNull$$$0(28);
        }
        if (names2 == null) {
            SqlImportUtil.$$$reportNull$$$0(29);
        }
        if (path == null) {
            SqlImportUtil.$$$reportNull$$$0(30);
        }
        ObjectKind targetKind = path[path.length - 1];
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern2, SqlImportUtil.createAddPattern(dsNames, path), (g2, parent2, parentKind) -> {
            if (parent2 instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g2.kind != targetKind) {
                return g2;
            }
            SmartList notFound = new SmartList();
            for (ObjectName name2 : names2) {
                if (g2.matchedChildren(name2, null, null)) continue;
                notFound.add(name2);
            }
            if (notFound.isEmpty()) {
                return g2;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable<ObjectName>)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g2);
            builder.children.add(atBegin ? 0 : builder.children.size(), new TreePatternNode(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g2.kind);
        });
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(31);
        }
        return treePattern;
    }

    @Nullable
    public static TreePatternNode.Group getRootGroup(boolean schemaRoot, MultiMap<String, String> databases2, boolean integrateStar) {
        return schemaRoot ? SqlImportUtil.getSchemaGroup(databases2) : SqlImportUtil.getDbGroup(databases2, integrateStar);
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroup(MultiMap<String, String> databases2) {
        if (!databases2.containsKey((Object)"*")) {
            return null;
        }
        return SqlImportUtil.getSchemaGroups(databases2.get((Object)"*"));
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroups(Collection<String> schemas2) {
        if (schemas2.contains("*")) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
        }
        if (schemas2.isEmpty()) {
            return null;
        }
        return TreePatternUtils.create(JBIterable.from(schemas2).transform(n -> ObjectName.quoted(n)).toList(), ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
    }

    @Nullable
    public static TreePatternNode.Group getDbGroup(MultiMap<String, String> databases2, boolean integrateStar) {
        if (databases2.containsKey((Object)"*") && !integrateStar) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.DATABASE, TreePatternNode.NO_GROUPS);
        }
        if (databases2.size() == 0) {
            return null;
        }
        ArrayList<TreePatternNode.Group> gr = new ArrayList<TreePatternNode.Group>();
        for (Map.Entry entry : databases2.entrySet()) {
            TreePatternNode.Group sgr = SqlImportUtil.getSchemaGroups((Collection)entry.getValue());
            gr.add(TreePatternUtils.create(((String)entry.getKey()).equals("*") ? null : ObjectName.quoted((String)entry.getKey()), ObjectKind.DATABASE, SqlImportUtil.optAr(sgr)));
        }
        return TreePatternUtils.UNION_PROCESSOR.mergeGroups(ObjectKind.DATABASE, gr);
    }

    public static TreePatternNode.Group[] optAr(TreePatternNode.Group x) {
        return x == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{x});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 15, 26, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvePattern";
                break;
            }
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refKind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultScopePattern";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processResolveScopePattern";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositiveDatabase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectsByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 26: 
            case 31: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultScopePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDataSource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createScopePatternIfAny";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDataSourceScopeIfAny";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processResolveScopePattern";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSingleRootPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNodeIfNotNull";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopePattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveDatabase";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createAddPattern";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addObjectsByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 15, 26, 31 -> new IllegalStateException(string);
        };
    }
}

