/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportBuilder {
    public static final SqlImportBuilder INSTANCE = new SqlImportBuilder();

    protected boolean maybeImportStatement(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImportBuilder.$$$reportNull$$$0(0);
        }
        return element2 instanceof SqlUseDatabaseStatement && DbSqlUtilCore.getFileResolveMode(element2) == SqlFileResolveMode.SCRIPT;
    }

    @NotNull
    protected SqlImportState produceNextState(@NotNull SqlImportState current, @NotNull SqlImportState.Shared shared, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement element2) {
        if (current == null) {
            SqlImportBuilder.$$$reportNull$$$0(1);
        }
        if (shared == null) {
            SqlImportBuilder.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            SqlImportBuilder.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            SqlImportBuilder.$$$reportNull$$$0(4);
        }
        SqlUseDatabaseStatement statement2 = (SqlUseDatabaseStatement)element2;
        return new SqlImportState((PsiElement)statement2, false, shared, dialect.processImports(statement2, current.state), current);
    }

    @NotNull
    public SqlImportState buildImports(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(5);
        }
        SqlFileResolveMode mode = DbSqlUtilCore.getFileResolveMode((PsiElement)sqlFile);
        TreePattern overlay = SqlDialectImplUtilCore.buildOverlayPattern(sqlFile);
        SqlImportState.Shared originalShared = new SqlImportState.Shared(sqlFile, overlay);
        SqlImportState.Shared nextShared = mode == SqlFileResolveMode.SCRIPT ? new SqlImportState.Shared(sqlFile, null) : originalShared;
        SqlImportState current = new SqlImportState(null, false, originalShared, SqlImportBuilder.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (PsiElement element2 : JBIterable.from((Iterable)sqlFile.getDdl()).filter(e2 -> this.maybeImportStatement((PsiElement)e2))) {
            current = this.produceNextState(current, nextShared, language, element2);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            SqlImportBuilder.$$$reportNull$$$0(6);
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        TreePattern resolvePattern;
        SearchPath searchPath;
        SqlFile hostFile;
        SqlFile orig;
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(7);
        }
        if ((orig = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class)) != null && orig != sqlFile) {
            return SqlImportBuilder.calcInitialImportState(orig);
        }
        VirtualFile vfile = sqlFile.getVirtualFile();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        if (host == null) {
            host = sqlFile.getContext();
        }
        SqlFile sqlFile2 = hostFile = host == null ? null : (SqlFile)ObjectUtils.tryCast((Object)host.getContainingFile(), SqlFile.class);
        if (hostFile != null && SqlImplUtil.getSqlDialectSafe((PsiElement)hostFile) == SqlImplUtil.getSqlDialectSafe((PsiElement)sqlFile)) {
            SqlImportState at = SqlDialectImplUtilCore.getImportCheckerAt(hostFile, (PsiElement)host);
            TreePattern treePattern = at.state;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            String dataSourceId = DbSrcUtilsCore.getDataSource(vfile);
            DbDataSource ds2 = dataSourceId == null ? null : DbPsiFacade.getInstance(sqlFile.getProject()).findDataSource(dataSourceId);
            SearchPath searchPath2 = DatabaseEditorHelperCore.dbSrcSearchPath(sqlFile.getProject(), vfile, true);
            TreePattern treePattern = searchPath2 != null ? language.srcFilePattern(ds2, searchPath2) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        if (vfile instanceof DatabaseElementVirtualFileImpl) {
            DbElement o2 = ((DatabaseElementVirtualFileImpl)vfile).findElement(sqlFile.getProject());
            SearchPath searchPath3 = ObjectPaths.searchPathOf(DbImplUtilCore.getSearchPathObject(language.getDatabaseDialect(), o2));
            TreePattern treePattern = searchPath3 != null && o2 != null ? language.srcFilePattern(o2.getDataSource(), searchPath3) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getValidConsole(sqlFile.getProject(), vfile);
        SearchPath searchPath4 = searchPath = console != null ? console.getSearchPath() : null;
        if (searchPath != null) {
            JBIterable<DbDataSource> dataSources2 = SqlImportBuilder.getFilteredDataSources(sqlFile, null);
            TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> language.srcFilePattern((DbDataSource)ds, searchPath)));
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(11);
            }
            return treePattern;
        }
        TreePattern treePattern = resolvePattern = console == null ? SqlImportUtil.getResolveScopePattern(sqlFile) : null;
        if (resolvePattern != null && !TreePatternUtils.isWildcard(resolvePattern.root.getGroup(SqlImportUtil.DATA_SOURCE))) {
            JBIterable<DbDataSource> dataSources3 = SqlImportBuilder.getFilteredDataSources(sqlFile, resolvePattern);
            JBIterable scopePatterns = dataSources3.filterMap(ds -> SqlImportUtil.createScopePatternIfAny(ds, language, sqlFile));
            TreePattern scopePattern = scopePatterns.isNotEmpty() ? TreePatternUtils.union((Iterable<TreePattern>)scopePatterns) : null;
            TreePattern pattern2 = SqlImportUtil.processResolveScopePattern(resolvePattern, scopePattern);
            pattern2 = (TreePattern)dataSources3.reduce((Object)pattern2, (p2, ds) -> language.applyImplicitImports(SqlImportUtil.getRealDsNames(ds), (TreePattern)p2));
            TreePattern treePattern2 = language.applyImplicitImports(null, pattern2);
            if (treePattern2 == null) {
                SqlImportBuilder.$$$reportNull$$$0(12);
            }
            return treePattern2;
        }
        return SqlImportBuilder.getDefaultInitialPattern(sqlFile, null);
    }

    @NotNull
    private static JBIterable<DbDataSource> getFilteredDataSources(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        boolean all2;
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(13);
        }
        TreePatternNode.Group group2 = filter2 == null ? null : filter2.root.getGroup(SqlImportUtil.DATA_SOURCE);
        boolean bl = all2 = filter2 == null || TreePatternUtils.isWildcard(group2);
        if (!all2 && group2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImportBuilder.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        JBIterable res2 = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        if (!all2) {
            res2 = res2.filter(ds -> {
                SqlDataSource sql = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sql != null && sql.containsFile(sqlFile.getVirtualFile()) || group2.matchedChildren(SqlImportUtil.getDataSourceName(ds), Casing.EXACT, null);
            });
        }
        JBIterable jBIterable = res2;
        if (jBIterable == null) {
            SqlImportBuilder.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    private static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(16);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources2 = SqlImportBuilder.getFilteredDataSources(sqlFile, filter2);
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language, sqlFile)).append((Object)SqlImportUtil.createDefaultScopePattern(null, language, sqlFile)));
        if (treePattern == null) {
            SqlImportBuilder.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(18);
        }
        return SqlImportBuilder.getDefaultInitialPattern(sqlFile, SqlImportUtil.getResolveScopePattern(sqlFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitialImportState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDataSources";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitialPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "maybeImportStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "produceNextState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildImports";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialImportState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDataSources";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitialPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

