/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StatusText;
import icons.DatabaseIcons;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlDataSourceRootsList {
    private final SqlDataSourceConfigurable myConfigurable;
    private JBList<Root> myRootsList;

    SqlDataSourceRootsList(SqlDataSourceConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    @NotNull
    private CollectionListModel<Root> getRootsListModel() {
        CollectionListModel collectionListModel = (CollectionListModel)this.myRootsList.getModel();
        if (collectionListModel == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(0);
        }
        return collectionListModel;
    }

    public JComponent createPanel() {
        this.myRootsList = new JBList((ListModel)new CollectionListModel((Object[])new Root[0]));
        StatusText text2 = this.myRootsList.getEmptyText();
        text2.clear();
        text2.appendText(DatabaseBundle.message("status.text.no.ddl.files.folders.added", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e2 -> this.doChooseFiles());
        this.myRootsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() != 2) {
                    return;
                }
                e2.consume();
                Root sel = (Root)SqlDataSourceRootsList.this.myRootsList.getSelectedValue();
                if (sel == null) {
                    return;
                }
                if (sel.myType == Root.Type.NAMED_SCOPE) {
                    SqlDataSourceRootsList.this.editNamedScope(sel.myRoot);
                } else if (sel.myType == Root.Type.ANONYMOUS_SCOPE) {
                    SqlDataSourceRootsList.editAnonymousScope(SqlDataSourceRootsList.this.myConfigurable.getProject(), SqlDataSourceRootsList.compile(sel.myRoot));
                }
            }
        });
        this.myRootsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Root>(){

            protected void customizeCellRenderer(@NotNull JList list, Root value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value2.myType == Root.Type.DATA_SOURCE) {
                    DasDataSource dataSource2 = value2.getDataSource(SqlDataSourceRootsList.this.myConfigurable.getController());
                    this.customizeRenderer(dataSource2);
                } else if (value2.myType == Root.Type.NAMED_SCOPE) {
                    NamedScope scope = NamedScopeManager.getInstance((Project)SqlDataSourceRootsList.this.myConfigurable.getProject()).getScope(value2.myRoot);
                    this.customizeRenderer(scope);
                } else if (value2.myType == Root.Type.ANONYMOUS_SCOPE) {
                    this.customizeAnonymousScopeRenderer(value2.myRoot);
                } else {
                    this.customizeRenderer(value2.myRoot);
                }
            }

            private void customizeRenderer(DasDataSource dataSource2) {
                if (dataSource2 == null) {
                    this.setIcon(DatabaseIcons.Dbms);
                    this.append(DatabaseBundle.message("non.existing.data.source", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.setIcon(dataSource2.getIcon(0));
                    this.append(dataSource2.getName());
                }
            }

            private void customizeRenderer(NamedScope scope) {
                if (scope == null) {
                    this.setIcon(AllIcons.Ide.LocalScope);
                    this.append(DatabaseBundle.message("non.existing.scope", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.setIcon(scope.getIcon());
                    this.append(scope.getPresentableName());
                }
            }

            private void customizeAnonymousScopeRenderer(@NlsSafe String scope) {
                this.setIcon(AllIcons.Ide.LocalScope);
                this.append(DatabaseBundle.message("separator.scope", new Object[0]));
                this.append(" ");
                this.append(scope, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }

            private void customizeRenderer(String url) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file != null) {
                    this.append(file.getPresentableUrl(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : IconUtil.getIcon((VirtualFile)file, (int)0, (Project)SqlDataSourceRootsList.this.myConfigurable.getProject()));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)url), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceRootsList$2", "customizeCellRenderer"));
            }
        });
        return ToolbarDecorator.createDecorator(this.myRootsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SqlBundle.message((String)"action.add.ddl.files.text", (Object[])new Object[0]), null, DatabaseIcons.DdlDbms){

                    public void actionPerformed(@NotNull AnActionEvent e2) {
                        if (e2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        SqlDataSourceRootsList.this.doChooseFiles();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$4$1", "actionPerformed"));
                    }
                }, new FileScopeGroup(), new ExtendDataSourceGroup()}), button.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).show(button.getPreferredPopupPoint());
            }
        }).addExtraAction((AnAction)new DumbAwareAction(SqlBundle.message((String)"button.configure.sql.dialect", (Object[])new Object[0]), null, AllIcons.Actions.Edit){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                Root supported = (Root)ContainerUtil.find((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList(), r -> r.myType != Root.Type.NAMED_SCOPE);
                e2.getPresentation().setEnabled(supported != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                String dsId;
                if (e2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((dsId = (String)JBIterable.from((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList()).map(Root::getDataSourceId).single()) != null) {
                    DatabaseConfigEditor controller = SqlDataSourceRootsList.this.myConfigurable.getController();
                    DbDataSource tgt = (DbDataSource)ContainerUtil.find((Iterable)controller.getDataSources(), ds -> ds.getUniqueId().equals(dsId));
                    if (tgt != null) {
                        controller.navigateTo(tgt, true);
                    }
                    return;
                }
                List files2 = JBIterable.from((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList()).filterMap(Root::getRootPath).filterMap(url -> VirtualFileManager.getInstance().findFileByUrl(url)).toList();
                SqlDialectsConfigurable.openDialectsConfigurable(SqlDataSourceRootsList.this.myConfigurable.getProject(), files2);
                SqlDataSourceRootsList.this.myConfigurable.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/database/SqlDataSourceRootsList$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceRootsList$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }).createPanel();
    }

    private void editNamedScope(String scopeId) {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myConfigurable.getProject(), c2 -> ConfigurableWrapper.cast(ScopeChooserConfigurable.class, (UnnamedConfigurable)c2) != null, c2 -> {
            ScopeChooserConfigurable configurable = (ScopeChooserConfigurable)ConfigurableWrapper.cast(ScopeChooserConfigurable.class, (UnnamedConfigurable)c2);
            if (configurable != null) {
                configurable.selectNodeInTree(scopeId);
            }
        });
    }

    void saveData(@NotNull SqlDataSourceImpl dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(1);
        }
        ListModel model2 = this.myRootsList.getModel();
        ArrayList<String> urls = new ArrayList<String>();
        String parentId = null;
        String filterId = null;
        String filter2 = null;
        int len = model2.getSize();
        block6: for (int i2 = 0; i2 < len; ++i2) {
            Root root2 = (Root)model2.getElementAt(i2);
            switch (root2.myType) {
                case DATA_SOURCE: {
                    parentId = root2.myRoot;
                    continue block6;
                }
                case NAMED_SCOPE: {
                    filterId = root2.myRoot;
                    continue block6;
                }
                case ANONYMOUS_SCOPE: {
                    filter2 = root2.myRoot;
                    continue block6;
                }
                case ROOT: {
                    urls.add(root2.myRoot);
                }
            }
        }
        dataSource2.setUrls(urls);
        dataSource2.setParentUniqueId(parentId);
        dataSource2.setFilterId(filterId);
        dataSource2.setInlineFilter(filter2);
    }

    void reset(@NotNull SqlDataSourceImpl o2) {
        if (o2 == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(2);
        }
        ArrayList<Root> items2 = new ArrayList<Root>();
        if (o2.getParentUniqueId() != null) {
            items2.add(new Root(o2.getParentUniqueId(), Root.Type.DATA_SOURCE));
        }
        if (o2.getFilterId() != null) {
            items2.add(new Root(o2.getFilterId(), Root.Type.NAMED_SCOPE));
        }
        if (o2.getInlineFilter() != null) {
            items2.add(new Root(o2.getInlineFilter(), Root.Type.ANONYMOUS_SCOPE));
        }
        for (String url : o2.getUrls()) {
            items2.add(new Root(url, Root.Type.ROOT));
        }
        this.setItems(items2);
    }

    private void doChooseFiles() {
        Project project = this.myConfigurable.getProject();
        Object[] roots2 = ProjectRootManager.getInstance((Project)project).getContentRoots();
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE);
            }
        };
        if (!PlatformUtils.isDataGrip()) {
            descriptor2.setRoots((VirtualFile[])roots2);
            descriptor2.withTreeRootVisible(true);
        }
        descriptor2.setTitle(SqlBundle.message((String)"dialog.title.choose.ddl.files", (Object[])new Object[0]));
        VirtualFile tgt = (VirtualFile)ContainerUtil.getFirstItem(((SqlDataSourceImpl)this.myConfigurable.getDataSource()).getRoots());
        if (tgt == null) {
            tgt = (VirtualFile)ArrayUtil.getLastElement((Object[])roots2);
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)tgt, files2 -> {
            CollectionListModel<Root> model2 = this.getRootsListModel();
            LinkedHashSet<Root> set = new LinkedHashSet<Root>(model2.toList());
            Root.Type type = Root.Type.ROOT;
            for (VirtualFile f : files2) {
                set.add(new Root(f.getUrl(), type));
            }
            this.setItems(set);
        });
    }

    private void setItems(Iterable<Root> set) {
        CollectionListModel<Root> model2 = this.getRootsListModel();
        SqlDataSourceRootsList.setItemsImpl(model2, set);
        this.myConfigurable.updateDefaultTexts(ContainerUtil.mapNotNull((Collection)model2.getItems(), Root::getRootPath));
    }

    private static void setItemsImpl(@NotNull CollectionListModel<Root> model2, Iterable<Root> items2) {
        if (model2 == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(3);
        }
        int len = model2.getSize();
        int i2 = 0;
        for (Root s2 : items2) {
            if (i2 < len) {
                model2.setElementAt((Object)s2, i2++);
                continue;
            }
            model2.add((Object)s2);
        }
        while (i2 < len) {
            model2.removeRow(i2++);
        }
    }

    private void replaceScope(Root element2) {
        CollectionListModel<Root> model2 = this.getRootsListModel();
        int existing = ContainerUtil.indexOf((List)model2.getItems(), r -> r.myType == Root.Type.NAMED_SCOPE || r.myType == Root.Type.ANONYMOUS_SCOPE);
        if (existing == -1) {
            Root root2 = model2.getSize() > 0 ? (Root)model2.getElementAt(0) : null;
            model2.add(root2 == null || root2.myType != Root.Type.DATA_SOURCE ? 0 : 1, (Object)element2);
        } else {
            model2.setElementAt((Object)element2, existing);
        }
    }

    @Nullable
    private static PackageSet editAnonymousScope(Project project, PackageSet scope) {
        ScopeEditorPanel panel2 = new ScopeEditorPanel(project, (NamedScopesHolder)NamedScopeManager.getInstance((Project)project));
        if (scope == null) {
            panel2.rebuild(true);
        } else {
            panel2.reset(scope, null);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)panel2.getPanel());
        return builder.showAndGet() ? panel2.getCurrentScope() : null;
    }

    @Nullable
    public static PackageSet compile(@Nullable String filter2) {
        PackageSet compiled;
        try {
            compiled = filter2 == null ? null : PackageSetFactory.getInstance().compile(filter2);
        }
        catch (ParsingException e2) {
            compiled = new InvalidPackageSet(filter2);
        }
        return compiled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceRootsList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsListModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceRootsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setItemsImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class Root {
        private final String myRoot;
        private final Type myType;

        Root(@NotNull String root2, @NotNull Type type) {
            if (root2 == null) {
                Root.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Root.$$$reportNull$$$0(1);
            }
            this.myRoot = root2;
            this.myType = type;
        }

        Root(@NotNull DasDataSource ds) {
            if (ds == null) {
                Root.$$$reportNull$$$0(2);
            }
            this(ds.getUniqueId(), Type.DATA_SOURCE);
        }

        @Nullable
        DasDataSource getDataSource(DatabaseConfigEditor controller) {
            if (this.myType != Type.DATA_SOURCE) {
                return null;
            }
            DbDataSource dataSource2 = (DbDataSource)ContainerUtil.find((Iterable)controller.getDataSources(), ds -> ds.getUniqueId().equals(this.myRoot));
            return dataSource2 == null ? null : (DasDataSource)controller.getTempTargetOrTarget(dataSource2.getDelegate());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Root)) {
                return false;
            }
            Root source = (Root)o2;
            return this.myRoot.equals(source.myRoot) && this.myType == source.myType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myRoot, this.myType});
        }

        public String getDataSourceId() {
            return this.myType == Type.DATA_SOURCE ? this.myRoot : null;
        }

        public String getRootPath() {
            return this.myType == Type.ROOT ? this.myRoot : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/database/SqlDataSourceRootsList$Root";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum Type {
            ROOT,
            DATA_SOURCE,
            NAMED_SCOPE,
            ANONYMOUS_SCOPE;

        }
    }

    private class FileScopeGroup
    extends ActionGroup {
        FileScopeGroup() {
            super(SqlBundle.message((String)"action.ddl.files.scope.text", (Object[])new Object[0]), null, AllIcons.Ide.LocalScopeAction);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            NamedScopeManager scopeManager = NamedScopeManager.getInstance((Project)SqlDataSourceRootsList.this.myConfigurable.getProject());
            NamedScope[] scopes = scopeManager.getScopes();
            int len = scopes.length;
            AnAction editScopes = ActionManager.getInstance().getAction("ScopeView.EditScopes");
            AnAction[] res2 = new AnAction[editScopes == null ? len + 2 : len + 3];
            for (int i2 = 0; i2 < len; ++i2) {
                final NamedScope scope = scopes[i2];
                res2[i2] = new DumbAwareAction(scope.getPresentableName(), null, scope.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e2) {
                        if (e2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Root element2 = new Root(scope.getScopeId(), Root.Type.NAMED_SCOPE);
                        SqlDataSourceRootsList.this.replaceScope(element2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup$1", "actionPerformed"));
                    }
                };
            }
            res2[len] = Separator.getInstance();
            res2[len + 1] = new DumbAwareAction(SqlBundle.message((String)"action.anonymous.scope.text", (Object[])new Object[0]), null, AllIcons.Ide.LocalScopeAction){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    Project project;
                    PackageSet scope;
                    if (e2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((scope = SqlDataSourceRootsList.editAnonymousScope(project = SqlDataSourceRootsList.this.myConfigurable.getProject(), null)) == null) {
                        return;
                    }
                    SqlDataSourceRootsList.this.replaceScope(new Root(scope.getText(), Root.Type.ANONYMOUS_SCOPE));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup$2", "actionPerformed"));
                }
            };
            if (editScopes != null) {
                res2[len + 2] = editScopes;
            }
            if (res2 == null) {
                FileScopeGroup.$$$reportNull$$$0(0);
            }
            return res2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup", "getChildren"));
        }
    }

    private class ExtendDataSourceGroup
    extends ActionGroup {
        ExtendDataSourceGroup() {
            super(SqlBundle.message((String)"action.extend.data.source.text", (Object[])new Object[0]), null, DatabaseIcons.Dbms);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            SqlDataSourceImpl me = SqlDataSourceRootsList.this.myConfigurable.getTempDataSource();
            String id = ((SqlDataSourceImpl)SqlDataSourceRootsList.this.myConfigurable.getDataSource()).getUniqueId();
            DatabaseDialectEx dialect = me.getDatabaseDialect();
            DatabaseConfigEditor controller = SqlDataSourceRootsList.this.myConfigurable.getController();
            List parents2 = (List)JBIterable.from((Iterable)controller.getDataSources()).filter(ds -> !ds.getUniqueId().equals(id)).map(ds -> (DasDataSource)controller.getTempTargetOrTarget(ds.getDelegate())).filter(ds -> DbImplUtil.getDatabaseDialect(ds.getDbms()) == dialect).addAllTo(new ArrayList());
            parents2.sort(Comparator.comparing(DasDataSource::getName, DbPresentation.NAMES_COMPARATOR));
            AnAction[] res2 = new AnAction[parents2.size()];
            int size = parents2.size();
            for (int i2 = 0; i2 < size; ++i2) {
                final DasDataSource ds2 = (DasDataSource)parents2.get(i2);
                res2[i2] = new DumbAwareAction(ds2.getName(), null, ds2.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e2) {
                        if (e2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        CollectionListModel<Root> model2 = SqlDataSourceRootsList.this.getRootsListModel();
                        Root element2 = new Root(ds2);
                        int existing = ContainerUtil.indexOf((List)model2.getItems(), r -> r.myType == Root.Type.DATA_SOURCE);
                        if (existing == -1) {
                            model2.add(0, (Object)element2);
                        } else {
                            model2.setElementAt((Object)element2, existing);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$ExtendDataSourceGroup$1", "actionPerformed"));
                    }
                };
            }
            if (res2 == null) {
                ExtendDataSourceGroup.$$$reportNull$$$0(0);
            }
            return res2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceRootsList$ExtendDataSourceGroup", "getChildren"));
        }
    }
}

