/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.AsyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class SqlDataSourceAutoSyncManager
implements Disposable {
    private final Alarm myComputationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final Set<SqlDataSource> myPending = new LinkedHashSet<SqlDataSource>();

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(@NotNull SqlDataSource dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceAutoSyncManager.$$$reportNull$$$0(0);
        }
        if (!this.needsRefresh(dataSource2)) {
            return;
        }
        Set<SqlDataSource> set = this.myPending;
        synchronized (set) {
            if (!this.myPending.add(dataSource2)) {
                return;
            }
        }
        this.myComputationAlarm.cancelAllRequests();
        this.myComputationAlarm.addRequest(() -> this.flushRequests(), 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRequests() {
        Set<SqlDataSource> set = this.myPending;
        synchronized (set) {
            for (SqlDataSource dataSource2 : this.myPending) {
                EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                indicator.start();
                AsyncUtil.underProgress(() -> DataSourceSyncManager.getInstance().tryPerform(dataSource2, false, true), (ProgressIndicator)indicator);
            }
            this.myPending.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsRefresh(@NotNull SqlDataSource dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceAutoSyncManager.$$$reportNull$$$0(1);
        }
        SqlDataSourceImpl impl = (SqlDataSourceImpl)dataSource2;
        if (SqlDataSourceStorage.getInstance(dataSource2.getProject()).isLoading(impl) || !impl.isAutoSync()) {
            return false;
        }
        long revision = impl.getModelModificationCount();
        if (revision == impl.getModelRevision()) {
            return false;
        }
        Set<SqlDataSource> set = this.myPending;
        synchronized (set) {
            if (this.myPending.contains(dataSource2)) {
                return false;
            }
        }
        return !DataSourceSyncManager.getInstance().isActive((DasDataSource)dataSource2);
    }

    @TestOnly
    public void waitComputed(SqlDataSource dataSource2) {
        try {
            this.myComputationAlarm.drainRequestsInTest();
            DataSourceSyncManager.getInstance().whenFinished((DasDataSource)dataSource2).toFuture().get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e2) {
            ExceptionUtil.rethrow((Throwable)e2.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataSourceRemoved(SqlDataSource dataSource2) {
        Set<SqlDataSource> set = this.myPending;
        synchronized (set) {
            this.myPending.remove(dataSource2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataSource";
        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceAutoSyncManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "needsRefresh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

