/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlElementFeatures
implements ElementFeatureProvider {
    public String getName() {
        return "sql";
    }

    public Map<@NonNls String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element2, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        String lookupString;
        FrequentWords word;
        if (element2 == null) {
            SqlElementFeatures.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SqlElementFeatures.$$$reportNull$$$0(1);
        }
        if (contextFeatures == null) {
            SqlElementFeatures.$$$reportNull$$$0(2);
        }
        if ((word = FrequentWords.lookup(lookupString = element2.getLookupString())) != null) {
            return Collections.singletonMap("word", MLFeatureValue.categorical((Enum)word));
        }
        String firstWord = StringUtil.substringBefore((String)lookupString, (String)" ");
        if (firstWord != null && (word = FrequentWords.lookup(firstWord)) != null) {
            return Collections.singletonMap("starts", MLFeatureValue.categorical((Enum)word));
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "contextFeatures";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/completion/ml/SqlElementFeatures";
        objectArray[2] = "calculateFeatures";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum FrequentWords {
        SELECT,
        INSERT,
        UPDATE,
        INTO,
        FROM,
        WHERE,
        CASE,
        JOIN,
        LEFT,
        RIGHT,
        UNION,
        BY,
        AS,
        ON,
        IN,
        INDEX,
        TABLE,
        DISTINCT,
        GROUP,
        ORDER,
        COUNT,
        AVG,
        SUM,
        CREATE,
        DROP,
        ALTER,
        VALUES,
        MIN,
        MAX,
        AND,
        OR,
        ANY,
        ALL,
        EXISTS,
        LIKE,
        BETWEEN,
        EXEC;

        private static final Map<String, FrequentWords> WORDS_INDEX;

        @Nullable
        static FrequentWords lookup(String candidate) {
            return WORDS_INDEX.get(candidate.toUpperCase(Locale.ROOT));
        }

        static {
            HashMap<String, FrequentWords> index2 = new HashMap<String, FrequentWords>();
            for (FrequentWords word : FrequentWords.values()) {
                index2.put(word.toString(), word);
            }
            WORDS_INDEX = index2;
        }
    }
}

