/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlInlayHintsProviderBase;
import com.intellij.sql.SqlJoinCardinalityInlayHintsProvider;
import com.intellij.sql.joinCardinality.SqlJoinCardinalityAnalyserKt;
import com.intellij.sql.joinCardinality.SqlJoinCardinalityInfo;
import com.intellij.sql.joinCardinality.SqlJoinType;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.ui.dsl.builder.BuilderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/intellij/sql/SqlJoinCardinalityInlayHintsProvider;", "Lcom/intellij/sql/SqlInlayHintsProviderBase;", "Lcom/intellij/sql/SqlJoinCardinalityInlayHintsProvider$Settings;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getName", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCaseDescription", "case", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable$Case;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isEnabledForJoinType", "", "joinType", "Lcom/intellij/sql/joinCardinality/SqlJoinType;", "Settings", "intellij.database.sql.impl"})
public final class SqlJoinCardinalityInlayHintsProvider
extends SqlInlayHintsProviderBase<Settings> {
    @NotNull
    private final SettingsKey<Settings> key = new SettingsKey("sql.join.cardinality.hints");
    @NotNull
    private final String name;

    public SqlJoinCardinalityInlayHintsProvider() {
        String string = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.name.join.cardinality", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.name = string;
    }

    @NotNull
    public SettingsKey<Settings> getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        String string = SqlBundle.message((String)"show.the.numerical.relationship", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public String getCaseDescription(@NotNull ImmediateConfigurable.Case case_) {
        Intrinsics.checkNotNullParameter((Object)case_, (String)"case");
        switch (case_.getId()) {
            case "inner.join": {
                return SqlBundle.message((String)"inlay.sql.join.cardinality.hints.inner.join", (Object[])new Object[0]);
            }
            case "left.join": {
                return SqlBundle.message((String)"inlay.sql.join.cardinality.hints.left.join", (Object[])new Object[0]);
            }
            case "right.join": {
                return SqlBundle.message((String)"inlay.sql.join.cardinality.hints.right.join", (Object[])new Object[0]);
            }
            case "full.join": {
                return SqlBundle.message((String)"inlay.sql.join.cardinality.hints.full.join", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @NotNull
    public FactoryInlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Settings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return new FactoryInlayHintsCollector(editor2, this, settings){
            final /* synthetic */ SqlJoinCardinalityInlayHintsProvider this$0;
            final /* synthetic */ Settings $settings;
            {
                this.this$0 = $receiver;
                this.$settings = $settings;
                super($editor);
            }

            public boolean collect(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                SqlJoinExpression sqlJoinExpression = element2 instanceof SqlJoinExpression ? (SqlJoinExpression)element2 : null;
                if (sqlJoinExpression == null) {
                    return true;
                }
                SqlJoinExpression joinExpr = sqlJoinExpression;
                SqlJoinCardinalityInfo sqlJoinCardinalityInfo = SqlJoinCardinalityAnalyserKt.analyse(joinExpr);
                if (sqlJoinCardinalityInfo == null) {
                    return true;
                }
                SqlJoinCardinalityInfo cardinalityInfo = sqlJoinCardinalityInfo;
                if (this.this$0.isEnabledForJoinType(cardinalityInfo.getJoinType(), this.$settings)) {
                    PsiElement condition2 = cardinalityInfo.getCondition();
                    PresentationFactory factory = new PresentationFactory(editor2);
                    InlayPresentation presentation = factory.smallText(cardinalityInfo.getLeftCardinality().getText() + "<->" + cardinalityInfo.getRightCardinality().getText() + ":");
                    presentation = factory.roundWithBackground(presentation);
                    sink.addInlineElement(condition2.getTextOffset(), true, presentation, false);
                }
                return true;
            }
        };
    }

    public final boolean isEnabledForJoinType(@NotNull SqlJoinType joinType, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)joinType), (String)"joinType");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return switch (WhenMappings.$EnumSwitchMapping$0[joinType.ordinal()]) {
            case 1 -> settings.getShowForFullJoin();
            case 2 -> settings.getShowForLeftJoin();
            case 3 -> settings.getShowForRightJoin();
            case 4 -> settings.getShowForInnerJoin();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(settings){
            @NotNull
            private final String mainCheckboxText;
            @NotNull
            private final List<ImmediateConfigurable.Case> cases;
            {
                String string = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.main.cognitive.complexity.hints.for", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.mainCheckboxText = string;
                Object[] objectArray = new ImmediateConfigurable.Case[4];
                String string2 = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.case.inner.join", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                objectArray[0] = new ImmediateConfigurable.Case(string2, "inner.join", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowForInnerJoin();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowForInnerJoin((Boolean)value2);
                    }
                }, null);
                String string3 = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.case.left.join", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                objectArray[1] = new ImmediateConfigurable.Case(string3, "left.join", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowForLeftJoin();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowForLeftJoin((Boolean)value2);
                    }
                }, null);
                String string4 = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.case.right.join", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                objectArray[2] = new ImmediateConfigurable.Case(string4, "right.join", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowForRightJoin();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowForRightJoin((Boolean)value2);
                    }
                }, null);
                String string5 = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.case.full.join", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                objectArray[3] = new ImmediateConfigurable.Case(string5, "full.join", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowForFullJoin();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowForFullJoin((Boolean)value2);
                    }
                }, null);
                this.cases = CollectionsKt.listOf((Object[])objectArray);
            }

            @NotNull
            public DialogPanel createComponent(@NotNull ChangeListener listener2) {
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                return BuilderKt.panel((Function1)createConfigurable.createComponent.1.INSTANCE);
            }

            @NotNull
            public String getMainCheckboxText() {
                return this.mainCheckboxText;
            }

            @NotNull
            public List<ImmediateConfigurable.Case> getCases() {
                return this.cases;
            }
        };
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(false, false, false, false, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/SqlJoinCardinalityInlayHintsProvider$Settings;", "", "showForInnerJoin", "", "showForLeftJoin", "showForRightJoin", "showForFullJoin", "(ZZZZ)V", "getShowForFullJoin", "()Z", "setShowForFullJoin", "(Z)V", "getShowForInnerJoin", "setShowForInnerJoin", "getShowForLeftJoin", "setShowForLeftJoin", "getShowForRightJoin", "setShowForRightJoin", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.sql.impl"})
    public static final class Settings {
        private boolean showForInnerJoin;
        private boolean showForLeftJoin;
        private boolean showForRightJoin;
        private boolean showForFullJoin;

        public Settings(boolean showForInnerJoin, boolean showForLeftJoin, boolean showForRightJoin, boolean showForFullJoin) {
            this.showForInnerJoin = showForInnerJoin;
            this.showForLeftJoin = showForLeftJoin;
            this.showForRightJoin = showForRightJoin;
            this.showForFullJoin = showForFullJoin;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getShowForInnerJoin() {
            return this.showForInnerJoin;
        }

        public final void setShowForInnerJoin(boolean bl) {
            this.showForInnerJoin = bl;
        }

        public final boolean getShowForLeftJoin() {
            return this.showForLeftJoin;
        }

        public final void setShowForLeftJoin(boolean bl) {
            this.showForLeftJoin = bl;
        }

        public final boolean getShowForRightJoin() {
            return this.showForRightJoin;
        }

        public final void setShowForRightJoin(boolean bl) {
            this.showForRightJoin = bl;
        }

        public final boolean getShowForFullJoin() {
            return this.showForFullJoin;
        }

        public final void setShowForFullJoin(boolean bl) {
            this.showForFullJoin = bl;
        }

        public final boolean component1() {
            return this.showForInnerJoin;
        }

        public final boolean component2() {
            return this.showForLeftJoin;
        }

        public final boolean component3() {
            return this.showForRightJoin;
        }

        public final boolean component4() {
            return this.showForFullJoin;
        }

        @NotNull
        public final Settings copy(boolean showForInnerJoin, boolean showForLeftJoin, boolean showForRightJoin, boolean showForFullJoin) {
            return new Settings(showForInnerJoin, showForLeftJoin, showForRightJoin, showForFullJoin);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.showForInnerJoin;
            }
            if ((n & 2) != 0) {
                bl2 = settings.showForLeftJoin;
            }
            if ((n & 4) != 0) {
                bl3 = settings.showForRightJoin;
            }
            if ((n & 8) != 0) {
                bl4 = settings.showForFullJoin;
            }
            return settings.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Settings(showForInnerJoin=" + this.showForInnerJoin + ", showForLeftJoin=" + this.showForLeftJoin + ", showForRightJoin=" + this.showForRightJoin + ", showForFullJoin=" + this.showForFullJoin + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.showForInnerJoin);
            result2 = result2 * 31 + Boolean.hashCode(this.showForLeftJoin);
            result2 = result2 * 31 + Boolean.hashCode(this.showForRightJoin);
            result2 = result2 * 31 + Boolean.hashCode(this.showForFullJoin);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings = (Settings)other;
            if (this.showForInnerJoin != settings.showForInnerJoin) {
                return false;
            }
            if (this.showForLeftJoin != settings.showForLeftJoin) {
                return false;
            }
            if (this.showForRightJoin != settings.showForRightJoin) {
                return false;
            }
            return this.showForFullJoin == settings.showForFullJoin;
        }

        public Settings() {
            this(false, false, false, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlJoinType.values().length];
            try {
                nArray[SqlJoinType.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlJoinType.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlJoinType.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlJoinType.INNER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

