/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.database.model.DasArgument;
import com.intellij.database.types.DasType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlColumnNamesInlayHintsProvider;
import com.intellij.sql.SqlInlayHintsProviderBase;
import com.intellij.sql.SqlValuesToColumnMapper;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\f0\u0005\u00a2\u0006\u0002\b$\u00a2\u0006\u0002\b%2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\"\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u00061"}, d2={"Lcom/intellij/sql/SqlColumnNamesInlayHintsProvider;", "Lcom/intellij/sql/SqlInlayHintsProviderBase;", "Lcom/intellij/sql/SqlColumnNamesInlayHintsProvider$Settings;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "group", "Lcom/intellij/codeInsight/hints/InlayGroup;", "getGroup", "()Lcom/intellij/codeInsight/hints/InlayGroup;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "getName", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCallHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getProperty", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getResultSetHints", "element", "Lcom/intellij/psi/PsiElement;", "guessExpressionName", "selectClause", "Lcom/intellij/sql/psi/SqlSelectClause;", "index", "", "shouldShowHintsForExpression", "", "Settings", "intellij.database.sql.impl"})
public final class SqlColumnNamesInlayHintsProvider
extends SqlInlayHintsProviderBase<Settings> {
    @NotNull
    private final SettingsKey<Settings> key = new SettingsKey("sql.column.names.inlay.hints");

    @NotNull
    public SettingsKey<Settings> getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        String string = SqlBundle.message((String)"SqlColumnNamesInlayHintsProvider.column.names.hint.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = SqlBundle.message((String)"SqlColumnNamesInlayHintsProvider.column.names.hint.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public InlayGroup getGroup() {
        return InlayGroup.PARAMETERS_GROUP;
    }

    @NotNull
    public String getProperty(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        String string = SqlBundle.message((String)key2, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public FactoryInlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Settings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return new FactoryInlayHintsCollector(editor2, this, settings){
            final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
            final /* synthetic */ Settings $settings;
            {
                this.this$0 = $receiver;
                this.$settings = $settings;
                super($editor);
            }

            public boolean collect(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                List hints = element2 instanceof SqlFunctionCallExpression ? SqlColumnNamesInlayHintsProvider.access$getCallHints(this.this$0, (SqlFunctionCallExpression)element2) : SqlColumnNamesInlayHintsProvider.access$getResultSetHints(this.this$0, element2, this.$settings);
                PresentationFactory factory = new PresentationFactory(editor2);
                for (InlayInfo hint : hints) {
                    InlayPresentation presentation = factory.smallText(hint.getText());
                    presentation = factory.roundWithBackground(presentation);
                    sink.addInlineElement(hint.getOffset(), true, presentation, false);
                }
                return true;
            }
        };
    }

    private final List<InlayInfo> getCallHints(SqlFunctionCallExpression callExpression) {
        SqlReferenceExpression sqlReferenceExpression = callExpression.getNameElement();
        if (sqlReferenceExpression == null) {
            return CollectionsKt.emptyList();
        }
        SqlReferenceExpression calleeExpression = sqlReferenceExpression;
        if (SqlImplUtil.resolveVisible(calleeExpression).filter(arg_0 -> SqlColumnNamesInlayHintsProvider.getCallHints$lambda$0(getCallHints.1.INSTANCE, arg_0)).isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<InlayInfo> objects2 = new ArrayList<InlayInfo>();
        SqlExpressionList sqlExpressionList = callExpression.getParameterList();
        if (sqlExpressionList == null) {
            return CollectionsKt.emptyList();
        }
        SqlExpressionList expressionList = sqlExpressionList;
        for (SqlExpression expression : expressionList.getExpressionList()) {
            String name2;
            DasArgument dasArgument;
            if (expression instanceof SqlNamedParameterValueExpression) continue;
            Intrinsics.checkNotNull((Object)expression);
            if (SqlPsiUtilKt.findParameterDefinition(expression, false) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dasArgument.getName(), (String)"getName(...)");
            if (StringUtil.isEmpty((String)name2)) continue;
            objects2.add(new InlayInfo(name2, expression.getTextRange().getStartOffset()));
        }
        return objects2;
    }

    private final List<InlayInfo> getResultSetHints(PsiElement element2, Settings settings) {
        List expressions2 = null;
        PsiElement psiElement = element2;
        if (psiElement instanceof SqlExpressionList) {
            if (!settings.getShowColumnNamesInInsertValues() || !(SqlImplUtil.sqlParent(element2) instanceof SqlValuesExpression)) {
                return CollectionsKt.emptyList();
            }
            List list = ((SqlExpressionList)element2).getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
            expressions2 = list;
        } else if (psiElement instanceof SqlSelectClause) {
            if (!settings.getShowColumnNamesInSelect()) {
                return CollectionsKt.emptyList();
            }
            List list = ((SqlSelectClause)element2).getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
            expressions2 = list;
        } else {
            return CollectionsKt.emptyList();
        }
        ArrayList<InlayInfo> objects2 = new ArrayList<InlayInfo>();
        Iterator iterator = expressions2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            SqlExpression expression = (SqlExpression)iterator.next();
            Intrinsics.checkNotNull((Object)expression);
            if (!this.shouldShowHintsForExpression((PsiElement)expression, settings)) continue;
            List names2 = null;
            SqlValuesToColumnMapper mapper = SqlValuesToColumnMapper.Companion.getInstance$default(SqlValuesToColumnMapper.Companion, (PsiElement)expression, false, 2, null);
            if (mapper != null) {
                IntRange indexRange = mapper.getIndexRange();
                names2 = new ArrayList(indexRange.getLast() - indexRange.getFirst() + 1);
                mapper.processColumnElements((Function2<? super PsiElement, ? super String, Unit>)((Function2)new Function2<PsiElement, String, Unit>((List<String>)names2){
                    final /* synthetic */ List<String> $names;
                    {
                        this.$names = $names;
                        super(2);
                    }

                    public final void invoke(@Nullable PsiElement psiElement, @Nullable String name2) {
                        if (name2 != null) {
                            ((ArrayList)this.$names).add(name2);
                        }
                    }
                }));
            } else {
                names2 = CollectionsKt.emptyList();
            }
            if (expression instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)expression).getName(), (Object)CollectionsKt.singleOrNull((List)names2))) continue;
            int inlayOffset = expression.getTextRange().getStartOffset();
            if (names2.isEmpty() && element2 instanceof SqlSelectClause) {
                String name2 = this.guessExpressionName((SqlSelectClause)element2, i2, settings);
                if (name2 == null) continue;
                objects2.add(new InlayInfo(name2, inlayOffset));
                continue;
            }
            String string = StringUtil.join((Collection)names2, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            objects2.add(new InlayInfo(string, inlayOffset));
        }
        return objects2;
    }

    private final String guessExpressionName(SqlSelectClause selectClause, int index2, Settings settings) {
        PsiElement pp;
        if (!settings.getShowColumnNamesForSetOperations()) {
            return null;
        }
        PsiElement p2 = selectClause.getParent();
        while (p2 instanceof SqlQueryExpression) {
            p2 = p2.getParent();
        }
        while ((pp = p2.getParent()) instanceof SqlSetOperatorExpression) {
            p2 = pp;
        }
        if (p2 instanceof SqlSetOperatorExpression) {
            SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.findChildOfType((PsiElement)p2, SqlQueryExpression.class);
            if (sqlQueryExpression == null) {
                return null;
            }
            SqlQueryExpression firstQuery = sqlQueryExpression;
            if (Intrinsics.areEqual((Object)firstQuery.getSelectClause(), (Object)selectClause)) {
                return null;
            }
            DasType dasType = firstQuery.getDasType();
            SqlTableType sqlTableType = dasType instanceof SqlTableType ? (SqlTableType)dasType : null;
            if (sqlTableType == null) {
                return null;
            }
            SqlTableType type = sqlTableType;
            return StringUtil.trimMiddle((String)type.getColumnName(index2), (int)20);
        }
        return null;
    }

    private final boolean shouldShowHintsForExpression(PsiElement element2, Settings settings) {
        if (SqlImplUtil.isAsteriskRef(element2)) {
            return settings.getShowColumnNamesForAsterisk();
        }
        return element2 instanceof SqlLiteralExpression || element2 instanceof SqlOperatorExpression || element2 instanceof SqlFunctionCallExpression || element2 instanceof SqlReferenceExpression;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(settings){
            @NotNull
            private final String mainCheckboxText;
            @NotNull
            private final List<ImmediateConfigurable.Case> cases;
            {
                String string = SqlBundle.message((String)"SqlJoinCardinalityInlayHintsProvider.hint.settings.main.cognitive.complexity.hints.for", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.mainCheckboxText = string;
                Object[] objectArray = new ImmediateConfigurable.Case[4];
                String string2 = SqlBundle.message((String)"settings.inlay.in.insert.values", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                objectArray[0] = new ImmediateConfigurable.Case(string2, "sql.show.column.names.in.insert.values", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowColumnNamesInInsertValues();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowColumnNamesInInsertValues((Boolean)value2);
                    }
                }, null);
                String string3 = SqlBundle.message((String)"settings.inlay.in.select.expressions", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                objectArray[1] = new ImmediateConfigurable.Case(string3, "sql.show.column.names.in.select", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowColumnNamesInSelect();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowColumnNamesInSelect((Boolean)value2);
                    }
                }, null);
                String string4 = SqlBundle.message((String)"settings.inlay.for.references", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                objectArray[2] = new ImmediateConfigurable.Case(string4, "sql.show.column.names.for.asterisk", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowColumnNamesForAsterisk();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowColumnNamesForAsterisk((Boolean)value2);
                    }
                }, null);
                String string5 = SqlBundle.message((String)"settings.inlay.for.set.operations", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                objectArray[3] = new ImmediateConfigurable.Case(string5, "sql.show.column.names.for.set.operations", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

                    @Nullable
                    public Object get() {
                        return ((Settings)this.receiver).getShowColumnNamesForSetOperations();
                    }

                    public void set(@Nullable Object value2) {
                        ((Settings)this.receiver).setShowColumnNamesForSetOperations((Boolean)value2);
                    }
                }, null);
                this.cases = CollectionsKt.listOf((Object[])objectArray);
            }

            @NotNull
            public DialogPanel createComponent(@NotNull ChangeListener listener2) {
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                return BuilderKt.panel((Function1)createConfigurable.createComponent.1.INSTANCE);
            }

            @NotNull
            public String getMainCheckboxText() {
                return this.mainCheckboxText;
            }

            @NotNull
            public List<ImmediateConfigurable.Case> getCases() {
                return this.cases;
            }
        };
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(false, false, false, false, 15, null);
    }

    private static final boolean getCallHints$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getCallHints(SqlColumnNamesInlayHintsProvider $this, SqlFunctionCallExpression callExpression) {
        return $this.getCallHints(callExpression);
    }

    public static final /* synthetic */ List access$getResultSetHints(SqlColumnNamesInlayHintsProvider $this, PsiElement element2, Settings settings) {
        return $this.getResultSetHints(element2, settings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/SqlColumnNamesInlayHintsProvider$Settings;", "", "showColumnNamesInInsertValues", "", "showColumnNamesInSelect", "showColumnNamesForAsterisk", "showColumnNamesForSetOperations", "(ZZZZ)V", "getShowColumnNamesForAsterisk", "()Z", "setShowColumnNamesForAsterisk", "(Z)V", "getShowColumnNamesForSetOperations", "setShowColumnNamesForSetOperations", "getShowColumnNamesInInsertValues", "setShowColumnNamesInInsertValues", "getShowColumnNamesInSelect", "setShowColumnNamesInSelect", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.sql.impl"})
    public static final class Settings {
        private boolean showColumnNamesInInsertValues;
        private boolean showColumnNamesInSelect;
        private boolean showColumnNamesForAsterisk;
        private boolean showColumnNamesForSetOperations;

        public Settings(boolean showColumnNamesInInsertValues, boolean showColumnNamesInSelect, boolean showColumnNamesForAsterisk, boolean showColumnNamesForSetOperations) {
            this.showColumnNamesInInsertValues = showColumnNamesInInsertValues;
            this.showColumnNamesInSelect = showColumnNamesInSelect;
            this.showColumnNamesForAsterisk = showColumnNamesForAsterisk;
            this.showColumnNamesForSetOperations = showColumnNamesForSetOperations;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getShowColumnNamesInInsertValues() {
            return this.showColumnNamesInInsertValues;
        }

        public final void setShowColumnNamesInInsertValues(boolean bl) {
            this.showColumnNamesInInsertValues = bl;
        }

        public final boolean getShowColumnNamesInSelect() {
            return this.showColumnNamesInSelect;
        }

        public final void setShowColumnNamesInSelect(boolean bl) {
            this.showColumnNamesInSelect = bl;
        }

        public final boolean getShowColumnNamesForAsterisk() {
            return this.showColumnNamesForAsterisk;
        }

        public final void setShowColumnNamesForAsterisk(boolean bl) {
            this.showColumnNamesForAsterisk = bl;
        }

        public final boolean getShowColumnNamesForSetOperations() {
            return this.showColumnNamesForSetOperations;
        }

        public final void setShowColumnNamesForSetOperations(boolean bl) {
            this.showColumnNamesForSetOperations = bl;
        }

        public final boolean component1() {
            return this.showColumnNamesInInsertValues;
        }

        public final boolean component2() {
            return this.showColumnNamesInSelect;
        }

        public final boolean component3() {
            return this.showColumnNamesForAsterisk;
        }

        public final boolean component4() {
            return this.showColumnNamesForSetOperations;
        }

        @NotNull
        public final Settings copy(boolean showColumnNamesInInsertValues, boolean showColumnNamesInSelect, boolean showColumnNamesForAsterisk, boolean showColumnNamesForSetOperations) {
            return new Settings(showColumnNamesInInsertValues, showColumnNamesInSelect, showColumnNamesForAsterisk, showColumnNamesForSetOperations);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.showColumnNamesInInsertValues;
            }
            if ((n & 2) != 0) {
                bl2 = settings.showColumnNamesInSelect;
            }
            if ((n & 4) != 0) {
                bl3 = settings.showColumnNamesForAsterisk;
            }
            if ((n & 8) != 0) {
                bl4 = settings.showColumnNamesForSetOperations;
            }
            return settings.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Settings(showColumnNamesInInsertValues=" + this.showColumnNamesInInsertValues + ", showColumnNamesInSelect=" + this.showColumnNamesInSelect + ", showColumnNamesForAsterisk=" + this.showColumnNamesForAsterisk + ", showColumnNamesForSetOperations=" + this.showColumnNamesForSetOperations + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.showColumnNamesInInsertValues);
            result2 = result2 * 31 + Boolean.hashCode(this.showColumnNamesInSelect);
            result2 = result2 * 31 + Boolean.hashCode(this.showColumnNamesForAsterisk);
            result2 = result2 * 31 + Boolean.hashCode(this.showColumnNamesForSetOperations);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings = (Settings)other;
            if (this.showColumnNamesInInsertValues != settings.showColumnNamesInInsertValues) {
                return false;
            }
            if (this.showColumnNamesInSelect != settings.showColumnNamesInSelect) {
                return false;
            }
            if (this.showColumnNamesForAsterisk != settings.showColumnNamesForAsterisk) {
                return false;
            }
            return this.showColumnNamesForSetOperations == settings.showColumnNamesForSetOperations;
        }

        public Settings() {
            this(false, false, false, false, 15, null);
        }
    }
}

