/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.view.DbSchemaNode;
import com.intellij.database.view.DbSchemaNodeReporter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCheckBoxTree<N extends DbSchemaNode<N>>
extends CheckboxTree {
    public DbCheckBoxTree(@NotNull CheckedTreeNode root2, @NotNull CheckboxTree.CheckboxTreeCellRenderer renderer2) {
        if (root2 == null) {
            DbCheckBoxTree.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            DbCheckBoxTree.$$$reportNull$$$0(1);
        }
        super(renderer2, root2, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        this.installReporter(root2);
        this.setRowHeight(renderer2.getTreeCellRendererComponent((JTree)((Object)this), (Object)root2, (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height);
        this.setLargeModel(true);
    }

    private void installReporter(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            DbCheckBoxTree.$$$reportNull$$$0(2);
        }
        DbSchemaNode rootNode = (DbSchemaNode)root2.getUserObject();
        rootNode.setRootReporter(new DbSchemaNodeReporter<N>(){

            @Override
            public void onNodeChecked(@NotNull N node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbCheckBoxTree.this.setNodeState((CheckedTreeNode)DbCheckBoxTree.this.getSearchModel().getNode(node2), ((DbSchemaNode)node2).isChecked());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/DbCheckBoxTree$1", "onNodeChecked"));
            }
        });
    }

    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
    }

    protected void installSpeedSearch() {
    }

    protected void processKeyEvent(KeyEvent e2) {
        if (e2.getID() == 401 && e2.getKeyCode() == 32 && e2.getModifiers() == 0) {
            TreePath path = this.getLeadSelectionPath();
            CheckedTreeNode node2 = path == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class);
            boolean state = node2 != null && node2.isChecked();
            CheckedTreeNode[] sel = (CheckedTreeNode[])this.getSelectedNodes(CheckedTreeNode.class, CheckedTreeNode::isEnabled);
            if (sel.length != 0) {
                for (CheckedTreeNode treeNode : sel) {
                    this.setNodeState(treeNode, !state);
                }
                this.updateFromNodes();
                e2.consume();
            }
            return;
        }
        if (e2.getID() == 400 && e2.getKeyChar() == ' ') {
            return;
        }
        super.processKeyEvent(e2);
    }

    public void updateFromNodes() {
        this.updateEnabled((Tree)this, null);
    }

    @NotNull
    public FilteringTree.SearchTreeModel<CheckedTreeNode, N> getSearchModel() {
        FilteringTree.SearchTreeModel searchTreeModel = (FilteringTree.SearchTreeModel)this.getModel();
        if (searchTreeModel == null) {
            DbCheckBoxTree.$$$reportNull$$$0(3);
        }
        return searchTreeModel;
    }

    protected void onNodeStateChanged(CheckedTreeNode treeNode) {
        super.onNodeStateChanged(treeNode);
        FilteringTree.SearchTreeModel<CheckedTreeNode, N> model2 = this.getSearchModel();
        DbSchemaNode node2 = (DbSchemaNode)model2.getUserObject((DefaultMutableTreeNode)treeNode);
        if (node2 != null) {
            this.updateEnabled((Tree)this, node2);
        }
    }

    private <N extends DbSchemaNode<N>> void updateEnabled(Tree tree, N root2) {
        Object parent2;
        FilteringTree.SearchTreeModel searchModel = (FilteringTree.SearchTreeModel)tree.getModel();
        if (root2 == null) {
            root2 = (DbSchemaNode)searchModel.getRootObject();
        }
        this.updateEnabledRec(root2, searchModel);
        if (((DbSchemaNode)root2).getObject() == "*" && (parent2 = ((DbSchemaNode)root2).getParent()) != null) {
            for (DbSchemaNode node2 : ((DbSchemaNode)parent2).getSimpleChildNodes()) {
                if (node2.getKind() != ((DbSchemaNode)root2).getKind()) continue;
                this.updateEnabledRec(node2, searchModel);
            }
        }
        tree.repaint();
        tree.revalidate();
    }

    private <N extends DbSchemaNode<N>> void updateEnabledRec(N root2, FilteringTree.SearchTreeModel<CheckedTreeNode, N> searchModel) {
        boolean shouldBeEnabled = this.shouldBeEnabled(root2, searchModel);
        if (DbCheckBoxTree.setEnabled(searchModel, root2, shouldBeEnabled)) {
            for (DbSchemaNode node2 : root2.getChildNodes()) {
                this.updateEnabledRec(node2, searchModel);
            }
        }
    }

    private <N extends DbSchemaNode<N>> boolean shouldBeEnabled(N n, FilteringTree.SearchTreeModel<CheckedTreeNode, N> searchModel) {
        N parent2 = n.getParent();
        if (parent2 != null && !DbCheckBoxTree.isEnabled(searchModel, parent2)) {
            return false;
        }
        if (n.getObject() == "*") {
            return true;
        }
        if (this.unblockByAll() && n.getAllNodes() != null) {
            return true;
        }
        DbSchemaNode allNode = parent2 == null ? null : (DbSchemaNode)((DbSchemaNode)parent2).getAllNode(n.getKind());
        return allNode == null || !allNode.isChecked();
    }

    private static <N extends DbSchemaNode<N>> void disableAllChildren(N node2, FilteringTree.SearchTreeModel<CheckedTreeNode, N> searchModel) {
        for (DbSchemaNode disabledNode : (JBTreeTraverser)JBTreeTraverser.from(DbSchemaNode::getChildNodes).withRoot(node2)) {
            DbCheckBoxTree.setEnabled(searchModel, disabledNode, false);
        }
    }

    private <N extends DbSchemaNode<N>> Iterable<N> enabledChildren(N n) {
        Set<ObjectKind> disabled = DbCheckBoxTree.getDisabledKinds(n);
        return n.getChildNodes().filter(c2 -> this.unblockByAll() && c2.getAllNodes() != null || !disabled.contains(c2.getKind()));
    }

    @NotNull
    private static <N extends DbSchemaNode<N>> Set<ObjectKind> getDisabledKinds(N n) {
        Set set = JBIterable.from(n.getAllNodes()).filter(DbSchemaNode::isChecked).map(DbSchemaNode::getKind).toSet();
        if (set == null) {
            DbCheckBoxTree.$$$reportNull$$$0(4);
        }
        return set;
    }

    protected boolean unblockByAll() {
        return true;
    }

    private static boolean isAllChecked(@Nullable DbSchemaNode<? extends DbSchemaNode<?>> n, @Nullable BasicMetaObject<?> metaObject, boolean def) {
        DbSchemaNode<?> allNode = n == null ? null : n.getAllNode(metaObject);
        return allNode == null ? def : allNode.isChecked();
    }

    private static <N extends DbSchemaNode<N>> boolean setEnabled(@NotNull FilteringTree.SearchTreeModel<CheckedTreeNode, N> m, @Nullable N n, boolean e2) {
        CheckedTreeNode node2;
        if (m == null) {
            DbCheckBoxTree.$$$reportNull$$$0(5);
        }
        if ((node2 = (CheckedTreeNode)m.getCachedNode(n)) != null && node2.isEnabled() != e2) {
            node2.setEnabled(e2);
            return true;
        }
        return false;
    }

    private static <N extends DbSchemaNode<N>> boolean isEnabled(@NotNull FilteringTree.SearchTreeModel<CheckedTreeNode, N> m, @Nullable N n) {
        CheckedTreeNode node2;
        if (m == null) {
            DbCheckBoxTree.$$$reportNull$$$0(6);
        }
        return (node2 = (CheckedTreeNode)m.getCachedNode(n)) != null && node2.isEnabled();
    }

    @Nullable
    public static <T extends DbCheckBoxTree<?>> T getTree(@NotNull DataContext dataContext, @NotNull Class<T> clazz) {
        if (dataContext == null) {
            DbCheckBoxTree.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            DbCheckBoxTree.$$$reportNull$$$0(8);
        }
        return (T)((Object)((DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext), clazz))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbCheckBoxTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbCheckBoxTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installReporter";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    protected static abstract class CellWithUnderlinedAllRenderer<N extends DbSchemaNode<N>>
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Color SEP_COLOR = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        private final Border OVERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)1, (int)0, (int)0, (int)0);
        private final Border UNDERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)0, (int)0, (int)1, (int)0);

        public CellWithUnderlinedAllRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree baseTree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DbCheckBoxTree tree = (DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)baseTree, DbCheckBoxTree.class));
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)value2, CheckedTreeNode.class);
            if (tree == null || !(tree.getModel() instanceof FilteringTree.SearchTreeModel) || treeNode == null) {
                return;
            }
            ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
            DbSchemaNode node2 = (DbSchemaNode)tree.getSearchModel().getUserObject((DefaultMutableTreeNode)treeNode);
            if (node2 != null) {
                this.customizeCheckboxRenderer(tree, node2);
                this.setToolTipText(treeNode.isEnabled() ? "" : DatabaseBundle.message("not.editable.because.all.check.box.is.selected", new Object[0]));
                if (ClientProperty.isTrue((Component)baseTree, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    this.setBorder(null);
                } else {
                    this.updateBorder(baseTree, (TreeNode)treeNode, node2);
                }
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)tree), (SimpleColoredComponent)renderer2, (boolean)true, (boolean)selected);
        }

        protected void updateBorder(JTree baseTree, @NotNull TreeNode treeNode, @NotNull N node2) {
            DbSchemaNode c1;
            DbSchemaNode c0;
            TreeNode parent2;
            if (treeNode == null) {
                CellWithUnderlinedAllRenderer.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                CellWithUnderlinedAllRenderer.$$$reportNull$$$0(1);
            }
            int idx = (parent2 = treeNode.getParent()) != null ? parent2.getIndex(treeNode) : -1;
            DbSchemaNode dbSchemaNode = c0 = idx == -1 ? null : (DbSchemaNode)node2;
            if (((DbSchemaNode)node2).getObject() == "*") {
                c1 = idx == -1 ? null : (DbSchemaNode)this.getChild(parent2, idx + 1);
            } else {
                c1 = c0;
                DbSchemaNode dbSchemaNode2 = c0 = idx > 0 ? (DbSchemaNode)this.getChild(parent2, idx - 1) : null;
            }
            if (c0 != null && c1 != null && c0.getObject() == "*" && c1.getObject() != "*") {
                boolean isFirst;
                SimpleColoredText text2 = new SimpleColoredText();
                this.renderText(baseTree, c0, (ColoredTextContainer)text2);
                String t0 = text2.toString();
                text2.clear();
                this.renderText(baseTree, c1, (ColoredTextContainer)text2);
                String t1 = text2.toString();
                boolean useFirst = t0.length() > t1.length();
                boolean bl = isFirst = node2 == c0;
                this.setBorder(useFirst == isFirst ? (isFirst ? this.UNDERLINE : this.OVERLINE) : null);
            } else {
                this.setBorder(null);
            }
        }

        @Nullable
        protected N getChild(@Nullable TreeNode parent2, int idx) {
            if (parent2 == null || idx >= parent2.getChildCount()) {
                return null;
            }
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)parent2.getChildAt(idx), CheckedTreeNode.class);
            return (N)(treeNode == null ? null : (DbSchemaNode)treeNode.getUserObject());
        }

        protected abstract void customizeCheckboxRenderer(DbCheckBoxTree<N> var1, N var2);

        protected abstract void renderText(JTree var1, N var2, ColoredTextContainer var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "treeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/ui/DbCheckBoxTree$CellWithUnderlinedAllRenderer";
            objectArray[2] = "updateBorder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

