/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseScriptDialog
extends DialogWrapper {
    protected final Project myProject;
    protected final RawDataSource myDataSource;
    protected final SearchPath mySearchPath;
    protected final SqlPreviewComponent myPreviewPanel;
    protected final ScriptOptionsPanel myOptionsPanel;
    protected final JBLoadingPanel myLoadingPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull RawDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title) {
        if (project == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myDataSource = dataSource2;
        this.mySearchPath = searchPath;
        this.myPreviewPanel = new SqlPreviewComponent(this.myProject, this.myDataSource, this.mySearchPath, "", false, () -> this.close(1)){

            @Override
            @NotNull
            public List<AnAction> createActions(@NotNull DasDataSource delegate) {
                if (delegate == null) {
                    1.$$$reportNull$$$0(0);
                }
                List list = ContainerUtil.concat(DatabaseScriptDialog.this.createPreviewActions(), super.createActions(delegate));
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createActions";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.myPreviewPanel.getEditor().setMinimumSize((Dimension)JBUI.size((int)120, (int)120));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), panel2 -> new LoadingDecorator((JComponent)panel2, this.getDisposable(), 100, true));
        this.myLoadingPanel.add((Component)this.myPreviewPanel.getEditor(), (Object)"Center");
        this.myOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            this.applyOptions();
            return Unit.INSTANCE;
        }));
        this.setTitle(title);
    }

    @NotNull
    protected List<AnAction> createPreviewActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected void init() {
        super.init();
        ScriptingTask task = this.getTask();
        this.myOptionsPanel.adjustOptionsUI(task, task.getOptions());
    }

    protected void applyOptions() {
        this.settingsChanged(this.appendCodeStyle(this.myOptionsPanel.gatherOptions()));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected abstract ScriptingTask getTask();

    protected abstract AsyncTask<ScriptingTask> applyAndGetTask();

    public static JBPopup showSettingsPopup(ScriptingTask task, Consumer<ScriptingOptions> callback) {
        Ref panel2 = Ref.create();
        panel2.set((Object)new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            callback.accept(((ScriptOptionsPanel)panel2.get()).gatherOptions());
            return Unit.INSTANCE;
        })));
        ((ScriptOptionsPanel)panel2.get()).adjustOptionsUI(task, task.getOptions());
        JComponent component2 = ((ScriptOptionsPanel)panel2.get()).getComponent();
        UIUtil.addInsets((JComponent)component2, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        return JBPopupFactory.getInstance().createComponentPopupBuilder(component2, component2).setRequestFocus(true).createPopup();
    }

    public static AnAction createSettingsPopupAction(final Supplier<? extends ScriptingTask> task, final Consumer<ScriptingOptions> callback) {
        return new ActionGroup(DatabaseBundle.messagePointer("action.DatabaseScriptDialog.settings.text", new Object[0]), Presentation.NULL_STRING, AllIcons.General.GearPlain){
            {
                super(arg0, arg1, arg2);
                this.setPopup(true);
                this.getTemplatePresentation().setPerformGroup(true);
                this.getTemplatePresentation().setDisableGroupIfEmpty(false);
            }

            public boolean isDumbAware() {
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                JBPopup popup2 = DatabaseScriptDialog.showSettingsPopup((ScriptingTask)task.get(), callback);
                DbUIUtil.showPopup(popup2, null, e2);
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
                if (AnAction.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(1);
                }
                return AnAction.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected ScriptingOptions appendCodeStyle(ScriptingOptions op) {
        CodeStyleSettings style = ScriptingTaskBuilderKt.getCodeStyle(this.myDataSource);
        DelegateScriptingOptions res2 = new DelegateScriptingOptions(op);
        res2.set(ScriptingOptionStatic.CODE_STYLE, style);
        return res2;
    }

    protected abstract void settingsChanged(ScriptingOptions var1);

    @Nullable
    protected JComponent createCenterPanel() {
        ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message("separator.preview", new Object[0]), this.createTopComponent(), (JComponent)this.myLoadingPanel, this.getDimensionServiceKey(), 0.5f);
        splitter.setTrailWidget(this.myPreviewPanel.createToolbar());
        return splitter;
    }

    @NotNull
    protected JComponent createTopComponent() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myOptionsPanel.getComponent(), (boolean)true);
        pane.setMinimumSize((Dimension)JBUI.size((int)300, (int)50));
        JScrollPane jScrollPane = pane;
        if (jScrollPane == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(5);
        }
        return jScrollPane;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    protected void doOKAction() {
        if (!this.perform()) {
            return;
        }
        super.doOKAction();
    }

    protected boolean isInstantClose() {
        return true;
    }

    protected boolean perform() {
        boolean instantClose = this.isInstantClose();
        LocalDataSource lds = (LocalDataSource)ObjectUtils.tryCast((Object)this.myDataSource, LocalDataSource.class);
        if (lds != null) {
            this.performInDatabaseAndClose(lds, instantClose);
            return instantClose;
        }
        SqlDataSource sqlDs2 = (SqlDataSource)ObjectUtils.tryCast((Object)this.myDataSource, SqlDataSource.class);
        if (sqlDs2 != null) {
            AsyncTask<?> task = this.updateSqlDataSource(sqlDs2);
            if (!instantClose) {
                task.whenComplete(AsyncUtil.getEdtExecutor(), (r, th) -> {
                    if (th == null) {
                        this.close(0);
                    }
                });
            }
            return instantClose;
        }
        return true;
    }

    private void performInDatabaseAndClose(LocalDataSource lds, boolean instantClose) {
        AsyncTask.Frame frame = AsyncTask.frame(this.getTitle());
        ProgressWindow window = instantClose ? (ProgressWindow)AsyncUtil.createBackgroundIndicator(this.myProject, frame.getName(), true) : new ProgressWindow(true, this.myProject);
        window.setTitle(frame.getName());
        AsyncTask.withIndicator(frame, (ProgressIndicator)window).compute(null, () -> {
            AsyncTask<?> task = this.performInDatabase(lds);
            if (!instantClose) {
                task.whenComplete(AsyncUtil.getEdtExecutor(), (r, th) -> {
                    if (th == null) {
                        this.close(0);
                    }
                });
            }
            return null;
        });
    }

    protected AsyncTask<?> performInDatabase(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(6);
        }
        return this.runScript(dataSource2, false);
    }

    protected AsyncTask<?> updateSqlDataSource(SqlDataSource ds) {
        return this.applyAndGetTask().apply(AsyncUtil.getNonEdtExecutor(), task -> {
            ScriptingSingleModelTaskBuilder builder = DatabaseScriptDialog.prepareCreationTask(task);
            return DumpToDdlDataSourceActionKt.expandAndDump(this.myProject, ds, builder.getModel(), null, builder.getElements(), false);
        }).apply(AsyncUtil.getEdtExecutor(), files2 -> {
            DumpToDdlDataSourceActionKt.selectFile(this.myProject, files2);
            return null;
        });
    }

    @NotNull
    public static ScriptingSingleModelTaskBuilder prepareCreationTask(ScriptingTask task) {
        ScriptingSingleModelTaskBuilder builder;
        if (task instanceof ScriptingSingleModelTask) {
            ScriptingSingleModelTask t = (ScriptingSingleModelTask)task;
            builder = new ScriptingSingleModelTaskBuilder(t.getModel(), ScriptCategory.CREATE_COMPLETE);
            builder.setElements(t.getElements());
        } else {
            ScriptingAlterTask t = (ScriptingAlterTask)task;
            builder = new ScriptingSingleModelTaskBuilder(t.getTargetModel(), ScriptCategory.CREATE_COMPLETE);
            JBIterable.from(t.getCorrespondence()).filterMap(ElementDelta::getTargetElement).addAllTo(builder.getElements());
        }
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = builder;
        if (scriptingSingleModelTaskBuilder == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(7);
        }
        return scriptingSingleModelTaskBuilder;
    }

    @NotNull
    public AsyncTask<?> runScript(@NotNull LocalDataSource localDataSource, boolean nonModalSync) {
        String statement2;
        if (localDataSource == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(8);
        }
        if ((statement2 = this.getStatement()).isEmpty()) {
            AsyncTask<Boolean> asyncTask = AsyncTask.completed(true);
            if (asyncTask == null) {
                DatabaseScriptDialog.$$$reportNull$$$0(9);
            }
            return asyncTask;
        }
        DatabaseRefactoringHandler handler2 = this.createRefactoringHandler(localDataSource).setStatement(statement2);
        this.fillContext(handler2);
        AsyncTask<Boolean> asyncTask = handler2.runStatements(nonModalSync);
        if (asyncTask == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(10);
        }
        return asyncTask;
    }

    @NotNull
    protected DatabaseRefactoringHandler createRefactoringHandler(@NotNull LocalDataSource localDataSource) {
        if (localDataSource == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(11);
        }
        return new DatabaseRefactoringHandler(this.myProject, localDataSource, this.mySearchPath);
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
        if (handler2 == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(12);
        }
    }

    protected void updateText(ScriptingResult script2) {
        this.updateText(script2.getScript());
    }

    protected void updateText(CompositeText script2) {
        this.myPreviewPanel.setQuery(script2);
    }

    public void initAndShow() {
        this.init();
        this.show();
    }

    public boolean initAndGet() {
        this.init();
        return this.showAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCreationTask";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performInDatabase";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runScript";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRefactoringHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

