/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTree;
import com.intellij.database.view.ui.MyInnerTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030 2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020&H\u0014J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0015J\b\u0010.\u001a\u00020/H\u0002J1\u00100\u001a\u0015\u0012\f\u0012\n 3*\u0004\u0018\u0001020201\u00a2\u0006\u0002\b4*\n\u0012\u0006\b\u0001\u0012\u000205012\b\u00106\u001a\u0004\u0018\u00010\u001dH\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lcom/intellij/database/view/ui/DatabaseSchemaSelectionTree;", "Lcom/intellij/ui/FilteringTree;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "Lcom/intellij/ui/tree/TreePathBackgroundSupplier;", "project", "Lcom/intellij/openapi/project/Project;", "dbmses", "", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getDbmses", "()Ljava/util/Set;", "filtered", "", "getFiltered", "()Z", "setFiltered", "(Z)V", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createNode", "obj", "filterIfNeeded", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSources", "getChildren", "", "getDataSource", "getGrouped", "prefix", "", "getNodeClass", "Ljava/lang/Class;", "getPathBackground", "Ljava/awt/Color;", "path", "Ljavax/swing/tree/TreePath;", "row", "", "getText", "rebuildTree", "", "applyFilter", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNamespace;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/database/model/basic/BasicElement;", "ds", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseSchemaSelectionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1855#2:216\n1856#2:218\n766#2:219\n857#2,2:220\n1#3:217\n*S KotlinDebug\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree\n*L\n128#1:216\n128#1:218\n157#1:219\n157#1:220,2\n*E\n"})
public final class DatabaseSchemaSelectionTree
extends FilteringTree<DefaultMutableTreeNode, Object>
implements TreePathBackgroundSupplier {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<Dbms> dbmses;
    @NotNull
    private final JPanel panel;
    private boolean filtered;

    /*
     * WARNING - void declaration
     */
    public DatabaseSchemaSelectionTree(@NotNull Project project, @NotNull Set<Dbms> dbmses) {
        void $this$_init__u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dbmses, (String)"dbmses");
        super((Tree)new MyInnerTree(), new DefaultMutableTreeNode((Object)DataSourceStorage.getProjectStorage(project)));
        this.project = project;
        this.dbmses = dbmses;
        this.panel = new JPanel(new BorderLayout());
        this.filtered = true;
        Object object = this.getTree();
        MyInnerTree myInnerTree = object instanceof MyInnerTree ? (MyInnerTree)((Object)object) : null;
        if (myInnerTree != null) {
            myInnerTree.setColorSupplier(this);
        }
        this.getTree().setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                DefaultMutableTreeNode defaultMutableTreeNode = value2 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value2 : null;
                Object obj2 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                String string = this.getText(obj2);
                if (string == null) {
                    string = "";
                }
                this.append(string);
                Object object = obj2;
                this.setIcon(object instanceof LocalDataSource ? ((LocalDataSource)obj2).getIcon() : (object instanceof BasicElement ? DbPresentation.getIcon((DasObject)obj2) : (object instanceof String ? AllIcons.Nodes.Folder : null)));
            }
        });
        this.getTree().setVisibleRowCount(10);
        this.getTree().setRootVisible(false);
        Object object2 = new AnAction[1];
        Supplier<String> supplier2 = DatabaseSchemaSelectionTree::_init_$lambda$0;
        Icon icon = AllIcons.General.Filter;
        object2[0] = new DumbAware(this, supplier2, icon){
            final /* synthetic */ DatabaseSchemaSelectionTree this$0;
            {
                block0: {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                    ShortcutSet shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)((AnAction)this));
                    if (shortcutSet == null) break block0;
                    ShortcutSet it2 = shortcutSet;
                    boolean bl = false;
                    this.registerCustomShortcutSet(it2, (JComponent)$receiver.getTree());
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public boolean isSelected(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                return this.this$0.getFiltered();
            }

            public void setSelected(@NotNull AnActionEvent e2, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.this$0.setFiltered(state);
                DatabaseSchemaSelectionTree.access$rebuildTree(this.this$0);
            }
        };
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup((AnAction[])object2), true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setTargetComponent((JComponent)this.getTree());
        toolbar2.setReservePlaceAutoPopupIcon(false);
        this.panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.getTree())), "Center");
        object2 = object = new JPanel(new BorderLayout());
        JPanel jPanel = this.panel;
        boolean bl = false;
        $this$_init__u24lambda_u241.add((Component)this.installSearchField(), "Center");
        $this$_init__u24lambda_u241.add((Component)toolbar2.getComponent(), "East");
        jPanel.add((Component)object, "North");
        this.rebuildTree();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Set<Dbms> getDbmses() {
        return this.dbmses;
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    public final boolean getFiltered() {
        return this.filtered;
    }

    public final void setFiltered(boolean bl) {
        this.filtered = bl;
    }

    private final void rebuildTree() {
        this.getSearchModel().updateStructure();
    }

    @NotNull
    protected Class<? extends DefaultMutableTreeNode> getNodeClass() {
        return DefaultMutableTreeNode.class;
    }

    @NotNull
    protected DefaultMutableTreeNode createNode(@NotNull Object obj2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        return new DefaultMutableTreeNode(obj2);
    }

    @NotNull
    protected Iterable<Object> getChildren(@NotNull Object obj2) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Object object = obj2;
        if (object instanceof DataSourceStorage) {
            List<LocalDataSource> list = ((DataSourceStorage)((Object)obj2)).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            iterable = this.getGrouped(this.filterIfNeeded(list), "");
        } else if (object instanceof String) {
            List<LocalDataSource> list = DataSourceStorage.getProjectStorage(this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            iterable = this.getGrouped(this.filterIfNeeded(list), (String)obj2);
        } else if (object instanceof LocalDataSource) {
            DasModel dasModel = ((LocalDataSource)obj2).getModel();
            CasingProvider casingProvider = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            iterable = casingProvider != null && (casingProvider = casingProvider.getRoot()) != null && (casingProvider = casingProvider.getChildren()) != null && (casingProvider = this.applyFilter((JBIterable<? extends BasicElement>)casingProvider, (LocalDataSource)obj2)) != null ? (Iterable)((Object)casingProvider) : (Iterable)CollectionsKt.emptyList();
        } else if (object instanceof BasicElement) {
            JBIterable<? extends BasicElement> jBIterable = ((BasicElement)obj2).getChildren();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getChildren(...)");
            iterable = (Iterable)this.applyFilter(jBIterable, this.getDataSource(obj2));
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    private final Iterable<Object> getGrouped(List<? extends LocalDataSource> dataSources2, String prefix) {
        LinkedHashSet dss2 = new LinkedHashSet();
        LinkedHashSet prefixes = new LinkedHashSet();
        Object longPrefix = ((CharSequence)prefix).length() == 0 ? "" : prefix + "/";
        int pLen = ((String)longPrefix).length();
        Iterable $this$forEach$iv = dataSources2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalDataSource ds = (LocalDataSource)element$iv;
            boolean bl = false;
            String string = ds.getGroupName();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String gr = string2;
            if (Intrinsics.areEqual((Object)gr, (Object)prefix)) {
                ((Collection)dss2).add(ds);
                continue;
            }
            if (!StringsKt.startsWith$default((String)gr, (String)longPrefix, (boolean)false, (int)2, null)) continue;
            Integer n = StringsKt.indexOf$default((CharSequence)gr, (String)"/", (int)pLen, (boolean)false, (int)4, null);
            int it2 = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n3 = it2 != -1 ? n : null;
            int e2 = n3 != null ? n3.intValue() : gr.length();
            Collection collection2 = prefixes;
            String string3 = gr.substring(0, e2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            collection2.add(string3);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)prefixes).append((Iterable)dss2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"append(...)");
        return (Iterable)jBIterable;
    }

    private final LocalDataSource getDataSource(Object obj2) {
        return (LocalDataSource)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)this.getSearchModel().getCachedNode(obj2), (Function1)getDataSource.1.INSTANCE), (Function1)getDataSource.2.INSTANCE));
    }

    private final JBIterable<BasicNamespace> applyFilter(JBIterable<? extends BasicElement> $this$applyFilter, LocalDataSource ds) {
        JBIterable jBIterable;
        JBIterable $this$applyFilter_u24lambda_u245 = $this$applyFilter.filter(BasicNamespace.class);
        boolean bl = false;
        if (!this.filtered) {
            jBIterable = $this$applyFilter_u24lambda_u245;
        } else {
            TreePattern scope = DbImplUtil.getIntrospectionScope(ds);
            jBIterable = $this$applyFilter_u24lambda_u245.filter(arg_0 -> DatabaseSchemaSelectionTree.applyFilter$lambda$5$lambda$4((Function1)new Function1<BasicNamespace, Boolean>(scope){
                final /* synthetic */ TreePattern $scope;
                {
                    this.$scope = $scope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicNamespace it2) {
                    return DataSourceSchemaMapping.isIntrospected(this.$scope, it2);
                }
            }, arg_0));
        }
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"run(...)");
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalDataSource> filterIfNeeded(List<? extends LocalDataSource> dataSources2) {
        List list;
        block5: {
            block4: {
                List list2;
                void $this$filterTo$iv$iv;
                List list3;
                List it2 = list3 = dataSources2;
                boolean bl = false;
                list = this.filtered && !((Collection)this.dbmses).isEmpty() ? list3 : null;
                if (list == null) break block4;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocalDataSource it3 = (LocalDataSource)element$iv$iv;
                    boolean bl2 = false;
                    if (!this.dbmses.contains(it3.getDbms())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List it4 = list2 = (List)destination$iv$iv;
                boolean bl3 = false;
                list = !((Collection)it4).isEmpty() ? list2 : null;
                if (list != null) break block5;
            }
            list = dataSources2;
        }
        return list;
    }

    @NlsSafe
    @Nullable
    protected String getText(@Nullable Object obj2) {
        Object object;
        block3: {
            block5: {
                block6: {
                    Object object2;
                    block4: {
                        block2: {
                            object2 = obj2;
                            if (!(object2 instanceof LocalDataSource)) break block2;
                            object = ((LocalDataSource)obj2).getName();
                            break block3;
                        }
                        if (!(object2 instanceof BasicElement)) break block4;
                        object = ((BasicElement)obj2).getName();
                        break block3;
                    }
                    if (!(object2 instanceof String)) break block5;
                    Integer n = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)obj2), (String)"/", (int)0, (boolean)false, (int)6, null);
                    int it2 = ((Number)n).intValue();
                    boolean bl = false;
                    object = it2 != -1 ? n : null;
                    if (object == null) break block6;
                    int it3 = ((Number)object).intValue();
                    boolean bl2 = false;
                    String string = ((String)obj2).substring(it3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    object = string;
                    if (string != null) break block3;
                }
                object = (String)obj2;
                break block3;
            }
            object = null;
        }
        return object;
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object obj2 = TreeUtil.getLastUserObject((TreePath)path);
        return obj2 instanceof LocalDataSource ? DatabaseColorManager.getColor(this.project, (DasDataSource)obj2) : (obj2 instanceof BasicElement ? DatabaseColorManager.getColor(this.project, this.getDataSource(obj2)) : null);
    }

    private static final String _init_$lambda$0() {
        return "&Filter";
    }

    private static final boolean applyFilter$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$rebuildTree(DatabaseSchemaSelectionTree $this) {
        $this.rebuildTree();
    }
}

