/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J\b\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0015\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0010\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0010\u00a2\u0006\u0002\b'J)\u0010(\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*H\u0010\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0010\u00a2\u0006\u0002\b.J\u001d\u0010/\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b2R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u000234\u00a8\u00065"}, d2={"Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "Lcom/intellij/database/view/structure/DvTreeLayer;", "Lcom/intellij/openapi/Disposable;", "()V", "base", "getBase", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "level", "", "getLevel", "()B", "vo", "Lcom/intellij/database/view/structure/DvViewOptions;", "getVo", "()Lcom/intellij/database/view/structure/DvViewOptions;", "baseParentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "", "countAllChildrenOf", "", "countRealChildrenOf", "dispose", "extension", "Lcom/intellij/database/view/structure/DvStructureExtension;", "dbms", "Lcom/intellij/database/Dbms;", "isValid", "", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeAbstractLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeAbstractLayer.kt\ncom/intellij/database/view/structure/DvTreeAbstractLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1774#2,4:103\n*S KotlinDebug\n*F\n+ 1 DvTreeAbstractLayer.kt\ncom/intellij/database/view/structure/DvTreeAbstractLayer\n*L\n39#1:103,4\n*E\n"})
public abstract class DvTreeAbstractLayer
implements DvTreeLayer,
Disposable {
    private DvTreeAbstractLayer() {
    }

    @Nullable
    public abstract DvTreeLayer getBase();

    @NotNull
    public abstract DvTreeContext getContext();

    public abstract byte getLevel();

    @NotNull
    protected final DvViewOptions getVo() {
        return this.getContext().vo;
    }

    @Nullable
    protected final DvStructureExtension extension(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return DvStructureExtension.Companion.getEP().forDbms(dbms);
    }

    @Nullable
    protected final BasicNode baseParentOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.getBase();
        if (dvTreeLayer == null) {
            return null;
        }
        DvTreeLayer base = dvTreeLayer;
        BasicNode p2 = base.parentOf(node2);
        if (p2 == node2) {
            String layerClassName = base.getClass().getSimpleName();
            throw new InternalError("The method " + layerClassName + ".parentOf() works incorrectly for node: " + node2 + " (node class: " + node2.getClass().getSimpleName() + ")");
        }
        return p2;
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return !this.isAlwaysLeaf(node2) ? CollectionsKt.count((Iterable)((Iterable)this.childrenOf(node2))) : 0;
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (!this.isAlwaysLeaf(node2)) {
            Iterable $this$count$iv = (Iterable)this.childrenOf(node2);
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    BasicNode it2 = (BasicNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    DvTreeNodeRank r = DvTreeNodeRankFun.getTreeNodeRank(it2);
                    if (!(r.compareTo((Enum)DvTreeNodeRank.TL_SYNTHETIC) < 0 && r != DvTreeNodeRank.TL_FAMILY) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
    }

    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
    }

    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
    }

    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
    }

    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
    }

    public void onViewOptionsChanged$intellij_database_core_impl() {
    }

    public abstract void clearAll();

    public void dispose() {
        this.clearAll();
    }

    @Override
    public boolean isValid(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.getBase();
        return dvTreeLayer != null ? dvTreeLayer.isValid(node2) : false;
    }

    public /* synthetic */ DvTreeAbstractLayer(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

