/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.editors.DatabaseTableEditorForm;
import com.intellij.database.view.editors.DatabaseTableForeignKeysEditor;
import com.intellij.database.view.editors.DatabaseTableGrantsEditor;
import com.intellij.database.view.editors.DatabaseTableIndicesEditor;
import com.intellij.database.view.editors.DatabaseTableKeysEditor;
import com.intellij.database.view.editors.DatabaseTableNameForm;
import com.intellij.database.view.editors.TableNameForm;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseTableEditor
extends DatabaseEditorBaseEx {
    private static final Border BORDER = IdeBorderFactory.createBorder((int)13);
    private final TableNameForm myTableNameForm;
    private final TabbedPaneWrapper myTabs;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final TableEditorModel myTableModel;
    private final List<TabProvider> myTabProviders;
    private JPanel myMainPanel;
    private boolean myActive;

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel, @NotNull DatabaseTableEditorForm form2, @Nullable TableNameForm tableNameForm) {
        if (state == null) {
            DatabaseTableEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(1);
        }
        if (tableModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(2);
        }
        if (form2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(3);
        }
        this(state, caps, tableModel, new TableEditorToolbarsDecorator.DefaultToolbarsDecorator(), form2, tableNameForm);
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel, @NotNull TableEditorToolbarsDecorator decorator, @NotNull DatabaseTableEditorForm form2, @Nullable TableNameForm tableNameForm) {
        if (state == null) {
            DatabaseTableEditor.$$$reportNull$$$0(4);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(5);
        }
        if (tableModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(6);
        }
        if (decorator == null) {
            DatabaseTableEditor.$$$reportNull$$$0(7);
        }
        if (form2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(8);
        }
        super(state);
        this.myActive = true;
        this.myCaps = caps;
        this.myTableModel = tableModel;
        this.myTabProviders = this.getTabProviders(decorator, caps);
        this.myTableNameForm = tableNameForm != null ? tableNameForm : this.createTableNameForm();
        this.myTabs = new TabbedPaneWrapper((Disposable)this);
        this.addToForm(form2);
        this.applyCaps();
        for (JComponent c2 : ((JBTreeTraverser)UIUtil.uiTraverser((Component)this.myTabs.getComponent()).expandAndFilter(Conditions.not((Condition)Conditions.instanceOf(JTable.class)))).filter(JComponent.class)) {
            c2.setFocusCycleRoot(false);
            c2.setFocusTraversalPolicy(null);
        }
        this.initSubscriptions();
        this.updateFromModel();
    }

    public void addToForm(@NotNull DatabaseTableEditorForm form2) {
        JPanel tableNamePanel;
        if (form2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(9);
        }
        if ((tableNamePanel = form2.getTableNamePanel()).getComponentCount() == 0 || tableNamePanel.getComponent(0) != this.myTableNameForm.getComponent()) {
            tableNamePanel.removeAll();
            tableNamePanel.add((Component)this.myTableNameForm.getComponent(), "Center");
        }
        form2.getTabsPanel().removeAll();
        form2.getTabsPanel().add((Component)this.myTabs.getComponent(), "Center");
        this.myMainPanel = form2.getMainPanel();
    }

    private boolean setSelectedTabSafe(@NotNull JComponent comp) {
        int idx;
        if (comp == null) {
            DatabaseTableEditor.$$$reportNull$$$0(10);
        }
        if ((idx = this.myTabs.indexOfComponent(comp)) != -1) {
            this.myTabs.setSelectedIndex(idx);
        }
        return idx != -1;
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject exported) {
        if (exported == null) {
            DatabaseTableEditor.$$$reportNull$$$0(11);
        }
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isMyObject(exported)) continue;
            return this.setSelectedTabSafe(provider.getComponent()) ? provider.startItemEditing(exported) : null;
        }
        return null;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        JComponent tab2 = this.myTabs.getSelectedComponent();
        DatabaseEditorBaseEx res2 = null;
        for (TabProvider provider : this.myTabProviders) {
            if (tab2 != provider.getComponent()) continue;
            res2 = provider.getActiveEditor();
        }
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.chooseNotNull(res2, (Object)this);
        if (databaseEditorBaseEx == null) {
            DatabaseTableEditor.$$$reportNull$$$0(12);
        }
        return databaseEditorBaseEx;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
        if (tableEditorCaps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(13);
        }
        return tableEditorCaps;
    }

    @NotNull
    public TableNameForm getTableNameForm() {
        TableNameForm tableNameForm = this.myTableNameForm;
        if (tableNameForm == null) {
            DatabaseTableEditor.$$$reportNull$$$0(14);
        }
        return tableNameForm;
    }

    @NotNull
    protected Border getTabComponentBorder() {
        Border border2 = BORDER;
        if (border2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(15);
        }
        return border2;
    }

    protected void applyCaps() {
        this.myTableNameForm.applyCaps();
        for (TabProvider provider : this.myTabProviders) {
            provider.configure(this.myCaps);
        }
        this.refillTabs();
    }

    @NotNull
    protected List<TabProvider> getTabProviders(@NotNull TableEditorToolbarsDecorator decorator, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (decorator == null) {
            DatabaseTableEditor.$$$reportNull$$$0(16);
        }
        if (caps == null) {
            DatabaseTableEditor.$$$reportNull$$$0(17);
        }
        List<TabProvider> list = Arrays.asList(new DatabaseTableColumnsEditor(this, caps, decorator), new DatabaseTableKeysEditor(this, caps, decorator), new DatabaseTableIndicesEditor(this, caps, decorator), new DatabaseTableForeignKeysEditor(this, caps, decorator), new DatabaseTableGrantsEditor(this));
        if (list == null) {
            DatabaseTableEditor.$$$reportNull$$$0(18);
        }
        return list;
    }

    public void setActive(boolean active) {
        this.myActive = active;
    }

    public void initSubscriptions() {
        this.myTableNameForm.getTableNameField().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DatabaseTableEditor.this.myUpdating || !DatabaseTableEditor.this.myActive) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setName(DatabaseTableEditor.this.myTableNameForm.getTableNameField().getText());
                DatabaseTableEditor.this.myTableModel.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/editors/DatabaseTableEditor$1", "documentChanged"));
            }
        }, (Disposable)this);
        this.myTableNameForm.getCommentField().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DatabaseTableEditor.this.myUpdating || !DatabaseTableEditor.this.myActive) {
                    return;
                }
                String newVal = StringUtil.nullize((String)DatabaseTableEditor.this.myTableNameForm.getCommentField().getText());
                String oldVal = StringUtil.nullize((String)DatabaseTableEditor.this.myTableModel.getComment());
                if (Objects.equals(oldVal, newVal)) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setComment(newVal);
                DatabaseTableEditor.this.myTableModel.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseTableEditor$2", "documentChanged"));
            }
        }, (Disposable)this);
        this.myTableModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableEditor.this.fromModelToUi();
            }
        }, this);
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(19);
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableEditor.setValue(this.myTableNameForm.getTableNameField(), this.getTableModel().getName());
        DatabaseTableEditor.setValue(this.myTableNameForm.getCommentField(), StringUtil.notNullize((String)this.getTableModel().getComment()));
        this.myTabProviders.forEach(TabProvider::updateFromModel);
        this.updateTabTitles();
    }

    protected void updateTabTitles() {
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            this.myTabs.setTitleAt(this.myTabs.indexOfComponent(provider.getComponent()), provider.getTabTitle());
        }
    }

    private void refillTabs() {
        JComponent prevComp = this.myTabs.getSelectedComponent();
        this.myTabs.removeAll();
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            JComponent comp = provider.getComponent();
            this.myTabs.addTab(provider.getTabTitle(), comp);
        }
        int index2 = this.myTabs.indexOfComponent(prevComp);
        if (index2 != -1) {
            this.myTabs.setSelectedIndex(index2);
        }
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(20);
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField2 = this.myTableNameForm.getTableNameField();
        if (editorTextField2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(21);
        }
        return editorTextField2;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseTableEditor.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.getTableModel().getName())) {
            return new ValidationInfo(DatabaseBundle.message("dialog.message.valid.table.name", this.getTableModel().getName()), (JComponent)this.myTableNameForm.getTableNameField());
        }
        for (TabProvider provider : this.myTabProviders) {
            ValidationInfo info2 = provider.validate();
            if (info2 == null) continue;
            return info2;
        }
        return null;
    }

    @NotNull
    protected TableNameForm createTableNameForm() {
        return new DatabaseTableNameForm(this.getContext(), this.myCaps, this.myTableModel);
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableEditor.$$$reportNull$$$0(23);
        }
        return deTable;
    }

    @TestOnly
    @NotNull
    public EditorTextField getNameEditor() {
        EditorTextField editorTextField2 = this.myTableNameForm.getTableNameField();
        if (editorTextField2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(24);
        }
        return editorTextField2;
    }

    @TestOnly
    @NotNull
    public EditorTextField getCommentEditor() {
        EditorTextField editorTextField2 = this.myTableNameForm.getCommentField();
        if (editorTextField2 == null) {
            DatabaseTableEditor.$$$reportNull$$$0(25);
        }
        return editorTextField2;
    }

    @NotNull
    @TestOnly
    public DatabaseTableColumnsEditor getColumnsEditor() {
        return this.get(DatabaseTableColumnsEditor.class);
    }

    @NotNull
    @TestOnly
    public DatabaseTableIndicesEditor getIndicesEditor() {
        return this.get(DatabaseTableIndicesEditor.class);
    }

    @NotNull
    @TestOnly
    public DatabaseTableKeysEditor getKeysEditor() {
        return this.get(DatabaseTableKeysEditor.class);
    }

    @NotNull
    @TestOnly
    public DatabaseTableForeignKeysEditor getForeignKeysEditor() {
        return this.get(DatabaseTableForeignKeysEditor.class);
    }

    @NotNull
    @TestOnly
    private <T extends TabProvider> T get(@NotNull Class<T> clazz) {
        if (clazz == null) {
            DatabaseTableEditor.$$$reportNull$$$0(26);
        }
        TabProvider tabProvider = Objects.requireNonNull((TabProvider)JBIterable.from(this.myTabProviders).filter(clazz).first());
        if (tabProvider == null) {
            DatabaseTableEditor.$$$reportNull$$$0(27);
        }
        return (T)tabProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exported";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableEditor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableNameForm";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabComponentBorder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabProviders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentEditor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addToForm";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTabSafe";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTabProviders";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 25, 27 -> new IllegalStateException(string);
        };
    }

    public static abstract class TabProvider {
        private boolean myTabEnabled = true;

        @NotNull
        public abstract JComponent getComponent();

        @Nullable
        public abstract DatabaseEditorBaseEx startItemEditing(@NotNull DeObject var1);

        @Nullable
        public abstract DatabaseEditorBaseEx getActiveEditor();

        @NlsContexts.TabTitle
        @NotNull
        public abstract String getTabTitle();

        public abstract boolean isMyObject(@NotNull DeObject var1);

        public abstract void updateFromModel();

        public abstract void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps var1);

        @Nullable
        public ValidationInfo validate() {
            return null;
        }

        void setTabEnabled(boolean enabled) {
            this.myTabEnabled = enabled;
        }

        boolean isTabEnabled() {
            return this.myTabEnabled;
        }
    }
}

