/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.actions;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.actions.ConfigureLayoutDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/actions/ConfigureLayoutAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "invalidateCaches", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "showConfigurationDialog", "configurationKey", "", "update", "getConfigurationKey", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.database.impl"})
public final class ConfigureLayoutAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (e2.getProject() == null) {
            return;
        }
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        String configurationKey = this.getConfigurationKey(dataContext);
        e2.getPresentation().setEnabledAndVisible(configurationKey != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BasicNode basicNode = DatabaseContextFun.getSelectedSingleNode(dataContext);
        if (basicNode == null) {
            return;
        }
        BasicNode node2 = basicNode;
        String string = this.getConfigurationKey(node2);
        if (string == null) {
            return;
        }
        String configurationKey = string;
        DataContext dataContext2 = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataSourceNode dataSourceNode = (DataSourceNode)CollectionsKt.singleOrNull(DatabaseContextFun.getSelectionRelatedDataSources(dataContext2));
        if (dataSourceNode == null) {
            return;
        }
        DataSourceNode dsn = dataSourceNode;
        LocalDataSource localDataSource = dsn.getLocalDataSource();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        this.showConfigurationDialog(project2, ds, node2, configurationKey);
    }

    private final String getConfigurationKey(DataContext $this$getConfigurationKey) {
        BasicNode basicNode = DatabaseContextFun.getSelectedSingleNode($this$getConfigurationKey);
        if (basicNode == null) {
            return null;
        }
        BasicNode node2 = basicNode;
        return this.getConfigurationKey(node2);
    }

    private final String getConfigurationKey(BasicNode $this$getConfigurationKey) {
        return $this$getConfigurationKey instanceof BasicSchema ? ((BasicSchema)$this$getConfigurationKey).getNaturalName() : null;
    }

    private final void showConfigurationDialog(Project project, LocalDataSource ds, BasicNode node2, String configurationKey) {
        ConfigureLayoutDialog dialog = new ConfigureLayoutDialog(project, ds, node2, configurationKey);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            String configurationText = dialog.getConfigurationText();
            ds.setLayoutConfigurationFor(configurationKey, configurationText);
            this.invalidateCaches(project, ds, node2);
        }
    }

    private final void invalidateCaches(Project project, LocalDataSource ds, BasicNode node2) {
    }
}

