/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.util.common.BooleanFalseVal;
import com.intellij.database.util.common.BooleanHolder;
import com.intellij.database.util.common.BooleanTrueVal;
import com.intellij.database.util.common.BooleanVal;
import com.intellij.database.util.common.BooleanVar;
import com.intellij.database.view.TreeFilterModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.FieldInplaceActionButtonLook;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\f\u0018\u0000 O2\u00020\u0001:\u0004OPQRB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0002062\u0006\u00108\u001a\u00020\tH\u0002J$\u00109\u001a\u00140:R\u0010\u0012\f\u0012\n 2*\u0004\u0018\u00010\u00030\u00030;2\b\u0010<\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010=\u001a\u000206H\u0014J\n\u0010>\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010?\u001a\u00020\fH\u0014J\b\u0010@\u001a\u000206H\u0002J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020CH\u0014J\b\u0010D\u001a\u000206H\u0002J\u001d\u0010E\u001a\u0002062\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010GH\u0002\u00a2\u0006\u0002\u0010HJ\u0018\u0010I\u001a\u0002062\u0006\u00108\u001a\u00020\t2\u0006\u0010J\u001a\u00020\fH\u0002J\u0010\u0010K\u001a\u0002062\u0006\u0010J\u001a\u00020\fH\u0002J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020\fH\u0002J\u0010\u0010N\u001a\u0002062\u0006\u0010M\u001a\u00020\fH\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u0019\u001a\u000f\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u001b\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0018\u00010\"R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0014\u0010(\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0016\u00100\u001a\n 2*\u0004\u0018\u00010101X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006S"}, d2={"Lcom/intellij/database/view/TreeFilterSearch;", "Lcom/intellij/ui/TreeSpeedSearch;", "tree", "Ljavax/swing/JTree;", "filterModel", "Lcom/intellij/database/view/TreeFilterModel;", "presentableStringFunction", "Ljava/util/function/Function;", "Ljavax/swing/tree/TreePath;", "", "(Ljavax/swing/JTree;Lcom/intellij/database/view/TreeFilterModel;Ljava/util/function/Function;)V", "enabled", "", "getEnabled", "()Z", "filterIsEnabledCheck", "Lcom/intellij/database/util/common/BooleanVal;", "getFilterIsEnabledCheck", "()Lcom/intellij/database/util/common/BooleanVal;", "setFilterIsEnabledCheck", "(Lcom/intellij/database/util/common/BooleanVal;)V", "filterIsStickyCheck", "getFilterIsStickyCheck", "setFilterIsStickyCheck", "filtering", "nothingFoundTextProvider", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "getNothingFoundTextProvider", "()Ljava/util/function/Supplier;", "setNothingFoundTextProvider", "(Ljava/util/function/Supplier;)V", "oldEmptyText", "popup", "Lcom/intellij/database/view/TreeFilterSearch$Popup;", "startedBySlash", "startingFilterAuto", "getStartingFilterAuto", "startingFilterBySlash", "getStartingFilterBySlash", "sticky", "getSticky", "stickyStateHolder", "Lcom/intellij/database/util/common/BooleanVar;", "getStickyStateHolder", "()Lcom/intellij/database/util/common/BooleanVar;", "setStickyStateHolder", "(Lcom/intellij/database/util/common/BooleanVar;)V", "templateAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "getTree", "()Ljavax/swing/JTree;", "adjustEmptyText", "", "continueFiltering", "input", "createPopup", "Lcom/intellij/ui/SpeedSearchBase$SearchPopup;", "Lcom/intellij/ui/SpeedSearchBase;", "s", "fireStateChanged", "getInput", "keepEvenWhenFocusLost", "pauseFiltering", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "restoreEmptyText", "restoreSelections", "selections", "", "([Ljavax/swing/tree/TreePath;)V", "startFiltering", "byKey", "startFilteringIfPossible", "stopFiltering", "preserveSticky", "stopFilteringIfNeeded", "Companion", "FilterAction", "FilterActionButton", "Popup", "intellij.database.impl"})
public final class TreeFilterSearch
extends TreeSpeedSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTree tree;
    @NotNull
    private final TreeFilterModel filterModel;
    @NotNull
    private BooleanVal filterIsEnabledCheck;
    @NotNull
    private BooleanVal filterIsStickyCheck;
    @NotNull
    private BooleanVar stickyStateHolder;
    @Nullable
    private Supplier<String> nothingFoundTextProvider;
    private final AnAction templateAction;
    private boolean filtering;
    private boolean startedBySlash;
    @Nullable
    private Popup popup;
    @Nullable
    private String oldEmptyText;
    @NotNull
    private static final FieldInplaceActionButtonLook FIELD_INPLACE_LOOK = new FieldInplaceActionButtonLook();
    @NotNull
    private static final BooleanHolder internalStickyStateHolder = new BooleanHolder(false, 1, null);
    @NotNull
    private static final Icon funnelIconLightNormal;
    @NotNull
    private static final Icon funnelIconLightHover;
    @NotNull
    private static final Icon funnelIconLightActive;
    @NotNull
    private static final Icon funnelIconDarkNormal;
    @NotNull
    private static final Icon funnelIconDarkHover;
    @NotNull
    private static final Icon funnelIconDarkActive;

    private TreeFilterSearch(JTree tree, TreeFilterModel filterModel, Function<? super TreePath, String> presentableStringFunction) {
        super(tree, false, null, presentableStringFunction);
        this.tree = tree;
        this.filterModel = filterModel;
        this.filterIsEnabledCheck = BooleanTrueVal.INSTANCE;
        this.filterIsStickyCheck = BooleanFalseVal.INSTANCE;
        this.stickyStateHolder = internalStickyStateHolder;
        this.templateAction = ActionManager.getInstance().getAction("DatabaseView.Filter");
    }

    @NotNull
    public final JTree getTree() {
        return this.tree;
    }

    @NotNull
    public final BooleanVal getFilterIsEnabledCheck() {
        return this.filterIsEnabledCheck;
    }

    public final void setFilterIsEnabledCheck(@NotNull BooleanVal booleanVal) {
        Intrinsics.checkNotNullParameter((Object)booleanVal, (String)"<set-?>");
        this.filterIsEnabledCheck = booleanVal;
    }

    @NotNull
    public final BooleanVal getFilterIsStickyCheck() {
        return this.filterIsStickyCheck;
    }

    public final void setFilterIsStickyCheck(@NotNull BooleanVal booleanVal) {
        Intrinsics.checkNotNullParameter((Object)booleanVal, (String)"<set-?>");
        this.filterIsStickyCheck = booleanVal;
    }

    @NotNull
    public final BooleanVar getStickyStateHolder() {
        return this.stickyStateHolder;
    }

    public final void setStickyStateHolder(@NotNull BooleanVar booleanVar) {
        Intrinsics.checkNotNullParameter((Object)booleanVar, (String)"<set-?>");
        this.stickyStateHolder = booleanVar;
    }

    @Nullable
    public final Supplier<String> getNothingFoundTextProvider() {
        return this.nothingFoundTextProvider;
    }

    public final void setNothingFoundTextProvider(@Nullable Supplier<String> supplier2) {
        this.nothingFoundTextProvider = supplier2;
    }

    private final boolean getEnabled() {
        return this.filterIsEnabledCheck.getValue();
    }

    private final boolean getSticky() {
        return this.filterIsStickyCheck.getValue();
    }

    private final boolean getStartingFilterBySlash() {
        return this.getEnabled();
    }

    private final boolean getStartingFilterAuto() {
        return this.getEnabled() && this.getSticky() && this.stickyStateHolder.getValue();
    }

    @NotNull
    protected SpeedSearchBase.SearchPopup createPopup(@Nullable String s2) {
        Popup popup2;
        this.popup = popup2 = new Popup(s2);
        return popup2;
    }

    protected void processKeyEvent(@NotNull KeyEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (!(e2.getKeyCode() != 47 && e2.getKeyChar() != '/' || e2.isShiftDown())) {
            if (this.getStartingFilterBySlash() && !this.filtering) {
                this.startFilteringIfPossible(true);
                e2.consume();
            } else if (this.startedBySlash) {
                e2.consume();
            } else {
                super.processKeyEvent(e2);
            }
        } else if (this.filtering && e2.getKeyCode() == 27) {
            if (this.startedBySlash) {
                this.stopFiltering(false);
                e2.consume();
            } else {
                this.stopFiltering(this.getSticky());
                super.processKeyEvent(e2);
            }
        } else {
            if (!this.filtering && this.getStartingFilterAuto()) {
                this.startFilteringIfPossible(false);
            }
            super.processKeyEvent(e2);
        }
    }

    protected void fireStateChanged() {
        if (!this.filtering) {
            if (this.getStartingFilterAuto()) {
                String string = this.getInput();
                if (string == null) {
                    return;
                }
                String input = string;
                this.startFiltering(input, false);
            }
        } else {
            String input = this.getInput();
            if (input != null) {
                this.continueFiltering(input);
            } else if (this.startedBySlash) {
                this.stopFiltering(false);
            } else {
                this.pauseFiltering();
            }
        }
        super.fireStateChanged();
    }

    private final String getInput() {
        return StringKt.nullize((String)this.getEnteredPrefix(), (boolean)true);
    }

    private final void startFilteringIfPossible(boolean byKey) {
        if (!this.getEnabled()) {
            return;
        }
        if (this.filtering) {
            return;
        }
        String string = this.getInput();
        if (string == null) {
            return;
        }
        String input = string;
        this.startFiltering(input, byKey);
        if (this.getSticky()) {
            this.stickyStateHolder.setValue(true);
        }
    }

    private final void startFiltering(String input, boolean byKey) {
        TreePath[] selections = this.tree.getSelectionPaths();
        this.filtering = true;
        this.startedBySlash = byKey;
        Popup popup2 = this.popup;
        if (popup2 != null) {
            popup2.updateFilterButton();
        }
        this.adjustEmptyText();
        this.filterModel.filter(((Object)StringsKt.trim((CharSequence)input)).toString());
        this.stickyStateHolder.setValue(this.getSticky());
        this.restoreSelections(selections);
    }

    private final void continueFiltering(String input) {
        this.filterModel.filter(((Object)StringsKt.trim((CharSequence)input)).toString());
    }

    private final void pauseFiltering() {
        this.filterModel.reset();
    }

    private final void stopFilteringIfNeeded(boolean preserveSticky) {
        if (!this.filtering) {
            return;
        }
        this.stopFiltering(preserveSticky);
    }

    private final void stopFiltering(boolean preserveSticky) {
        TreePath[] selections = this.tree.getSelectionPaths();
        this.filterModel.reset();
        this.startedBySlash = false;
        this.filtering = false;
        Popup popup2 = this.popup;
        if (popup2 != null) {
            popup2.updateFilterButton();
        }
        if (!preserveSticky) {
            this.stickyStateHolder.setValue(false);
        }
        this.restoreSelections(selections);
        this.restoreEmptyText();
    }

    private final void restoreSelections(TreePath[] selections) {
        if (selections != null && !(selections.length == 0)) {
            TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"getSelectionModel(...)");
            TreeSelectionModel sm = treeSelectionModel;
            sm.setSelectionPaths(selections);
        } else {
            this.tree.clearSelection();
        }
    }

    private final void adjustEmptyText() {
        if (this.tree instanceof ComponentWithEmptyText) {
            this.oldEmptyText = ((ComponentWithEmptyText)this.tree).getEmptyText().getText();
            StatusText statusText = ((ComponentWithEmptyText)this.tree).getEmptyText();
            Supplier<String> supplier2 = this.nothingFoundTextProvider;
            String string = supplier2 != null ? supplier2.get() : null;
            if (string == null) {
                string = "nothing found";
            }
            statusText.setText(string);
        }
    }

    private final void restoreEmptyText() {
        if (this.tree instanceof ComponentWithEmptyText) {
            StatusText statusText = ((ComponentWithEmptyText)this.tree).getEmptyText();
            String string = this.oldEmptyText;
            if (string == null) {
                string = "";
            }
            statusText.setText(string);
        }
    }

    protected boolean keepEvenWhenFocusLost() {
        return this.filtering;
    }

    public /* synthetic */ TreeFilterSearch(JTree tree, TreeFilterModel filterModel, Function presentableStringFunction, DefaultConstructorMarker $constructor_marker) {
        this(tree, filterModel, presentableStringFunction);
    }

    static {
        Icon icon = DatabaseIcons.FunnelGray;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FunnelGray");
        funnelIconLightNormal = icon;
        Icon icon2 = DatabaseIcons.FunnelHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FunnelHover");
        funnelIconLightHover = icon2;
        Icon icon3 = DatabaseIcons.FunnelSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FunnelSelected");
        funnelIconLightActive = icon3;
        Icon icon4 = DatabaseIcons.FunnelGray;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FunnelGray");
        funnelIconDarkNormal = icon4;
        Icon icon5 = DatabaseIcons.FunnelHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"FunnelHover");
        funnelIconDarkHover = icon5;
        Icon icon6 = DatabaseIcons.FunnelSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"FunnelSelected");
        funnelIconDarkActive = icon6;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$Companion;", "", "()V", "FIELD_INPLACE_LOOK", "Lcom/intellij/openapi/actionSystem/impl/FieldInplaceActionButtonLook;", "funnelIconDarkActive", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "funnelIconDarkHover", "funnelIconDarkNormal", "funnelIconLightActive", "funnelIconLightHover", "funnelIconLightNormal", "internalStickyStateHolder", "Lcom/intellij/database/util/common/BooleanHolder;", "isLight", "", "()Z", "installOn", "Lcom/intellij/database/view/TreeFilterSearch;", "tree", "Ljavax/swing/JTree;", "filterModel", "Lcom/intellij/database/view/TreeFilterModel;", "presentableStringFunction", "Ljava/util/function/Function;", "Ljavax/swing/tree/TreePath;", "", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLight() {
            return JBColor.isBright();
        }

        @NotNull
        public final TreeFilterSearch installOn(@NotNull JTree tree, @NotNull TreeFilterModel filterModel, @NotNull Function<? super TreePath, String> presentableStringFunction) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)filterModel, (String)"filterModel");
            Intrinsics.checkNotNullParameter(presentableStringFunction, (String)"presentableStringFunction");
            TreeFilterSearch search = new TreeFilterSearch(tree, filterModel, presentableStringFunction, null);
            search.setupListeners();
            return search;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "(Lcom/intellij/database/view/TreeFilterSearch;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.database.impl"})
    private final class FilterAction
    extends DumbAwareToggleAction
    implements TooltipDescriptionProvider {
        public FilterAction() {
            this.copyFrom(TreeFilterSearch.this.templateAction);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            return TreeFilterSearch.this.filtering;
        }

        public void setSelected(@NotNull AnActionEvent e2, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            if (state) {
                TreeFilterSearch.this.startFilteringIfPossible(false);
            } else {
                boolean withCtrl = (e2.getModifiers() & 2) != 0;
                TreeFilterSearch.this.stopFilteringIfNeeded(withCtrl && !TreeFilterSearch.this.startedBySlash);
                if (withCtrl) {
                    TreeFilterSearch.this.hidePopup();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "(Lcom/intellij/database/view/TreeFilterSearch$FilterAction;)V", "getIcon", "Ljavax/swing/Icon;", "getPopState", "", "Companion", "intellij.database.impl"})
    private static final class FilterActionButton
    extends ActionButton {
        @NotNull
        private static final Companion Companion = new Companion(null);

        public FilterActionButton(@NotNull FilterAction action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            super((AnAction)action, Companion.obtainPresentation(action), "TreeFilter", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook((ActionButtonLook)FIELD_INPLACE_LOOK);
            this.updateIcon();
        }

        @NotNull
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            Icon icon = super.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @JvmStatic
        @NotNull
        public static final Presentation obtainPresentation(@NotNull FilterAction action) {
            return Companion.obtainPresentation(action);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton$Companion;", "", "()V", "obtainPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "action", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "intellij.database.impl"})
        private static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Presentation obtainPresentation(@NotNull FilterAction action) {
                Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
                Presentation presentation = action.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
                Presentation tp = presentation;
                Presentation presentation2 = tp.clone();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"clone(...)");
                Presentation p2 = presentation2;
                p2.setText(DatabaseBundle.message("tree.filter.button.text", new Object[0]));
                p2.setDescription(DatabaseBundle.message("tree.filter.button.tooltip", new Object[0]));
                if (TreeFilterSearch.Companion.isLight()) {
                    p2.setIcon(funnelIconLightNormal);
                    p2.setHoveredIcon(funnelIconLightHover);
                    p2.setSelectedIcon(funnelIconLightActive);
                } else {
                    p2.setIcon(funnelIconDarkNormal);
                    p2.setHoveredIcon(funnelIconDarkHover);
                    p2.setSelectedIcon(funnelIconDarkActive);
                }
                return p2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00140\u0001R\u0010\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u0002B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u0012\u0010\b\u001a\u00060\tR\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$Popup;", "Lcom/intellij/ui/SpeedSearchBase$SearchPopup;", "Lcom/intellij/ui/SpeedSearchBase;", "Ljavax/swing/JTree;", "kotlin.jvm.PlatformType", "initialString", "", "(Lcom/intellij/database/view/TreeFilterSearch;Ljava/lang/String;)V", "filterAction", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "funnelButton", "Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton;", "updateFilterButton", "", "intellij.database.impl"})
    private final class Popup
    extends SpeedSearchBase.SearchPopup {
        @NotNull
        private final FilterAction filterAction;
        @NotNull
        private final FilterActionButton funnelButton;

        public Popup(String initialString) {
            super((SpeedSearchBase)TreeFilterSearch.this, initialString);
            this.filterAction = new FilterAction();
            this.funnelButton = new FilterActionButton(this.filterAction);
            this.mySearchField.setColumns(15);
            this.mySearchField.setMinimumSize((Dimension)new JBDimension(100, 26));
            this.setMinimumSize((Dimension)new JBDimension(126, 26));
            this.add((Component)((Object)this.funnelButton), "East");
            if (TreeFilterSearch.this.getStartingFilterBySlash()) {
                Shortcut[] shortcutArray = this.filterAction.getShortcutSet().getShortcuts();
                Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
                for (Shortcut shortcut : shortcutArray) {
                    if (!(shortcut instanceof KeyboardShortcut) || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
                    ((JTree)TreeFilterSearch.this.myComponent).registerKeyboardAction(arg_0 -> Popup._init_$lambda$0(this, arg_0), ((KeyboardShortcut)shortcut).getFirstKeyStroke(), 1);
                }
            }
        }

        public final void updateFilterButton() {
            this.funnelButton.update();
        }

        private static final void _init_$lambda$0(Popup this$0, ActionEvent it2) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.funnelButton.click();
        }
    }
}

