/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.diagnostic.LogInterceptor;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelRoot;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DvTreeIcons;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0000\u001a\"\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a2\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u001a\u0012\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!H\u0000\u001a\u001a\u0010'\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u001a\u0010*\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!H\u0000\u001a\u001d\u0010+\u001a\u00070\u0005\u00a2\u0006\u0002\b,2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u001a\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a\f\u00100\u001a\u00020\u0001*\u000201H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\u00020\u0001*\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u00062"}, d2={"boldDataSources", "", "getBoldDataSources", "()Z", "boldDataSourcesRegistryKey", "", "hidePillsWhenL3", "getHidePillsWhenL3", "hidePillsWhenL3RegistryKey", "isLow", "Lcom/intellij/database/model/properties/Level;", "(Lcom/intellij/database/model/properties/Level;)Z", "addDetailsLevelIcon", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "level", "addLevelIcon", "area", "Lcom/intellij/database/model/basic/BasicMultiLevelIntrospectableArea;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "declared", "extraLow", "nullMeansAuto", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "addSecondIcon", "secondIcon", "Ljavax/swing/Icon;", "countShowChildrenNum", "", "node", "Lcom/intellij/database/model/basic/BasicNode;", "structure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "vo", "Lcom/intellij/database/view/structure/DvViewOptions;", "getDataSourceForTopNode", "getDataSourceIcon", "project", "Lcom/intellij/openapi/project/Project;", "getNodeIcon", "getNodePrimaryText", "Lorg/jetbrains/annotations/Nls;", "isInIntrospectionScope", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "scanToCheckWhetherModelHasLowIntrospectionLevels", "Lcom/intellij/database/model/DasModel;", "intellij.database.impl"})
@JvmName(name="DbNodeDescriptorHelper")
@SourceDebugExtension(value={"SMAP\nDbNodeDescriptorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbNodeDescriptorHelper.kt\ncom/intellij/database/view/DbNodeDescriptorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class DbNodeDescriptorHelper {
    @NotNull
    private static final String hidePillsWhenL3RegistryKey = "database.view.levels.hide.L3";
    @NotNull
    private static final String boldDataSourcesRegistryKey = "database.view.ds.bold";

    private static final boolean getHidePillsWhenL3() {
        return Registry.is((String)hidePillsWhenL3RegistryKey);
    }

    public static final boolean getBoldDataSources() {
        return Registry.is((String)boldDataSourcesRegistryKey);
    }

    @Nullable
    public static final RawDataSource getDataSourceForTopNode(@NotNull BasicNode node2) {
        RawDataSource rawDataSource;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        if (basicNode instanceof DataSourceNode) {
            rawDataSource = ((DataSourceNode)node2).rawDataSource;
        } else if (basicNode instanceof BasicNamespace) {
            BasicModel basicModel = ((BasicNamespace)node2).getModel();
            if (basicModel != null) {
                BasicModel it2 = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it2);
            } else {
                rawDataSource = null;
            }
        } else if (basicNode instanceof BasicIntrospectableArea) {
            BasicModel basicModel = ((BasicIntrospectableArea)node2).getModel();
            if (basicModel != null) {
                BasicModel it3 = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it3);
            } else {
                rawDataSource = null;
            }
        } else {
            rawDataSource = null;
        }
        return rawDataSource;
    }

    @NotNull
    public static final String getNodePrimaryText(@NotNull BasicNode node2, @NotNull DvTreeStructure structure) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        String text2 = structure.presentableNameOf(node2);
        if (node2 instanceof BasicElement && Intrinsics.areEqual((Object)((BasicElement)node2).getKind(), (Object)ObjectKind.BODY)) {
            String string = DatabaseBundle.message("ObjectKind.body", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            text2 = string;
        }
        return text2;
    }

    public static final int countShowChildrenNum(@NotNull BasicNode node2, @NotNull DvTreeStructure structure, @NotNull DvViewOptions vo) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)vo, (String)"vo");
        boolean toCount = DvTreeNodeRankFun.getTreeNodeRank(node2) == DvTreeNodeRank.TL_FAMILY ? true : (node2 instanceof BasicNamespaceOwner ? !vo.getGroupNamespaces() : false);
        return toCount ? structure.countRealChildrenOf(node2) : 0;
    }

    @Nullable
    public static final Icon getNodeIcon(@NotNull Project project, @NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Icon icon = null;
        BasicNode basicNode = node2;
        if (basicNode instanceof BasicElement) {
            Object object = ((BasicElement)node2).getModel();
            if (object == null || (object = object.getDbms()) == null) {
                object = Dbms.UNKNOWN;
            }
            Object dbms = object;
            ModelHelper modelHelper = ModelFacade.forDbms((Dbms)dbms).getModelHelper();
            Intrinsics.checkNotNullExpressionValue((Object)modelHelper, (String)"getModelHelper(...)");
            ModelHelper helper = modelHelper;
            icon = helper.getIcon((DasObject)((Object)node2));
        } else if (basicNode instanceof HostFamily) {
            icon = DatabaseIcons.ObjectGroup;
        } else if (basicNode instanceof DvExtraNode) {
            DvTreeIconItem iconItem = ((DvExtraNode)node2).getIconItem();
            if (iconItem != null) {
                icon = DvTreeIcons.TREE_NODE_ITEMS.get((Object)iconItem);
            }
        } else if (basicNode instanceof DataSourceNode) {
            icon = DbNodeDescriptorHelper.getDataSourceIcon(project, (DataSourceNode)node2);
        }
        return icon;
    }

    private static final Icon getDataSourceIcon(Project project, DataSourceNode dsn) {
        Icon icon = dsn.dbDataSource.getIcon();
        if (project.isDisposed()) {
            return icon;
        }
        RawDataSource ds = dsn.rawDataSource;
        boolean isSpinning = DataSourceSyncManager.getInstance().isActive(ds);
        if (isSpinning) {
            icon = (Icon)AnimatedIcon.Default.INSTANCE;
        } else if (ds instanceof LocalDataSource) {
            Icon icon2;
            Icon[] iconArray;
            int connectionCount = DbImplUtil.isConnected(project, (LocalDataSource)ds) ? DbImplUtil.getActiveConnectionCount((LocalDataSource)ds) : 0;
            icon = ((LocalDataSource)ds).getBaseIcon();
            if (((LocalDataSource)ds).isReadOnly()) {
                iconArray = new Icon[2];
                iconArray[0] = icon;
                Intrinsics.checkNotNullExpressionValue((Object)DatabaseIcons.Locked, (String)"Locked");
                icon = (Icon)LayeredIcon.Companion.layeredIcon(iconArray);
            }
            if (connectionCount > 0) {
                icon2 = ExecutionUtil.getLiveIndicator((Icon)icon);
            } else {
                Icon icon3 = icon;
                icon2 = icon3;
                Intrinsics.checkNotNull((Object)icon3);
            }
            iconArray = icon2;
            Intrinsics.checkNotNull((Object)iconArray);
            icon = LogInterceptor.Companion.loggedIcon((Icon)iconArray, (LocalDataSource)ds);
        }
        return icon;
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dsn.getDbms())) {
            return;
        }
        LocalDataSource localDataSource = dsn.getLocalDataSource();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        Level level = lds.getIntrospectionLevel();
        DbNodeDescriptorHelper.addLevelIcon(presentation, level, true, false, true);
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull BasicMultiLevelIntrospectableArea area, @Nullable RawDataSource dataSource2) {
        boolean autodetect;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        BasicModel basicModel = area.getModel();
        if (basicModel == null) {
            return;
        }
        BasicModel model2 = basicModel;
        BasicRoot basicRoot = model2.getRoot();
        BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
        if (basicMultiLevelRoot == null) {
            return;
        }
        BasicMultiLevelRoot rootArea = basicMultiLevelRoot;
        Dbms dbms = model2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) {
            return;
        }
        boolean bl = autodetect = area instanceof BasicMultiLevelSchema && rootArea.getExplicitIntrospectionLevel() == null;
        if (DbNodeDescriptorHelper.getHidePillsWhenL3() && !autodetect && !DbNodeDescriptorHelper.scanToCheckWhetherModelHasLowIntrospectionLevels(model2)) {
            return;
        }
        LocalDataSource localDataSource = dataSource2 instanceof LocalDataSource ? (LocalDataSource)dataSource2 : null;
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        if (area instanceof BasicNamespace && !DbNodeDescriptorHelper.isInIntrospectionScope((BasicNamespace)((Object)area), lds)) {
            Icon icon = AllIcons.Nodes.EmptyNode;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EmptyNode");
            DbNodeDescriptorHelper.addSecondIcon(presentation, icon);
            return;
        }
        Level explicitlyDeclaredLevel = area.getExplicitIntrospectionLevel();
        Level level = explicitlyDeclaredLevel;
        if (level == null) {
            level = ModelFun.effectiveExplicitIntrospectionLevel(area);
        }
        Level declaredLevel = level;
        Level showLevel = null;
        boolean showAsExplicit = false;
        boolean showAsExtraLow = false;
        if (autodetect && area instanceof BasicMultiLevelSchema) {
            Level lastActualLevel = ((BasicMultiLevelSchema)area).getLastIntrospectionLevel();
            if (explicitlyDeclaredLevel != null) {
                if (LevelFun.isGreaterOrEqualsTo(lastActualLevel, explicitlyDeclaredLevel)) {
                    showLevel = explicitlyDeclaredLevel;
                    showAsExplicit = true;
                } else {
                    showLevel = lastActualLevel;
                    showAsExplicit = false;
                    showAsExtraLow = true;
                }
            } else {
                showLevel = lastActualLevel;
                showAsExplicit = false;
            }
        } else {
            showLevel = declaredLevel;
            showAsExplicit = explicitlyDeclaredLevel != null;
        }
        DbNodeDescriptorHelper.addLevelIcon(presentation, showLevel, showAsExplicit, showAsExtraLow, false);
    }

    private static final void addLevelIcon(PresentationData presentation, Level level, boolean declared, boolean extraLow, boolean nullMeansAuto) {
        Icon icon;
        block17: {
            block15: {
                block18: {
                    block16: {
                        if (level == null) break block15;
                        if (!extraLow) break block16;
                        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                            case 1: {
                                icon = DatabaseIcons.Level1_details;
                                break block17;
                            }
                            case 2: {
                                icon = DatabaseIcons.Level2_details;
                                break block17;
                            }
                            case 3: {
                                icon = DatabaseIcons.Level3_details;
                                break block17;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!declared) break block18;
                    switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                        case 1: {
                            icon = DatabaseIcons.Level1_declared;
                            break block17;
                        }
                        case 2: {
                            icon = DatabaseIcons.Level2_declared;
                            break block17;
                        }
                        case 3: {
                            icon = DatabaseIcons.Level3_declared;
                            break block17;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        icon = DatabaseIcons.Level1_inherited;
                        break block17;
                    }
                    case 2: {
                        icon = DatabaseIcons.Level2_inherited;
                        break block17;
                    }
                    case 3: {
                        icon = DatabaseIcons.Level3_inherited;
                        break block17;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            icon = nullMeansAuto ? DatabaseIcons.LevelAuto : AllIcons.Nodes.EmptyNode;
        }
        Icon icon2 = icon;
        Intrinsics.checkNotNull((Object)icon2);
        Icon levelIcon = icon2;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    public static final void addDetailsLevelIcon(@NotNull PresentationData presentation, @Nullable Level level) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (level == null) {
            return;
        }
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1 -> DatabaseIcons.Level1_details;
            case 2 -> DatabaseIcons.Level2_details;
            case 3 -> DatabaseIcons.Level3_details;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)icon);
        Icon levelIcon = icon;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    private static final void addSecondIcon(PresentationData presentation, Icon secondIcon) {
        Icon normalIcon = presentation.getIcon(false);
        Icon rowIcon = IconUtil.rowIcon((Icon)normalIcon, (Icon)secondIcon);
        presentation.setIcon(rowIcon);
    }

    public static final boolean isInIntrospectionScope(@NotNull BasicNamespace namespace, @Nullable RawDataSource dataSource2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (dataSource2 instanceof LocalDataSource) {
            TreePattern treePattern = ((LocalDataSource)dataSource2).getIntrospectionScope();
            Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
            TreePattern scope = treePattern;
            bl = DataSourceSchemaMapping.isIntrospected(scope, namespace);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean scanToCheckWhetherModelHasLowIntrospectionLevels(DasModel $this$scanToCheckWhetherModelHasLowIntrospectionLevels) {
        if ($this$scanToCheckWhetherModelHasLowIntrospectionLevels instanceof BasicModel) {
            BasicRoot basicRoot = ((BasicModel)$this$scanToCheckWhetherModelHasLowIntrospectionLevels).getRoot();
            BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
            if (basicMultiLevelRoot == null) {
                return false;
            }
            BasicMultiLevelRoot root2 = basicMultiLevelRoot;
            if (DbNodeDescriptorHelper.isLow(root2.getExplicitIntrospectionLevel())) {
                return true;
            }
            for (BasicSchema basicSchema : root2.getAllSchemas()) {
                if (!(basicSchema instanceof BasicMultiLevelSchema) || !DbNodeDescriptorHelper.isLow(((BasicMultiLevelSchema)basicSchema).getExplicitIntrospectionLevel())) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isLow(Level $this$isLow) {
        return $this$isLow == Level.L1 || $this$isLow == Level.L2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.L1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

