/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.BasicDataSourceManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DataSourceManagerUi;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DatabaseSettingBooleanVal;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.RegistryBooleanVal;
import com.intellij.database.util.common.BooleanVal;
import com.intellij.database.view.AsyncTreeFilterModel;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseDocumentationService;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.DatabaseViewTreeComponent;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.TreeFilterModel;
import com.intellij.database.view.TreeFilterSearch;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvErsatzFamilyNode;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.database.view.structure.DvRootDsGroup;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.ide.documentation.ActionsKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 }2\u00020\u00012\u00020\u0002:\u0007}~\u007f\u0080\u0001\u0081\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u00105\u001a\u0002062\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010908J8\u0010:\u001a\b\u0012\u0004\u0012\u0002H;08\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=2\u0006\u0010>\u001a\u00020?2\f\u00107\u001a\b\u0012\u0004\u0012\u00020A0@H\u0002J\b\u0010B\u001a\u00020$H\u0002J\u0006\u0010C\u001a\u000206J\b\u0010D\u001a\u000206H\u0016J\b\u0010E\u001a\u000206H\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020?H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010A2\u0006\u0010L\u001a\u00020MH\u0016J(\u0010N\u001a\u0004\u0018\u00010A2\u0006\u0010L\u001a\u00020M2\u0006\u0010>\u001a\u00020?2\f\u00107\u001a\b\u0012\u0004\u0012\u00020A0@H\u0002J\n\u0010O\u001a\u0004\u0018\u00010AH\u0002J\u0014\u0010P\u001a\u0004\u0018\u00010M2\b\u0010Q\u001a\u0004\u0018\u00010AH\u0002J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J\u0013\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VH\u0002\u00a2\u0006\u0002\u0010XJ\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020W0ZH\u0002J\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0ZJ\f\u0010]\u001a\b\u0012\u0004\u0012\u0002090ZJ\u0006\u0010^\u001a\u00020_J\u0006\u0010`\u001a\u00020aJ\u0014\u0010b\u001a\u0004\u0018\u00010M2\b\u0010Q\u001a\u0004\u0018\u00010cH\u0002J\b\u0010d\u001a\u000206H\u0002J\b\u0010e\u001a\u000206H\u0002J\u000e\u0010f\u001a\u0002062\u0006\u0010g\u001a\u00020_J\u001e\u0010h\u001a\b\u0012\u0004\u0012\u00020\\0Z2\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u0002090ZH\u0002J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\\0Z2\u0006\u0010j\u001a\u000209H\u0002J\u0006\u0010k\u001a\u000206J\u0016\u0010l\u001a\u0002062\u0006\u0010j\u001a\u0002092\u0006\u0010m\u001a\u00020?J\u0014\u0010l\u001a\u0006\u0012\u0002\b\u00030n2\b\u0010j\u001a\u0004\u0018\u000109J\u001c\u0010o\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010p0n2\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J,\u0010o\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010p0n2\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010m\u001a\u00020?2\u0006\u0010q\u001a\u00020?J\u0010\u0010r\u001a\u0002062\u0006\u0010s\u001a\u00020tH\u0002J\u000e\u0010u\u001a\u0002062\u0006\u0010s\u001a\u00020tJ\u0010\u0010v\u001a\u0002062\b\u0010w\u001a\u0004\u0018\u00010xJ\u001a\u0010y\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090@2\n\u0010z\u001a\u0006\u0012\u0002\b\u00030ZJ\u0014\u0010y\u001a\u0004\u0018\u0001092\b\u0010Q\u001a\u0004\u0018\u00010AH\u0007J\u001a\u0010y\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090@2\n\u0010z\u001a\u0006\u0012\u0002\b\u000308J\b\u0010{\u001a\u000206H\u0014J\u0006\u0010|\u001a\u000206R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0019\u001a\u0004\b \u0010!R\u001c\u0010#\u001a\u00020$8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0019\u001a\u0004\b0\u00101R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006\u0082\u0001"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "options", "Lcom/intellij/database/view/structure/DvMutableViewOptions;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvMutableViewOptions;)V", "asyncModel", "Lcom/intellij/ui/tree/AsyncTreeModel;", "getAsyncModel", "()Lcom/intellij/ui/tree/AsyncTreeModel;", "copyPasteProvider", "Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "getCopyPasteProvider", "()Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "myAutoScrollHandler", "Lcom/intellij/database/view/DatabaseViewPanel$MyAutoScrollFromSourceHandler;", "myContext", "Lcom/intellij/database/view/DatabaseTreeContext;", "myDocService", "Lcom/intellij/database/view/DatabaseDocumentationService;", "getMyDocService", "()Lcom/intellij/database/view/DatabaseDocumentationService;", "myDocService$delegate", "Lkotlin/Lazy;", "myFilterTreeModel", "Lcom/intellij/database/view/TreeFilterModel;", "myStructure", "Lcom/intellij/database/view/DatabaseStructure;", "myStructureService", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "getMyStructureService", "()Lcom/intellij/database/view/structure/DvTreeStructureService;", "myStructureService$delegate", "myToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getMyToolbar$intellij_database_impl", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "setMyToolbar$intellij_database_impl", "(Lcom/intellij/openapi/actionSystem/ActionToolbar;)V", "myTree", "Lcom/intellij/database/view/DatabaseViewTreeComponent;", "getMyTree", "()Lcom/intellij/database/view/DatabaseViewTreeComponent;", "myViewOptions", "myWrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getMyWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "myWrappingService$delegate", "getProject", "()Lcom/intellij/openapi/project/Project;", "collapseNodes", "", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "collectDataFromSelectedNodes", "T", "key", "Lcom/intellij/openapi/actionSystem/DataKey;", "slow", "", "", "", "createToolbar", "deselectElements", "dispose", "enableDnD", "findDndTargetAt", "Lcom/intellij/ide/dnd/DnDTarget;", "point", "Ljava/awt/Point;", "strict", "getData", "dataId", "", "getDataFromSelectedNodes", "getDropElementProvider", "getNodePresentationText", "o", "getNodeRanks", "Ljava/util/EnumSet;", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getRelatedDataSource", "", "Lcom/intellij/database/view/DataSourceNode;", "()[Lcom/intellij/database/view/DataSourceNode;", "getRelatedDataSourceNodes", "Lcom/intellij/util/containers/JBIterable;", "getSelectedElements", "Lcom/intellij/database/model/basic/BasicElement;", "getSelectedNodes", "getState", "Lorg/jdom/Element;", "getTree", "Lcom/intellij/ui/treeStructure/Tree;", "getTreePathPresentationText", "Ljavax/swing/tree/TreePath;", "initComponents", "invokeRefresh", "loadState", "state", "refineAndExpandNodesAsElements", "refineNodeAsElements", "node", "refreshView", "selectNode", "requestFocus", "Lorg/jetbrains/concurrency/Promise;", "selectNodes", "Ljava/lang/Void;", "forceShowToolWindow", "setupGearMenu", "toolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "setupToolWindow", "showSchemaManagerGotIt", "ds", "Lcom/intellij/database/psi/DbDataSource;", "unwrap", "objects", "updateEmptyText", "viewOptionsChanged", "Companion", "MyAutoScrollFromSourceHandler", "MyDnDSource", "MyDnDTarget", "MyTransferable", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,914:1\n31#2,2:915\n11065#3:917\n11400#3,3:918\n37#4,2:921\n37#4,2:923\n26#5:925\n26#5:926\n26#5:927\n*S KotlinDebug\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel\n*L\n792#1:915,2\n421#1:917\n421#1:918,3\n442#1:921,2\n446#1:923,2\n909#1:925\n910#1:926\n911#1:927\n*E\n"})
public class DatabaseViewPanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseTreeContext myContext;
    @NotNull
    private final Lazy myStructureService$delegate;
    @NotNull
    private final Lazy myWrappingService$delegate;
    @NotNull
    private final Lazy myDocService$delegate;
    @NotNull
    private final DatabaseViewTreeComponent myTree;
    @NotNull
    private final DatabaseCopyPasteProvider copyPasteProvider;
    @NotNull
    private final DatabaseStructure myStructure;
    @NotNull
    private final DvMutableViewOptions myViewOptions;
    @NotNull
    private final AsyncTreeModel asyncModel;
    @NotNull
    private final TreeFilterModel myFilterTreeModel;
    @NotNull
    private final MyAutoScrollFromSourceHandler myAutoScrollHandler;
    public ActionToolbar myToolbar;
    @NotNull
    private static final BooleanVal ourFilterIsEnabledCheck = new RegistryBooleanVal("database.view.filter.enabled");
    @NotNull
    private static final BooleanVal ourFilterIsStickyCheck = new DatabaseSettingBooleanVal((Function1<? super DatabaseSettings, Boolean>)((Function1)Companion.ourFilterIsStickyCheck.1.INSTANCE));
    @NotNull
    private static final Logger ourLogger;
    @NotNull
    private static final BasicNode[] EMPTY_NODES_ARRAY;
    @NotNull
    private static final BasicElement[] EMPTY_ELEMENTS_ARRAY;
    @NotNull
    private static final DataSourceNode[] EMPTY_DSN_ARRAY;

    public DatabaseViewPanel(@NotNull Project project, @NotNull DvMutableViewOptions options2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        super(true, true);
        this.project = project;
        this.myStructureService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DvTreeStructureService>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DvTreeStructureService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.this$0.getProject();
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DvTreeStructureService)object;
            }
        }));
        this.myWrappingService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseNodeWrappingService>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseNodeWrappingService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.this$0.getProject();
                boolean $i$f$service = false;
                Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DatabaseNodeWrappingService)object;
            }
        }));
        this.myDocService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseDocumentationService>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseDocumentationService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.this$0.getProject();
                boolean $i$f$service = false;
                Class<DatabaseDocumentationService> serviceClass$iv = DatabaseDocumentationService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DatabaseDocumentationService)object;
            }
        }));
        this.myContext = new DatabaseTreeContext(this.project, () -> DatabaseViewPanel._init_$lambda$16(this));
        this.myViewOptions = options2;
        this.myAutoScrollHandler = new MyAutoScrollFromSourceHandler(this.project, this);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.myStructure = new DatabaseStructure((DvTreeStructure)object);
        this.myTree = new DatabaseViewTreeComponent(this.myContext, this.myViewOptions);
        this.asyncModel = new AsyncTreeModel((TreeModel)((Object)this.myStructure), (Disposable)this);
        this.myFilterTreeModel = new AsyncTreeFilterModel(this.asyncModel, (JTree)((Object)this.myTree));
        this.myTree.setModel(this.myFilterTreeModel);
        this.copyPasteProvider = new DatabaseCopyPasteProvider(this.myContext, (Tree)this.myTree);
        this.myTree.setCopyPasteProvider(this.copyPasteProvider);
        this.initComponents();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<DbPsiFacade.Listener> topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> DatabaseViewPanel._init_$lambda$17(this, arg_0));
        JdbcDriverManager.getDriverManager(this.project).addModificationTrackerListener((ModificationTrackerListener<JdbcDriverManager>)((ModificationTrackerListener)arg_0 -> DatabaseViewPanel._init_$lambda$18(this, arg_0)), this);
        this.enableDnD();
        this.getMyStructureService().setOnStructureChanged(() -> DatabaseViewPanel._init_$lambda$19(this));
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection2.subscribe(DatabaseConnectionManager.Companion.getTOPIC(), (arg_0, arg_1) -> DatabaseViewPanel._init_$lambda$20(this, arg_0, arg_1));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DvTreeStructureService getMyStructureService() {
        Lazy lazy = this.myStructureService$delegate;
        return (DvTreeStructureService)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getMyWrappingService() {
        Lazy lazy = this.myWrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    private final DatabaseDocumentationService getMyDocService() {
        Lazy lazy = this.myDocService$delegate;
        return (DatabaseDocumentationService)lazy.getValue();
    }

    @NotNull
    protected final DatabaseViewTreeComponent getMyTree() {
        return this.myTree;
    }

    @NotNull
    public final DatabaseCopyPasteProvider getCopyPasteProvider() {
        return this.copyPasteProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public final AsyncTreeModel getAsyncModel() {
        return this.asyncModel;
    }

    @ApiStatus.Internal
    @NotNull
    public final ActionToolbar getMyToolbar$intellij_database_impl() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar != null) {
            return actionToolbar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myToolbar");
        return null;
    }

    public final void setMyToolbar$intellij_database_impl(@NotNull ActionToolbar actionToolbar) {
        Intrinsics.checkNotNullParameter((Object)actionToolbar, (String)"<set-?>");
        this.myToolbar = actionToolbar;
    }

    @NotNull
    public final Tree getTree() {
        return (Tree)this.myTree;
    }

    @NotNull
    public final JBIterable<BasicNode> getSelectedNodes() {
        JBIterable jBIterable = UtilKt.asJBIterable((Object[])this.myTree.getSelectionPaths()).map(arg_0 -> DatabaseViewPanel.getSelectedNodes$lambda$0(getSelectedNodes.1.INSTANCE, arg_0)).filter(BasicNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @NotNull
    public final JBIterable<BasicElement> getSelectedElements() {
        JBIterable jBIterable = this.getSelectedNodes().filter(BasicNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable nodes = jBIterable;
        if (nodes.isEmpty()) {
            JBIterable jBIterable2 = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
            return jBIterable2;
        }
        return this.refineAndExpandNodesAsElements((JBIterable<? extends BasicNode>)nodes);
    }

    private final JBIterable<BasicElement> refineAndExpandNodesAsElements(JBIterable<? extends BasicNode> nodes) {
        JBIterable jBIterable = nodes.flatten(arg_0 -> DatabaseViewPanel.refineAndExpandNodesAsElements$lambda$1((Function1)new Function1<BasicNode, Iterable<? extends BasicElement>>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<BasicElement> invoke(BasicNode it2) {
                Intrinsics.checkNotNull((Object)it2);
                return (Iterable)DatabaseViewPanel.access$refineNodeAsElements(this.this$0, it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatten(...)");
        return jBIterable;
    }

    private final JBIterable<BasicElement> refineNodeAsElements(BasicNode node2) {
        JBIterable jBIterable;
        BasicNode basicNode = node2;
        if (basicNode instanceof BasicElement) {
            JBIterable jBIterable2 = JBIterable.of((Object)node2);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else if (basicNode instanceof Family ? true : basicNode instanceof DvErsatzFamilyNode) {
            jBIterable = this.refineAndExpandNodesAsElements(this.getMyStructureService().childrenOf(node2));
        } else if (basicNode instanceof DataSourceNode) {
            JBIterable jBIterable3 = JBIterable.of((Object)((DataSourceNode)node2).getModelRoot());
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"of(...)");
        } else {
            JBIterable jBIterable4 = JBIterable.empty();
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"empty(...)");
        }
        return jBIterable;
    }

    private final JBIterable<DataSourceNode> getRelatedDataSourceNodes() {
        JBIterable jBIterable = UtilKt.asJBIterable((Object[])this.myTree.getSelectionPaths()).filterMap(arg_0 -> DatabaseViewPanel.getRelatedDataSourceNodes$lambda$2(getRelatedDataSourceNodes.1.INSTANCE, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"unique(...)");
        return jBIterable;
    }

    private final void initComponents() {
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setShowsRootHandles(true);
        this.updateEmptyText();
        EditSourceOnDoubleClickHandler.install$default((JTree)((JTree)((Object)this.myTree)), null, (int)2, null);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        TreeUtil.installActions((JTree)((JTree)((Object)this.myTree)));
        TreeFilterSearch ss2 = TreeFilterSearch.Companion.installOn((JTree)((Object)this.myTree), this.myFilterTreeModel, arg_0 -> DatabaseViewPanel.initComponents$lambda$3((Function1)new Function1<TreePath, String>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@Nullable TreePath it2) {
                return DatabaseViewPanel.access$getTreePathPresentationText(this.this$0, it2);
            }
        }, arg_0));
        ss2.setFilterIsEnabledCheck(ourFilterIsEnabledCheck);
        ss2.setFilterIsStickyCheck(ourFilterIsStickyCheck);
        ss2.setStickyStateHolder(this.myViewOptions.getFilterStickyState());
        ss2.setNothingFoundTextProvider(DatabaseBundle.messagePointer("tree.filer.nothingFound", new Object[0]));
        SpeedSearchComparator ssComparator = ss2.getComparator();
        this.myFilterTreeModel.setMatcher(new TreeFilterModel.Matcher(ssComparator, this){
            final /* synthetic */ SpeedSearchComparator $ssComparator;
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.$ssComparator = $ssComparator;
                this.this$0 = $receiver;
            }

            public boolean matches(@NotNull Object node2, @NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                String string = DatabaseViewPanel.access$getNodePresentationText(this.this$0, node2);
                if (string == null) {
                    string = "";
                }
                return this.$ssComparator.matchingDegree(input, string) > 0;
            }
        });
        this.myTree.setRootVisible(false);
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.myTree)), (String)"DatabaseViewPopupMenu", (String)"DatabaseViewPopup");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane(null);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setViewport((JViewport)this.myTree.getViewport());
        this.setContent(scrollPane);
        this.setMyToolbar$intellij_database_impl(this.createToolbar());
        this.setToolbar(this.getMyToolbar$intellij_database_impl().getComponent());
        this.myAutoScrollHandler.install();
    }

    protected void updateEmptyText() {
        String emptyText = null;
        if (DbPsiFacade.getInstance(this.project).getDataSources().isEmpty()) {
            String string;
            String string2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("NewElement"));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
            String shortcut = string2;
            if (StringUtil.isNotEmpty((String)shortcut)) {
                Object[] objectArray = new Object[]{shortcut};
                var3_4 = DatabaseBundle.message("status.text.create.data.source.with", objectArray);
                Intrinsics.checkNotNull((Object)var3_4);
                string = var3_4;
            } else {
                var3_4 = DatabaseBundle.message("status.text.create.data.source.with.context.menu", new Object[0]);
                Intrinsics.checkNotNull((Object)var3_4);
                string = var3_4;
            }
            emptyText = string;
        } else {
            String string = CommonBundle.getLoadingTreeNodeText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLoadingTreeNodeText(...)");
            emptyText = string;
        }
        this.myTree.getEmptyText().setText(emptyText);
    }

    public final void viewOptionsChanged() {
        this.getMyStructureService().onViewOptionsChanged();
        this.refreshView();
    }

    public final void refreshView() {
        this.updateEmptyText();
        this.myStructure.refreshAll();
    }

    private final void invokeRefresh() {
        ApplicationManager.getApplication().invokeLater(() -> DatabaseViewPanel.invokeRefresh$lambda$4(this));
    }

    public final void selectNode(@NotNull BasicNode node2, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (requestFocus) {
            AsyncPromise res2 = new AsyncPromise();
            Runnable continuation = () -> DatabaseViewPanel.selectNode$lambda$5(this, node2, res2);
            ToolWindow window = Companion.getDatabaseToolWindow(this.project);
            window.activate(continuation);
        } else {
            this.selectNode(node2);
        }
    }

    @NotNull
    public final Promise<?> selectNode(@Nullable BasicNode node2) {
        BasicNode basicNode = node2;
        return basicNode != null ? this.selectNodes(SetsKt.setOf((Object)basicNode)) : Promises.resolvedPromise();
    }

    public final void deselectElements() {
        this.selectNodes(SetsKt.emptySet());
    }

    @NotNull
    public final Promise<Void> selectNodes(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AsyncTreeModel treeModel = this.asyncModel;
        List list = JBIterable.from((Iterable)nodes).map(arg_0 -> DatabaseViewPanel.selectNodes$lambda$6((Function1)new Function1<BasicNode, Promise<TreePath>>(treeModel){
            final /* synthetic */ AsyncTreeModel $treeModel;
            {
                this.$treeModel = $treeModel;
                super(1);
            }

            public final Promise<TreePath> invoke(BasicNode it2) {
                return this.$treeModel.getTreePath((Object)it2);
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List promises2 = list;
        Promise collectedPromise = Promises.collectResults((Collection)promises2, (boolean)true);
        Promise promise = collectedPromise.onProcessed(arg_0 -> DatabaseViewPanel.selectNodes$lambda$7((Function1)new Function1<List<? extends TreePath>, Unit>(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<? extends TreePath> paths2) {
                if (paths2 != null) {
                    TreeUtil.selectPaths((JTree)((JTree)((Object)this.this$0.getMyTree())), (Collection)paths2);
                }
            }
        }, arg_0)).then(arg_0 -> DatabaseViewPanel.selectNodes$lambda$8(selectNodes.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    public final void collapseNodes(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AsyncTreeModel treeModel = this.asyncModel;
        for (BasicNode basicNode : nodes) {
            Promise treePathPromise;
            Intrinsics.checkNotNullExpressionValue((Object)treeModel.getTreePath((Object)basicNode), (String)"getTreePath(...)");
            treePathPromise.onProcessed(arg_0 -> DatabaseViewPanel.collapseNodes$lambda$9((Function1)new Function1<TreePath, Unit>(this){
                final /* synthetic */ DatabaseViewPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(TreePath it2) {
                    this.this$0.getMyTree().collapsePath(it2);
                }
            }, arg_0));
        }
    }

    @Contract(value="null->null")
    @Nullable
    public final BasicNode unwrap(@Nullable Object o2) {
        if (o2 instanceof BasicNode) {
            return (BasicNode)o2;
        }
        BasicNode unwrappedNode = o2 instanceof PsiElement ? this.getMyWrappingService().unwrap((Object)((PsiElement)o2)) : null;
        return unwrappedNode;
    }

    @NotNull
    public final List<BasicNode> unwrap(@NotNull Collection<?> objects2) {
        Intrinsics.checkNotNullParameter(objects2, (String)"objects");
        JBIterable jBIterable = JBIterable.from((Iterable)objects2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return this.unwrap(jBIterable);
    }

    @NotNull
    public final List<BasicNode> unwrap(@NotNull JBIterable<?> objects2) {
        Intrinsics.checkNotNullParameter(objects2, (String)"objects");
        List list = objects2.filterMap(arg_0 -> DatabaseViewPanel.unwrap$lambda$10(this, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    private final void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)((Object)this.myTree));
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)((Object)this.myTree));
        }
    }

    private final ActionToolbar createToolbar() {
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        AnAction anAction = actionManager.getAction("DatabaseViewToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup group2 = (ActionGroup)anAction;
        ActionToolbar toolbar2 = actionManager.createActionToolbar("DatabaseViewToolbar", group2, true, false);
        toolbar2.setTargetComponent((JComponent)((Object)this.myTree));
        return toolbar2;
    }

    public void dispose() {
        this.removeAll();
    }

    public final void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.setupGearMenu(toolWindow);
        AnAction consoleTitleAction2 = (AnAction)new DumbAwareAction(this){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                e2.getPresentation().setVisible(!this.this$0.isToolbarVisible());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                JBIterable jBIterable = UtilKt.asJBIterable((Object[])this.this$0.getMyTree().getSelectionPaths()).map(arg_0 -> setupToolWindow.consoleTitleAction.1.actionPerformed$lambda$0(setupToolWindow.consoleTitleAction.actionPerformed.1.INSTANCE, arg_0)).filter(Conditions.notNull()).unique();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"unique(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DbDataSource it2 = (DbDataSource)element$iv;
                    boolean bl = false;
                    DatabaseEditorHelper.openConsoleFile(it2);
                }
            }

            private static final DbDataSource actionPerformed$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (DbDataSource)$tmp0.invoke(p0);
            }
        };
        consoleTitleAction2.getTemplatePresentation().setText(DatabaseBundle.messagePointer("action.OpenConsole.text", new Object[0]));
        consoleTitleAction2.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        AnAction refreshTitleAction2 = (AnAction)new DumbAwareAction(this){
            @NotNull
            private final AnAction baseAction;
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                AnAction anAction = ActionManager.getInstance().getAction("DatabaseView.Refresh");
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
                this.baseAction = anAction;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"DatabaseView.Refresh");
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
            }

            @NotNull
            public final AnAction getBaseAction() {
                return this.baseAction;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                e2.getPresentation().setEnabledAndVisible(!this.this$0.isToolbarVisible());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.baseAction.actionPerformed(new AnActionEvent(e2.getInputEvent(), DataManager.getInstance().getDataContext((Component)((Object)this.this$0)), e2.getPlace(), e2.getPresentation(), e2.getActionManager(), e2.getModifiers()));
            }
        };
        Supplier<String> supplier2 = DatabaseBundle.messagePointer("action.DatabaseView.scroll.from.editor.text", new Object[0]);
        Object[] objectArray = DatabaseBundle.messagePointer("action.DatabaseView.select.database.element.open.in.active.editor.description", new Object[0]);
        Icon icon = AllIcons.General.Locate;
        AnAction scrollFromEditorAction2 = (AnAction)new DumbAwareAction(this, supplier2, (Supplier<String>)objectArray, icon){
            final /* synthetic */ DatabaseViewPanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                e2.getPresentation().setEnabledAndVisible(!DatabaseViewPanel.access$getMyAutoScrollHandler$p(this.this$0).isAutoScrollEnabled());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                FileEditor fileEditor;
                EditorComposite editorComposite;
                EditorWindow window;
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                EditorWindow editorWindow = window = FileEditorManagerEx.Companion.getInstanceEx(this.this$0.getProject()).getCurrentWindow();
                EditorComposite editorComposite2 = editorComposite = editorWindow != null ? editorWindow.getSelectedComposite() : null;
                if (editorComposite2 == null) {
                    v2 = null;
                } else {
                    FileEditorWithProvider fileEditorWithProvider = editorComposite2.getSelectedWithProvider();
                    Intrinsics.checkNotNull((Object)fileEditorWithProvider);
                    v2 = fileEditor = fileEditorWithProvider.getFileEditor();
                }
                if (fileEditor == null) {
                    return;
                }
                DatabaseViewPanel.access$getMyAutoScrollHandler$p(this.this$0).selectElementFromEditorInner(fileEditor, true);
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        objectArray = new AnAction[]{refreshTitleAction2, consoleTitleAction2, scrollFromEditorAction2, actionsManager.createExpandAllHeaderAction((JTree)((Object)this.myTree)), actionsManager.createCollapseAllHeaderAction((JTree)((Object)this.myTree))};
        toolWindow.setTitleActions(CollectionsKt.listOf((Object[])objectArray));
    }

    private final void setupGearMenu(ToolWindowEx toolWindow) {
        AnAction anAction = ActionManager.getInstance().getAction("DatabaseView.MoreOptions");
        ActionGroup group2 = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        toolWindow.setAdditionalGearActions(group2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        List list;
        TreePath[] paths2;
        Object data;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (this.project.isDisposed()) {
            return null;
        }
        Object object = data = super.getData(dataId);
        if (object != null) {
            return object;
        }
        if (DatabaseView.DATABASE_TREE_IS_ORIGIN.is(dataId)) {
            return true;
        }
        if (DatabaseView.DATABASE_NODES.is(dataId)) {
            BasicNode[] basicNodeArray;
            JBIterable<BasicNode> selectedNodes2 = this.getSelectedNodes();
            if (selectedNodes2.isEmpty()) {
                basicNodeArray = EMPTY_NODES_ARRAY;
            } else {
                Object[] objectArray = selectedNodes2.toArray((Object[])new BasicNode[0]);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
                basicNodeArray = (BasicNode[])objectArray;
            }
            return basicNodeArray;
        }
        if (DatabaseView.DATABASE_ELEMENTS.is(dataId)) {
            BasicElement[] basicElementArray;
            JBIterable<BasicElement> selectedElements = this.getSelectedElements();
            if (selectedElements.isEmpty()) {
                basicElementArray = EMPTY_ELEMENTS_ARRAY;
            } else {
                Object[] objectArray = selectedElements.toArray((Object[])new BasicElement[0]);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
                basicElementArray = (BasicElement[])objectArray;
            }
            return basicElementArray;
        }
        if (DatabaseView.DATABASE_NODE_RANKS.is(dataId)) {
            return this.getNodeRanks();
        }
        if (DatabaseView.DATABASE_RELATED_SINGLE_DATA_SOURCE.is(dataId)) {
            JBIterable<DataSourceNode> relatedDSNs = this.getRelatedDataSourceNodes();
            return relatedDSNs.single();
        }
        if (DatabaseView.DATABASE_RELATED_DATA_SOURCES.is(dataId)) {
            return this.getRelatedDataSource();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project;
        }
        if (DatabaseView.DATABASE_VIEW_KEY.is(dataId)) {
            return DatabaseView.getDatabaseView(this.project);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return "reference.tools.datasource";
        }
        if (ActionsKt.DOCUMENTATION_TARGETS.is(dataId)) {
            DocumentationTarget d2;
            BasicNode singleNode = (BasicNode)this.getSelectedNodes().single();
            if (singleNode == null) {
                return null;
            }
            DocumentationTarget documentationTarget = d2 = this.getMyDocService().prepareQuickDoc(singleNode);
            return documentationTarget != null ? CollectionsKt.listOf((Object)documentationTarget) : null;
        }
        if (DatabaseView.DROP_ELEMENT_PROVIDER.is(dataId)) {
            return this.getDropElementProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.copyPasteProvider;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.copyPasteProvider;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.copyPasteProvider;
        }
        if (paths2 != null) {
            void $this$mapTo$iv$iv;
            TreePath[] $this$map$iv = paths2 = this.myTree.getSelectionPaths();
            boolean $i$f$map = false;
            TreePath[] treePathArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it2;
                void item$iv$iv;
                void var13_18 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getLastPathComponent());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List nodes = list;
        return PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId) ? arg_0 -> DatabaseViewPanel.getData$lambda$12(this, nodes, arg_0) : this.getDataFromSelectedNodes(dataId, false, nodes);
    }

    private final Object getDropElementProvider() {
        EnumSet<DvTreeNodeRank> ranks = this.getNodeRanks();
        if (ranks.isEmpty()) {
            return null;
        }
        if (ranks.contains(DvTreeNodeRank.TL_FOLDER) || ranks.contains(DvTreeNodeRank.TL_UNKNOWN)) {
            return null;
        }
        return ranks.contains(DvTreeNodeRank.TL_ROOT) || ranks.contains(DvTreeNodeRank.TL_FAMILY) || ranks.contains(DvTreeNodeRank.TL_NAMESPACE) || ranks.contains(DvTreeNodeRank.TL_ELEMENT) ? new DbDeleteProvider.DbTreeDeleteProvider() : null;
    }

    private final Object getDataFromSelectedNodes(String dataId, boolean slow, List<? extends Object> nodes) {
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] psiElementArray;
            DataKey dataKey = CommonDataKeys.PSI_ELEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT");
            Collection<PsiElement> c2 = this.collectDataFromSelectedNodes(dataKey, true, nodes);
            if (c2.isEmpty()) {
                psiElementArray = null;
            } else {
                Collection<PsiElement> $this$toTypedArray$iv = c2;
                boolean $i$f$toTypedArray = false;
                Collection<PsiElement> thisCollection$iv = $this$toTypedArray$iv;
                psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
            }
            return psiElementArray;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Navigatable[] navigatableArray;
            DataKey dataKey = CommonDataKeys.NAVIGATABLE;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATABLE");
            Collection<Navigatable> c3 = this.collectDataFromSelectedNodes(dataKey, slow, nodes);
            if (c3.isEmpty()) {
                navigatableArray = null;
            } else {
                Collection<Navigatable> $this$toTypedArray$iv = c3;
                boolean $i$f$toTypedArray = false;
                Collection<Navigatable> thisCollection$iv = $this$toTypedArray$iv;
                navigatableArray = thisCollection$iv.toArray(new Navigatable[0]);
            }
            return navigatableArray;
        }
        return DatabaseViewPanel.Companion.getDataFromNode(dataId, this.project, CollectionsKt.firstOrNull(nodes), slow);
    }

    private final EnumSet<DvTreeNodeRank> getNodeRanks() {
        EnumSet<DvTreeNodeRank> ranks = EnumSet.noneOf(DvTreeNodeRank.class);
        JBIterable<BasicNode> selectedNodes2 = this.getSelectedNodes();
        for (BasicNode node2 : selectedNodes2) {
            Intrinsics.checkNotNull((Object)node2);
            ranks.add(DvTreeNodeRankFun.getTreeNodeRank(node2));
        }
        Intrinsics.checkNotNull(ranks);
        return ranks;
    }

    private final DataSourceNode[] getRelatedDataSource() {
        DataSourceNode[] dataSourceNodeArray;
        JBIterable<DataSourceNode> relatedDSNs = this.getRelatedDataSourceNodes();
        if (relatedDSNs.isEmpty()) {
            dataSourceNodeArray = EMPTY_DSN_ARRAY;
        } else {
            Object[] objectArray = relatedDSNs.toArray((Object[])EMPTY_DSN_ARRAY);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
            dataSourceNodeArray = (DataSourceNode[])objectArray;
        }
        return dataSourceNodeArray;
    }

    private final <T> Collection<T> collectDataFromSelectedNodes(DataKey<T> key2, boolean slow, List<? extends Object> nodes) {
        LinkedHashSet result2 = new LinkedHashSet();
        for (Object object : nodes) {
            Collection collection2 = result2;
            String string = key2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ContainerUtil.addIfNotNull((Collection)collection2, (Object)DatabaseViewPanel.Companion.getDataFromNode(string, this.project, object, slow));
        }
        return result2;
    }

    private final DnDTarget findDndTargetAt(Point point, boolean strict) {
        DasObject o2;
        TreePath path;
        TreePath treePath = path = strict ? this.myTree.getPathForLocation(point.x, point.y) : this.myTree.getClosestPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        Object smth = path.getLastPathComponent();
        if (smth == null) {
            return null;
        }
        if (smth instanceof BasicNode) {
            Object theRootNode = path.getPathComponent(0);
            DvTreeContext context = theRootNode instanceof DvRootDsGroup ? ((DvRootDsGroup)theRootNode).getContext() : null;
            return context == null ? null : DatabaseViewPanel.Companion.getDnDTarget1((BasicNode)smth, context);
        }
        DbDataSource dataSource2 = DatabaseViewPanel.Companion.findDbDataSourceInPath(path);
        DasObject dasObject = o2 = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        Object object = dasObject == null ? smth : DbImplUtilCore.findElement(dataSource2, dasObject);
        Intrinsics.checkNotNull((Object)object);
        Object element2 = object;
        return DatabaseViewPanel.Companion.getDnDTarget2(element2);
    }

    @NotNull
    public final Promise<Void> selectNodes(@NotNull Collection<? extends BasicNode> nodes, boolean requestFocus, boolean forceShowToolWindow) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        ToolWindow window = Companion.getDatabaseToolWindow(this.project);
        if (!requestFocus && !forceShowToolWindow) {
            return this.selectNodes(nodes);
        }
        AsyncPromise res2 = new AsyncPromise();
        Runnable continuation = () -> DatabaseViewPanel.selectNodes$lambda$13(this, nodes, res2);
        if (requestFocus) {
            window.activate(continuation);
        } else {
            window.show(continuation);
        }
        return (Promise)res2;
    }

    @NotNull
    public final Element getState() {
        Element element2 = new Element("TreeState");
        TreeState.createOn((JTree)((JTree)((Object)this.myTree))).writeExternal(element2);
        return element2;
    }

    public final void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializer.deserializeInto((Object)this.myViewOptions, (Element)state);
        TreeState treeState = TreeState.createFrom((Element)state);
        Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createFrom(...)");
        TreeState treeState2 = treeState;
        treeState2.applyTo((JTree)((Object)this.myTree), (Object)this.myStructure.getRoot());
    }

    private final String getTreePathPresentationText(TreePath o2) {
        TreePath treePath = o2;
        Object node2 = treePath != null ? treePath.getLastPathComponent() : null;
        return this.getNodePresentationText(node2);
    }

    private final String getNodePresentationText(Object o2) {
        if (o2 instanceof BasicNode) {
            ItemPresentation presentation;
            ItemPresentation itemPresentation = presentation = (ItemPresentation)ReadAction.compute(() -> DatabaseViewPanel.getNodePresentationText$lambda$14(this, o2));
            return itemPresentation != null ? itemPresentation.getPresentableText() : null;
        }
        return null;
    }

    public final void showSchemaManagerGotIt(@Nullable DbDataSource ds) {
        if (ds == null) {
            return;
        }
        String string = DatabaseBundle.message("click.here.to.display.other.schemas.got.it", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GotItTooltip tip = new GotItTooltip("database.schema.control.got.it", string, (Disposable)this);
        if (!tip.canShow()) {
            return;
        }
        AsyncTreeModel model2 = this.asyncModel;
        DataSourceNode dsn = DataSourceNode.Companion.node(ds);
        Function1 function1 = new Function1(this, tip){
            final /* synthetic */ DatabaseViewPanel this$0;
            final /* synthetic */ GotItTooltip $tip;
            {
                this.this$0 = $receiver;
                this.$tip = $tip;
                super(1);
            }

            @Nullable
            public final Void invoke(TreePath path) {
                Tree tree = this.this$0.getTree();
                Intrinsics.checkNotNull((Object)path);
                Point pt = com.intellij.database.view.DatabaseViewPanel$Companion.access$getSchemaControlLocation(DatabaseViewPanel.Companion, path, tree);
                if (pt != null) {
                    tree.scrollRectToVisible(new Rectangle(pt));
                }
                this.$tip.show((JComponent)tree, (Function2)new Function2<Component, Balloon, Point>(path, tree){
                    final /* synthetic */ TreePath $path;
                    final /* synthetic */ Tree $tree;
                    {
                        this.$path = $path;
                        this.$tree = $tree;
                        super(2);
                    }

                    @NotNull
                    public final Point invoke(@NotNull Component c2, @NotNull Balloon b2) {
                        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
                        TreePath treePath = this.$path;
                        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"$path");
                        Point loc = com.intellij.database.view.DatabaseViewPanel$Companion.access$getSchemaControlLocation(DatabaseViewPanel.Companion, treePath, this.$tree);
                        Point point = loc;
                        if (point == null) {
                            point = new Point();
                        }
                        return point;
                    }
                });
                return null;
            }
        };
        model2.getTreePath((Object)dsn).thenAsync(arg_0 -> DatabaseViewPanel.showSchemaManagerGotIt$lambda$15((Function1)new Function1<TreePath, Promise<TreePath>>(model2){
            final /* synthetic */ AsyncTreeModel $model;
            {
                this.$model = $model;
                super(1);
            }

            public final Promise<TreePath> invoke(TreePath it2) {
                return this.$model.resolve(it2);
            }
        }, arg_0)).then(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.function = function2;
            }

            public final /* synthetic */ Object fun(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    private static final Object getSelectedNodes$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Iterable refineAndExpandNodesAsElements$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final DataSourceNode getRelatedDataSourceNodes$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final String initComponents$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void invokeRefresh$lambda$4(DatabaseViewPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.myStructure.refreshAll();
    }

    private static final void selectNode$lambda$5(DatabaseViewPanel this$0, BasicNode $node, AsyncPromise $res) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        this$0.selectNode($node).processed((Promise)$res);
    }

    private static final Promise selectNodes$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final void selectNodes$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Void selectNodes$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Void)$tmp0.invoke(p0);
    }

    private static final void collapseNodes$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final BasicNode unwrap$lambda$10(DatabaseViewPanel this$0, Object o2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.unwrap(o2);
    }

    private static final Object getData$lambda$12(DatabaseViewPanel this$0, List $nodes, String slowId) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
        Intrinsics.checkNotNullParameter((Object)slowId, (String)"slowId");
        return this$0.getDataFromSelectedNodes(slowId, true, $nodes);
    }

    private static final void selectNodes$lambda$13(DatabaseViewPanel this$0, Collection $nodes, AsyncPromise $res) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        this$0.selectNodes($nodes).processed((Promise)$res);
    }

    private static final ItemPresentation getNodePresentationText$lambda$14(DatabaseViewPanel this$0, Object $o) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.myTree.getCellPresentation((BasicNode)$o);
    }

    private static final Promise showSchemaManagerGotIt$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$16(DatabaseViewPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.invokeRefresh();
    }

    private static final void _init_$lambda$17(DatabaseViewPanel this$0, DbDataSource it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.refreshView();
    }

    private static final void _init_$lambda$18(DatabaseViewPanel this$0, JdbcDriverManager it2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
        this$0.refreshView();
    }

    private static final void _init_$lambda$19(DatabaseViewPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.invokeRefresh();
    }

    private static final void _init_$lambda$20(DatabaseViewPanel this$0, DatabaseConnection databaseConnection, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)databaseConnection, (String)"<anonymous parameter 0>");
        this$0.refreshView();
    }

    public static final /* synthetic */ JBIterable access$refineNodeAsElements(DatabaseViewPanel $this, BasicNode node2) {
        return $this.refineNodeAsElements(node2);
    }

    public static final /* synthetic */ String access$getTreePathPresentationText(DatabaseViewPanel $this, TreePath o2) {
        return $this.getTreePathPresentationText(o2);
    }

    public static final /* synthetic */ String access$getNodePresentationText(DatabaseViewPanel $this, Object o2) {
        return $this.getNodePresentationText(o2);
    }

    public static final /* synthetic */ MyAutoScrollFromSourceHandler access$getMyAutoScrollHandler$p(DatabaseViewPanel $this) {
        return $this.myAutoScrollHandler;
    }

    static {
        Logger logger2 = Logger.getInstance(DatabaseViewPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        ourLogger = logger2;
        boolean $i$f$emptyArray = false;
        EMPTY_NODES_ARRAY = new BasicNode[0];
        $i$f$emptyArray = false;
        EMPTY_ELEMENTS_ARRAY = new BasicElement[0];
        $i$f$emptyArray = false;
        EMPTY_DSN_ARRAY = new DataSourceNode[0];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J7\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0017\u001a\u00020\u001aH\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\"J\u001a\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0002J\u0014\u0010/\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0002J\"\u00105\u001a\u0004\u0018\u0001H6\"\u0004\b\u0000\u001062\u000b\u00107\u001a\u00070 \u00a2\u0006\u0002\b8H\u0003\u00a2\u0006\u0002\u00109R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$Companion;", "", "()V", "EMPTY_DSN_ARRAY", "", "Lcom/intellij/database/view/DataSourceNode;", "[Lcom/intellij/database/view/DataSourceNode;", "EMPTY_ELEMENTS_ARRAY", "Lcom/intellij/database/model/basic/BasicElement;", "[Lcom/intellij/database/model/basic/BasicElement;", "EMPTY_NODES_ARRAY", "Lcom/intellij/database/model/basic/BasicNode;", "getEMPTY_NODES_ARRAY", "()[Lcom/intellij/database/model/basic/BasicNode;", "[Lcom/intellij/database/model/basic/BasicNode;", "ourFilterIsEnabledCheck", "Lcom/intellij/database/util/common/BooleanVal;", "ourFilterIsStickyCheck", "ourLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createDnDTarget", "Lcom/intellij/ide/dnd/DnDTarget;", "element", "Lcom/intellij/database/psi/DbElement;", "findDbDataSourceInPath", "Lcom/intellij/database/psi/DbDataSource;", "path", "Ljavax/swing/tree/TreePath;", "getDataFromNode", "T", "dataId", "", "project", "Lcom/intellij/openapi/project/Project;", "node", "slow", "", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Z)Ljava/lang/Object;", "getDataSourceManagerUi", "Lcom/intellij/database/psi/DataSourceManagerUi;", "Lcom/intellij/database/model/RawDataSource;", "getDatabaseToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getDnDTarget1", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getDnDTarget2", "getPathDSN", "getSchemaControlLocation", "Ljava/awt/Point;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "traceAndNull", "Z", "message", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)Ljava/lang/Object;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final DataSourceNode getPathDSN(TreePath path) {
            Object[] pathNodes = path.getPath();
            Intrinsics.checkNotNull((Object)pathNodes);
            for (Object node2 : pathNodes) {
                if (!(node2 instanceof DataSourceNode)) continue;
                return (DataSourceNode)node2;
            }
            return null;
        }

        private final <T> T getDataFromNode(String dataId, Project project, Object node2, boolean slow) {
            if (node2 == null) {
                return null;
            }
            Object result2 = slow ? DbNodeDescriptor.getDataSlow(dataId, project, () -> Companion.getDataFromNode$lambda$0(node2)) : DbNodeDescriptor.getData(dataId, project, () -> Companion.getDataFromNode$lambda$1(node2));
            return (T)result2;
        }

        private final DbDataSource findDbDataSourceInPath(TreePath path) {
            DataSourceNode dsn;
            DataSourceNode dataSourceNode = dsn = (DataSourceNode)TreeUtil.findObjectInPath((TreePath)path, DataSourceNode.class);
            return dataSourceNode != null ? dataSourceNode.dbDataSource : null;
        }

        private final DnDTarget getDnDTarget1(BasicNode node2, DvTreeContext context) {
            DnDTarget dnDTarget;
            BasicNode basicNode = node2;
            if (basicNode instanceof DvDsGroup) {
                String string;
                DvDsGroup dvDsGroup = (DvDsGroup)node2;
                if (dvDsGroup instanceof DvSimpleDsGroup) {
                    string = ((DvSimpleDsGroup)node2).getPath();
                } else if (dvDsGroup instanceof DvRootDsGroup) {
                    string = "";
                } else {
                    return null;
                }
                String groupName = string;
                dnDTarget = new DataSourceUiUtil.DbGroupDropTarget(groupName);
            } else if (basicNode instanceof DataSourceNode) {
                DbDataSource dbDataSource = ((DataSourceNode)node2).dbDataSource;
                DnDTarget target2 = this.getDataSourceManagerUi(dbDataSource).createDnDTarget(dbDataSource.getDelegate());
                if (target2 == null) {
                    target2 = new DbElementDnDTarget.DataSourceDnDTarget(dbDataSource);
                }
                dnDTarget = target2;
            } else if (basicNode instanceof BasicElement) {
                DbModelRegistry r = (DbModelRegistry)context.project.getService(DbModelRegistry.class);
                DbElement dbElement = r.findDbElement((BasicElement)node2);
                dnDTarget = this.getDnDTarget2(dbElement);
            } else if (basicNode instanceof HostFamily) {
                DbModelRegistry registry;
                BasicElement basicElement = ((HostFamily)node2).getHost();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
                BasicElement host = basicElement;
                DbModelRegistry dbModelRegistry = registry = (DbModelRegistry)context.project.getService(DbModelRegistry.class);
                DbElement dbHost = dbModelRegistry != null ? dbModelRegistry.findDbElement(host) : null;
                dnDTarget = dbHost instanceof DbNamespaceImpl ? new DbElementDnDTarget.FamilyGroupDnDTarget((DbNamespaceImpl)dbHost, ((HostFamily)node2).getChildrenKind()) : null;
            } else {
                dnDTarget = null;
            }
            return dnDTarget;
        }

        @TestOnly
        @Nullable
        public final DnDTarget createDnDTarget(@Nullable DbElement element2) {
            return this.getDnDTarget2(element2);
        }

        private final DnDTarget getDnDTarget2(Object element2) {
            DnDTarget dnDTarget;
            Object object = element2;
            if (object instanceof DbDataSource) {
                DnDTarget target2 = this.getDataSourceManagerUi((DbDataSource)element2).createDnDTarget(((DbDataSource)element2).getDelegate());
                dnDTarget = target2;
                if (dnDTarget == null) {
                    dnDTarget = new DbElementDnDTarget.DataSourceDnDTarget((DbDataSource)element2);
                }
            } else {
                dnDTarget = object instanceof DbNamespaceImpl ? (DnDTarget)new DbElementDnDTarget.NamespaceDnDTarget((DbNamespace)element2) : (object instanceof DbTableImpl ? (DnDTarget)new DbElementDnDTarget.DbTableDnDTarget((DbTable)element2) : null);
            }
            return dnDTarget;
        }

        private final DataSourceManagerUi<RawDataSource> getDataSourceManagerUi(DbDataSource element2) {
            Intrinsics.checkNotNull((Object)element2, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbDataSourceImpl");
            DataSourceManager<RawDataSource> dataSourceManager = ((DbDataSourceImpl)element2).getDbManager();
            Intrinsics.checkNotNull(dataSourceManager, (String)"null cannot be cast to non-null type com.intellij.database.psi.DataSourceManagerUi<com.intellij.database.model.RawDataSource>");
            return (DataSourceManagerUi)((Object)dataSourceManager);
        }

        @NotNull
        public final ToolWindow getDatabaseToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Database");
            Intrinsics.checkNotNull((Object)toolWindow);
            return toolWindow;
        }

        @Contract(value="_ -> null")
        private final <Z> Z traceAndNull(String message2) {
            ourLogger.trace(message2);
            return null;
        }

        private final Point getSchemaControlLocation(TreePath path, Tree tree) {
            Rectangle b2 = tree.getPathBounds(path);
            if (b2 == null) {
                return null;
            }
            double x = b2.getMaxX() - b2.getHeight() / (double)2;
            return new Point((int)x, (int)b2.getMaxY());
        }

        @NotNull
        public final BasicNode[] getEMPTY_NODES_ARRAY() {
            return EMPTY_NODES_ARRAY;
        }

        private static final Object getDataFromNode$lambda$0(Object $node) {
            return $node;
        }

        private static final Object getDataFromNode$lambda$1(Object $node) {
            return $node;
        }

        public static final /* synthetic */ DataSourceNode access$getPathDSN(Companion $this, TreePath path) {
            return $this.getPathDSN(path);
        }

        public static final /* synthetic */ Point access$getSchemaControlLocation(Companion $this, TreePath path, Tree tree) {
            return $this.getSchemaControlLocation(path, tree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\bJ\u0012\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyAutoScrollFromSourceHandler;", "Lcom/intellij/ui/AutoScrollFromSourceHandler;", "project", "Lcom/intellij/openapi/project/Project;", "myView", "Lcom/intellij/database/view/DatabaseViewPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/DatabaseViewPanel;)V", "enabled", "", "value", "isAutoScrollEnabledSynthetic", "()Z", "setAutoScrollEnabledSynthetic", "(Z)V", "getMyView", "()Lcom/intellij/database/view/DatabaseViewPanel;", "install", "", "isAutoScrollEnabled", "selectElementFromEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "selectElementFromEditorInner", "force", "selectForEditorInAlarm", "selectedEditor", "selectInView", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "Lcom/intellij/openapi/editor/Editor;", "setAutoScrollEnabled", "updateEnabledState", "intellij.database.impl"})
    public static final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        @NotNull
        private final DatabaseViewPanel myView;
        private boolean enabled;

        public MyAutoScrollFromSourceHandler(@NotNull Project project, @NotNull DatabaseViewPanel myView) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)myView), (String)"myView");
            super(project, (JComponent)((Object)myView), (Disposable)myView);
            this.myView = myView;
        }

        @NotNull
        public final DatabaseViewPanel getMyView() {
            return this.myView;
        }

        public final boolean isAutoScrollEnabledSynthetic() {
            return this.isAutoScrollEnabled();
        }

        public final void setAutoScrollEnabledSynthetic(boolean value2) {
            this.setAutoScrollEnabled(value2);
        }

        public void install() {
            super.install();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(new CaretListener(this){
                final /* synthetic */ MyAutoScrollFromSourceHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void caretPositionChanged(@NotNull CaretEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor2 = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    MyAutoScrollFromSourceHandler.access$selectInView(this.this$0, editor2);
                }
            }, (Disposable)this.myView);
            MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myView);
            Topic topic = DataGridListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new DataGridListener(this){
                final /* synthetic */ MyAutoScrollFromSourceHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSelectionChanged(@NotNull DataGrid dataGrid) {
                    Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                    MyAutoScrollFromSourceHandler.access$selectInView(this.this$0, dataGrid);
                }
            });
            this.myProject.getMessageBus().connect((Disposable)this.myView).subscribe(DatabaseViewOptions.TOPIC, () -> MyAutoScrollFromSourceHandler.install$lambda$0(this));
            this.updateEnabledState();
        }

        private final void updateEnabledState() {
            boolean willEnable = this.isAutoScrollEnabled();
            if (this.enabled == willEnable) {
                return;
            }
            this.enabled = willEnable;
            if (this.enabled) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
                FileEditor[] fileEditorArray = fileEditorManager.getSelectedEditors();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
                FileEditor[] editors = fileEditorArray;
                if (!(editors.length == 0)) {
                    FileEditor fileEditor = editors[0];
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"get(...)");
                    this.selectElementFromEditor(fileEditor);
                }
            }
        }

        private final void selectInView(Editor editor2) {
            VirtualFile file1;
            FileEditor selectedEditor;
            if (!this.myView.isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            FileEditor fileEditor = selectedEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
            Object object = file1 = fileEditor != null ? fileEditor.getFile() : null;
            if (file1 == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (!Intrinsics.areEqual((Object)file1, (Object)file2)) {
                return;
            }
            this.selectForEditorInAlarm(selectedEditor);
        }

        private final void selectForEditorInAlarm(FileEditor selectedEditor) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> MyAutoScrollFromSourceHandler.selectForEditorInAlarm$lambda$1(this, selectedEditor), this.getAlarmDelay(), this.getModalityState());
        }

        private final void selectInView(DataGrid grid) {
            DataGrid grid1;
            DatabaseTableFileEditor selectedEditor;
            if (!this.myView.isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
            DatabaseTableFileEditor databaseTableFileEditor = selectedEditor = fileEditor instanceof DatabaseTableFileEditor ? (DatabaseTableFileEditor)fileEditor : null;
            Object object = grid1 = databaseTableFileEditor != null ? databaseTableFileEditor.getDataGrid() : null;
            if (!Intrinsics.areEqual((Object)grid, (Object)grid1)) {
                return;
            }
            this.selectForEditorInAlarm((FileEditor)selectedEditor);
        }

        public boolean isAutoScrollEnabled() {
            return this.myView.myViewOptions.getAutoScrollingFromSources();
        }

        public void setAutoScrollEnabled(boolean enabled) {
            this.myView.myViewOptions.setAutoScrollingFromSources(enabled);
            this.myView.myViewOptions.fireChanged();
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.selectElementFromEditorInner(editor2, false);
        }

        public final void selectElementFromEditorInner(@NotNull FileEditor editor2, boolean force) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            DbElement element2 = DatabaseContextFun.getSelectedDbElementFromEditor(dataContext2);
            DataContext dataContext3 = DataManager.getInstance().getDataContext((Component)((Object)this.myView));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            PsiElement selection2 = (PsiElement)DatabaseContextFun.getSelectedPsiElements(dataContext3).first();
            if (element2 != null && (force || selection2 == null || !PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)selection2, (boolean)false))) {
                BasicNode node2 = this.myView.unwrap(element2);
                this.myView.selectNode(node2);
            }
        }

        private static final void install$lambda$0(MyAutoScrollFromSourceHandler this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.updateEnabledState();
        }

        private static final void selectForEditorInAlarm$lambda$1(MyAutoScrollFromSourceHandler this$0, FileEditor $selectedEditor) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            FileEditor fileEditor = $selectedEditor;
            Intrinsics.checkNotNull((Object)fileEditor);
            this$0.selectElementFromEditor(fileEditor);
        }

        public static final /* synthetic */ void access$selectInView(MyAutoScrollFromSourceHandler $this, Editor editor2) {
            $this.selectInView(editor2);
        }

        public static final /* synthetic */ void access$selectInView(MyAutoScrollFromSourceHandler $this, DataGrid grid) {
            $this.selectInView(grid);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyDnDSource;", "Lcom/intellij/ide/dnd/DnDSource;", "(Lcom/intellij/database/view/DatabaseViewPanel;)V", "canStartDragging", "", "action", "Lcom/intellij/ide/dnd/DnDAction;", "dragOrigin", "Ljava/awt/Point;", "createDraggedImage", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Image;", "bean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "startDragging", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel$MyDnDSource\n+ 2 SequenceFun.kt\ncom/intellij/database/util/common/SequenceFun\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,914:1\n9#2:915\n37#3,2:916\n*S KotlinDebug\n*F\n+ 1 DatabaseViewPanel.kt\ncom/intellij/database/view/DatabaseViewPanel$MyDnDSource\n*L\n609#1:915\n609#1:916,2\n*E\n"})
    private final class MyDnDSource
    implements DnDSource {
        public boolean canStartDragging(@NotNull DnDAction action, @NotNull Point dragOrigin) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            TreePath[] treePathArray = DatabaseViewPanel.this.getMyTree().getSelectionPaths();
            return treePathArray != null ? !(treePathArray.length == 0) : false;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public DnDDragStartBean startDragging(@NotNull DnDAction action, @NotNull Point dragOrigin) {
            void $this$toArray$iv;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            Object[] paths2 = DatabaseViewPanel.this.getMyTree().getSelectionPaths();
            if (paths2 == null || paths2.length == 0) {
                return new DnDDragStartBean(null, dragOrigin);
            }
            Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths2), (Function1)startDragging.selection.1.INSTANCE));
            boolean $i$f$toArray = false;
            Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] selection2 = thisCollection$iv$iv.toArray(new Object[0]);
            return new DnDDragStartBean((Object)(!(selection2.length == 0) ? new MyTransferable(selection2) : null), dragOrigin);
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(@NotNull DnDAction action, @NotNull Point dragOrigin, @NotNull DnDDragStartBean bean) {
            DatabaseViewTreeComponent.CellRenderer cellRenderer;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)dragOrigin, (String)"dragOrigin");
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Object object = bean.getAttachedObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.view.DatabaseViewPanel.MyTransferable");
            Object[] attachedObjects = ((MyTransferable)object).getObjects();
            if (attachedObjects.length == 0) {
                return (Pair)Companion.traceAndNull("Cannot drag: no attached objects");
            }
            Object attachedObject = attachedObjects[0];
            TreeCellRenderer treeCellRenderer = DatabaseViewPanel.this.getMyTree().getCellRenderer();
            DatabaseViewTreeComponent.CellRenderer cellRenderer2 = cellRenderer = treeCellRenderer instanceof DatabaseViewTreeComponent.CellRenderer ? (DatabaseViewTreeComponent.CellRenderer)treeCellRenderer : null;
            if (cellRenderer == null) {
                return (Pair)Companion.traceAndNull("Cannot drag: no cell renderer");
            }
            ThrowableComputable innerPresentationSupplier = () -> MyDnDSource.createDraggedImage$lambda$0(cellRenderer, attachedObject);
            ItemPresentation presentation = (ItemPresentation)ReadAction.compute((ThrowableComputable)innerPresentationSupplier);
            if (presentation == null) {
                return (Pair)Companion.traceAndNull("Cannot drag: no presentation");
            }
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            c2.setForeground(RenderingUtil.getForeground((JTree)((JTree)((Object)DatabaseViewPanel.this.getMyTree()))));
            c2.setBackground(RenderingUtil.getBackground((JTree)((JTree)((Object)DatabaseViewPanel.this.getMyTree()))));
            c2.setIcon(presentation.getIcon(false));
            if (presentation instanceof PresentationData) {
                for (PresentableNodeDescriptor.ColoredFragment fragment : ((PresentationData)presentation).getColoredText()) {
                    c2.append(fragment.getText(), fragment.getAttributes());
                }
            }
            if (attachedObjects.length > 1) {
                c2.append(" +" + (attachedObjects.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension dimension = c2.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            Dimension size = dimension;
            c2.setSize(size);
            BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)c2), (int)size.width, (int)size.height, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image = bufferedImage;
            c2.setOpaque(false);
            Graphics2D g2 = image.createGraphics();
            c2.paint((Graphics)g2);
            g2.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }

        private static final ItemPresentation createDraggedImage$lambda$0(DatabaseViewTreeComponent.CellRenderer $cellRenderer, Object $attachedObject) {
            Object object = $attachedObject;
            Intrinsics.checkNotNull((Object)object);
            return $cellRenderer.getCopyPresentationInner(object);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyDnDTarget;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "(Lcom/intellij/database/view/DatabaseViewPanel;)V", "myHelper", "Lcom/intellij/database/dbimport/DbElementDnDTarget$ExpandHelper;", "cleanUpOnLeave", "", "drop", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "hasDdlDataSourceFiles", "", "update", "intellij.database.impl"})
    private final class MyDnDTarget
    implements DnDNativeTarget {
        @NotNull
        private final DbElementDnDTarget.ExpandHelper myHelper;

        public MyDnDTarget() {
            this.myHelper = new DbElementDnDTarget.ExpandHelper((JTree)((Object)DatabaseViewPanel.this.getMyTree()), DatabaseViewPanel.this);
        }

        public boolean update(@NotNull DnDEvent aEvent) {
            Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
            this.myHelper.update(aEvent);
            Point point = aEvent.getPointOn((Component)((Object)DatabaseViewPanel.this.getMyTree()));
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            Intrinsics.checkNotNull((Object)point);
            DnDTarget target2 = DatabaseViewPanel.this.findDndTargetAt(point, canCreateDataSource);
            boolean targetOk = target2 != null && aEvent.delegateUpdateTo(target2);
            boolean ok2 = targetOk || canCreateDataSource;
            aEvent.setDropPossible(ok2);
            if (ok2) {
                RelativeRectangle rectangle = null;
                if (targetOk) {
                    Rectangle bounds = DatabaseViewPanel.this.getMyTree().getPathBounds(DatabaseViewPanel.this.getMyTree().getClosestPathForLocation(point.x, point.y));
                    rectangle = bounds != null ? new RelativeRectangle((Component)((Object)DatabaseViewPanel.this.getMyTree()), bounds) : null;
                } else {
                    Rectangle bounds = DatabaseViewPanel.this.getBounds();
                    rectangle = new RelativeRectangle((Component)((Object)DatabaseViewPanel.this), bounds);
                }
                if (rectangle != null) {
                    aEvent.setHighlighting(rectangle, 1);
                }
            } else {
                this.myHelper.notHandled(aEvent);
            }
            return ok2;
        }

        public void cleanUpOnLeave() {
            super.cleanUpOnLeave();
            this.myHelper.leave();
        }

        public void drop(@NotNull DnDEvent aEvent) {
            Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            Point point = aEvent.getPointOn((Component)((Object)DatabaseViewPanel.this.getMyTree()));
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPointOn(...)");
            DnDTarget target2 = DatabaseViewPanel.this.findDndTargetAt(point, canCreateDataSource);
            if (target2 != null && aEvent.delegateUpdateTo(target2)) {
                aEvent.delegateDropTo(target2);
            } else if (!(target2 instanceof DbElementDnDTarget.DataSourceDnDTarget)) {
                DataSourceUiUtil.createDataSourceFromFiles(DatabaseViewPanel.this.getProject(), FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject()));
            }
        }

        private final boolean hasDdlDataSourceFiles(DnDEvent aEvent) {
            List list = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVirtualFileListFromAttachedObject(...)");
            Collection files2 = list;
            for (DataSourceManager<?> manager : DataSourceManager.getManagers(DatabaseViewPanel.this.getProject())) {
                if (!(manager instanceof BasicDataSourceManager) || !((BasicDataSourceManager)manager).canCreateDataSourceByFiles(files2)) continue;
                return true;
            }
            return SystemInfo.isMac && files2.isEmpty();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseViewPanel$MyTransferable;", "Ljava/awt/datatransfer/Transferable;", "objects", "", "", "([Ljava/lang/Object;)V", "getObjects", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getTransferData", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "intellij.database.impl"})
    private static final class MyTransferable
    implements Transferable {
        @NotNull
        private final Object[] objects;

        public MyTransferable(@NotNull Object[] objects2) {
            Intrinsics.checkNotNullParameter((Object)objects2, (String)"objects");
            this.objects = objects2;
        }

        @NotNull
        public final Object[] getObjects() {
            return this.objects;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[2];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.stringFlavor, (String)"stringFlavor");
            Intrinsics.checkNotNullExpressionValue((Object)DnDEventImpl.ourDataFlavor, (String)"ourDataFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return true;
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                for (Object object : this.objects) {
                    if (!(object instanceof PsiNamedElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(((PsiNamedElement)object).getName());
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.objects;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

