/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EDT;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@State(name="DatabaseView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, getStateRequiresEdt=true)
public class DatabaseView
implements PersistentStateComponent<Element>,
Disposable,
DataProvider {
    public static final DataKey<DatabaseView> DATABASE_VIEW_KEY = DataKey.create((String)"DATABASE_VIEW_KEY");
    public static final DataKey<BasicNode[]> DATABASE_NODES = DataKey.create((String)"DATABASE_NODES");
    public static final DataKey<BasicElement[]> DATABASE_ELEMENTS = DataKey.create((String)"DATABASE_ELEMENTS");
    public static final DataKey<EnumSet<DvTreeNodeRank>> DATABASE_NODE_RANKS = DataKey.create((String)"DATABASE_NODE_RANKS");
    public static final DataKey<DataSourceNode> DATABASE_RELATED_SINGLE_DATA_SOURCE = DataKey.create((String)"DATABASE_RELATED_SINGLE_DATA_SOURCE");
    public static final DataKey<DataSourceNode[]> DATABASE_RELATED_DATA_SOURCES = DataKey.create((String)"DATABASE_RELATED_DATA_SOURCES");
    public static final DataKey<Boolean> DATABASE_TREE_IS_ORIGIN = DataKey.create((String)"DATABASE_TREE_IS_ORIGIN");
    public static final DataKey<DbElement[]> DB_ELEMENTS = DataKey.create((String)"DB_ELEMENTS");
    public static final DataKey<DeleteProvider> DROP_ELEMENT_PROVIDER = DataKey.create((String)"DROP_ELEMENT_PROVIDER");
    static final String DATABASE_VIEW_POPUP_MENU = "DatabaseViewPopupMenu";
    @NotNull
    protected final Project myProject;
    protected volatile DatabaseViewPanel myDatabaseViewPanel;
    protected final DvMutableViewOptions myViewOptions;
    private Element myTempState;

    public static DatabaseView getDatabaseView(@NotNull Project project) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(0);
        }
        return (DatabaseView)project.getService(DatabaseView.class);
    }

    public DatabaseView(@NotNull Project project) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myViewOptions = DvViewOptionsFun.getDatabaseMutableViewOptions(project);
        project.getMessageBus().connect().subscribe(DatabaseViewOptions.TOPIC, this::viewOptionsChanged);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        DatabaseViewPanel panel2;
        if (dataId == null) {
            DatabaseView.$$$reportNull$$$0(2);
        }
        return (panel2 = this.getPanelIfAny()) == null ? null : panel2.getData(dataId);
    }

    @RequiresEdt
    @NotNull
    public DatabaseViewPanel getPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDatabaseViewPanel == null) {
            this.myDatabaseViewPanel = new DatabaseViewPanel(this.myProject, this.myViewOptions);
            Element state = this.myTempState;
            if (state != null) {
                this.myDatabaseViewPanel.loadState(state);
                this.myTempState = null;
            }
            Disposer.register((Disposable)this, (Disposable)this.myDatabaseViewPanel);
        }
        DatabaseViewPanel databaseViewPanel = this.myDatabaseViewPanel;
        if (databaseViewPanel == null) {
            DatabaseView.$$$reportNull$$$0(3);
        }
        return databaseViewPanel;
    }

    @Nullable
    @ApiStatus.Internal
    public DatabaseViewPanel getPanelIfAny() {
        return this.myDatabaseViewPanel;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Promise<@NotNull DatabaseViewPanel> getPanelOnEdt() {
        if (EDT.isCurrentThreadEdt()) {
            Promise promise = Promises.resolvedPromise((Object)((Object)this.getPanel()));
            if (promise == null) {
                DatabaseView.$$$reportNull$$$0(4);
            }
            return promise;
        }
        @NotNull AsyncPromise promise = new AsyncPromise();
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (this.myProject.isDisposed()) {
                promise.cancel();
            } else {
                promise.setResult((Object)this.getPanel());
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            DatabaseView.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    @Nullable
    public DatabaseCopyPasteProvider getCopyPasteProvider() {
        DatabaseViewPanel panel2 = this.getPanelIfAny();
        return panel2 == null ? null : panel2.getCopyPasteProvider();
    }

    @NotNull
    public DvViewOptions getViewOptions() {
        DvMutableViewOptions dvMutableViewOptions = this.myViewOptions;
        if (dvMutableViewOptions == null) {
            DatabaseView.$$$reportNull$$$0(6);
        }
        return dvMutableViewOptions;
    }

    @ApiStatus.Internal
    @NotNull
    public DvMutableViewOptions getMutableViewOptions() {
        DvMutableViewOptions dvMutableViewOptions = this.myViewOptions;
        if (dvMutableViewOptions == null) {
            DatabaseView.$$$reportNull$$$0(7);
        }
        return dvMutableViewOptions;
    }

    @RequiresEdt
    public void repaint() {
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseViewPanel panel2 = this.getPanelIfAny();
        panel2.getTree().repaint();
    }

    @NotNull
    public JBIterable<BasicNode> getSelectedNodes() {
        DatabaseViewPanel panel2 = this.getPanelIfAny();
        JBIterable<BasicNode> jBIterable = panel2 == null ? JBIterable.empty() : panel2.getSelectedNodes();
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<BasicElement> getSelectedElements() {
        DatabaseViewPanel panel2 = this.getPanelIfAny();
        JBIterable<BasicElement> jBIterable = panel2 == null ? JBIterable.empty() : panel2.getSelectedElements();
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(10);
        }
        return project;
    }

    private void viewOptionsChanged() {
        this.getPanelOnEdt().onSuccess(DatabaseViewPanel::viewOptionsChanged);
    }

    public void selectNode(@NotNull BasicNode node2, boolean requestFocus) {
        if (node2 == null) {
            DatabaseView.$$$reportNull$$$0(11);
        }
        this.getPanelOnEdt().onSuccess(p2 -> p2.selectNode(node2, requestFocus));
    }

    @NotNull
    public Promise<Void> selectNode(@Nullable BasicNode node2) {
        Promise promise = this.getPanelOnEdt().thenAsync(p2 -> p2.selectNode(node2).then(v2 -> null));
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Promise<Void> selectElement(@Nullable Object object) {
        DatabaseNodeWrappingService service = (DatabaseNodeWrappingService)this.myProject.getService(DatabaseNodeWrappingService.class);
        BasicNode node2 = service.unwrap(object);
        Promise<Void> promise = this.selectNode(node2);
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(13);
        }
        return promise;
    }

    public void dispose() {
    }

    @RequiresEdt
    public Content setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            DatabaseView.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseViewPanel panel2 = this.getPanel();
        panel2.setupToolWindow(toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(panel2.getComponent(), null, false);
        content.setPreferredFocusableComponent((JComponent)panel2.getTree());
        return content;
    }

    @RequiresEdt
    public static void refreshViewAndSelect(@NotNull Project project, @NotNull Collection<?> selection2) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(15);
        }
        if (selection2 == null) {
            DatabaseView.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DataSourceStorage.getProjectStorage(project).incModificationCount();
        DataSourceStorage.getStorage().incModificationCount();
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        DatabaseViewPanel panel2 = view2.getPanel();
        panel2.refreshView();
        List<BasicNode> nodes = panel2.unwrap(selection2);
        panel2.selectNodes(nodes);
        DatabaseServiceViewContributor.refreshView(project);
    }

    @RequiresEdt
    public static void collapseNodes(@NotNull Project project, @NotNull Collection<? extends BasicNode> nodes) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(17);
        }
        if (nodes == null) {
            DatabaseView.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        DatabaseViewPanel panel2 = view2.getPanel();
        panel2.collapseNodes(nodes);
    }

    @NotNull
    public static Promise<Void> select(@NotNull PsiElement element2, boolean requestFocus) {
        if (element2 == null) {
            DatabaseView.$$$reportNull$$$0(19);
        }
        return DatabaseView.select(element2.getProject(), Collections.singleton(element2), requestFocus);
    }

    @NotNull
    public static Promise<Void> select(@NotNull Project project, @NotNull Collection<?> elements2, boolean requestFocus) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(20);
        }
        if (elements2 == null) {
            DatabaseView.$$$reportNull$$$0(21);
        }
        return DatabaseView.select(project, elements2, requestFocus, true);
    }

    @NotNull
    public static Promise<Void> select(@NotNull Project project, @NotNull Collection<?> elements2, boolean requestFocus, boolean forceShowToolWindow) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(22);
        }
        if (elements2 == null) {
            DatabaseView.$$$reportNull$$$0(23);
        }
        DatabaseView dbView = DatabaseView.getDatabaseView(project);
        Promise promise = dbView.getPanelOnEdt().thenAsync(p2 -> p2.selectNodes(p2.unwrap(elements2), requestFocus, forceShowToolWindow));
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(24);
        }
        return promise;
    }

    @NotNull
    public Element getState() {
        if (this.myDatabaseViewPanel == null) {
            Element state = this.myTempState;
            Element element2 = state == null ? new Element("state") : state;
            if (element2 == null) {
                DatabaseView.$$$reportNull$$$0(25);
            }
            return element2;
        }
        Element element3 = this.getPanel().getState();
        if (element3 == null) {
            DatabaseView.$$$reportNull$$$0(26);
        }
        return element3;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DatabaseView.$$$reportNull$$$0(27);
        }
        if (this.myDatabaseViewPanel == null) {
            this.myTempState = state;
        } else {
            this.myTempState = null;
            this.getPanel().loadState(state);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void showSchemaManagerGotIt(@Nullable DbDataSource dbDataSource) {
        void ds;
        ThreadingAssertions.assertEventDispatchThread();
        this.getPanel().showSchemaManagerGotIt((DbDataSource)ds);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static <T extends DbElement> Set<T> getSelectedElements(@NotNull DataContext dataContext, Class<T> aClass) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(28);
        }
        Set set = DatabaseContextFun.getSelectedDbElements(dataContext, aClass).toSet();
        if (set == null) {
            DatabaseView.$$$reportNull$$$0(29);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 24, 25, 26, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelOnEdt";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableViewOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 9: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "selectNode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseView";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "refreshViewAndSelect";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collapseNodes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 24, 25, 26, 29 -> new IllegalStateException(string);
        };
    }
}

