/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProviderUi;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisherUi;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleDataRequestUi;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.UnindexedFilesScanner;
import java.util.Collections;
import java.util.function.Supplier;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public final class DatabaseUiServiceImpl
extends DatabaseUiService {
    @Override
    public void applyFix(@NotNull Project project, ErrorInfo.Fix fix, DatabaseConfigEditor editor2) {
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(0);
        }
        DataSourceUiUtil.applyFix(project, fix, editor2);
    }

    @Override
    @NotNull
    public DataRequest.CoupledWithEditor.ErrorNavigator reportError(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
        if (request == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(1);
        }
        if (errorInfo == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(2);
        }
        DataRequest.CoupledWithEditor.ErrorNavigator errorNavigator = new ConsoleDataRequestUi(request).reportError(errorInfo);
        if (errorNavigator == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(3);
        }
        return errorNavigator;
    }

    @Override
    public void reportWarning(@NotNull ConsoleDataRequest request, @NotNull JdbcEngineUtils.EngineWarningExceptionInfo info2) {
        if (request == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(4);
        }
        if (info2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(5);
        }
        new ConsoleDataRequestUi(request).reportWarning(info2);
    }

    @Override
    public void updateConsoleUI(ConsoleDataRequest request, boolean scrollToQuery) {
        new ConsoleDataRequestUi(request).updateConsoleUI(scrollToQuery);
    }

    @Override
    public Pair<DataSourceSshTunnelConfiguration, SshUiData> askSshCredentials(Project project, LocalDataSource source, @NlsContexts.DialogMessage String message2, boolean error2) {
        return DatabaseSshTunnelEstablisherUi.askSshCredentials(project, source, message2, error2);
    }

    @Override
    public void navigateToSource(@NotNull DbElement element2, boolean requestFocus) {
        if (element2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(6);
        }
        DbNavigationUtils.navigateToSource(element2, requestFocus);
    }

    @Override
    @NotNull
    public Promise<Void> selectInDatabaseView(@NotNull PsiElement element2, boolean requestFocus) {
        if (element2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(7);
        }
        Promise<Void> promise = DatabaseView.select(element2, requestFocus);
        if (promise == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @Override
    public void reloadIfNeeded(Project project, DatabaseElementSourceVirtualFileImpl file) {
        DatabaseEditorHelper.reloadIfNeeded(project, file);
    }

    @Override
    public void updateQuickDocAsync(@NotNull PsiElement element2, @NotNull CharSequence prefix, @NotNull Consumer<Consumer<Object>> provider) {
        if (element2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(10);
        }
        if (provider == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(11);
        }
        QuickDocUtil.updateQuickDocAsync((PsiElement)element2, (CharSequence)prefix, provider);
    }

    @Override
    public String askChangePassword(Project project) {
        return DatabaseCredentialsAuthProviderUi.askChangePassword(project);
    }

    @Override
    public DatabaseCredentials newOneTimeInstance(DatabaseCredentials credentials) {
        return DatabaseCredentialsUi.newOneTimeInstance(credentials);
    }

    @Override
    public <T> AsyncTask<T> showCredentialsDialog(Supplier<T> supplier2) {
        return DatabaseCredentialsUi.showCredentialsDialog(supplier2);
    }

    @Override
    public boolean confirmAndRunSync(@NotNull Project project, @NotNull @Nls String actionName, @NotNull Runnable sync) {
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(12);
        }
        if (actionName == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(13);
        }
        if (sync == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(14);
        }
        String whatToDoText = DatabaseBundle.message("button.abort.increase.introspection.level.AbortAndIntrospect", new Object[0]);
        return DatabaseUiServiceImpl.confirmTextAndRunSync(project, actionName, whatToDoText, sync);
    }

    @Override
    public boolean confirmAndRunSync(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull @Nls String actionName, @NotNull LevelAnalyzer.Recommendation recommendation) {
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(15);
        }
        if (dataSource2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(16);
        }
        if (actionName == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(17);
        }
        if (recommendation == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(18);
        }
        String whatToDoText = DatabaseBundle.message("button.abort.increase.introspection.level.AbortAndWhatIsRecommended", recommendation.getTitle());
        return DatabaseUiServiceImpl.confirmTextAndRunSync(project, actionName, whatToDoText, () -> DataSourceUtil.performManualSyncTask(project, dataSource2, recommendation.tasks));
    }

    private static boolean confirmTextAndRunSync(@NotNull Project project, @NotNull @Nls String actionName, @NotNull @Nls String whatToDoText, @NotNull Runnable sync) {
        String questionText;
        String title;
        int result2;
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(19);
        }
        if (actionName == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(20);
        }
        if (whatToDoText == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(21);
        }
        if (sync == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(22);
        }
        if ((result2 = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)(title = DatabaseBundle.message("dialog.title.low.introspection.level", StringUtil.trimEnd((String)actionName, (String)"\u2026"))), (String)(questionText = DatabaseBundle.message("notification.content.results.might.be.wrong.due.to.low.level", new Object[0]))).yesText(whatToDoText)).noText(DatabaseBundle.message("button.force.continue", new Object[0]))).show(project)) == 1) {
            return false;
        }
        if (result2 == 0) {
            sync.run();
        }
        return true;
    }

    @Override
    public boolean askIfAbort(@Nls String actionName, @NotNull LoaderContext context) {
        if (context == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(23);
        }
        return this.confirmAndRunSync(context.getProject(), actionName, () -> DataSourceUiUtil.performManualSyncTask(context));
    }

    @Override
    public boolean askIfAbort(@Nls String actionName, @NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull BasicElement element2) {
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(24);
        }
        if (dataSource2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(25);
        }
        if (element2 == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(26);
        }
        return this.confirmAndRunSync(project, actionName, () -> RefreshActionsLogic.refreshToComplete(project, dataSource2, Collections.singleton(element2)));
    }

    @Override
    public void rescanDbSrcIndex(@NotNull Project project, @NotNull String reason) {
        if (project == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(27);
        }
        if (reason == null) {
            DatabaseUiServiceImpl.$$$reportNull$$$0(28);
        }
        if (ApplicationManagerEx.getApplicationEx().isLightEditMode()) {
            return;
        }
        new UnindexedFilesScanner(project, reason){

            protected boolean shouldHideProgressInSmartMode() {
                return Registry.is((String)"scanning.hide.progress.in.smart.mode", (boolean)true);
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseUiServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sync";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommendation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDoText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseUiServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reportError";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInDatabaseView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportWarning";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectInDatabaseView";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateQuickDocAsync";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "confirmAndRunSync";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "confirmTextAndRunSync";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "askIfAbort";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rescanDbSrcIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

