/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProviderUi;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.ui.AuthWidgetBuilderImpl;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.net.HttpConfigurable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseCoreUiServiceImpl
extends DatabaseCoreUiService {
    @Override
    @Nullable
    public DbElement findElement(@NotNull Project project, @Nullable DasObject o2) {
        if (project == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(0);
        }
        return ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbElement(o2);
    }

    @Override
    @NotNull
    public JBIterable<?> treeChildren(@NotNull Project project, @NotNull Object object, @NotNull ObjectKind kind) {
        BasicNode node2;
        if (project == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(1);
        }
        if (object == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(3);
        }
        if ((node2 = (BasicNode)ObjectUtils.tryCast((Object)object, BasicNode.class)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseCoreUiServiceImpl.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        JBIterable children2 = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(structure::childrenOf).withRoot((Object)node2)).expandAndSkip(o2 -> o2 == node2 || o2 instanceof DvTreeLayoutLayer.HostGroup)).bfsTraversal();
        BasicNode family = (BasicNode)children2.find(o2 -> DatabaseCoreUiServiceImpl.getEffectiveFamilyKind(o2) == kind);
        JBIterable jBIterable = family == null ? children2.filter(o2 -> o2 instanceof BasicObjectNode && ((BasicObjectNode)o2).getMetaObject().kind == kind) : structure.childrenOf(family);
        if (jBIterable == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static ObjectKind getEffectiveFamilyKind(BasicNode node2) {
        return node2 instanceof FamilyWithId ? ((FamilyWithId)node2).getFamilyId().getFakeKind() : ObjectKind.UNKNOWN_OBJECT;
    }

    @Override
    @Nullable
    public ObjectKind getKindOrFakeKind(@Nullable String code) {
        DvFamilyId.Companion.ensureInitialised();
        return super.getKindOrFakeKind(code);
    }

    @Override
    @Nullable
    public AuthWidgetBuilder createAuthWidgetBuilder() {
        return new AuthWidgetBuilderImpl();
    }

    @Override
    @NotNull
    public Executor executor() {
        Executor executor = DatabaseCredentialsUi.EXECUTOR;
        if (executor == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(6);
        }
        return executor;
    }

    @Override
    public void askCredentials(@NlsContexts.DialogMessage String message2, boolean error2, DatabaseConnectionConfig config, Project project, DatabaseCredentials dc, boolean unsure) {
        int res2;
        if (unsure && (res2 = Messages.showOkCancelDialog((Project)project, (String)message2, (String)DatabaseBundle.message("dialog.title.connecting.to", config.getName()), (String)DatabaseBundle.message("button.change.credentials", new Object[0]), (String)DatabaseBundle.message("button.abort", new Object[0]), (Icon)Messages.getErrorIcon())) == 2) {
            throw new ProcessCanceledException();
        }
        DatabaseCredentialsAuthProviderUi.askCredentials(message2, error2, config, project, dc);
    }

    @Override
    @NotNull
    public <E> JComboBox<E> createComboBox(@NotNull ComboBoxModel<E> model2) {
        if (model2 == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(7);
        }
        return new ComboBox(model2);
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getProxyOptions(@NotNull List<String> extraNonProxyHosts) {
        HttpConfigurable configurable;
        ArrayList<Pair<String, String>> options2;
        if (extraNonProxyHosts == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(8);
        }
        if (!(options2 = new ArrayList<Pair<String, String>>((configurable = HttpConfigurable.getInstance()).getJvmProperties(false, null))).isEmpty()) {
            List hosts = StringUtil.isEmpty((String)configurable.PROXY_EXCEPTIONS) ? Collections.emptyList() : StringUtil.split((String)configurable.PROXY_EXCEPTIONS, (String)",");
            StringBuilder nonProxy = new StringBuilder();
            StringUtil.join((Iterable)hosts, String::trim, (String)"|", (StringBuilder)nonProxy);
            for (String host : extraNonProxyHosts) {
                if (hosts.contains(host)) continue;
                if (!nonProxy.isEmpty()) {
                    nonProxy.append("|");
                }
                nonProxy.append(host);
            }
            if (!nonProxy.isEmpty()) {
                String nonProxyHosts = nonProxy.toString();
                options2.add((Pair<String, String>)Pair.create((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                options2.add((Pair<String, String>)Pair.create((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
        }
        ArrayList<Pair<String, String>> arrayList = options2;
        if (arrayList == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        if (context == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(10);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performAutoSyncTask(context, stopRunning);
        if (asyncTask == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(11);
        }
        return asyncTask;
    }

    @Override
    @NotNull
    public AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(12);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(context);
        if (asyncTask == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(13);
        }
        return asyncTask;
    }

    @Override
    public boolean isNonPersistentPasswordStorage() {
        return PasswordStorageComponent.isNonPersistentStorage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseCoreUiServiceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraNonProxyHosts";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseCoreUiServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "treeChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "treeChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProxyOptions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

