/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternSubdivision;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("\\", ":", ",", "|"), Arrays.asList("\\\\", "\\:", "\\,", "\\|"));
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups2) {
            return !1.containsNotNull(groups2);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            if (value2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return !2.containsNull(value2);
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups2) {
            return 2.containsNull(groups2);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value2) {
            if (value2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                3.$$$reportNull$$$0(0);
            }
            JBIterable ji = JBIterable.from(nodes);
            return super.mergeRoots((Iterable<TreePatternNode>)ji.take(1).append((Iterable)ji.skip(1).filter(n -> n.groups.length != 0)));
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value2) {
            Iterator<TreePatternNode> it2;
            if (value2 == null) {
                3.$$$reportNull$$$0(1);
            }
            if (!(it2 = value2.iterator()).hasNext()) {
                return false;
            }
            TreePatternNode first2 = it2.next();
            if (first2 == null) {
                return false;
            }
            while (it2.hasNext()) {
                TreePatternNode n = it2.next();
                if (n == null || first2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            Iterator<TreePatternNode.Group> it2;
            if (value2 == null) {
                3.$$$reportNull$$$0(2);
            }
            return (it2 = value2.iterator()).hasNext() && it2.next() != null;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups2) {
            for (TreePatternNode group2 : groups2) {
                if (group2 == null || group2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null);

    public static String escape(String s2) {
        return StringUtil.replace((String)s2, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescape(String s2) {
        return StringUtil.replace((String)s2, ESCAPES.get(1), ESCAPES.get(0));
    }

    public static TreePattern parse(@NotNull Dbms dbms, String s2) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(0);
        }
        MultiMap<String, String> state = TreePatternUtils.parseToState(s2);
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), state);
    }

    public static TreePattern parse(boolean multiDatabase, String s2) {
        MultiMap<String, String> state = TreePatternUtils.parseToState(s2);
        return TreePatternUtils.fromScopeMap(multiDatabase, state);
    }

    @NotNull
    private static MultiMap<String, String> parseToState(String s2) {
        ArrayList<String> dbs2 = new ArrayList<String>();
        ArrayList schs = new ArrayList();
        int dbPos = s2.length();
        while (dbPos > 0) {
            int dbEnd2;
            int curDbPos = TreePatternUtils.lastIndexOf(s2, '|', dbPos - 1) + 1;
            int dbEnd = TreePatternUtils.lastIndexOf(s2, ':', dbPos - 1, curDbPos);
            int n = dbEnd2 = dbEnd == -1 ? -1 : TreePatternUtils.lastIndexOf(s2, ':', dbEnd - 1, curDbPos);
            if (dbEnd != -1 && dbEnd2 == -1) {
                dbs2.add(TreePatternUtils.unescape(s2.substring(curDbPos, dbEnd)));
                LinkedHashSet<String> ss2 = new LinkedHashSet<String>();
                schs.add(ss2);
                int schPos = dbPos;
                while (schPos > 0) {
                    int curSchPos = TreePatternUtils.lastIndexOf(s2, ',', schPos - 1, dbEnd);
                    String sch = TreePatternUtils.unescape(s2.substring(Math.max(dbEnd, curSchPos) + 1, schPos));
                    if (!sch.isEmpty()) {
                        ss2.add(sch);
                    }
                    schPos = curSchPos;
                }
            }
            dbPos = curDbPos - 1;
        }
        MultiMap state = MultiMap.create();
        for (int i2 = dbs2.size() - 1; i2 >= 0; --i2) {
            state.putValues((Object)((String)dbs2.get(i2)), (Collection)schs.get(i2));
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            TreePatternUtils.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    public static String serialize(TreePattern scope) {
        StringBuilder res2 = new StringBuilder();
        TreePatternNode.Group dbG = scope.root.getGroup(ObjectKind.DATABASE);
        if (dbG == null) {
            if (!TreePatternUtils.serializeSchemas(res2, scope.root, (JBIterable<String>)JBIterable.of((Object)"*"))) {
                return "";
            }
        } else if (dbG.children != null) {
            for (TreePatternNode child : dbG.children) {
                TreePatternUtils.serializeSchemas(res2, child, TreePatternUtils.serializeNamings(child));
            }
        }
        return res2.toString();
    }

    private static boolean serializeSchemas(StringBuilder res2, TreePatternNode child, JBIterable<@NotNull String> dbs2) {
        String scs = TreePatternUtils.serializeSchemas(child);
        for (String db : dbs2) {
            if (res2.length() != 0) {
                res2.append('|');
            }
            res2.append(TreePatternUtils.escape(db)).append(':').append(scs);
        }
        return !scs.isEmpty();
    }

    @NotNull
    private static String serializeSchemas(TreePatternNode child) {
        StringBuilder res2 = new StringBuilder();
        int start2 = res2.length();
        for (TreePatternNode.Group group2 : child.groups) {
            TreePatternUtils.serializeSchemaNames(group2, group2.kind == ObjectKind.SCHEMA ? null : group2.kind.code(), res2, start2);
        }
        String string = res2.toString();
        if (string == null) {
            TreePatternUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void serializeSchemaNames(@NotNull TreePatternNode.Group scG, @Nullable String kind, StringBuilder res2, int start2) {
        if (scG == null) {
            TreePatternUtils.$$$reportNull$$$0(3);
        }
        for (Object sch : JBIterable.of((Object[])scG.children).flatten(n -> TreePatternUtils.serializeNamings(n))) {
            if (res2.length() != start2) {
                res2.append(',');
            }
            if (kind != null) {
                sch = (String)sch + "[" + kind + "]";
            }
            res2.append(TreePatternUtils.escape((String)sch));
        }
    }

    @NotNull
    private static @NotNull JBIterable<@NotNull String> serializeNamings(TreePatternNode n) {
        if (n.naming instanceof TreePatternNode.NegativeNaming) {
            JBIterable patterns2 = SmartPredicate.extractPositiveChecks(((TreePatternNode.NegativeNaming)n.naming).pattern).collect();
            if (patterns2.isEmpty()) {
                JBIterable jBIterable = JBIterable.of((Object)"*");
                if (jBIterable == null) {
                    TreePatternUtils.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            JBIterable jBIterable = patterns2.map(p2 -> "{" + p2.getText() + "}");
            if (jBIterable == null) {
                TreePatternUtils.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])n.naming.names).map(ObjectName::name);
        if (jBIterable == null) {
            TreePatternUtils.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    public static int lastIndexOf(String s2, char c2, int from) {
        return TreePatternUtils.lastIndexOf(s2, c2, from, 0);
    }

    private static int lastIndexOf(String s2, char c2, int from, int to) {
        while (from >= to) {
            char cur = s2.charAt(from);
            --from;
            if (cur != c2) continue;
            int pos = from + 1;
            int slashes = 0;
            while (from >= to && (cur = s2.charAt(from)) == '\\') {
                ++slashes;
                --from;
            }
            if (slashes % 2 != 0) continue;
            return pos;
        }
        return -1;
    }

    @NotNull
    public static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull TreePattern scope) {
        if (namespaceOwner == null) {
            TreePatternUtils.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(8);
        }
        int m = 0;
        int n = 0;
        for (BasicNamespace basicNamespace : namespaceOwner.getNamespaces()) {
            boolean shown = DataSourceSchemaMapping.matches(scope, basicNamespace);
            if (shown) {
                ++m;
            }
            ++n;
        }
        Couple couple = Couple.of((Object)m, (Object)n);
        if (couple == null) {
            TreePatternUtils.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @Nullable
    public static TreePatternNode findNegativeChild(@Nullable TreePatternNode.Group cg) {
        return cg == null || cg.children == null ? null : (TreePatternNode)ContainerUtil.find((Object[])cg.children, c2 -> c2.naming instanceof TreePatternNode.NegativeNaming);
    }

    @Nullable
    public static TreePatternNode findPositiveChild(@Nullable TreePatternNode.Group cg) {
        return cg == null || cg.children == null ? null : (TreePatternNode)ContainerUtil.find((Object[])cg.children, c2 -> c2.naming instanceof TreePatternNode.PositiveNaming);
    }

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names2) {
        if (names2 == null) {
            TreePatternUtils.$$$reportNull$$$0(10);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names2);
        if (stringArray == null) {
            TreePatternUtils.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names2) {
        if (names2 == null) {
            TreePatternUtils.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.collect(names2.iterator());
        return TreePatternUtils.toStringArray(list);
    }

    @NotNull
    public static JBIterable<ObjectName> getAllNames(@NotNull TreePatternNode.Group g2) {
        if (g2 == null) {
            TreePatternUtils.$$$reportNull$$$0(13);
        }
        JBIterable jBIterable = JBIterable.of((Object[])g2.children).flatten(c2 -> JBIterable.of((Object[])c2.naming.names));
        if (jBIterable == null) {
            TreePatternUtils.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    public static void subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups2, @NotNull MultiMap<TreePatternNode.BaseNaming, TreePatternNode> subdiv) {
        if (groups2 == null) {
            TreePatternUtils.$$$reportNull$$$0(15);
        }
        if (subdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(16);
        }
        TreePatternSubdivision.Subdivision<Pair<Integer, TreePatternNode>> subdivision = TreePatternSubdivision.generateSubdivision(groups2);
        for (Pair<TreePatternNode.BaseNaming, IntList> datum : subdivision.data) {
            Collection nodes = subdiv.getModifiable((Object)((TreePatternNode.BaseNaming)datum.first));
            HashSet usedGroups = new HashSet();
            ((IntList)datum.second).forEach(id -> {
                if (subdivision.isCovered(id)) {
                    usedGroups.add((Integer)((Pair)subdivision.getLayer((int)id)).first);
                }
            });
            ((IntList)datum.second).forEach(id -> {
                Pair layer = (Pair)subdivision.getLayer(id);
                if (subdivision.isCovered(id)) {
                    nodes.add((TreePatternNode)layer.second);
                } else if (layer == null || usedGroups.add((Integer)layer.first)) {
                    nodes.add(null);
                }
            });
        }
    }

    @Nullable
    private static TreePatternNode.Group processGrouped(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups2, @NotNull GroupedGroupFactory fac) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(17);
        }
        if (groups2 == null) {
            TreePatternUtils.$$$reportNull$$$0(18);
        }
        if (fac == null) {
            TreePatternUtils.$$$reportNull$$$0(19);
        }
        LinkedHashSet grouped = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet(groups2) : groups2;
        MultiMap children2 = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        TreePatternUtils.subdivideChildren(grouped, (MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)children2);
        return fac.create((MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)children2, kind);
    }

    public static boolean isValid(TreePatternNode node2) {
        HashSet<ObjectKind> kinds = new HashSet<ObjectKind>();
        for (TreePatternNode.Group group2 : node2.groups) {
            if (kinds.add(group2.kind)) continue;
            return false;
        }
        return true;
    }

    public static StringBuilder print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group2, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(20);
        }
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(21);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group2.kind).append("\n");
        TreePatternUtils.printChildren(builder, group2, depth + 1);
        return builder;
    }

    public static void printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group2, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(22);
        }
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(23);
        }
        TreePatternUtils.printChildren(builder, group2, depth, false);
        TreePatternUtils.printChildren(builder, group2, depth, true);
    }

    private static void printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group2, int depth, boolean negative) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(24);
        }
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(25);
        }
        if (group2.children != null) {
            for (TreePatternNode n : group2.children) {
                if (n.naming instanceof TreePatternNode.NegativeNaming != negative) continue;
                TreePatternUtils.print(builder, n, depth);
            }
        }
    }

    public static StringBuilder print(@NotNull StringBuilder builder, @NotNull TreePatternNode node2, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(26);
        }
        if (node2 == null) {
            TreePatternUtils.$$$reportNull$$$0(27);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node2.naming).append("\n");
        return TreePatternUtils.printChildren(builder, node2, depth + 1);
    }

    public static StringBuilder printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode node2, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(28);
        }
        if (node2 == null) {
            TreePatternUtils.$$$reportNull$$$0(29);
        }
        for (TreePatternNode.Group n : node2.groups) {
            TreePatternUtils.print(builder, n, depth);
        }
        return builder;
    }

    private static TreePatternNode @Nullable [] createPositiveNodes(@NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming> mergedBranches) {
        if (mergedBranches == null) {
            TreePatternUtils.$$$reportNull$$$0(30);
        }
        if (mergedBranches.isEmpty()) {
            return null;
        }
        ArrayList<TreePatternNode> positive = new ArrayList<TreePatternNode>();
        for (Map.Entry entry : mergedBranches.entrySet()) {
            TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable)entry.getValue(), false);
            if (merged == null) continue;
            for (TreePatternNode.BaseNaming naming : merged) {
                positive.add(new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array));
            }
        }
        return (TreePatternNode[])positive.toArray(TreePatternNode[]::new);
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups2, boolean preserveOthers, @Nullable TreePatternNode.Group res2, int pos) {
        if (groups2 == null) {
            TreePatternUtils.$$$reportNull$$$0(31);
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res2 == null ? groups2 : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups2, (Object)res2);
            } else if (res2 == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res2;
            }
            return groupArray;
        }
        if (res2 == null) {
            return preserveOthers && groups2.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups2, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res2};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups2.clone();
        clone[pos] = res2;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups2, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i2, boolean preserveOthers) {
        if (groups2 == null) {
            TreePatternUtils.$$$reportNull$$$0(32);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(33);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(34);
        }
        if (i2 >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i2];
        int idx = -1;
        for (int k = 0; k < groups2.length; ++k) {
            if (groups2[k].kind != kinds[i2]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res2 = null;
            if (wildcard) {
                TreePatternNode.Group[] children2 = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i2 + 1, preserveOthers);
                res2 = children2 == null ? null : new TreePatternNode.Group(kinds[i2], new TreePatternNode[]{new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, children2)});
            }
            return TreePatternUtils.preserve(groups2, preserveOthers, res2, -1);
        }
        TreePatternNode.Group group2 = groups2[idx];
        if (!wildcard) {
            MultiMap merged = MultiMap.createLinkedSet();
            if (group2.children != null) {
                for (TreePatternNode child : group2.children) {
                    TreePatternNode.Group[] masked = TreePatternUtils.mask(child.groups, kinds, mask, i2 + 1, preserveOthers);
                    if (masked == null) continue;
                    merged.putValue(new AW<TreePatternNode.Group>(masked), (Object)child.naming);
                }
            }
            TreePatternNode[] children3 = TreePatternUtils.createPositiveNodes((MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)merged);
            TreePatternNode.Group result2 = merged.isEmpty() ? null : new TreePatternNode.Group(kinds[i2], children3);
            return TreePatternUtils.preserve(groups2, preserveOthers, result2, idx);
        }
        LinkedHashSet<TreePatternNode> res3 = new LinkedHashSet<TreePatternNode>();
        for (TreePatternNode node2 : JBIterable.of((Object[])group2.children)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node2.groups, kinds, mask, i2 + 1, preserveOthers);
            if (grouped == null) continue;
            res3.add(new TreePatternNode(node2.naming, grouped));
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.mergeRoots(res3);
        TreePatternNode.Group result3 = merged == null ? null : new TreePatternNode.Group(kinds[i2], new TreePatternNode[]{new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, merged)});
        return TreePatternUtils.preserve(groups2, preserveOthers, result3, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(35);
        }
        return TreePatternUtils.union(Arrays.asList(patterns2));
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(36);
        }
        TreePattern treePattern = UNION_PROCESSOR.merge(patterns2);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(37);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(38);
        }
        TreePattern treePattern = INTERSECTION_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns2));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(39);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(40);
        }
        TreePattern treePattern = MINUS_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns2));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(41);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern diff(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(42);
        }
        return TreePatternUtils.minus(TreePatternUtils.union(patterns2), TreePatternUtils.intersect(patterns2));
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern2, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern2 == null) {
            TreePatternUtils.$$$reportNull$$$0(43);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(44);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(45);
        }
        return new TreePattern(TreePatternUtils.mask(pattern2.root.groups, kinds, mask, 0, preserveOthers));
    }

    @NotNull
    public static TreePatternNode.Group create(@NotNull DasObject obj2, TreePatternNode.Group ... children2) {
        if (obj2 == null) {
            TreePatternUtils.$$$reportNull$$$0(46);
        }
        return TreePatternUtils.create(ObjectName.create(obj2.getName(), DbSqlUtilCore.isQuoted(obj2)), obj2.getKind(), children2);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name2, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(47);
        }
        return TreePatternUtils.create(name2 == null ? null : Collections.singletonList(name2), kind, children2);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names2, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(48);
        }
        return TreePatternUtils.create(ObjectName.toArray(names2), kind, children2);
    }

    @NotNull
    public static TreePatternNode.Group create(ObjectName @Nullable [] names2, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(49);
        }
        if (children2 == null) {
            children2 = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children2) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children2.length) {
            if (nonNulls == 0) {
                children2 = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children22 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children2) {
                    if (child == null) continue;
                    children22[nonNulls++] = child;
                }
                children2 = children22;
            }
        }
        TreePatternNode.BaseNaming naming = names2 == null ? TreePatternNode.NegativeNaming.WILDCARD : new TreePatternNode.PositiveNaming(names2);
        return new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode(naming, children2)});
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor2) {
        TreePatternNode.Group[] newRoot;
        if (processed == null) {
            TreePatternUtils.$$$reportNull$$$0(50);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(51);
        }
        if (processor2 == null) {
            TreePatternUtils.$$$reportNull$$$0(52);
        }
        return (newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode node2, @Nullable TreePatternNode checker, @Nullable TreePatternNode.BaseNaming parent2, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return node2 == null ? null : node2.groups;
                }
                NodeBuilder b2 = null;
                LinkedHashMap<ObjectKind, TreePatternNode.Group> newGroups = new LinkedHashMap<ObjectKind, TreePatternNode.Group>();
                for (TreePatternNode.Group group2 : checker.groups) {
                    newGroups.put(group2.kind, group2);
                }
                if (node2 != null) {
                    for (int i2 = 0; i2 < node2.groups.length; ++i2) {
                        TreePatternNode.Group group3 = node2.groups[i2];
                        newGroups.remove(group3.kind);
                        TreePatternNode.Group checkerGroup = checker.getGroup(group3.kind);
                        processed = group3;
                        if (checkerGroup != null) {
                            processed = this.visit(group3, checkerGroup, parent2, parentKind);
                        }
                        if (processed != group3 && b2 == null) {
                            b2 = new NodeBuilder();
                            for (int k = 0; k < i2; ++k) {
                                b2.addGroup(node2.groups[k]);
                            }
                        }
                        if (b2 == null || processed == null) continue;
                        b2.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group4;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group4.kind, null);
                    group4 = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group4, parent2, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b2 == null) {
                        b2 = NodeBuilder.from(node2);
                    }
                    b2.addGroup(processed);
                }
                return b2 == null ? (node2 == null ? null : node2.groups) : b2.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group2, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent2, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group procRes;
                if (group2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (checker == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((procRes = processor2.process(group2, parent2, parentKind)) == SKIP_PROCESSING) {
                    return group2;
                }
                if (procRes == null) {
                    return null;
                }
                group2 = procRes;
                MultiMap gluedChildren = MultiMap.createLinked();
                MultiMap p2 = MultiMap.createLinked();
                TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group2, checker}), (MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)p2);
                for (Map.Entry entry : p2.entrySet()) {
                    Iterator it2 = ((Collection)entry.getValue()).iterator();
                    TreePatternNode p1 = (TreePatternNode)it2.next();
                    TreePatternNode p22 = (TreePatternNode)it2.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p22, (TreePatternNode.BaseNaming)entry.getKey(), group2.kind);
                    gluedChildren.putValue(new AW<TreePatternNode.Group>(processed), (Object)((TreePatternNode.BaseNaming)entry.getKey()));
                }
                return 4.createNewIfChanged(group2, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)gluedChildren);
            }

            private static TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group2, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming> children2) {
                if (group2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (children2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                HashMap<TreePatternNode.BaseNaming, TreePatternNode> pool = new HashMap<TreePatternNode.BaseNaming, TreePatternNode>();
                if (group2.children != null) {
                    for (TreePatternNode child : group2.children) {
                        pool.put(child.naming, child);
                    }
                }
                boolean changed = pool.size() != children2.size();
                GroupBuilder builder = new GroupBuilder();
                for (Map.Entry entry : children2.entrySet()) {
                    TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable)entry.getValue(), false);
                    if (merged == null) continue;
                    for (TreePatternNode.BaseNaming naming : merged) {
                        TreePatternNode node2 = (TreePatternNode)pool.get(naming);
                        if (node2 == null || node2.groups != ((AW)entry.getKey()).array) {
                            changed = true;
                            node2 = ((AW)entry.getKey()).array == null ? null : new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        }
                        ContainerUtil.addIfNotNull(builder.children, (Object)node2);
                    }
                }
                return changed ? builder.build(group2.kind) : group2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "checker";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createNewIfChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(processed.root, mask.root, null, null)) == processed.root.groups ? processed : new TreePattern(newRoot);
    }

    public static boolean isWildcard(@Nullable TreePatternNode.Group g2) {
        return g2 != null && g2.children != null && g2.children.length == 1 && TreePatternUtils.isWildcard(g2.children[0]);
    }

    public static boolean isWildcard(@Nullable TreePatternNode n) {
        return n != null && n.naming instanceof TreePatternNode.NegativeNaming && n.naming.names.length == 0 && n.groups.length == 0;
    }

    @NotNull
    public static TreePattern sorted(@NotNull TreePattern pattern2) {
        TreePatternNode sortedRoot;
        if (pattern2 == null) {
            TreePatternUtils.$$$reportNull$$$0(53);
        }
        return (sortedRoot = TreePatternUtils.sorted(pattern2.root)) == pattern2.root ? pattern2 : new TreePattern(sortedRoot);
    }

    @NotNull
    private static TreePatternNode sorted(@NotNull TreePatternNode node2) {
        if (node2 == null) {
            TreePatternUtils.$$$reportNull$$$0(54);
        }
        TreePatternNode.Group[] newGroups = TreePatternUtils.sorted(node2.groups, TreePatternNode.Group.BY_KIND);
        TreePatternNode.BaseNaming naming = TreePatternUtils.sorted(node2.naming);
        return newGroups == node2.groups && naming == node2.naming ? node2 : new TreePatternNode(naming, newGroups);
    }

    @NotNull
    private static <T> T[] sorted(T[] items2, Comparator<? super T> comp) {
        Object[] newItems = null;
        boolean unsorted = false;
        for (int i2 = 0; i2 < items2.length; ++i2) {
            Object newItem;
            Object object = newItem = items2[i2] instanceof TreePatternNode.Group ? TreePatternUtils.sorted((TreePatternNode.Group)items2[i2]) : TreePatternUtils.sorted((TreePatternNode)items2[i2]);
            if (!unsorted && i2 != 0) {
                boolean bl = unsorted = comp.compare(items2[i2 - 1], items2[i2]) > 0;
            }
            if (newItems == null) {
                if (newItem == items2[i2] && !unsorted) continue;
                newItems = (Object[])Array.newInstance(items2[i2].getClass(), items2.length);
                System.arraycopy(items2, 0, newItems, 0, i2);
            }
            newItems[i2] = newItem;
        }
        if (unsorted) {
            Arrays.sort(newItems, comp);
        }
        Object[] objectArray = newItems == null ? items2 : newItems;
        if (objectArray == null) {
            TreePatternUtils.$$$reportNull$$$0(55);
        }
        return objectArray;
    }

    private static TreePatternNode.BaseNaming @Nullable [] merge(@NotNull Iterable<? extends TreePatternNode.BaseNaming> namings, boolean sort) {
        TreePatternNode.BaseNaming[] baseNamingArray;
        TreePatternNode.PositiveNaming pn;
        Iterator<? extends TreePatternNode.BaseNaming> it2;
        if (namings == null) {
            TreePatternUtils.$$$reportNull$$$0(56);
        }
        if (!(it2 = namings.iterator()).hasNext()) {
            return null;
        }
        TreePatternNode.BaseNaming naming = it2.next();
        if (!it2.hasNext()) {
            return new TreePatternNode.BaseNaming[]{naming};
        }
        LinkedHashSet<ObjectName> positive = new LinkedHashSet<ObjectName>();
        LinkedHashSet<ObjectName> negative = new LinkedHashSet<ObjectName>();
        boolean hasNegative = false;
        SmartPredicate<TreePatternNode.PatternWrapper> pattern2 = SmartPredicate.none();
        while (naming != null) {
            LinkedHashSet<ObjectName> target2;
            boolean n = naming instanceof TreePatternNode.NegativeNaming;
            if (n) {
                pattern2 = pattern2.union(((TreePatternNode.NegativeNaming)naming).pattern);
                hasNegative = true;
                target2 = negative;
            } else {
                target2 = positive;
            }
            ContainerUtil.addAll(target2, (Object[])naming.names);
            naming = it2.hasNext() ? it2.next() : null;
        }
        if (hasNegative) {
            negative.removeAll(positive);
            TreePatternUtils.removeByPattern(positive, pattern2);
        }
        TreePatternNode.PositiveNaming positiveNaming = pn = positive.isEmpty() ? null : new TreePatternNode.PositiveNaming(TreePatternUtils.prepare(positive, sort));
        if (hasNegative) {
            TreePatternNode.NegativeNaming nn = new TreePatternNode.NegativeNaming(pattern2, TreePatternUtils.prepare(negative, sort));
            if (pn == null) {
                return new TreePatternNode.BaseNaming[]{nn};
            }
            return new TreePatternNode.BaseNaming[]{pn, nn};
        }
        if (pn == null) {
            baseNamingArray = null;
        } else {
            TreePatternNode.BaseNaming[] baseNamingArray2 = new TreePatternNode.BaseNaming[1];
            baseNamingArray = baseNamingArray2;
            baseNamingArray2[0] = pn;
        }
        return baseNamingArray;
    }

    private static ObjectName[] prepare(Set<ObjectName> names2, boolean sort) {
        Object[] res2 = ObjectName.toArray(names2);
        if (sort) {
            Arrays.sort(res2);
        }
        return res2;
    }

    private static void removeByPattern(Set<ObjectName> positive, SmartPredicate<TreePatternNode.PatternWrapper> pattern2) {
        positive.removeIf(n -> TreePatternNode.PatternWrapper.evaluate(pattern2, n));
    }

    @NotNull
    private static TreePatternNode.Group sorted(@NotNull TreePatternNode.Group g2) {
        if (g2 == null) {
            TreePatternUtils.$$$reportNull$$$0(57);
        }
        TreePatternNode[] nodes = g2.children == null ? null : TreePatternUtils.sorted(g2.children, TreePatternNode.BY_FIRST);
        nodes = TreePatternUtils.tighten(nodes);
        return nodes == g2.children ? g2 : new TreePatternNode.Group(g2.kind, nodes);
    }

    private static TreePatternNode[] tighten(TreePatternNode @Nullable [] c2) {
        if (c2 == null) {
            return null;
        }
        MultiMap grouping = MultiMap.createLinked();
        for (TreePatternNode node3 : c2) {
            grouping.putValue(new AW<TreePatternNode.Group>(node3.groups), (Object)node3);
        }
        if (c2.length == grouping.size()) {
            return c2;
        }
        if (grouping.isEmpty()) {
            return null;
        }
        ArrayList<TreePatternNode> children2 = new ArrayList<TreePatternNode>(grouping.size());
        for (Map.Entry entry : grouping.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                children2.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                continue;
            }
            TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable<? extends TreePatternNode.BaseNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).transform(node2 -> node2.naming), true);
            if (merged == null) continue;
            for (TreePatternNode.BaseNaming naming : merged) {
                children2.add(new TreePatternNode(naming, Objects.requireNonNull((TreePatternNode.Group[])((AW)entry.getKey()).array)));
            }
        }
        return children2.toArray(new TreePatternNode[0]);
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> N sorted(@NotNull N naming) {
        if (naming == null) {
            TreePatternUtils.$$$reportNull$$$0(58);
        }
        boolean unsorted = false;
        ObjectName[] names2 = naming.names;
        int s2 = names2.length;
        for (int i2 = 1; i2 < s2 && !unsorted; ++i2) {
            unsorted = names2[i2 - 1].compareTo(names2[i2]) > 0;
        }
        if (!unsorted) {
            N n = naming;
            if (n == null) {
                TreePatternUtils.$$$reportNull$$$0(59);
            }
            return n;
        }
        Object[] newNames = (ObjectName[])names2.clone();
        Arrays.sort(newNames);
        return (N)(naming instanceof TreePatternNode.NegativeNaming ? new TreePatternNode.NegativeNaming(((TreePatternNode.NegativeNaming)naming).pattern, (ObjectName[])newNames) : new TreePatternNode.PositiveNaming((ObjectName[])newNames));
    }

    @NotNull
    public static String exportScope(@NotNull MetaModel meta, @NotNull TreePattern pattern2) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(60);
        }
        if (pattern2 == null) {
            TreePatternUtils.$$$reportNull$$$0(61);
        }
        String string = IntrospectionScopes.exportState(meta, pattern2);
        if (string == null) {
            TreePatternUtils.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static TreePattern fromScopeMap(@NotNull BasicMetaModel<?> meta, @NotNull MultiMap<String, String> scope) {
        BasicMetaObject metaDb;
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(63);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(64);
        }
        TreePatternNode.Group[] g2 = (metaDb = BasicMetaUtils.findChild(meta.root, ObjectKind.DATABASE)) != null ? TreePatternUtils.scopeGroup(scope.keySet(), ObjectKind.DATABASE, (Function<String, TreePatternNode.Group[]>)((Function)db -> TreePatternUtils.scopeGroup(scope.get(db), ObjectKind.SCHEMA, null))) : TreePatternUtils.scopeGroup(scope.values(), ObjectKind.SCHEMA, null);
        return new TreePattern(g2);
    }

    @NotNull
    public static TreePattern fromScopeMap(boolean multiDatabase, @NotNull MultiMap<String, String> scope) {
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(65);
        }
        TreePatternNode.Group[] g2 = multiDatabase ? TreePatternUtils.scopeGroup(scope.keySet(), ObjectKind.DATABASE, (Function<String, TreePatternNode.Group[]>)((Function)db -> TreePatternUtils.scopeGroup(scope.get(db), ObjectKind.SCHEMA, null))) : TreePatternUtils.scopeGroup(scope.values(), ObjectKind.SCHEMA, null);
        return new TreePattern(g2);
    }

    private static TreePatternNode.Group[] scopeGroup(Collection<String> names2, ObjectKind defKind, Function<String, TreePatternNode.Group[]> child) {
        Map groups2 = FactoryMap.createMap(k -> new GroupBuilder(), TreeMap::new);
        for (String name2 : ContainerUtil.sorted(names2)) {
            Pair<ObjectKind, String> kindAndName = TreePatternUtils.extractKindAndName(name2, defKind);
            TreePatternNode.Group[] schemas2 = child == null ? null : (TreePatternNode.Group[])child.fun((Object)((String)kindAndName.second));
            ((GroupBuilder)groups2.get((Object)kindAndName.first)).children.add(new TreePatternNode(TreePatternUtils.createNaming((String)kindAndName.second), schemas2 == null ? TreePatternNode.NO_GROUPS : schemas2));
        }
        ArrayList<TreePatternNode.Group> res2 = new ArrayList<TreePatternNode.Group>(groups2.size());
        for (Map.Entry entry : groups2.entrySet()) {
            ((GroupBuilder)entry.getValue()).deduplicate();
            res2.add(((GroupBuilder)entry.getValue()).build((ObjectKind)entry.getKey()));
        }
        return res2.toArray(TreePatternNode.NO_GROUPS);
    }

    @NotNull
    private static Pair<ObjectKind, String> extractKindAndName(String name2, ObjectKind defKind) {
        String code;
        int kS = name2.endsWith("]") ? name2.lastIndexOf(91) : -1;
        ObjectKind kind = null;
        if (kS != -1 && (kind = ObjectKind.getKind(code = name2.substring(kS + 1, name2.length() - 1))) != null) {
            name2 = name2.substring(0, kS);
        }
        if (kind == null) {
            kind = defKind;
        }
        Pair pair = Pair.create((Object)kind, (Object)name2);
        if (pair == null) {
            TreePatternUtils.$$$reportNull$$$0(66);
        }
        return pair;
    }

    @NotNull
    private static TreePatternNode.BaseNaming createNaming(String name2) {
        TreePatternNode.BaseNaming naming;
        if (name2.equals("*")) {
            naming = TreePatternNode.NegativeNaming.WILDCARD;
        } else if (name2.startsWith("{") && name2.endsWith("}")) {
            String text2 = name2.substring(1, name2.length() - 1);
            TreePatternNode.PatternWrapper pattern2 = TreePatternNode.PatternWrapper.create(text2);
            naming = new TreePatternNode.NegativeNaming(SmartPredicate.create(pattern2), new ObjectName[0]);
        } else {
            naming = new TreePatternNode.PositiveNaming(ObjectName.quoted(name2));
        }
        TreePatternNode.NegativeNaming negativeNaming = naming;
        if (negativeNaming == null) {
            TreePatternUtils.$$$reportNull$$$0(67);
        }
        return negativeNaming;
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode node2, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(68);
        }
        if (node2 == null) {
            TreePatternUtils.$$$reportNull$$$0(69);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(71);
        }
        for (TreePatternNode.Group group2 : node2.groups) {
            TreePatternUtils.breakDown(meta, group2, database, scope);
        }
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode.Group group2, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(72);
        }
        if (group2 == null) {
            TreePatternUtils.$$$reportNull$$$0(73);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(74);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(75);
        }
        if (!meta.getNamespaces().contains(group2.kind)) {
            return;
        }
        if (group2.children != null) {
            for (TreePatternNode child : group2.children) {
                if (child.naming instanceof TreePatternNode.NegativeNaming) {
                    TreePatternUtils.addToScope("*", group2.kind, child, meta, database, scope);
                    continue;
                }
                for (ObjectName name2 : child.naming.names) {
                    TreePatternUtils.addToScope(name2.name, group2.kind, child, meta, database, scope);
                }
            }
        }
    }

    private static void addToScope(@NotNull String name2, @NotNull ObjectKind kind, @NotNull TreePatternNode node2, @NotNull MetaModel meta, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (name2 == null) {
            TreePatternUtils.$$$reportNull$$$0(76);
        }
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(77);
        }
        if (node2 == null) {
            TreePatternUtils.$$$reportNull$$$0(78);
        }
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(79);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(80);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(81);
        }
        if (kind == ObjectKind.DATABASE) {
            scope.getModifiable((Object)name2);
            TreePatternUtils.breakDown(meta, node2, name2, scope);
        } else {
            scope.putValue((Object)database, (Object)name2);
            TreePatternUtils.breakDown(meta, node2, database, scope);
        }
    }

    public static ObjectName nameOf(@Nullable DasObject o2, boolean nullize) {
        return o2 == null ? null : ObjectName.create(nullize ? StringUtil.nullize((String)o2.getName()) : o2.getName(), DbSqlUtilCore.isQuoted(o2));
    }

    public static ObjectName nameOf(@Nullable DasObject o2) {
        return TreePatternUtils.nameOf(o2, false);
    }

    public static ObjectName nameOf(@Nullable ObjectPath p2) {
        return p2 == null ? null : ObjectName.create(p2.name, p2.isQuoted());
    }

    @NotNull
    public static TreePattern create(@NotNull ObjectPath path) {
        if (path == null) {
            TreePatternUtils.$$$reportNull$$$0(82);
        }
        return new TreePattern(TreePatternUtils.createGroup(path));
    }

    @Nullable
    private static TreePatternNode.Group createGroup(@NotNull ObjectPath path) {
        if (path == null) {
            TreePatternUtils.$$$reportNull$$$0(83);
        }
        TreePatternNode.Group g2 = null;
        ObjectPath p2 = path;
        while (p2 != null) {
            g2 = TreePatternUtils.create(TreePatternUtils.nameOf(p2), p2.kind, g2);
            p2 = p2.parent;
        }
        return g2;
    }

    @NotNull
    @Contract(pure=true)
    public static TreePattern importPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(84);
        }
        MultiMap map2 = MultiMap.createLinkedSet();
        if (string != null) {
            IntrospectionScopes.importStateToMap(string, (MultiMap<String, String>)map2);
        }
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map2);
    }

    @NotNull
    @Contract(pure=true)
    public static TreePattern patternFromPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(85);
        }
        MultiMap map2 = MultiMap.createLinkedSet();
        IntrospectionScopes.fromSchemaPatternToMap(string, (MultiMap<String, String>)map2);
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 9, 11, 14, 37, 39, 41, 55, 59, 62, 66, 67 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 37: 
            case 39: 
            case 41: 
            case 55: 
            case 59: 
            case 62: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scG";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceOwner";
                break;
            }
            case 8: 
            case 64: 
            case 65: 
            case 71: 
            case 75: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 15: 
            case 18: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdiv";
                break;
            }
            case 17: 
            case 47: 
            case 48: 
            case 49: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 27: 
            case 29: 
            case 54: 
            case 69: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedBranches";
                break;
            }
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 34: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 43: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namings";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
            case 60: 
            case 63: 
            case 68: 
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 70: 
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeSchemas";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNamings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "countNamespaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 55: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "exportScope";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "extractKindAndName";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createNaming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 37: 
            case 39: 
            case 41: 
            case 55: 
            case 59: 
            case 62: 
            case 66: 
            case 67: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serializeSchemaNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countNamespaces";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subdivideChildren";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processGrouped";
                break;
            }
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "printChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveNodes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "preserve";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "patternProcessor";
                break;
            }
            case 53: 
            case 54: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "exportScope";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "fromScopeMap";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "breakDown";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addToScope";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "importPattern";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "patternFromPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 9, 11, 14, 37, 39, 41, 55, 59, 62, 66, 67 -> new IllegalStateException(string);
        };
    }

    public static abstract class GroupedGroupFactory {
        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.BaseNaming, TreePatternNode> c2, ObjectKind kind) {
            if (c2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(0);
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : c2.entrySet()) {
                TreePatternNode.Group[] merged = this.mergeNodes((TreePatternNode.BaseNaming)entry.getKey(), kind, (Iterable)entry.getValue());
                if (merged == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), (Object)((TreePatternNode.BaseNaming)entry.getKey()));
            }
            if (mergedBranches.isEmpty()) {
                return null;
            }
            TreePatternNode[] children2 = TreePatternUtils.createPositiveNodes((MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)mergedBranches);
            return new TreePatternNode.Group(kind, children2);
        }

        @Nullable
        public TreePatternNode.Group[] mergeNodes(@Nullable TreePatternNode.BaseNaming naming, @Nullable ObjectKind kind, @NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                GroupedGroupFactory.$$$reportNull$$$0(1);
            }
            this.enter(naming, kind, nodes);
            if (!this.checkNode(naming, kind, nodes)) {
                this.leave(naming, kind, nodes);
                return null;
            }
            MultiMap grouped = this.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            LinkedHashSet<ObjectKind> allKinds = new LinkedHashSet<ObjectKind>();
            for (TreePatternNode treePatternNode : nodes) {
                if (treePatternNode == null) continue;
                for (TreePatternNode.Group group2 : treePatternNode.groups) {
                    allKinds.add(group2.kind);
                }
            }
            for (TreePatternNode treePatternNode : nodes) {
                HashSet<ObjectKind> currentKinds = null;
                if (treePatternNode != null) {
                    currentKinds = new HashSet<ObjectKind>();
                    for (TreePatternNode.Group group3 : treePatternNode.groups) {
                        grouped.putValue((Object)group3.kind, (Object)group3);
                        currentKinds.add(group3.kind);
                    }
                }
                for (ObjectKind gkind : allKinds) {
                    if (currentKinds != null && currentKinds.contains(gkind)) continue;
                    grouped.putValue((Object)gkind, null);
                }
            }
            SmartList res2 = new SmartList();
            for (Map.Entry entry : grouped.entrySet()) {
                this.enterGroups(naming, kind, (Iterable)entry.getValue());
                if (this.checkGroup(naming, kind, (Iterable)entry.getValue())) {
                    ContainerUtil.addAllNotNull((Collection)res2, (Object[])new TreePatternNode.Group[]{TreePatternUtils.processGrouped((ObjectKind)entry.getKey(), (Iterable)entry.getValue(), this)});
                }
                this.leaveGroups(naming, kind, (Iterable)entry.getValue());
            }
            TreePatternNode.Group[] groupArray = !res2.isEmpty() ? res2.toArray(new TreePatternNode.Group[0]) : (this.willDestroyEmpty(naming, kind, nodes) ? null : TreePatternNode.NO_GROUPS);
            this.leave(naming, kind, nodes);
            return groupArray;
        }

        @NotNull
        public TreePattern merge(@NotNull Iterable<TreePattern> patterns2) {
            TreePatternNode.Group[] groups2;
            if (patterns2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(2);
            }
            return (groups2 = this.mergeRoots((Iterable<TreePatternNode>)JBIterable.from(patterns2).transform(p2 -> p2.root))) == null ? TreePattern.EMPTY : new TreePattern(groups2);
        }

        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                GroupedGroupFactory.$$$reportNull$$$0(3);
            }
            return this.mergeNodes(TreePatternNode.NegativeNaming.WILDCARD, ObjectKind.NONE, nodes);
        }

        @Nullable
        public TreePatternNode.Group mergeGroups(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups2) {
            if (kind == null) {
                GroupedGroupFactory.$$$reportNull$$$0(4);
            }
            if (groups2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(5);
            }
            return TreePatternUtils.processGrouped(kind, groups2, this);
        }

        protected abstract boolean checkGroup(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode.Group> var3);

        protected abstract boolean checkNode(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode> var3);

        protected abstract boolean willDestroyEmpty(TreePatternNode.BaseNaming var1, ObjectKind var2, Iterable<TreePatternNode> var3);

        protected void enter(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> nodes) {
        }

        protected void leave(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> nodes) {
        }

        protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups2) {
        }

        protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups2) {
        }

        public boolean mergeChildren() {
            return true;
        }

        protected static boolean containsNull(Iterable<?> it2) {
            if (it2 instanceof Collection) {
                return ((Collection)it2).contains(null);
            }
            for (Object o2 : it2) {
                if (o2 != null) continue;
                return true;
            }
            return false;
        }

        protected static boolean containsNotNull(Iterable<?> it2) {
            for (Object o2 : it2) {
                if (o2 == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupedGroupFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            AW aw = (AW)o2;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static final class GroupBuilder {
        public final List<TreePatternNode> children = new SmartList();

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(0);
            }
            return this.build(kind, true);
        }

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind, boolean validate2) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(1);
            }
            TreePatternNode[] p2 = this.children.isEmpty() ? null : this.children.toArray(new TreePatternNode[0]);
            return p2 == null ? null : new TreePatternNode.Group(kind, p2, validate2);
        }

        public void add(@NotNull TreePatternNode node2) {
            if (node2 == null) {
                GroupBuilder.$$$reportNull$$$0(2);
            }
            this.children.add(node2);
        }

        public void deduplicate() {
            if (this.children.size() < 2) {
                return;
            }
            MultiMap map2 = MultiMap.createLinked();
            for (TreePatternNode c2 : this.children) {
                map2.putValue(new AW<TreePatternNode.Group>(c2.groups), (Object)c2);
            }
            if (map2.size() == this.children.size()) {
                return;
            }
            ArrayList<TreePatternNode> newPos = new ArrayList<TreePatternNode>();
            for (Map.Entry entry : map2.entrySet()) {
                if (((Collection)entry.getValue()).size() == 1) {
                    newPos.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                    continue;
                }
                TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable<? extends TreePatternNode.BaseNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).map(x -> x.naming), false);
                if (merged == null) continue;
                for (TreePatternNode.BaseNaming naming : merged) {
                    newPos.add(new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array));
                }
            }
            this.children.clear();
            this.children.addAll(newPos);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g2) {
            GroupBuilder builder = new GroupBuilder();
            if (g2 != null && g2.children != null) {
                ContainerUtil.addAll(builder.children, (Object[])g2.children);
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                GroupBuilder.$$$reportNull$$$0(3);
            }
            return groupBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class NodeBuilder {
        public final List<TreePatternNode.Group> groups = new SmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g2) {
            if (g2 != null) {
                this.groups.add(g2);
            }
            return this;
        }

        @NotNull
        public TreePatternNode build(TreePatternNode.BaseNaming naming) {
            return new TreePatternNode(naming, this.buildGroups());
        }

        public TreePatternNode.Group @Nullable [] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[0]);
        }

        public TreePatternNode.Group @NotNull [] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                NodeBuilder.$$$reportNull$$$0(0);
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode node2) {
            return NodeBuilder.from(node2 == null ? null : node2.groups);
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups2) {
            NodeBuilder b2 = new NodeBuilder();
            if (groups2 != null) {
                ContainerUtil.addAll(b2.groups, (Object[])groups2);
            }
            NodeBuilder nodeBuilder = b2;
            if (nodeBuilder == null) {
                NodeBuilder.$$$reportNull$$$0(1);
            }
            return nodeBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/util/TreePatternUtils$NodeBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildGroups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

