/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SmartPredicate<T> {
    private static final boolean ourValidate = true;
    private static final Comparator<Object> MY_COMP = (c1, c2) -> {
        if (c1 instanceof Comparable && c2 instanceof Comparable) {
            return ((Comparable)c1).compareTo(c2);
        }
        return 0;
    };

    public abstract boolean evaluate(@NotNull Predicate<T> var1);

    public abstract boolean isAll();

    public abstract boolean isNone();

    @NotNull
    public SmartPredicate<T> intersect(SmartPredicate<T> o2) {
        return SmartPredicate.intersect(this, o2);
    }

    @NotNull
    public SmartPredicate<T> union(SmartPredicate<T> o2) {
        return SmartPredicate.union(this, o2);
    }

    @NotNull
    public SmartPredicate<T> minus(SmartPredicate<T> o2) {
        return SmartPredicate.minus(this, o2);
    }

    @NotNull
    public SmartPredicate<T> negate() {
        return SmartPredicate.negate(this);
    }

    @NotNull
    public static <T> SmartPredicate<T> create(@NotNull T predicate) {
        if (predicate == null) {
            SmartPredicate.$$$reportNull$$$0(0);
        }
        return SmartPredicate.create(predicate, false);
    }

    @NotNull
    public static <T> SmartPredicate<T> all() {
        SmartPredicateAnd smartPredicateAnd = SmartPredicateAnd.all();
        if (smartPredicateAnd == null) {
            SmartPredicate.$$$reportNull$$$0(1);
        }
        return smartPredicateAnd;
    }

    @NotNull
    public static <T> SmartPredicate<T> none() {
        SmartPredicateOr smartPredicateOr = SmartPredicateOr.none();
        if (smartPredicateOr == null) {
            SmartPredicate.$$$reportNull$$$0(2);
        }
        return smartPredicateOr;
    }

    @NotNull
    public static <T> Iterable<? extends SmartPredicate<T>> orTerms(@Nullable SmartPredicate<T> p2, boolean strict) {
        JBIterable jBIterable = p2 instanceof SmartPredicateOr ? ((SmartPredicateOr)p2).terms : (strict ? JBIterable.empty() : JBIterable.of(p2));
        if (jBIterable == null) {
            SmartPredicate.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static <T> Iterable<? extends T> andTerms(@Nullable SmartPredicate<T> p2) {
        Object object = p2 instanceof SmartPredicateAnd ? ((SmartPredicateAnd)p2).checks : JBIterable.empty();
        if (object == null) {
            SmartPredicate.$$$reportNull$$$0(4);
        }
        return object;
    }

    public static <T> boolean isNegative(@NotNull SmartPredicate<T> p2, @NotNull T check) {
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(5);
        }
        if (check == null) {
            SmartPredicate.$$$reportNull$$$0(6);
        }
        return p2 instanceof SmartPredicateAnd && ((SmartPredicateAnd)p2).isNegative(check);
    }

    @NotNull
    public static <T> JBIterable<T> extractPositiveChecks(@Nullable SmartPredicate<T> predicate) {
        JBIterable jBIterable = JBIterable.from(SmartPredicate.orTerms(predicate, false)).filterMap(SmartPredicate::extractSinglePositiveCheck);
        if (jBIterable == null) {
            SmartPredicate.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static <T> T extractSinglePositiveCheck(@Nullable SmartPredicate<T> predicate) {
        if (!(predicate instanceof SmartPredicateAnd)) {
            return null;
        }
        List checks2 = ((SmartPredicateAnd)predicate).checks;
        T res2 = null;
        for (Object check : checks2) {
            if (((SmartPredicateAnd)predicate).isNegative(check)) continue;
            if (res2 != null) {
                return null;
            }
            res2 = check;
        }
        return res2;
    }

    private static <T> void insertNegationTerms(@NotNull List<SmartPredicateAnd<T>> terms, @NotNull Consumer<SmartPredicateAnd<T>> res2) {
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(8);
        }
        if (res2 == null) {
            SmartPredicate.$$$reportNull$$$0(9);
        }
        SmartPredicate.insertNegationTerms(terms, 0, new LinkedHashSet(), new HashSet(), res2);
    }

    private static <T> void insertNegationTerms(@NotNull List<SmartPredicateAnd<T>> terms, int termIdx, @NotNull Set<T> checks2, @NotNull Set<T> negative, @NotNull Consumer<SmartPredicateAnd<T>> res2) {
        int length;
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(10);
        }
        if (checks2 == null) {
            SmartPredicate.$$$reportNull$$$0(11);
        }
        if (negative == null) {
            SmartPredicate.$$$reportNull$$$0(12);
        }
        if (res2 == null) {
            SmartPredicate.$$$reportNull$$$0(13);
        }
        if (termIdx >= (length = terms.size())) {
            res2.accept(SmartPredicate.createAnd(new ArrayList<T>(checks2), negative, true));
            return;
        }
        SmartPredicateAnd term = terms.get(termIdx);
        for (Object check : term.checks) {
            boolean expectedNeg;
            boolean already = !checks2.add(check);
            boolean bl = expectedNeg = !term.isNegative(check);
            if (already) {
                if (negative.contains(check) != expectedNeg) {
                    continue;
                }
            } else if (expectedNeg) {
                negative.add(check);
            }
            SmartPredicate.insertNegationTerms(terms, termIdx + 1, checks2, negative, res2);
            if (already) continue;
            checks2.remove(check);
            negative.remove(check);
        }
    }

    private static <T> SmartPredicate<T> createOr(@NotNull List<SmartPredicateAnd<T>> terms) {
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(14);
        }
        if (terms.isEmpty()) {
            return SmartPredicate.none();
        }
        if (terms.size() == 1) {
            return terms.get(0);
        }
        return new SmartPredicateOr<T>(terms);
    }

    private static <T> boolean insert(@NotNull List<SmartPredicateAnd<T>> terms, @NotNull SmartPredicateAnd<T> newOne) {
        int pos;
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(15);
        }
        if (newOne == null) {
            SmartPredicate.$$$reportNull$$$0(16);
        }
        for (SmartPredicateAnd<T> term : terms) {
            if ((newOne = SmartPredicate.fixBySingleValue(newOne, term)) != null) continue;
            return false;
        }
        int idx = Collections.binarySearch(terms, newOne);
        if (idx >= 0) {
            return false;
        }
        boolean modified = SmartPredicate.fixTermsBySingleValue(terms, newOne);
        Iterator<SmartPredicateAnd<T>> it2 = terms.iterator();
        while (it2.hasNext()) {
            SmartPredicateAnd<T> cur = it2.next();
            SmartPredicateAnd<T> merged = SmartPredicate.submerge(newOne, cur);
            if (merged == null) continue;
            if (merged == cur) {
                return modified;
            }
            if (merged.isAll()) {
                terms.clear();
                terms.add(merged);
                return true;
            }
            it2.remove();
            modified = true;
            if (merged == newOne) continue;
            SmartPredicate.insert(terms, merged);
            return true;
        }
        int n = pos = !modified ? idx : Collections.binarySearch(terms, newOne);
        if (pos < 0) {
            terms.add(-pos - 1, newOne);
        }
        return true;
    }

    private static <T> boolean fixTermsBySingleValue(@NotNull List<SmartPredicateAnd<T>> terms, @NotNull SmartPredicateAnd<T> newOne) {
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(17);
        }
        if (newOne == null) {
            SmartPredicate.$$$reportNull$$$0(18);
        }
        if (newOne.checks.size() != 1) {
            return false;
        }
        boolean modified = false;
        ArrayList<SmartPredicateAnd<T>> postponed = null;
        Iterator<SmartPredicateAnd<T>> it2 = terms.iterator();
        while (it2.hasNext()) {
            SmartPredicateAnd<T> smartPredicateAnd = it2.next();
            SmartPredicateAnd<T> fixed = Objects.requireNonNull(SmartPredicate.fixBySingleValue(smartPredicateAnd, newOne));
            if (fixed == smartPredicateAnd) continue;
            it2.remove();
            modified = true;
            if (postponed == null) {
                postponed = new ArrayList<SmartPredicateAnd<T>>();
            }
            postponed.add(fixed);
        }
        if (postponed != null) {
            for (SmartPredicateAnd smartPredicateAnd : postponed) {
                SmartPredicate.insert(terms, smartPredicateAnd);
            }
        }
        return modified;
    }

    private static <T> void intersectTo(@NotNull List<SmartPredicateAnd<T>> terms, @NotNull SmartPredicateAnd<T> p2, List<SmartPredicateAnd<T>> res2) {
        if (terms == null) {
            SmartPredicate.$$$reportNull$$$0(19);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(20);
        }
        for (SmartPredicateAnd<T> term : terms) {
            SmartPredicate.intersectTo(term, p2, res2);
        }
    }

    private static <T> void intersectTo(@NotNull SmartPredicateAnd<T> term, @NotNull SmartPredicateAnd<T> p2, List<SmartPredicateAnd<T>> res2) {
        SmartPredicate<T> intersection;
        if (term == null) {
            SmartPredicate.$$$reportNull$$$0(21);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(22);
        }
        if ((intersection = SmartPredicate.intersect(term, p2)).isNone()) {
            return;
        }
        SmartPredicate.insert(res2, (SmartPredicateAnd)intersection);
    }

    @NotNull
    private static <T> SmartPredicateAnd<T> createAnd(@NotNull List<T> checks2, @Nullable Set<T> negative, boolean sort) {
        if (checks2 == null) {
            SmartPredicate.$$$reportNull$$$0(23);
        }
        if (checks2.isEmpty()) {
            SmartPredicateAnd smartPredicateAnd = SmartPredicateAnd.all();
            if (smartPredicateAnd == null) {
                SmartPredicate.$$$reportNull$$$0(24);
            }
            return smartPredicateAnd;
        }
        if (sort) {
            checks2.sort(MY_COMP);
        }
        return new SmartPredicateAnd<T>(checks2, negative == null || negative.isEmpty() ? ImmutableSet.of() : negative);
    }

    @Nullable
    public static <T> SmartPredicateAnd<T> submerge(@NotNull SmartPredicateAnd<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        int oLength;
        int length;
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(25);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(26);
        }
        if ((length = p2.checks.size()) == (oLength = p1.checks.size())) {
            if (!Objects.equals(p2.checks, p1.checks)) {
                return null;
            }
            int nLength = p2.negative.size();
            int onLength = p1.negative.size();
            int d2 = onLength - nLength;
            if (Math.abs(d2) > 1) {
                return null;
            }
            return d2 >= 0 ? SmartPredicate.mergeByNegative(p1, p2) : SmartPredicate.mergeByNegative(p2, p1);
        }
        return length > oLength ? SmartPredicate.submergeByLarger(p1, oLength, p2, length) : SmartPredicate.submergeByLarger(p2, length, p1, oLength);
    }

    @Nullable
    private static <T> SmartPredicateAnd<T> submergeByLarger(@NotNull SmartPredicateAnd<T> o1, int len1, @NotNull SmartPredicateAnd<T> o2, int len2) {
        if (o1 == null) {
            SmartPredicate.$$$reportNull$$$0(27);
        }
        if (o2 == null) {
            SmartPredicate.$$$reportNull$$$0(28);
        }
        int oi = 0;
        for (int i2 = 0; i2 < len1; ++i2) {
            Object check = o1.checks.get(i2);
            while (oi < len2 && !Objects.equals(o2.checks.get(oi), check)) {
                ++oi;
            }
            if (oi >= len2) {
                return null;
            }
            if (o1.isNegative(check) == o2.isNegative(check)) continue;
            return null;
        }
        return o1;
    }

    @Nullable
    private static <T> SmartPredicateAnd<T> fixBySingleValue(@NotNull SmartPredicateAnd<T> what, @NotNull SmartPredicateAnd<T> fixer) {
        Set negative;
        if (what == null) {
            SmartPredicate.$$$reportNull$$$0(29);
        }
        if (fixer == null) {
            SmartPredicate.$$$reportNull$$$0(30);
        }
        if (fixer.checks.size() != 1) {
            return what;
        }
        Object check = fixer.checks.get(0);
        int idx = what.checks.indexOf(check);
        if (idx == -1) {
            return what;
        }
        if (fixer.isNegative(check) == what.isNegative(check)) {
            return what;
        }
        if (what.checks.size() == 1) {
            return null;
        }
        ArrayList checks2 = new ArrayList(what.checks);
        checks2.remove(idx);
        if (what.negative.contains(check)) {
            negative = new HashSet(what.negative);
            negative.remove(check);
        } else {
            negative = what.negative;
        }
        return SmartPredicate.createAnd(checks2, negative, false);
    }

    @Nullable
    private static <T> SmartPredicateAnd<T> mergeByNegative(@NotNull SmartPredicateAnd<T> o1, SmartPredicateAnd<T> o2) {
        Iterator it2;
        if (o1 == null) {
            SmartPredicate.$$$reportNull$$$0(31);
        }
        if (!(it2 = JBIterable.from(o1.checks).filter(x -> o1.isNegative(x) != o2.isNegative(x)).iterator()).hasNext()) {
            return o1;
        }
        Object merged = it2.next();
        if (it2.hasNext()) {
            return null;
        }
        if (o1.checks.size() == 1) {
            return SmartPredicateAnd.all();
        }
        ArrayList res2 = new ArrayList(o1.checks);
        res2.remove(merged);
        return SmartPredicate.createAnd(res2, o2.negative, false);
    }

    @NotNull
    private static <T> SmartPredicate<T> intersect(@NotNull SmartPredicate<T> p1, @NotNull SmartPredicate<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(32);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(33);
        }
        if (p2.isNone() || p1.isNone()) {
            return SmartPredicate.none();
        }
        if (p2.isAll()) {
            SmartPredicate<T> smartPredicate = p1;
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(34);
            }
            return smartPredicate;
        }
        if (p1.isAll()) {
            SmartPredicate<T> smartPredicate = p2;
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(35);
            }
            return smartPredicate;
        }
        if (p1 instanceof SmartPredicateOr) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.intersectImpl((SmartPredicateOr)p1, (SmartPredicateOr)p2);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.intersectImpl((SmartPredicateOr)p1, (SmartPredicateAnd)p2);
            }
        }
        if (p1 instanceof SmartPredicateAnd) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.intersectImpl((SmartPredicateOr)p2, (SmartPredicateAnd)p1);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.intersectImpl((SmartPredicateAnd)p1, (SmartPredicateAnd)p2);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @NotNull
    private static <T> SmartPredicate<T> intersectImpl(@NotNull SmartPredicateAnd<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(36);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(37);
        }
        LinkedHashSet res2 = new LinkedHashSet(p1.checks);
        for (Object check : p2.checks) {
            if (res2.add(check) || p1.isNegative(check) == p2.isNegative(check)) continue;
            return SmartPredicate.none();
        }
        HashSet neg = new HashSet(p1.negative);
        neg.addAll(p2.negative);
        return SmartPredicate.createAnd(new ArrayList(res2), neg, true);
    }

    @NotNull
    private static <T> SmartPredicate<T> intersectImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(38);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(39);
        }
        ArrayList<SmartPredicateAnd<T>> res2 = new ArrayList<SmartPredicateAnd<T>>();
        SmartPredicate.intersectTo(p1.terms, p2, res2);
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(40);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> intersectImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateOr<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(41);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(42);
        }
        ArrayList<SmartPredicateAnd<T>> res2 = new ArrayList<SmartPredicateAnd<T>>();
        for (SmartPredicateAnd oTerm : p2.terms) {
            SmartPredicate.intersectTo(p1.terms, oTerm, res2);
        }
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(43);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> minus(@NotNull SmartPredicate<T> p1, @NotNull SmartPredicate<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(44);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(45);
        }
        if (p2.isAll() || p1.isNone()) {
            return SmartPredicate.none();
        }
        if (p2.isNone()) {
            SmartPredicate<T> smartPredicate = p1;
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(46);
            }
            return smartPredicate;
        }
        if (p1.isAll()) {
            return SmartPredicate.negate(p2);
        }
        if (p1.equals(p2)) {
            return SmartPredicate.none();
        }
        if (p1 instanceof SmartPredicateOr) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.minusImpl((SmartPredicateOr)p1, (SmartPredicateOr)p2);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.minusImpl((SmartPredicateOr)p1, (SmartPredicateAnd)p2);
            }
        }
        if (p1 instanceof SmartPredicateAnd) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.minusImpl((SmartPredicateAnd)p1, (SmartPredicateOr)p2);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.minusImpl((SmartPredicateAnd)p1, (SmartPredicateAnd)p2);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @NotNull
    private static <T> SmartPredicate<T> minusImpl(@NotNull SmartPredicateAnd<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(47);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(48);
        }
        ArrayList<SmartPredicateAnd<T>> res2 = new ArrayList<SmartPredicateAnd<T>>();
        for (Object check : p2.checks) {
            SmartPredicate.intersectTo(p1, SmartPredicate.create(check, !p2.isNegative(check)), res2);
        }
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(49);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> minusImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        ArrayList terms;
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(50);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(51);
        }
        if ((terms = new ArrayList(p1.terms)).remove(p2)) {
            SmartPredicate smartPredicate = SmartPredicate.createOr(terms);
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(52);
            }
            return smartPredicate;
        }
        ArrayList<SmartPredicateAnd<T>> res2 = new ArrayList<SmartPredicateAnd<T>>();
        for (Object check : p2.checks) {
            SmartPredicate.intersectTo(terms, SmartPredicate.create(check, !p2.isNegative(check)), res2);
        }
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(53);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> minusImpl(@NotNull SmartPredicateAnd<T> p1, @NotNull SmartPredicateOr<T> p22) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(54);
        }
        if (p22 == null) {
            SmartPredicate.$$$reportNull$$$0(55);
        }
        if (p22.terms.contains(p1)) {
            return SmartPredicate.none();
        }
        ArrayList res2 = new ArrayList();
        SmartPredicate.insertNegationTerms(p22.terms, p2 -> SmartPredicate.intersectTo(p1, p2, res2));
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(56);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> minusImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateOr<T> p22) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(57);
        }
        if (p22 == null) {
            SmartPredicate.$$$reportNull$$$0(58);
        }
        ArrayList terms = new ArrayList(p1.terms);
        ArrayList mTerms = new ArrayList(p22.terms);
        Iterator it2 = mTerms.iterator();
        while (it2.hasNext()) {
            SmartPredicateAnd ap = (SmartPredicateAnd)it2.next();
            if (!terms.remove(ap)) continue;
            it2.remove();
        }
        if (mTerms.isEmpty()) {
            SmartPredicate smartPredicate = SmartPredicate.createOr(terms);
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(59);
            }
            return smartPredicate;
        }
        ArrayList res2 = new ArrayList();
        SmartPredicate.insertNegationTerms(mTerms, p2 -> SmartPredicate.intersectTo(terms, p2, res2));
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(60);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicateAnd<T> create(T check, boolean negative) {
        return new SmartPredicateAnd(ImmutableList.of(check), negative ? ImmutableSet.of(check) : ImmutableSet.of());
    }

    @NotNull
    private static <T> SmartPredicate<T> negate(@NotNull SmartPredicate<T> p2) {
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(61);
        }
        if (p2.isNone()) {
            return SmartPredicate.all();
        }
        if (p2.isAll()) {
            return SmartPredicate.none();
        }
        if (p2 instanceof SmartPredicateOr) {
            return SmartPredicate.negateImpl((SmartPredicateOr)p2);
        }
        if (p2 instanceof SmartPredicateAnd) {
            return SmartPredicate.negateImpl((SmartPredicateAnd)p2);
        }
        throw new AssertionError((Object)"impossible");
    }

    @NotNull
    private static <T> SmartPredicate<T> negateImpl(@NotNull SmartPredicateOr<T> p2) {
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(62);
        }
        ArrayList res2 = new ArrayList();
        SmartPredicate.insertNegationTerms(p2.terms, n -> SmartPredicate.insert(res2, n));
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(63);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> negateImpl(@NotNull SmartPredicateAnd<T> p2) {
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(64);
        }
        ArrayList<SmartPredicateAnd<T>> res2 = new ArrayList<SmartPredicateAnd<T>>(p2.checks.size());
        for (Object check : p2.checks) {
            res2.add(SmartPredicate.create(check, !p2.isNegative(check)));
        }
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(res2);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(65);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> union(@NotNull SmartPredicate<T> p1, @NotNull SmartPredicate<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(66);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(67);
        }
        if (p2.isAll() || p1.isAll()) {
            return SmartPredicate.all();
        }
        if (p2.isNone()) {
            SmartPredicate<T> smartPredicate = p1;
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(68);
            }
            return smartPredicate;
        }
        if (p1.isNone()) {
            SmartPredicate<T> smartPredicate = p2;
            if (smartPredicate == null) {
                SmartPredicate.$$$reportNull$$$0(69);
            }
            return smartPredicate;
        }
        if (p1 instanceof SmartPredicateOr) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.unionImpl((SmartPredicateOr)p1, (SmartPredicateOr)p2);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.unionImpl((SmartPredicateOr)p1, (SmartPredicateAnd)p2);
            }
        }
        if (p1 instanceof SmartPredicateAnd) {
            if (p2 instanceof SmartPredicateOr) {
                return SmartPredicate.unionImpl((SmartPredicateOr)p2, (SmartPredicateAnd)p1);
            }
            if (p2 instanceof SmartPredicateAnd) {
                return SmartPredicate.unionImpl((SmartPredicateAnd)p1, (SmartPredicateAnd)p2);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @NotNull
    private static <T> SmartPredicate<T> unionImpl(@NotNull SmartPredicateAnd<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(70);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(71);
        }
        ArrayList<SmartPredicateAnd<T>> terms = new ArrayList<SmartPredicateAnd<T>>();
        terms.add(p1);
        SmartPredicate.insert(terms, p2);
        SmartPredicate<T> smartPredicate = SmartPredicate.createOr(terms);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(72);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> unionImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateAnd<T> p2) {
        ArrayList terms;
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(73);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(74);
        }
        if (!SmartPredicate.insert(terms = new ArrayList(p1.terms), p2)) {
            SmartPredicateOr<T> smartPredicateOr = p1;
            if (smartPredicateOr == null) {
                SmartPredicate.$$$reportNull$$$0(75);
            }
            return smartPredicateOr;
        }
        SmartPredicate smartPredicate = SmartPredicate.createOr(terms);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(76);
        }
        return smartPredicate;
    }

    @NotNull
    private static <T> SmartPredicate<T> unionImpl(@NotNull SmartPredicateOr<T> p1, @NotNull SmartPredicateOr<T> p2) {
        if (p1 == null) {
            SmartPredicate.$$$reportNull$$$0(77);
        }
        if (p2 == null) {
            SmartPredicate.$$$reportNull$$$0(78);
        }
        ArrayList terms = new ArrayList(p1.terms);
        boolean changed = false;
        for (SmartPredicateAnd term : p2.terms) {
            changed |= SmartPredicate.insert(terms, term);
        }
        if (!changed) {
            SmartPredicateOr<T> smartPredicateOr = p1;
            if (smartPredicateOr == null) {
                SmartPredicate.$$$reportNull$$$0(79);
            }
            return smartPredicateOr;
        }
        SmartPredicate smartPredicate = SmartPredicate.createOr(terms);
        if (smartPredicate == null) {
            SmartPredicate.$$$reportNull$$$0(80);
        }
        return smartPredicate;
    }

    private static boolean isSorted(@NotNull List<?> list) {
        if (list == null) {
            SmartPredicate.$$$reportNull$$$0(81);
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (MY_COMP.compare(list.get(i2 - 1), list.get(i2)) <= 0) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 24, 34, 35, 40, 43, 46, 49, 52, 53, 56, 59, 60, 63, 65, 68, 69, 72, 75, 76, 79, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 24: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SmartPredicate";
                break;
            }
            case 5: 
            case 61: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terms";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negative";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOne";
                break;
            }
            case 20: 
            case 22: 
            case 26: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 55: 
            case 58: 
            case 67: 
            case 71: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 25: 
            case 32: 
            case 36: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 57: 
            case 66: 
            case 70: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixer";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SmartPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "none";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "orTerms";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "andTerms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPositiveChecks";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnd";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 40: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectImpl";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 49: 
            case 52: 
            case 53: 
            case 56: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "minusImpl";
                break;
            }
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "negateImpl";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "unionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 24: 
            case 34: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 79: 
            case 80: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNegative";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertNegationTerms";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOr";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixTermsBySingleValue";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "intersectTo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createAnd";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "submerge";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "submergeByLarger";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fixBySingleValue";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mergeByNegative";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "intersectImpl";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "minusImpl";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "negateImpl";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "unionImpl";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isSorted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 24, 34, 35, 40, 43, 46, 49, 52, 53, 56, 59, 60, 63, 65, 68, 69, 72, 75, 76, 79, 80 -> new IllegalStateException(string);
        };
    }

    private static final class SmartPredicateAnd<T>
    extends SmartPredicate<T>
    implements Comparable<SmartPredicateAnd<T>> {
        private static final SmartPredicateAnd<?> ALL = new SmartPredicateAnd(ImmutableList.of(), ImmutableSet.of());
        @NotNull
        private final List<T> checks;
        @NotNull
        private final Set<T> negative;

        @NotNull
        public static <T> SmartPredicateAnd<T> all() {
            SmartPredicateAnd<?> smartPredicateAnd = ALL;
            if (smartPredicateAnd == null) {
                SmartPredicateAnd.$$$reportNull$$$0(0);
            }
            return smartPredicateAnd;
        }

        private SmartPredicateAnd(@NotNull List<T> checks2, @NotNull Set<T> negative) {
            if (checks2 == null) {
                SmartPredicateAnd.$$$reportNull$$$0(1);
            }
            if (negative == null) {
                SmartPredicateAnd.$$$reportNull$$$0(2);
            }
            this.checks = ImmutableList.copyOf(checks2);
            this.negative = ImmutableSet.copyOf(negative);
            if (!SmartPredicate.isSorted(checks2)) {
                throw new AssertionError((Object)"Not sorted");
            }
        }

        @Override
        public int compareTo(@NotNull SmartPredicateAnd<T> o2) {
            int length;
            int res2;
            if (o2 == null) {
                SmartPredicateAnd.$$$reportNull$$$0(3);
            }
            if ((res2 = Integer.compare(length = this.checks.size(), o2.checks.size())) != 0 || length == 0) {
                return res2;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                res2 = MY_COMP.compare(this.checks.get(i2), o2.checks.get(i2));
                if (res2 != 0) {
                    return res2;
                }
                res2 = Boolean.compare(this.isNegative(this.checks.get(i2)), o2.isNegative(o2.checks.get(i2)));
                if (res2 == 0) continue;
                return res2;
            }
            return 0;
        }

        @Override
        public boolean isAll() {
            return this.checks.isEmpty();
        }

        @Override
        public boolean isNone() {
            return false;
        }

        public String toString() {
            if (this.isAll()) {
                return "\u03a9";
            }
            return StringUtil.join(this.checks, c2 -> (this.isNegative(c2) ? "\u00ac" : "") + c2.toString(), (String)" \u2229 ");
        }

        @Override
        public boolean evaluate(@NotNull Predicate<T> evaluator) {
            if (evaluator == null) {
                SmartPredicateAnd.$$$reportNull$$$0(4);
            }
            for (T check : this.checks) {
                boolean matches2 = evaluator.test(check);
                if (matches2 != this.isNegative(check)) continue;
                return false;
            }
            return true;
        }

        private boolean isNegative(T p2) {
            return this.negative.contains(p2);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof SmartPredicateAnd)) {
                return false;
            }
            SmartPredicateAnd pattern2 = (SmartPredicateAnd)o2;
            return Objects.equals(this.negative, pattern2.negative) && Objects.equals(this.checks, pattern2.checks);
        }

        public int hashCode() {
            return Objects.hash(this.negative, this.checks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/SmartPredicate$SmartPredicateAnd";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "negative";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "all";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/SmartPredicate$SmartPredicateAnd";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class SmartPredicateOr<T>
    extends SmartPredicate<T> {
        private static final SmartPredicateOr<?> NONE = new SmartPredicateOr(ImmutableList.of());
        @NotNull
        private final List<SmartPredicateAnd<T>> terms;

        @NotNull
        public static <T> SmartPredicateOr<T> none() {
            SmartPredicateOr<?> smartPredicateOr = NONE;
            if (smartPredicateOr == null) {
                SmartPredicateOr.$$$reportNull$$$0(0);
            }
            return smartPredicateOr;
        }

        private SmartPredicateOr(@NotNull List<SmartPredicateAnd<T>> terms) {
            if (terms == null) {
                SmartPredicateOr.$$$reportNull$$$0(1);
            }
            this.terms = ImmutableList.copyOf(terms);
            if (!SmartPredicate.isSorted(terms)) {
                throw new AssertionError((Object)"Not sorted");
            }
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public boolean isNone() {
            return this.terms.isEmpty();
        }

        public String toString() {
            if (this.isNone()) {
                return "\u2205";
            }
            return StringUtil.join(this.terms, t -> t.checks.size() > 1 ? "(" + t + ")" : t.toString(), (String)" \u222a ");
        }

        @Override
        public boolean evaluate(@NotNull Predicate<T> evaluator) {
            if (evaluator == null) {
                SmartPredicateOr.$$$reportNull$$$0(2);
            }
            for (SmartPredicateAnd<T> term : this.terms) {
                if (!term.evaluate(evaluator)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof SmartPredicateOr)) {
                return false;
            }
            SmartPredicateOr or = (SmartPredicateOr)o2;
            return this.terms.equals(or.terms);
        }

        public int hashCode() {
            return this.terms.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/SmartPredicate$SmartPredicateOr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "none";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/SmartPredicate$SmartPredicateOr";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

