/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.UnparsedTypeHolder;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.AppendableWithRead;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Out;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlBuilder {
    private final List<String> myResults = new SmartList();
    private final Appendable myOut;
    private boolean mySortElements;
    private boolean mySplitStatements;
    private DatabaseDialectEx myDialect = DatabaseDialects.getGenericDialect();
    private CasingProvider myCasing = DasUtil.NO_CASING_PROVIDER;
    private Case myKeywordCase = Case.MIXED;
    private Case myTypeCase = Case.MIXED;
    private Casing myIdentCase = DasUtil.CASING_MIXED;
    private boolean myQuoteIdentifiers;
    private boolean myQualifyReferences;
    private boolean mySuppressQuoteIdentifiers;
    private boolean mySuppressQuoteConstraints;
    private boolean myJdbcOdbc;
    private final Deque<ObjectPath> myDefaultSchemas = new LinkedList<ObjectPath>();
    private final Map<DasObject, String> myRenames = new HashMap<DasObject, String>();
    private boolean mySkipExternalReferences;
    private boolean myNewName;
    private boolean myAddNewLineBeforeNewText = false;
    private String myIndent;
    private Marker myMarker = null;

    public DdlBuilder(Out out) {
        this.myOut = out.toAppendable();
    }

    public DdlBuilder(StringBuilder out) {
        this.myOut = out;
    }

    public DdlBuilder() {
        this(new StringBuilder());
    }

    public DdlBuilder configureBuilder(@NotNull Project project, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            DdlBuilder.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            DdlBuilder.$$$reportNull$$$0(1);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect);
        this.configureBuilder(settings);
        return this;
    }

    public DdlBuilder configureBuilder(@NotNull SqlCodeStyleSettings settings) {
        if (settings == null) {
            DdlBuilder.$$$reportNull$$$0(2);
        }
        this.keywordCase(settings.getKeywordCase());
        this.typeCase(settings.getBuiltInTypeCase());
        this.identifierCase(Casing.create(settings.getIdentifierCase(), settings.getQuotedIdentifierCase()));
        this.quoteIdentifiers(settings.QUOTE_IDENTIFIER == 2);
        return this;
    }

    @NotNull
    public DdlBuilder applyCodeStyle(@Nullable Project project, SqlLanguageDialect dialect) {
        if (project != null) {
            this.configureBuilder(project, dialect);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(3);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder renameObject(@NotNull DasObject obj2, @Nullable String name2) {
        if (obj2 == null) {
            DdlBuilder.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            this.myRenames.remove(obj2);
        } else {
            this.myRenames.put(obj2, name2);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder configureFrom(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DdlBuilder.$$$reportNull$$$0(6);
        }
        this.myDialect = builder.myDialect;
        this.myCasing = builder.myCasing;
        this.myKeywordCase = builder.myKeywordCase;
        this.myTypeCase = builder.myTypeCase;
        this.myIdentCase = builder.myIdentCase;
        this.myQuoteIdentifiers = builder.myQuoteIdentifiers;
        this.myQualifyReferences = builder.myQualifyReferences;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder copied() {
        DdlBuilder builder = new DdlBuilder().configureFrom(this);
        builder.mySuppressQuoteConstraints = this.mySuppressQuoteConstraints;
        builder.mySuppressQuoteIdentifiers = this.mySuppressQuoteIdentifiers;
        builder.myDefaultSchemas.addAll(this.myDefaultSchemas);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    public DdlBuilder configureFor(@NotNull DbElement element2) {
        if (element2 == null) {
            DdlBuilder.$$$reportNull$$$0(9);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(element2);
        this.applyCodeStyle(element2.getProject(), dialect);
        this.myDialect = DbImplUtilCore.getDatabaseDialect(element2);
        return this.withCasingFor(element2);
    }

    public DdlBuilder withCasingFor(@NotNull DbElement element2) {
        if (element2 == null) {
            DdlBuilder.$$$reportNull$$$0(10);
        }
        this.myCasing = element2.getDataSource().getModel();
        return this;
    }

    private int outLength() {
        if (this.myOut instanceof Out) {
            return (int)((Out)this.myOut).length();
        }
        if (this.myOut instanceof StringBuilder) {
            return ((StringBuilder)this.myOut).length();
        }
        throw new AssertionError((Object)String.format("The type '%s' is not supported as outType", this.myOut.getClass()));
    }

    @NotNull
    private String outString() {
        if (this.myOut instanceof AppendableWithRead) {
            String string = ((AppendableWithRead)this.myOut).getString();
            if (string == null) {
                DdlBuilder.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (this.myOut instanceof StringBuilder) {
            String string = ((StringBuilder)this.myOut).toString();
            if (string == null) {
                DdlBuilder.$$$reportNull$$$0(12);
            }
            return string;
        }
        throw new AssertionError((Object)String.format("The type '%s' is not supported as outType", this.myOut.getClass()));
    }

    public int length() {
        return this.outLength() + (this.myMarker == null ? 0 : this.myMarker.length());
    }

    public <T> T cast(Class<T> c2) {
        Object t = ObjectUtils.tryCast((Object)this.myOut, c2);
        if (t == null) {
            throw new UnsupportedOperationException("failed to cast " + this.myOut.getClass() + " to " + c2);
        }
        return (T)t;
    }

    public DdlBuilder withCasing(@NotNull CasingProvider casing) {
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(13);
        }
        this.myCasing = casing;
        return this;
    }

    public DdlBuilder withDialect(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DdlBuilder.$$$reportNull$$$0(14);
        }
        this.myDialect = dialect;
        this.myCasing = this.myCasing == DasUtil.NO_CASING_PROVIDER ? this.myDialect : this.myCasing;
        return this;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DdlBuilder.$$$reportNull$$$0(15);
        }
        return databaseDialectEx;
    }

    public boolean isEmpty() {
        return this.length() == 0 && this.myResults.isEmpty();
    }

    @NotNull
    public DdlBuilder sort(boolean flag) {
        this.mySortElements = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywordCase(Case mode) {
        this.myKeywordCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder typeCase(Case mode) {
        this.myTypeCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifierCase(@NotNull Casing casing) {
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(19);
        }
        this.myIdentCase = casing;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder splitStatements(boolean flag) {
        this.mySplitStatements = flag;
        if (this.mySplitStatements) {
            this.cast(StringBuilder.class);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifyReferences(boolean flag) {
        this.myQualifyReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(22);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newStatement() {
        if (this.length() != 0) {
            if (this.mySplitStatements) {
                StringBuilder builder = this.cast(StringBuilder.class);
                this.myResults.add(builder.toString());
                builder.setLength(0);
            } else {
                this.symbol(";");
                this.myAddNewLineBeforeNewText = true;
            }
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder clear() {
        StringBuilder sb = (StringBuilder)ObjectUtils.tryCast((Object)this.myOut, StringBuilder.class);
        if (sb != null) {
            this.myAddNewLineBeforeNewText = false;
            sb.setLength(0);
        }
        this.myResults.clear();
        this.myMarker = null;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @NlsSafe
    @NotNull
    public String getStatement() {
        String string = this.myMarker == null ? this.outString() : this.myMarker.toString();
        if (string == null) {
            DdlBuilder.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public List<String> getStatements() {
        if ((this.mySplitStatements || this.myResults.isEmpty()) && this.length() > 0) {
            this.newStatement();
        }
        List<String> list = this.myResults;
        if (list == null) {
            DdlBuilder.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public DdlBuilder jdbcOdbc(boolean flag) {
        this.myJdbcOdbc = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    public boolean isJdbcOdbc() {
        return this.myJdbcOdbc;
    }

    @NotNull
    public DdlBuilder skipExternalReferences(boolean flag) {
        this.mySkipExternalReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    public boolean skipExternalReferences() {
        return this.mySkipExternalReferences;
    }

    @NotNull
    public DdlBuilder quoteIdentifiers(boolean quoteIdentifiers) {
        this.myQuoteIdentifiers = quoteIdentifiers;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteIdentifiers(boolean flag) {
        this.mySuppressQuoteIdentifiers = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder pushDefaultSchema(@Nullable ObjectPath namespace) {
        this.myDefaultSchemas.push(namespace);
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder popDefaultSchema() {
        this.myDefaultSchemas.pop();
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteConstraints(boolean flag) {
        this.mySuppressQuoteConstraints = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @NotNull
    public Marker mark() {
        StringBuilder builder = (StringBuilder)ObjectUtils.tryCast((Object)this.myOut, StringBuilder.class);
        if (builder != null) {
            return new Marker(builder);
        }
        return new Marker(new StringBuilder());
    }

    @NotNull
    public DdlBuilder plain(@NotNull String text2) {
        if (text2 == null) {
            DdlBuilder.$$$reportNull$$$0(34);
        }
        DdlBuilder ddlBuilder = this.append(text2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(35);
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder append(@NotNull String text2) {
        if (text2 == null) {
            DdlBuilder.$$$reportNull$$$0(36);
        }
        if (!text2.isEmpty() && this.myAddNewLineBeforeNewText) {
            this.myAddNewLineBeforeNewText = false;
            this.newLine();
        }
        if (this.myMarker == null) {
            try {
                this.myOut.append(text2);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            this.myMarker.builder.append(text2);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder placeholder() {
        DdlBuilder ddlBuilder = this.symbol("?");
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(38);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keyword(@NotNull String keyword) {
        if (keyword == null) {
            DdlBuilder.$$$reportNull$$$0(39);
        }
        DdlBuilder ddlBuilder = this.plain(this.myKeywordCase.apply(keyword));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywords(String ... keywords) {
        if (keywords == null) {
            DdlBuilder.$$$reportNull$$$0(41);
        }
        boolean first2 = true;
        for (String s2 : keywords) {
            if (first2) {
                first2 = false;
            } else {
                this.space();
            }
            this.keyword(s2);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull String type) {
        if (type == null) {
            DdlBuilder.$$$reportNull$$$0(43);
        }
        return this.typeInner(type);
    }

    @NotNull
    private DdlBuilder typeInner(@NotNull String type) {
        Case styleMode;
        if (type == null) {
            DdlBuilder.$$$reportNull$$$0(44);
        }
        boolean quoted = this.getNamingService().isQuoted(type);
        Casing casing = this.myCasing.getCasing(ObjectKind.OBJECT_TYPE, null);
        Case case_ = styleMode = quoted ? this.myIdentCase.choose(false) : this.myTypeCase;
        Case caseMode = quoted || casing.choose(true) == Case.EXACT ? casing.choose(!quoted) : Case.MIXED;
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? type : styleMode.apply(type));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DasTypedObject typedInfo) {
        DataType type;
        if (typedInfo == null) {
            DdlBuilder.$$$reportNull$$$0(46);
        }
        try {
            type = typedInfo.getDasType().toDataType();
        }
        catch (UnsupportedOperationException e2) {
            if (typedInfo instanceof UnparsedTypeHolder) {
                DdlBuilder ddlBuilder = this.plain(((UnparsedTypeHolder)((Object)typedInfo)).getUnparsedType());
                if (ddlBuilder == null) {
                    DdlBuilder.$$$reportNull$$$0(47);
                }
                return ddlBuilder;
            }
            throw e2;
        }
        DdlBuilder ddlBuilder = this.type(type);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DataType dataType) {
        if (dataType == null) {
            DdlBuilder.$$$reportNull$$$0(49);
        }
        if (dataType.schemaName != null) {
            this.ref(null, dataType.schemaName).symbol(".");
        }
        this.typeInner(dataType.typeName);
        if (dataType.vagueArg != null) {
            this.symbol("(").plain(dataType.vagueArg).symbol(")");
        } else if (dataType.enumValues != null) {
            this.symbol("(");
            this.plain(StringUtil.join(dataType.enumValues, (String)", "));
            this.symbol(")");
        } else if (dataType.size >= 0) {
            this.symbol("(");
            if (dataType.size == 0x7FFFFFFE) {
                this.symbol("*");
            } else if (dataType.size == Integer.MAX_VALUE) {
                this.keyword("max");
            } else {
                this.number(dataType.size);
            }
            if (dataType.scale != 0) {
                this.symbol(",").number(dataType.scale);
            }
            if (dataType.sizeUnit != LengthUnit.NONE && dataType.sizeUnitExplicit) {
                this.space().keyword(dataType.sizeUnit.suffix);
            }
            this.symbol(")");
        }
        if (dataType.suffix != null) {
            this.space().plain(dataType.suffix);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder number(int n) {
        DdlBuilder ddlBuilder = this.plain(String.valueOf(n));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(51);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder literal(@NotNull String def) {
        if (def == null) {
            DdlBuilder.$$$reportNull$$$0(52);
        }
        DdlBuilder ddlBuilder = this.plain(def);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder ref(@Nullable DasObject object, String name2) {
        DdlBuilder ddlBuilder = this.ref(object == null ? ObjectKind.TABLE : object.getKind(), object, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder ref(@NotNull ObjectKind kind, @Nullable DasObject context, String name2) {
        if (kind == null) {
            DdlBuilder.$$$reportNull$$$0(55);
        }
        boolean quoted = this.getNamingService().isQuoted(name2);
        Casing casing = this.myCasing.getCasing(kind, context);
        Case styleMode = this.myIdentCase.choose(!quoted);
        Case caseMode = casing.choose(!quoted);
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? name2 : styleMode.apply(name2));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space(int count) {
        DdlBuilder ddlBuilder = this.plain(StringUtil.repeat((String)" ", (int)count));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(57);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space() {
        DdlBuilder ddlBuilder = this.space(1);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder tab() {
        DdlBuilder ddlBuilder = this.space(4);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(59);
        }
        return ddlBuilder;
    }

    public DdlBuilder newLine() {
        DdlBuilder result2 = this.plain("\n");
        return this.myIndent == null ? result2 : result2.plain(this.myIndent);
    }

    @NotNull
    public DdlBuilder indent(@Nullable String indent) {
        this.myIndent = indent;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Nullable
    public String getIndent() {
        return this.myIndent;
    }

    @NotNull
    public DdlBuilder symbol(@NotNull String symbol) {
        if (symbol == null) {
            DdlBuilder.$$$reportNull$$$0(61);
        }
        DdlBuilder ddlBuilder = this.plain(symbol);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(62);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder comment(@NotNull String s2) {
        if (s2 == null) {
            DdlBuilder.$$$reportNull$$$0(63);
        }
        for (String commentLine : StringUtil.splitByLinesKeepSeparators((String)s2)) {
            this.plain("-- ").plain(commentLine);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(64);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder inlineComment(@NotNull String s2) {
        if (s2 == null) {
            DdlBuilder.$$$reportNull$$$0(65);
        }
        DdlBuilder ddlBuilder = this.plain("/*").plain(s2).plain("*/");
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(66);
        }
        return ddlBuilder;
    }

    private String catToScript(@NotNull String name2, boolean forceQuoting, boolean suppress, @NotNull Casing casing, @Nullable ObjectKind kind) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(67);
        }
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(68);
        }
        boolean suppressFlag = suppress || this.mySuppressQuoteIdentifiers;
        return this.myDialect.catToScript(name2, kind, forceQuoting && !suppressFlag, suppressFlag, casing);
    }

    @NotNull
    public DdlBuilder identifier(@NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(69);
        }
        DdlBuilder ddlBuilder = this.identifier(null, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@NotNull String name2, @NotNull ObjectKind kind) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(71);
        }
        if (kind == null) {
            DdlBuilder.$$$reportNull$$$0(72);
        }
        return this.identifier(name2, kind, null);
    }

    @NotNull
    private DdlBuilder identifier(@NotNull String name2, @NotNull ObjectKind kind, @Nullable DasObject object) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(73);
        }
        if (kind == null) {
            DdlBuilder.$$$reportNull$$$0(74);
        }
        Casing casing = this.myCasing.getCasing(kind, object);
        DdlBuilder ddlBuilder = this.ref(kind, object, this.catToScript(name2, this.myQuoteIdentifiers, DdlBuilder.isPlainIdentifier(object), casing, kind));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(76);
        }
        DdlBuilder ddlBuilder = this.identifier(object, this.getName(object));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(77);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(78);
        }
        return this.identifier(name2, object == null ? ObjectKind.TABLE : object.getKind(), object);
    }

    @NotNull
    public DdlBuilder identifier(@NotNull ObjectName name2, @Nullable ObjectKind kind) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(79);
        }
        ObjectKind objectKind = (ObjectKind)ObjectUtils.chooseNotNull((Object)kind, (Object)ObjectKind.TABLE);
        Casing casing = this.myCasing.getCasing(objectKind, null);
        DdlBuilder ddlBuilder = this.ref(null, this.catToScript(name2.name, this.myQuoteIdentifiers, !name2.quoted, casing, objectKind));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(80);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder alias(@NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(81);
        }
        DdlBuilder ddlBuilder = this.ref(null, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(82);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String newName) {
        if (newName == null) {
            DdlBuilder.$$$reportNull$$$0(83);
        }
        DdlBuilder ddlBuilder = this.identifier(newName);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(84);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String name2, @Nullable DasObject info2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(85);
        }
        this.myNewName = true;
        this.qualifiedRefOpt(info2, name2);
        this.myNewName = false;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(86);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder formatQualification(@NotNull DasObject object, ObjectKind ... kinds) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(87);
        }
        if (kinds == null) {
            DdlBuilder.$$$reportNull$$$0(88);
        }
        boolean first2 = true;
        for (ObjectKind kind : kinds) {
            DasObject item = DasUtil.getParentOfKind(object, kind, false);
            if (item == null || StringUtil.isEmpty((String)item.getName())) continue;
            if (!first2) {
                this.symbol(".");
            }
            first2 = false;
            this.identifier(item, item.getName());
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(89);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull DasObject info2) {
        if (info2 == null) {
            DdlBuilder.$$$reportNull$$$0(90);
        }
        DdlBuilder ddlBuilder = this.identifier(info2, this.getName(info2));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(91);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(92);
        }
        DdlBuilder ddlBuilder = this.identifier(null, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(93);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getName(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(94);
        }
        String string = StringUtil.notNullize((String)this.myRenames.get(object), (String)object.getName());
        if (string == null) {
            DdlBuilder.$$$reportNull$$$0(95);
        }
        return string;
    }

    @NotNull
    public DdlBuilder constraintRef(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(96);
        }
        DdlBuilder ddlBuilder = this.constraintRef(object, object.getName());
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(97);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder constraintRef(@Nullable DasObject object, @NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(98);
        }
        Casing casing = this.myCasing.getCasing(ObjectKind.KEY, object);
        DdlBuilder ddlBuilder = this.ref(object, this.catToScript(name2, this.myQuoteIdentifiers, this.mySuppressQuoteConstraints || DdlBuilder.isPlainIdentifier(object), casing, ObjectKind.KEY));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(99);
        }
        return ddlBuilder;
    }

    private static boolean isPlainIdentifier(@Nullable DasObject object) {
        return !DbSqlUtilCore.isQuoted(object);
    }

    @NotNull
    public DdlBuilder qualifiedRef(@NotNull DasObject info2) {
        if (info2 == null) {
            DdlBuilder.$$$reportNull$$$0(100);
        }
        if (this.myQualifyReferences && !this.inCurrentNamespace(info2)) {
            this.myDialect.qualifiedIdentifier(this, this.getName(info2), info2, info2);
        } else if (info2 instanceof DasRoutine) {
            String pkgName = ((DasRoutine)info2).getPackageName();
            this.qualifiedRef(info2, this.getName(info2), null, null, null, null, pkgName != null ? info2.getDasParent() : null, pkgName);
        } else {
            this.qualifiedRefLast(info2, this.getName(info2));
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(101);
        }
        return ddlBuilder;
    }

    public boolean inCurrentNamespace(@NotNull DasObject info2) {
        if (info2 == null) {
            DdlBuilder.$$$reportNull$$$0(102);
        }
        ObjectPath current = this.myDefaultSchemas.peek();
        DasObject parent2 = info2.getDasParent();
        if (current == null) {
            return parent2 == null;
        }
        return current.equals(ObjectPaths.of(parent2));
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(103);
        }
        DdlBuilder ddlBuilder = this.qualifiedRefOpt(object, object, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(104);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @Nullable DasObject qualifier, @NotNull String name2) {
        boolean explicitSchema;
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(105);
        }
        if (explicitSchema = qualifier != null && this.myQualifyReferences ? !this.inCurrentNamespace(qualifier) : false) {
            this.myDialect.qualifiedIdentifier(this, name2, object, qualifier);
        } else {
            this.qualifiedRefLast(object, name2);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(106);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRef(@Nullable DasObject object, @NotNull String name2, @Nullable DasObject schemaObject, @Nullable String schema2, @Nullable DasObject catalogObject, @Nullable String catalog, @Nullable DasObject packageObject, @Nullable String packageName) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(107);
        }
        if (this.isNotEmptyName(catalog) && (object == null || object != catalogObject)) {
            this.identifier(catalogObject, catalog).symbol(".");
        }
        if (this.isNotEmptyName(schema2) && (object == null || object != schemaObject)) {
            this.identifier(schemaObject, schema2).symbol(".");
        }
        if (this.isNotEmptyName(packageName) && (object == null || object != packageObject)) {
            this.identifier(packageObject, packageName).symbol(".");
        }
        DdlBuilder ddlBuilder = this.qualifiedRefLast(object, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(108);
        }
        return ddlBuilder;
    }

    private boolean isNotEmptyName(@Nullable String name2) {
        if (StringUtil.isEmpty((String)name2)) {
            return false;
        }
        if (name2.length() != 2) {
            return true;
        }
        return StringUtil.isNotEmpty((String)this.getNamingService().unquoteIdentifier(name2));
    }

    @NotNull
    private NamingService getNamingService() {
        NamingService namingService2 = NamingServices.getNamingService(this.myDialect.getDbms());
        if (namingService2 == null) {
            DdlBuilder.$$$reportNull$$$0(109);
        }
        return namingService2;
    }

    @NotNull
    protected DdlBuilder qualifiedRefLast(@Nullable DasObject element2, @NotNull String name2) {
        if (name2 == null) {
            DdlBuilder.$$$reportNull$$$0(110);
        }
        DdlBuilder ddlBuilder = this.myNewName ? this.newName(name2) : this.identifier(element2, name2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(111);
        }
        return ddlBuilder;
    }

    public <T extends DasObject> Iterable<T> sortKeysIfNeeded(Iterable<T> elements2) {
        if (!this.mySortElements) {
            return elements2;
        }
        ArrayList result2 = new ArrayList();
        Iterables.addAll(result2, elements2);
        result2.sort((o1, o2) -> Comparing.compare((Comparable)((Object)this.getName((DasObject)o1)), (Comparable)((Object)this.getName((DasObject)o2))));
        return result2;
    }

    public String toString() {
        return super.toString() + ": " + (this.myMarker == null ? this.outString() : this.myMarker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 11, 12, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 38, 40, 42, 45, 47, 48, 50, 51, 53, 54, 56, 57, 58, 59, 60, 62, 64, 66, 70, 75, 77, 80, 82, 84, 86, 89, 91, 93, 95, 97, 99, 101, 104, 106, 108, 109, 111 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 70: 
            case 75: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DdlBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 19: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 55: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 81: 
            case 85: 
            case 92: 
            case 98: 
            case 103: 
            case 105: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 76: 
            case 87: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 90: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DdlBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyCodeStyle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "renameObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFrom";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copied";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "outString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "keywordCase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "typeCase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "identifierCase";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "splitStatements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyReferences";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "clear";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "jdbcOdbc";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "skipExternalReferences";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteIdentifiers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressQuoteIdentifiers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "pushDefaultSchema";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "popDefaultSchema";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressQuoteConstraints";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "plain";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "placeholder";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "keyword";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "keywords";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "typeInner";
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "number";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "literal";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "ref";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "space";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tab";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "indent";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "symbol";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "comment";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineComment";
                break;
            }
            case 70: 
            case 75: 
            case 77: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "identifier";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "alias";
                break;
            }
            case 84: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "newName";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "formatQualification";
                break;
            }
            case 91: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "columnRef";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 97: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "constraintRef";
                break;
            }
            case 101: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRef";
                break;
            }
            case 104: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRefOpt";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRefLast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 70: 
            case 75: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withCasingFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withCasing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withDialect";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "identifierCase";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "plain";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "keyword";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "keywords";
                break;
            }
            case 43: 
            case 46: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "typeInner";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "literal";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "ref";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "symbol";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "comment";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "inlineComment";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "catToScript";
                break;
            }
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "identifier";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "newName";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "formatQualification";
                break;
            }
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "columnRef";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "constraintRef";
                break;
            }
            case 100: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRef";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "inCurrentNamespace";
                break;
            }
            case 103: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRefOpt";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRefLast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 11, 12, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 38, 40, 42, 45, 47, 48, 50, 51, 53, 54, 56, 57, 58, 59, 60, 62, 64, 66, 70, 75, 77, 80, 82, 84, 86, 89, 91, 93, 95, 97, 99, 101, 104, 106, 108, 109, 111 -> new IllegalStateException(string);
        };
    }

    public final class Marker {
        private final int position;
        private final StringBuilder builder;

        private Marker(StringBuilder builder) {
            this.builder = builder;
            this.position = builder.length();
            if (DdlBuilder.this.myMarker != null) {
                throw new AssertionError((Object)"Marker already exists");
            }
            DdlBuilder.this.myMarker = this;
        }

        @NotNull
        public String extract() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            String string = this.builder.subSequence(this.position, this.builder.length()).toString();
            if (string == null) {
                Marker.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void replace(@NotNull String replacement) {
            if (replacement == null) {
                Marker.$$$reportNull$$$0(1);
            }
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            this.builder.replace(this.position, this.builder.length(), replacement);
        }

        public void finish() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Finishing invalid marker");
            }
            if (DdlBuilder.this.myOut != this.builder) {
                try {
                    DdlBuilder.this.myOut.append(this.builder);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            DdlBuilder.this.myMarker = null;
        }

        public String toString() {
            if (DdlBuilder.this.myOut != this.builder) {
                return DdlBuilder.this.myOut + this.builder.toString();
            }
            return this.builder.toString();
        }

        private int length() {
            return this.builder.length() - this.position;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DdlBuilder$Marker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extract";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DdlBuilder$Marker";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

