/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Case;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSqlUtil
extends DbSqlUtilCore {
    private DbSqlUtil() {
    }

    public static boolean isSqlFileCoarse(VirtualFile file) {
        if (!DbSqlUtil.isSqlFileValid(file)) {
            return false;
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE);
    }

    private static boolean isSqlFileValid(VirtualFile file) {
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            if (file instanceof DatabaseElementSourceVirtualFileImpl && ((DatabaseElementSourceVirtualFileImpl)file).isBusy()) {
                return false;
            }
            ObjectKind kind = ((DatabaseElementVirtualFileImpl)file).getObjectKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition2 = Conditions.alwaysFalse();
            if (condition2 == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition2;
        }
        Condition condition3 = file -> {
            if (DbSqlUtil.isSqlFileCoarse(file)) {
                return true;
            }
            return DbSqlUtil.isSqlFileValid(file) && LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition3 == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition3;
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        ColoredDdlBuilder colored = new ColoredDdlBuilder();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys2;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys2 = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys2[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable String queryText2, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns2) {
        void var9_15;
        void var9_13;
        boolean checkMetadata;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (columns2 == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        if (!ContainerUtil.all(columns2, column2 -> column2 instanceof JdbcGridColumn)) {
            return null;
        }
        JdbcGridColumn tableColumn = null;
        if (!columns2.isEmpty()) {
            for (GridColumn gridColumn : columns2) {
                JdbcGridColumn c2 = (JdbcGridColumn)gridColumn;
                if (StringUtil.isNotEmpty((String)c2.getTable()) && (tableColumn == null || Objects.equals(c2.getCatalog(), tableColumn.getCatalog()) && Objects.equals(c2.getSchema(), tableColumn.getSchema()) && Objects.equals(c2.getTable(), tableColumn.getTable()))) {
                    tableColumn = c2;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        Dbms dbms = dataSource2 == null ? DbSqlUtil.getDbms(language) : dataSource2.getDbms();
        Object var9_10 = null;
        if (queryText2 != null) {
            DasTable dasTable;
            SqlTableType type = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource2, searchPath, queryText2, null);
            PsiElement element2 = type == null ? null : type.getTypeElement();
            DasTable dasTable2 = dasTable = element2 instanceof DasTable ? (DasTable)element2 : null;
            if (dasTable == null && language instanceof SqlLanguageDialect && element2 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref2 = (SqlReferenceExpression)element2;
                String name2 = ref2.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref2.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref2.getReferencePart(ObjectKind.DATABASE);
                String schema2 = refSchema.isEmpty() && tableColumn != null && tableColumn.getSchema() != null ? tableColumn.getSchema() : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.getCatalog() != null ? tableColumn.getCatalog() : refCatalog;
                BasicModTable mt = DbSqlUtil.sqlCreateFakeTable(dbms, catalog, schema2, name2);
                if (mt != null) {
                    DasTypeSystemBase dtService = DasTypeSystems.getTypeSystem(dbms);
                    for (GridColumn gridColumn : columns2) {
                        BasicModTableOrViewColumn c3 = (BasicModTableOrViewColumn)mt.getColumns().renewAt((short)gridColumn.getColumnNumber(), gridColumn.getName());
                        String tn = gridColumn.getTypeName();
                        if (tn == null) continue;
                        c3.setDasType(dtService.createDasType(DataTypeFactory.of(tn)));
                    }
                    BasicModTable basicModTable = mt;
                }
            }
        }
        boolean bl = checkMetadata = language instanceof SqlLanguageDialect || !dbms.isMongo();
        if (checkMetadata && tableColumn != null && var9_13 != null) {
            String catalog;
            boolean checkTableName = !dbms.is(Dbms.GREENPLUM) && !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.MEMSQL) || var9_13.getKind() != ObjectKind.VIEW;
            boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
            boolean dbIsSchema = dbms.isMysql() || dbms == Dbms.CLICKHOUSE;
            String schema3 = dbIsSchema ? DasUtil.NO_NAME : DasUtil.getSchema((DasObject)var9_13);
            String string = catalog = dbIsSchema ? DasUtil.getSchema((DasObject)var9_13) : DasUtil.getCatalog((DasObject)var9_13);
            if (checkTableName && !DbSqlUtil.matches(tableColumn.getTable(), var9_13.getName(), metadataMayReturnDifferentCase) || !DbSqlUtil.matches(tableColumn.getSchema(), schema3, metadataMayReturnDifferentCase) || !catalog.isEmpty() && !DbSqlUtil.matches(tableColumn.getCatalog(), catalog, metadataMayReturnDifferentCase)) {
                Object var9_14 = null;
            }
        }
        return var9_15;
    }

    @Nullable
    public static BasicModTable sqlCreateFakeTable(Dbms dbms, String catalog, String schema2, String name2) {
        BasicModModel model2 = ModelFactory.BLACK_HOLE.createModel(dbms);
        Ref res2 = Ref.create();
        model2.modify(BasicModRoot.class, r -> {
            BasicModElement db = Objects.requireNonNullElse(DbSqlUtil.createChild(r, ObjectKind.DATABASE, catalog), r);
            String scName = dbms.isMysql() && db.getKind() != ObjectKind.DATABASE ? StringUtil.notNullize((String)StringUtil.nullize((String)schema2), (String)catalog) : schema2;
            BasicModElement sc2 = DbSqlUtil.createChild(db, ObjectKind.SCHEMA, scName);
            res2.set((Object)((BasicModTable)ObjectUtils.tryCast((Object)DbSqlUtil.createChild(sc2, ObjectKind.TABLE, name2), BasicModTable.class)));
        });
        return (BasicModTable)res2.get();
    }

    @Nullable
    private static BasicModElement createChild(@Nullable BasicModElement p2, @NotNull ObjectKind kind, @Nullable String name2) {
        Family dbf;
        if (kind == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        Family family = dbf = p2 == null ? null : p2.familyOf(kind);
        if (dbf == null) {
            return null;
        }
        Object db = dbf.createNewOne();
        if (name2 != null && db instanceof BasicModNamedElement) {
            BasicModNamedElement ne = (BasicModNamedElement)db;
            ne.setName(name2);
        }
        return db;
    }

    private static boolean matches(@Nullable String jdbcName, @Nullable String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema2, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        ArrayList<DataConsumer.Column> columns2 = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count = type.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String name2 = columnNames.get(i2);
            String typeName = type.getColumnDasType(i2).getDescription();
            columns2.add(new DataConsumer.Column(i2, name2, 1111, typeName, null, 0, 0, catalog, schema2, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns2;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect(dialect)).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name2 = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias != null && (duplicates.contains(name2) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i2)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i2));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i2));
            builder.columnRef(name2);
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names2) {
        Set duplicates = CollectionFactory.createCaseInsensitiveStringSet();
        Set distinctNames = CollectionFactory.createCaseInsensitiveStringSet();
        for (String name2 : names2) {
            if (distinctNames.add(name2)) continue;
            duplicates.add(name2);
        }
        return duplicates;
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String queryText2, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).parseQueryTableType(project, language, dataSource2, searchPath, queryText2, hostLanguage);
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull JdbcConsoleBase console, @NotNull Language language, @NotNull String queryText2) {
        if (console == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        return DbSqlUtil.parseQueryTableType(console.getProject(), language, DbSqlUtil.getDbDataSource(console.getProject(), console.getDataSource()), console.getSearchPath(), queryText2, null);
    }

    public static boolean isResultEditable(@Nullable GridDataRequest request, SqlTableType tableType2, @Nullable DasObject detectedTable) {
        DasObject table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        if (tableType2 == null) {
            return false;
        }
        PsiElement element2 = tableType2.getTypeElement();
        DasObject dasObject = element2 instanceof DasObject ? (DasObject)element2 : (table = element2 instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null) {
            return false;
        }
        return DbImplUtilCore.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s2, @Nullable ObjectPath ns, @NotNull DasModel model2) {
        if (s2 == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        if (model2 == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        IntrospectionScopeUpdater res2 = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model2);
        for (SqlStatement statement2 : s2.filter(SqlStatement.class)) {
            ObjectKind kind;
            SqlDropStatement dropStatement;
            SqlReferenceExpression expression;
            ObjectPath objectName;
            if (statement2 instanceof SqlAlterStatement) {
                for (SqlSynonymDefinition synonymDefinition : SyntaxTraverser.psiApi().children((Object)statement2).filter(SqlSynonymDefinition.class)) {
                    ObjectKind kind2 = synonymDefinition.getKind();
                    if (kind2 != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA) continue;
                    SqlNameElement newName = synonymDefinition.getNameElement();
                    SqlReferenceExpression oldName = synonymDefinition.getTargetReference();
                    if (newName == null || oldName == null) continue;
                    if (res2 == null) {
                        res2 = new IntrospectionScopeUpdater();
                    }
                    ObjectPath parent2 = kind2 == ObjectKind.SCHEMA ? db : null;
                    ObjectPath oldObjectName = ObjectPath.create(oldName.getName(), kind2, oldName.isQuotedIdentifier(), null, parent2);
                    ObjectPath newObjectName = ObjectPath.create(newName.getName(), kind2, newName.isQuotedIdentifier(), null, parent2);
                    res2.toRemove(oldObjectName);
                    res2.toAdd(newObjectName);
                }
                continue;
            }
            if (statement2 instanceof SqlCreateStatement) {
                SqlNameElement element2;
                SqlCreateStatement createStatement = (SqlCreateStatement)statement2;
                ObjectKind kind3 = createStatement.getKind();
                if (kind3 != ObjectKind.DATABASE && kind3 != ObjectKind.SCHEMA || (element2 = createStatement.getNameElement()) == null) continue;
                if (res2 == null) {
                    res2 = new IntrospectionScopeUpdater();
                }
                objectName = ObjectPath.create(element2.getName(), kind3, element2.isQuotedIdentifier(), null, kind3 == ObjectKind.SCHEMA ? db : null);
                res2.toAdd(objectName);
                continue;
            }
            if (!(statement2 instanceof SqlDropStatement) || (expression = (dropStatement = (SqlDropStatement)statement2).getTargetExpression()) == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create(expression.getName(), kind, expression.isQuotedIdentifier(), null, kind == ObjectKind.SCHEMA ? db : null);
            res2.toRemove(objectName);
        }
        return res2;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model2) {
        DasNamespace cur;
        if (model2 == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        if ((cur = model2.getCurrentRootNamespace()) == null) {
            Iterator it2 = model2.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it2.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it2.next();
            if (it2.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectPaths.of(cur) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static boolean isSqlElement(@NotNull DbElement element2) {
        DbDataSource dataSource2;
        if (element2 == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        return element2 != (dataSource2 = element2.getDataSource()) && dataSource2.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbElement element2) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element2 == null ? null : (DasObject)ObjectUtils.tryCast((Object)element2.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlSourceElement(element2.getDataSource(), dasObject);
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res2;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect(dialect)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        MongoJSLanguage mongoJSLanguage = dbms == Dbms.MONGO ? MongoJSLanguage.INSTANCE : DbSqlUtil.getSqlDialect(dbms);
        if (mongoJSLanguage == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        return mongoJSLanguage;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource2) {
        Language language = dataSource2 == null ? null : dataSource2.getQueryLanguage();
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver2) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver2);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver2) {
        if (driver2 == null) {
            return null;
        }
        String dialectId = driver2.getSqlDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById(dialectId);
        return result2 != null ? result2 : DbSqlUtil.getSqlDialect(DbImplUtilCore.getDbms(driver2));
    }

    @Deprecated
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGeneralSqlSettings((Project)project);
        Case keywordCaseMode = codeStyleSettings.getKeywordCase();
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        SqlCodeStyleSettings codeStyleSettings;
        Case keywordCaseMode;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        return (keywordCaseMode = (codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect)).getKeywordCase()) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 46 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 15: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 25: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 12: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 18: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 41: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryTableType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 46 -> new IllegalArgumentException(string);
        };
    }
}

