/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ColumnRefKt;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Triple;
import me.xuender.unidecode.Unidecode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class DbImplUtil
extends DbImplUtilCore {
    private static final String READ_ONLY_WARNING = "Read-only mode is not supported. Dbms: %s";
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtilCore::canConnectTo;
    private static final char ESCAPE_CHAR = '#';

    private DbImplUtil() {
    }

    @NotNull
    public static Dbms getDbms(@NotNull GridDataRequest.Context context) {
        DataRequest.Context c2;
        if (context == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
         @Nullable DataRequest.Owner owner = (c2 = (DataRequest.Context)((Object)ObjectUtils.tryCast((Object)context, DataRequest.Context.class))) == null ? null : c2.request.owner;
        Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)DbImplUtil.getDbms(owner), (Object)Dbms.UNKNOWN);
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Nullable
    public static Dbms getDbms(@Nullable DataRequest.Owner owner) {
        DbDataSource system = owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDataSource() : (owner instanceof JdbcConsoleBase ? ((JdbcConsoleBase)owner).getDataSource() : (owner instanceof DatabaseSession ? ((DatabaseConnectionPoint)((DatabaseSession)owner).getTarget()).getDataSource() : (owner instanceof DataRequest.DasDataSourceProvider ? ((DataRequest.DasDataSourceProvider)((Object)owner)).getDataSource() : null)));
        return system == null ? null : system.getDbms();
    }

    public static int valueHashCode(Object v2) {
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if (v2 instanceof Number) {
            Number n = (Number)v2;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v2 instanceof byte[]) {
            return Arrays.hashCode((byte[])v2);
        }
        if (v2 instanceof char[]) {
            return Arrays.hashCode((char[])v2);
        }
        if (v2 instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v2).data);
        }
        return Comparing.hashcode((Object)v2);
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        if ((expression = DbSqlUtilCore.parseSqlQueryResultSetExpression(project, DbSqlUtilCore.getSqlDialect(dbms), query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        Set names2 = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        Object result2 = alias;
        int index2 = 1;
        while (names2.contains(result2)) {
            result2 = alias + index2++;
        }
        String string = result2;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isConnected(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        Object delegate = element2.getDelegate();
        Project project = element2.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    @Nullable
    public static Domain getDomain(@Nullable DasTypedObject column2) {
        if (column2 == null) {
            return null;
        }
        DomainRegistry registry = BaseDomainRegistry.get(DbImplUtilCore.getDbms(column2), null);
        return registry.getDomain(new TypeNameColumnDescriptor(DasTypeUtilsKt.getTypeName(column2.getDasType())));
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource delegate) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        return !JdbcDriverManager.getDriverManager(project).getActiveConfigurations(delegate).isEmpty();
    }

    public static int getActiveConnectionCount(@NotNull LocalDataSource delegate) {
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(11);
        }
        int result2 = 0;
        for (DatabaseConnection connection2 : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            if (delegate != connection2.getConnectionPoint().getDataSource()) continue;
            ++result2;
        }
        return result2;
    }

    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element2, @NotNull DatabaseDepartment department) throws Exception {
        RawDataSource ds;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        if (department == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        if (!((ds = element2.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        LocalDataSource localDataSource = (LocalDataSource)ds;
        SearchPath path = SearchPath.of(ObjectPaths.of(DasUtil.getNamespace(element2)));
        Project project = element2.getProject();
        GuardedRef<DatabaseConnection> connection2 = DatabaseSessionManager.getFacade(project, localDataSource, null, path, false, null, department).connect();
        JdbcNativeUtil.performSafe(() -> ((DatabaseConnection)connection2.get()).getRemoteConnection().setCatalog(DasUtil.getCatalog(element2)));
        return connection2;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e2) {
        if (e2 == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        if (ExceptionUtil.findCause((Throwable)e2, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e2, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        ModelHelper modelHelper = DbImplUtilCore.getModelHelper(element2);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        return modelHelper;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        ModelHelper modelHelper = DbImplUtilCore.getModelHelper(dbms);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        return modelHelper;
    }

    @NotNull
    public static Dbms getDbms(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        Dbms dbms = console.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        return dbms;
    }

    public static boolean isGenericSupport(Dbms dbms) {
        if (dbms.in(Dbms.PSEUDO_SUPPORTED)) {
            return true;
        }
        DatabaseDialectEx db = DbImplUtil.getDatabaseDialect(dbms);
        SqlLanguageDialect sql = DbSqlUtilCore.getSqlDialect(dbms);
        return SqlDialects.isGenericDialect(sql) && DatabaseDialects.isGenericDialect(db);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(21);
        }
        return DbImplUtil.getDatabaseDialect(console.getDataSource());
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        return databaseDialectEx;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return DbImplUtilCore.guessDatabaseDialect(dbms);
    }

    @Nullable
    public static DatabaseDialect guessDatabaseDialect(@Nullable DasObject object) {
        return DbImplUtil.guessDatabaseDialect(DbImplUtil.guessDbms(object));
    }

    @Nullable
    public static Dbms guessDbms(@Nullable DasObject object) {
        Language language;
        BasicModel model2;
        DasObject o2;
        DasObject dasObject = o2 = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Dbms dbms = o2 instanceof BasicElement ? ((model2 = ((BasicElement)o2).getModel()) == null ? null : model2.getDbms()) : (o2 instanceof SqlElement ? ((language = ((SqlElement)o2).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : null) : null);
        return dbms;
    }

    public static boolean supportsDbmsOutput(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        return dbms.isOracle() || dbms == Dbms.DB2_LUW;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull DatabaseConnectionPoint dataSource2) {
        DatabaseDialectEx dialect;
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect(dataSource2)) == null || dataSource2.getDbms() != Dbms.MYSQL || !dataSource2.isReadOnly();
    }

    public static boolean isScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbImplUtil.isSqlScriptFile(project, file) || DbImplUtil.isJSScriptFile(project, file);
    }

    public static boolean isSqlScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbSqlUtil.SQL_FILE_FILTER(project).value((Object)file);
    }

    public static boolean isJSScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (!"js".equals(file.getExtension()) && !FileTypeRegistry.getInstance().getFileTypeByFile(file).getName().equals("JavaScript")) {
            return false;
        }
        for (LocalDataSource localDataSource : DbSrcUtilsCore.getDataSources(project)) {
            if (!localDataSource.getDbms().isMongo()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtilsCore.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtils.getKind(file.getPath());
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o2, boolean refresh2) {
        VirtualFile file;
        if (o2 == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        if ((file = DbImplUtil.findVirtualFileInSourceStorage(o2, false, refresh2)) != null) {
            return file;
        }
        return o2.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findDataVirtualFile(@NotNull DbElement o2, boolean refresh2) {
        ObjectKind kind;
        if (o2 == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        if (DbImplUtil.isDataTable(kind = o2.getKind())) {
            return DatabaseElementVirtualFileImpl.findFile(o2, false);
        }
        return DbImplUtil.findSourceVirtualFile(o2, refresh2);
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o2, boolean original, boolean refresh2) {
        VirtualFile vf;
        Object delegate;
        Object object = delegate = o2 != null ? o2.getDelegate() : null;
        if (delegate instanceof BasicSourceAware && (vf = DbSrcUtils.findDbSrcFile(o2.getDataSource(), o2, refresh2)) != null) {
            return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o2) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o2, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean canSwitchTo(@NotNull SearchPath to, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        return dialect.sqlSetSearchPath(to) != null || DbImplUtilCore.isNamespace(to.getCurrent().kind) && DbImplUtil.shouldSwitchThroughJdbc(dialect);
    }

    @Nullable
    public static String getSearchPathSql(@NotNull SearchPath to, @NotNull DatabaseConnectionPoint dataSource2, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(31);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return null;
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        if (setSchemaSql != null) {
            return setSchemaSql;
        }
        ObjectPath current = to.getCurrent();
        ObjectPath db = current.kind != ObjectKind.SCHEMA ? null : current.findParent(ObjectKind.DATABASE, true);
        return db == null ? null : dialect.sqlSetSearchPath(SearchPath.of(db));
    }

    public static boolean switchSchemaThroughJdbc(@NotNull SearchPath path, @NotNull DatabaseConnection connection2, @NotNull DatabaseConnectionPoint dataSource2) throws SQLException {
        if (path == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return false;
        }
        if (!DbImplUtil.shouldSwitchThroughJdbc(DbImplUtil.getDatabaseDialect(dataSource2))) {
            return false;
        }
        if (dataSource2.getDbms().isClickHouse()) {
            ObjectPath schema2 = path.getCurrent().findParent(ObjectKind.SCHEMA, false);
            if (schema2 == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> connection2.getRemoteConnection().setSchema(schema2.name));
            return true;
        }
        return DbImplUtil.switchSchemaThroughJdbcImpl(path.getCurrent(), connection2);
    }

    private static boolean shouldSwitchThroughJdbc(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        return dialect.getDbms().isClickHouse() || DatabaseDialects.isGenericDialect(dialect);
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasObject table, @NotNull List<T> descriptors, @NotNull Dbms dbms) {
        ColumnDescriptor idColumn;
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(39);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey(table);
        ArrayList<ColumnDescriptor> result2 = new ArrayList<ColumnDescriptor>(descriptors.size());
        if (primaryKey != null) {
            Set set = CollectionFactory.createCaseInsensitiveStringSet();
            ContainerUtil.addAll((Collection)set, primaryKey.getColumnsRef().names());
            result2.addAll(ContainerUtil.filter(descriptors, descriptor2 -> set.contains(descriptor2.getName())));
        } else if (dbms.is(Dbms.MONGO) && (idColumn = (ColumnDescriptor)ContainerUtil.find(descriptors, d2 -> "_id".equals(d2.getName()))) != null) {
            result2.add(idColumn);
        }
        if (!result2.isEmpty()) {
            ArrayList<ColumnDescriptor> arrayList = result2;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        result2.addAll(ContainerUtil.filter(descriptors, descriptor2 -> DbImplUtil.isSuitable(descriptor2, dbms)));
        ArrayList<ColumnDescriptor> arrayList = result2;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    public static boolean supportsReadOnlyChangeOnTheFly(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        return !dbms.isSqlite() && !dbms.isHive() && dbms != Dbms.SNOWFLAKE && dbms != Dbms.COCKROACH;
    }

    public static void tryToSetReadOnly(@NotNull DatabaseConnection connection2, boolean isReadOnly) {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        try {
            connection2.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, connection2.getDbms()), t);
        }
    }

    public static void tryToSetReadOnly(@NotNull RemoteConnection remoteConnection, boolean isReadOnly, Dbms dbms) {
        if (remoteConnection == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        try {
            remoteConnection.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, dbms), t);
        }
    }

    public static boolean supportsReadOnlyChangeDuringTx(@NotNull Dbms family) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        return family == Dbms.MYSQL;
    }

    @Nullable
    public static DbDataSource findDataSourceByFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        if (file == null) {
            return null;
        }
        for (DbDataSource dataSource2 : DbPsiFacade.getInstance(project).getDataSources()) {
            String adjusted2;
            LocalDataSource d2 = DbImplUtil.getMaybeLocalDataSource(dataSource2);
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(d2);
            String path = parsed == null ? null : parsed.getParameter("file");
            if (path == null || !Objects.equals(adjusted2 = FileUtil.toSystemIndependentName((String)PathManager.getAbsolutePath((String)path)), file.getPath())) continue;
            return dataSource2;
        }
        return null;
    }

    public static TriConsumer<DdlBuilder, List<DasColumn>, Dbms> defaultWhereCondition(@NotNull String[] columnNames, @NotNull List<String[]> valuesList, @Nullable Version version) {
        if (valuesList == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        return (builder, columns2, dbms) -> {
            List<ColumnRef> actualColumns = ColumnRefKt.toColumnsRef(columns2, columnNames);
            ArrayList columnsAndValuesList = new ArrayList();
            for (String[] values2 : valuesList) {
                ArrayList<Triple> list = new ArrayList<Triple>();
                for (int i2 = 0; i2 < actualColumns.size(); ++i2) {
                    list.add(new Triple((Object)actualColumns.get(i2), (Object)ModelIndex.forColumn((GridModel)null, (int)i2), (Object)values2[i2]));
                }
                columnsAndValuesList.add(list);
            }
            WhereClause whereClause2 = ExtractorsUtil.createWhereClauseTask(false, PredicatesHelperKt.predicatesHelper(dbms).getSupportsInOperator(), columnsAndValuesList, (column2, v2) -> PredicateValuesKt.predicateValue(v2));
            WhereClauseTask task = DmlTaskKt.whereClause(whereClause2).version(version).build((DdlBuilder)builder);
            DmlUtilKt.dmlGenerator(dbms).generate(task);
        };
    }

    @NotNull
    public static ObjectKind getTableKind(@NotNull DatabaseConnection connection2, @NotNull String query) throws SQLException {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(49);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        ExecutionEnvironmentHelper helper = ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms());
        ObjectKind result2 = (ObjectKind)DbImplUtil.executeAndGetResult(connection2, query, helper::getTableKind);
        if (result2 == null) {
            throw new AssertionError((Object)"Incorrect table kind query!");
        }
        ObjectKind objectKind = result2;
        if (objectKind == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        return objectKind;
    }

    @Nullable
    public static SqlLanguageDialect getSqlLanguageDialectForExec(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        return (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)file), (Object)SqlPsiFacade.getInstance((Project)file.getProject()).getConfiguredSqlLanguageDialect(virtualFile));
    }

    @Nullable
    public static DbDataSource getForcedDataSourceForExec(@NotNull PsiFile file) {
        DbDataSource forcedDataSource;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        return (forcedDataSource = DbImplUtil.getForcedDataSource(file)) != null && DbImplUtil.canConnectTo(forcedDataSource) ? forcedDataSource : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSourcesForExec(@NotNull PsiFile file) {
        SqlLanguageDialect dialect;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        if ((dialect = DbImplUtil.getSqlLanguageDialectForExec(file)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbImplUtil.$$$reportNull$$$0(55);
            }
            return jBIterable;
        }
        DatabaseDialect databaseDialect2 = dialect.getDatabaseDialect();
        JBIterable<DbDataSource> appropriateDataSources = DbSqlUtilCore.getAppropriateDataSources(databaseDialect2, PsiUtilCore.getVirtualFile((PsiElement)file), file.getProject(), false, false);
        JBIterable jBIterable = appropriateDataSources.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(56);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAllDataSourcesForExec(@NotNull PsiFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(57);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance(file.getProject());
        JBIterable jBIterable = JBIterable.from(facade.getDataSources()).filter(ds -> !(ds instanceof SqlDataSource) && ds.isValid()).filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(58);
        }
        return jBIterable;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull GridColumn column2, boolean isNull, @Nullable String alias, @NotNull Dbms dbms, boolean inUpdate) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(59);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(60);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(61);
        }
        if (GridUtilCore.isRowId((GridColumn)column2)) {
            builder.plain(column2.getName());
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column2.getName());
        }
        builder.space();
        if (isNull) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        String className = column2 instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column2).getJavaClassName() : null;
        boolean bl = useLike = DbImplUtil.getDatabaseDialect(dbms).getLikeSupport(null).isSupported(inUpdate) && "java.lang.String".equals(className);
        if (useLike) {
            builder.keyword("LIKE");
        } else if (dbms.isPostgres() && PgBaseJdbcHelper.isCustomOperatorType((String)column2.getTypeName())) {
            builder.symbol("~=");
        } else {
            builder.symbol("=");
        }
        builder.space().placeholder();
        if (useLike && helper.supportsEscape()) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        return 1;
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        if (callback == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        }, modalityState);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @NotNull ModalityState state) {
        if (state == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        DbImplUtil.setActionCallbackDone(callback, done, null, state);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        EnumSet<ReservedCellValue> result2 = EnumSet.noneOf(ReservedCellValue.class);
        if (dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            result2.add(ReservedCellValue.UNSET);
        }
        if (databaseColumn == null) {
            result2.add(ReservedCellValue.NULL);
            EnumSet<ReservedCellValue> enumSet = result2;
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(65);
            }
            return enumSet;
        }
        if (DasUtil.isAutoGenerated(databaseColumn)) {
            result2.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed(databaseColumn)) {
            result2.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result2.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result2.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result2;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(66);
        }
        return enumSet;
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable LocalDataSource dataSource2, @Nullable SearchPath path) {
        SchemaControl control;
        if (path == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control == SchemaControl.AUTOMATIC) {
            return path;
        }
        return DbImplUtil.getDatabaseToSwitch(path);
    }

    @Nullable
    public static SearchPath getDatabaseToSwitch(@Nullable SearchPath path) {
        return DbImplUtil.getPathToSwitch(path, ObjectKind.DATABASE);
    }

    @Nullable
    public static SearchPath getSchemaToSwitch(@Nullable SearchPath path) {
        return DbImplUtil.getPathToSwitch(path, ObjectKind.SCHEMA);
    }

    @Nullable
    private static SearchPath getPathToSwitch(@Nullable SearchPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        return path == null ? null : SearchPath.of(path.getCurrent().findParent(kind, false));
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor2, @NotNull Dbms dbms) {
        if (descriptor2 == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        int type = descriptor2.getType();
        String typeName = descriptor2.getTypeName();
        return !(type == 2004 || type == 2005 || type == 2011 || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml") && dbms.isMicrosoft() || type == 2009 && (dbms.isPostgres() || dbms.isOracle()) || dbms.isPostgres() && !PgBaseJdbcHelper.canCompare((String)typeName));
    }

    @NotNull
    public static String searchPathPresentation(List<ObjectPath> schemas2) {
        StringBuilder res2 = new StringBuilder();
        int pos = 0;
        while (pos < schemas2.size()) {
            if (res2.length() != 0) {
                res2.append("; ");
            }
            ObjectPath cur = schemas2.get(pos);
            if (++pos < schemas2.size() && cur.parent != null && cur.parent.equals(schemas2.get((int)pos).parent)) {
                res2.append(cur.parent.getDisplayName());
                res2.append(": ");
                res2.append(cur.getName()).append(", ").append(schemas2.get(pos).getName());
                ++pos;
                while (pos < schemas2.size() && cur.parent.equals(schemas2.get((int)pos).parent)) {
                    res2.append(", ").append(schemas2.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res2.append(cur.getDisplayName());
        }
        String string = res2.toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent2, @NotNull DasObject child, Map<DasObject, Boolean> cache2, Condition<? super DasObject> expandCondition) {
        if (child == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        if (parent2 == null || parent2.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res2 = cache2.get(parent2);
        if (res2 == null) {
            res2 = DbImplUtil.isChildrenAccessible(parent2.getDasParent(), parent2, cache2, expandCondition) && expandCondition.value((Object)parent2);
            cache2.put(parent2, res2);
        }
        return res2;
    }

    public static boolean processCandidates(JBIterable<DasObject> candidates2, Condition<? super DasObject> expandCondition, Processor<? super DasObject> processor2) {
        HashMap<DasObject, Boolean> cache2 = new HashMap<DasObject, Boolean>();
        for (DasObject candidate : candidates2) {
            if (!DbImplUtil.isChildrenAccessible(candidate.getDasParent(), candidate, cache2, expandCondition) || processor2.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@Nullable DasColumn dasColumn, @NotNull Dbms dbms) {
        EnumSet<ReservedCellValue> opts;
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        return (opts = DbImplUtil.getSpecialValues(dasColumn, dbms)).contains(ReservedCellValue.UNSET) ? ReservedCellValue.UNSET : (opts.contains(ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains(ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (opts.contains(ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains(ReservedCellValue.NULL) ? ReservedCellValue.NULL : null))));
    }

    @NotNull
    public static String simplify(@NotNull String name2) {
        if (name2 == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        return DbImplUtil.simplify(name2, true);
    }

    @NotNull
    public static String simplify(@NotNull String name2, boolean lowercase) {
        if (name2 == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        String ascii = Unidecode.decode(name2);
        String lowered = lowercase ? StringUtil.toLowerCase((String)ascii) : ascii;
        String underscored = lowered.replaceAll("[^0-9a-zA-Z]", "_");
        String deduplicated = underscored.replaceAll("_+", "_");
        String string = StringUtil.trim((String)deduplicated, c2 -> c2 != '_');
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 16, 18, 20, 23, 40, 41, 51, 55, 56, 58, 65, 66, 70, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 40: 
            case 41: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 65: 
            case 66: 
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 2: 
            case 9: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 17: 
            case 24: 
            case 39: 
            case 42: 
            case 61: 
            case 64: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 25: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 26: 
            case 52: 
            case 53: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 30: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnection";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesList";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 1: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKind";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSourcesForExec";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataSourcesForExec";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPathPresentation";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 40: 
            case 41: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 65: 
            case 66: 
            case 70: 
            case 75: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConnectionCount";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "supportsDbmsOutput";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findDataVirtualFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathSql";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbc";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldSwitchThroughJdbc";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeOnTheFly";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetReadOnly";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeDuringTx";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceByFile";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "defaultWhereCondition";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTableKind";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageDialectForExec";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getForcedDataSourceForExec";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSourcesForExec";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getAllDataSourcesForExec";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setActionCallbackDone";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialValues";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getPathToSwitch";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 16, 18, 20, 23, 40, 41, 51, 55, 56, 58, 65, 66, 70, 75 -> new IllegalStateException(string);
        };
    }
}

