/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DataSourceUtilBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Out;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DataSourceUtil {
    private static final DateTimeFormatter ourTimestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, Key<?> key2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(0);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.asSequence((AreaInstance)project)) {
            if (provider.getId() != key2) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, String key2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(1);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.asSequence((AreaInstance)project)) {
            if (!provider.getId().toString().equals(key2)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static <T extends EventListener, U extends T> EventDispatcher<U> eventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            DataSourceUtil.$$$reportNull$$$0(2);
        }
        EventDispatcher eventDispatcher = DataSourceUtilBase.eventDispatcher(listenerClass);
        if (eventDispatcher == null) {
            DataSourceUtil.$$$reportNull$$$0(3);
        }
        return eventDispatcher;
    }

    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(4);
        }
        return DataSourceUtil.performAutoSyncTask(context, false);
    }

    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        LocalDataSource dataSource2;
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(5);
        }
        if (!(dataSource2 = context.getDataSource()).isAutoSynchronize()) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            if (asyncTask == null) {
                DataSourceUtil.$$$reportNull$$$0(6);
            }
            return asyncTask;
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.automatic.synchronisation", context.getDataSource().getName())).computeAsync(AsyncUtil.getEdtExecutor(), () -> {
            AsyncTask.withBgIndicatorIfNeeded(AsyncTask.currentFrame(), context.getProject(), null);
            AsyncTask<SyncQueue.SyncResult> result2 = DataSourceSyncManager.getInstance().tryPerform(context, stopRunning, true);
            if (result2 == null) {
                return AsyncTask.completed(null);
            }
            result2.whenComplete(null, (r, e2) -> {
                if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e2)) {
                    DataSourceUtil.showNotification(context.getProject(), dataSource2.getName(), DatabaseBundle.message("notification.content.cancelled", new Object[0]), false, Collections.emptyList());
                } else if (context.getErrorHandler().hasErrors()) {
                    if (context.isOutdatedCheck()) {
                        DataSourceUtil.showOutdatedCheckErrorNotification(context, r == null ? 0L : r.elapsedTime);
                    } else {
                        DataSourceUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
                    }
                }
            });
            return result2;
        });
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(7);
        }
        return asyncTask;
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(8);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(9);
        }
        DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(project, dataSource2));
    }

    @Nls
    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o2) {
        Casing modes = o2.getCaseModes();
        NameVersion databaseVersion = o2.getDatabaseVersion();
        Dbms effectiveDbms = o2.getDbms();
        Dbms actualDbms = Dbms.fromString(databaseVersion.name);
        Version effectiveVersion = o2.getVersion();
        String verWithFallback = StringUtil.isEmpty((String)databaseVersion.version) && !effectiveVersion.equals(Version.ZERO) ? effectiveVersion.toString() : databaseVersion.version;
        Version actualVersion = Version.parse(verWithFallback);
        boolean emptyDbName = StringUtil.isEmpty((String)databaseVersion.name);
        boolean matches2 = (effectiveDbms == actualDbms || emptyDbName) && (actualVersion != null && actualVersion.eqCoarse(effectiveVersion) || actualVersion == null && (effectiveVersion.eqCoarse(0) || verWithFallback.contains(effectiveVersion.toString())));
        NameVersion driverVersion = o2.getDriverVersion();
        String dbmsName = emptyDbName ? effectiveDbms.getDisplayName() : databaseVersion.name;
        Object s2 = DatabaseBundle.message("dataSource.quickInfo.dbmsPhrase", dbmsName, verWithFallback, StringUtil.isEmpty((String)verWithFallback) ? 0 : 1);
        s2 = (String)s2 + "\n" + DatabaseBundle.message("dataSource.quickInfo.caseSensitivity2Phrase", Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()));
        if (StringUtil.isNotEmpty((String)driverVersion.name)) {
            s2 = (String)s2 + "\n" + DatabaseBundle.message("dataSource.quickInfo.driverPhrase", driverVersion.name, driverVersion.version, o2.getJDBCVersion());
        }
        if (!matches2) {
            String s4 = DatabaseBundle.message("dataSource.quickInfo.effectiveVersion", effectiveDbms.getDisplayName(), effectiveVersion);
            s2 = (String)s2 + "\n" + s4;
        }
        Object object = s2;
        if (object == null) {
            DataSourceUtil.$$$reportNull$$$0(10);
        }
        return object;
    }

    public static void showNotification(@NotNull Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message2, boolean error2, List<ErrorInfo.Fix> fixes) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(11);
        }
        Pair<@NlsContexts.NotificationContent String, @NotNull Collection<AnAction>> pair = DataSourceUtil.truncatePopupMessageIfNeeded(project, message2, error2 ? DatabaseBundle.message("message.title.connection.error", new Object[0]) : title, error2 ? UIUtil.getErrorIcon() : UIUtil.getInformationIcon(), fixes);
        NotificationGroup group2 = error2 ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group2.createNotification(title, (String)pair.first, error2 ? NotificationType.WARNING : NotificationType.INFORMATION).addActions((Collection)pair.second).setDisplayId("DataSourceUtil.generic.notification").notify(project);
    }

    public static Pair<@NlsContexts.NotificationContent String, @NotNull Collection<AnAction>> truncatePopupMessageIfNeeded(@NotNull Project project, @NlsContexts.NotificationContent String text2, @NlsContexts.DialogTitle String dialogTitle, Icon icon, List<ErrorInfo.Fix> fixes) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(12);
        }
        int maxLen = 120;
        boolean truncate = text2.length() > maxLen;
        ArrayList<DumbAwareAction> actions = new ArrayList<DumbAwareAction>(fixes.size() + 1);
        for (ErrorInfo.Fix fix : fixes) {
            actions.add(DumbAwareAction.create((String)fix.getName(), e2 -> {
                DatabaseUiService.getInstance().applyFix(project, fix, null);
                Notification.get((AnActionEvent)e2).hideBalloon();
            }));
        }
        if (!truncate) {
            return Pair.create((Object)text2, actions);
        }
        @NlsSafe String message2 = text2.replace("\t", "  ");
        actions.add(DumbAwareAction.create((String)DataGridBundle.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]), e2 -> MessagesService.getInstance().showMessageDialog(project, null, message2, dialogTitle, new String[]{CommonBundle.getOkButtonText()}, 0, 0, icon, null, true, null)));
        return Pair.create((Object)text2.substring(0, maxLen), actions);
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message2 = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUtil.computeMessage(context)), (String)DatabaseBundle.message("notification.content.connection.successful", new Object[0]));
        List fixes = context.getErrorHandler().getFixes();
        DataSourceUtil.showNotification(context.getProject(), context.getDataSource().getName(), message2 + (isError ? "" : DataSourceUtil.getElapsedString(elapsedTime)), isError, fixes);
    }

    private static void showOutdatedCheckErrorNotification(LoaderContext context, long elapsedTime) {
        String message2 = DataSourceUtil.computeMessage(context);
        String title = context.getDataSource().getName();
        Pair<String, @NotNull Collection<AnAction>> pair = DataSourceUtil.truncatePopupMessageIfNeeded(context.getProject(), message2 + DataSourceUtil.getElapsedString(elapsedTime), DatabaseBundle.message("message.title.connection.error", new Object[0]), UIUtil.getErrorIcon(), context.getErrorHandler().getFixes());
        ((Collection)pair.second).add(DumbAwareAction.create((String)DatabaseBundle.message("action.disable.outdated.object.notification.text", new Object[0]), e2 -> {
            context.getDataSource().setCheckOutdated(false);
            DataSourceStorage.getProjectStorage(context.getProject()).updateDataSource(context.getDataSource());
            Notification.get((AnActionEvent)e2).expire();
        }));
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DatabaseBundle.message("notification.content.br.you.can.href.disable.disable.outdated.object.notification", pair.first), NotificationType.WARNING).addActions((Collection)pair.second).setDisplayId("OutdatedCheck.failed").notify(context.getProject());
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        int n = context.countTasks();
        if (isError) {
            String summary = context.getErrorHandler().getSummary();
            String string = DataSourceUtil.escapeAngleBrackets(summary);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (n > 0) {
            String string = ApplicationManager.getApplication().isInternal() ? DatabaseBundle.message("notification.content.synchronized", n) : DatabaseBundle.message("notification.content.synchronization.successful", new Object[0]);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = DataSourceUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\n" + DatabaseBundle.message("notification.content.connection.successful", new Object[0]);
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String escapeAngleBrackets(String message2) {
        return message2.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + NlsMessages.formatDuration((long)elapsedTime) + ")" : "";
    }

    @NlsSafe
    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(LocalDateTime.now()) + "] ";
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean isTransactionsSupported(@NotNull Dbms family) {
        if (family == null) {
            DataSourceUtil.$$$reportNull$$$0(17);
        }
        return DbImplUtilCore.getJdbcHelper(family).supportsTransactions();
    }

    public static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DasDataSource dataSource2) {
        if (dbFacade == null) {
            DataSourceUtil.$$$reportNull$$$0(18);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(19);
        }
        return dbFacade.findDataSource(dataSource2.getUniqueId()) != null;
    }

    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull List<? extends IntrospectionTask> tasks) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(20);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(21);
        }
        if (tasks == null) {
            DataSourceUtil.$$$reportNull$$$0(22);
        }
        LoaderContext context = LoaderContext.selectTasks(project, dataSource2, tasks);
        return DataSourceUtil.performManualSyncTask(context);
    }

    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(23);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
        AsyncTask<SyncQueue.SyncResult> result2 = DataSourceSyncManager.getInstance().tryPerform(context, true, true);
        if (result2 == null) {
            AsyncTask<SyncQueue.SyncResult> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                DataSourceUtil.$$$reportNull$$$0(24);
            }
            return asyncTask;
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = result2.whenComplete(null, (r, e2) -> {
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e2)) {
                DataSourceUtil.showNotification(context.getProject(), context.getDataSource().getName(), DatabaseBundle.message("notification.content.cancelled", new Object[0]), false, Collections.emptyList());
            } else {
                DataSourceUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(25);
        }
        return asyncTask;
    }

    @Nullable
    public static AsyncTask<SyncQueue.SyncResult> applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(26);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(27);
        }
        return DataSourceSyncManager.getInstance().applyMappings(project, dataSource2);
    }

    public static boolean setNamespacesVisible(Project project, LocalDataSource dataSource2, Iterable<? extends BasicNamespace> selectedValues, boolean visible) {
        return DataSourceUtil.setPathsVisible(project, dataSource2, (Iterable<ObjectPath>)JBIterable.from(selectedValues).map(ObjectPaths::of), visible);
    }

    public static boolean setPathsVisible(Project project, LocalDataSource dataSource2, Iterable<ObjectPath> paths2, boolean visible) {
        TreePattern newScope;
        TreePattern objects2 = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(paths2).map(TreePatternUtils::create));
        TreePattern scope = dataSource2.getIntrospectionScope();
        TreePattern treePattern = newScope = visible ? TreePatternUtils.union(scope, objects2) : TreePatternUtils.minus(scope, objects2);
        if (scope.equals(newScope)) {
            return false;
        }
        dataSource2.setIntrospectionScope(newScope);
        DbSrcUtils.getDataSourceStorage(dataSource2.isGlobal() ? null : project).updateDataSource(dataSource2);
        DataSourceUtil.applyMappings(project, dataSource2);
        return true;
    }

    public static void resultSetToString(@NotNull String title, @NotNull RemoteResultSet resultSet, int size, @NotNull Dbms dbms, @NotNull DataExtractor extractor, @NotNull Out out) throws Exception {
        if (title == null) {
            DataSourceUtil.$$$reportNull$$$0(28);
        }
        if (resultSet == null) {
            DataSourceUtil.$$$reportNull$$$0(29);
        }
        if (dbms == null) {
            DataSourceUtil.$$$reportNull$$$0(30);
        }
        if (extractor == null) {
            DataSourceUtil.$$$reportNull$$$0(31);
        }
        if (out == null) {
            DataSourceUtil.$$$reportNull$$$0(32);
        }
        DataConsumer.Column[] columns2 = JdbcEngineUtils.getColumnDescriptors(resultSet, dbms);
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        RemoteResultSet.DataRetrievingOptions options2 = new RemoteResultSet.DataRetrievingOptions(size, maxLobLength, false);
        List data = resultSet.getObjects(options2);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create((int)i2, (Object[])((Object[])data.get(i2))));
        }
        out.appendText((CharSequence)String.format(title, data.size()));
        GridExtractorsUtilCore.extract((Out)out, Arrays.asList(columns2), (DataExtractor)extractor, rows, (int[])new int[0]);
    }

    public static void tryLoadFirstNRows(String title, DatabaseConnection connection2, String query, Out out, int rows) throws Exception {
        if (connection2 == null) {
            return;
        }
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
            DatabaseObjectNormalizer normalizer = new DatabaseObjectNormalizer(connection2.getDbms());
            DbObjectFormatter converter = new DbObjectFormatter(connection2.getDbms(), (ObjectNormalizer)normalizer){
                final /* synthetic */ ObjectNormalizer val$normalizer;
                {
                    this.val$normalizer = objectNormalizer;
                    super(arg0);
                }

                @Nullable
                public String objectToString(@Nullable Object o2, GridColumn column2, @NotNull ObjectFormatterConfig config) {
                    Object o1;
                    if (config == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((o1 = this.val$normalizer.objectToObject(o2, column2)) instanceof ImageInfo) {
                        ImageInfo info2 = (ImageInfo)o1;
                        String s2 = super.objectToString((Object)info2.stripBytes(), column2, config);
                        return DbDocumentationHelper.createImageRefTag(info2, s2);
                    }
                    String s3 = super.objectToString(o1, column2, config);
                    return HtmlValuesExtractor.escapeChars((String)s3);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/util/DataSourceUtil$1", "objectToString"));
                }
            };
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)EditorColors.DOCUMENTATION_COLOR));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, (ObjectFormatter)converter);
            DataSourceUtil.resultSetToString(title, rs, rows, connection2.getDbms(), (DataExtractor)extractor, out);
        })));
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection2, String query, @Nls StringBuilder sb, int rows) {
        try {
            Out.Readable out = new Out.Readable();
            DataSourceUtil.tryLoadFirstNRows("", connection2, query, (Out)out, rows);
            sb.append(out.getString());
        }
        catch (Exception e2) {
            DataSourceUtil.exceptionToHtml(e2, DatabaseBundle.message("documentation.unable.to.load.data", new Object[0]), sb);
        }
    }

    @NotNull
    public static StringBuilder exceptionToHtml(Exception e2, @Nls String str, @Nls StringBuilder sb) {
        StringBuilder stringBuilder = sb.append(str).append(":<br>").append("<code>").append(e2).append("</code><br>");
        if (stringBuilder == null) {
            DataSourceUtil.$$$reportNull$$$0(33);
        }
        return stringBuilder;
    }

    @NotNull
    public static Promise<?> promiseFacadeUpdate(@NotNull DbPsiFacade facade, @Nullable Disposable parent2) {
        if (facade == null) {
            DataSourceUtil.$$$reportNull$$$0(34);
        }
        AsyncPromise p2 = new AsyncPromise();
        Disposable listenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)parent2, (Object)facade.getProject())), (Disposable)listenerDisposable);
        facade.getProject().getMessageBus().connect(listenerDisposable).subscribe(DbPsiFacade.TOPIC, o2 -> {
            Disposer.dispose((Disposable)listenerDisposable);
            p2.setResult(null);
        });
        AsyncPromise asyncPromise = p2;
        if (asyncPromise == null) {
            DataSourceUtil.$$$reportNull$$$0(35);
        }
        return asyncPromise;
    }

    public static List<BeforeRunTask<?>> instantiateBeforeTasks(ConsoleRunConfiguration runConfiguration, List<LocalDataSource.BeforeTask> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.instantiateBeforeRunTask(runConfiguration, t));
    }

    @Nullable
    private static BeforeRunTask<?> instantiateBeforeRunTask(ConsoleRunConfiguration runConfiguration, LocalDataSource.BeforeTask t) {
        BeforeRunTask task;
        BeforeRunTaskProvider<BeforeRunTask<?>> provider = DataSourceUtil.getProvider(runConfiguration.getProject(), t.providerId);
        BeforeRunTask beforeRunTask = task = provider == null ? null : provider.createTask((RunConfiguration)runConfiguration);
        if (task != null) {
            if (task instanceof PersistentStateComponent) {
                XmlSerializer.deserializeAndLoadState((PersistentStateComponent)((PersistentStateComponent)task), (Element)t.serialized);
            } else {
                task.readExternal(t.serialized);
            }
        }
        return task;
    }

    public static List<LocalDataSource.BeforeTask> storeBeforeTasks(List<BeforeRunTask<?>> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.storeBeforeRunTask(t));
    }

    @NotNull
    private static LocalDataSource.BeforeTask storeBeforeRunTask(BeforeRunTask<?> task) {
        Element rt = new Element("task");
        if (task instanceof PersistentStateComponent) {
            XmlSerializer.serializeStateInto((PersistentStateComponent)((PersistentStateComponent)task), (Element)rt);
        } else {
            task.writeExternal(rt);
        }
        return new LocalDataSource.BeforeTask(task.getProviderId().toString(), rt);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String getEffectiveUrl(@NotNull Project project, @NotNull RawConnectionConfig dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(36);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(37);
        }
        if (dataSource2 instanceof LocalDataSource) {
            DatabaseConnectionInterceptor.ProtoConnection proto2 = DataSourceUtil.getProtoConnection(project, (LocalDataSource)dataSource2);
            return proto2 == null ? null : proto2.getUrl();
        }
        return dataSource2.getUrl();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static DatabaseConnectionInterceptor.ProtoConnection getProtoConnection(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(38);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(39);
        }
        try {
            return DataSourceUtil.getProtoConnectionAsync(project, dataSource2).toFuture().get();
        }
        catch (Exception e2) {
            ExceptionUtil.rethrow((Throwable)e2);
            return null;
        }
    }

    @NotNull
    public static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> getProtoConnectionAsync(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(40);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(41);
        }
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = DatabaseConnectionEstablisher.processInterceptors2(ConsoleRunConfiguration.newConfiguration(project), dataSource2, null, true, false);
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(42);
        }
        return asyncTask;
    }

    public static Promise<?> deactivate(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(43);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(44);
        }
        return DataSourceUtil.deactivate(project, dataSource2, null);
    }

    public static Promise<?> deactivate(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ConsoleRunConfiguration configuration) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(45);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(46);
        }
        if (configuration == null) {
            dataSource2.clearIntrospectionCache();
        }
        List<DatabaseSession> sessions2 = DatabaseSessionManager.getSessions(project, dataSource2, configuration);
        Promise cancel2 = Promises.all((Collection)ContainerUtil.map(sessions2, SessionsUtil::cancel), (Object)true);
        cancel2.then(unused -> JdbcDriverManager.getDriverManager(project).releaseDriver(dataSource2, configuration));
        return Promises.all((Collection)ContainerUtil.map(sessions2, SessionsUtil::disconnect), (Object)true);
    }

    public static boolean isActive(@NotNull Project project, LocalDataSource local) {
        JdbcDriverManager manager;
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(47);
        }
        return !(manager = JdbcDriverManager.getDriverManager(project)).getActiveConfigurations(local).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 10, 13, 14, 15, 16, 24, 25, 33, 35, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 33: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 4: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 19: 
            case 21: 
            case 27: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "eventDispatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDataSourceInfoString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTime";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "exceptionToHtml";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseFacadeUpdate";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtoConnectionAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "eventDispatcher";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 33: 
            case 35: 
            case 42: {
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "truncatePopupMessageIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTransactionsSupported";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resultSetToString";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "promiseFacadeUpdate";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveUrl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getProtoConnection";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getProtoConnectionAsync";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 10, 13, 14, 15, 16, 24, 25, 33, 35, 42 -> new IllegalStateException(string);
        };
    }
}

