/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.Case;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Casing {
    public final Case plain;
    public final Case quoted;
    public static final Casing EXACT = Casing.create(Case.EXACT, Case.EXACT);

    @NotNull
    public static Casing create(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            Casing.$$$reportNull$$$0(0);
        }
        if (quoted == null) {
            Casing.$$$reportNull$$$0(1);
        }
        return new Casing(plain, quoted);
    }

    private Casing(@NotNull Case plain, @NotNull Case quoted) {
        if (plain == null) {
            Casing.$$$reportNull$$$0(2);
        }
        if (quoted == null) {
            Casing.$$$reportNull$$$0(3);
        }
        this.plain = plain;
        this.quoted = quoted;
    }

    @NotNull
    public Case choose(boolean isPlain) {
        Case case_ = isPlain ? this.plain : this.quoted;
        if (case_ == null) {
            Casing.$$$reportNull$$$0(4);
        }
        return case_;
    }

    @NotNull
    public String specification() {
        if (this.quoted == Case.EXACT) {
            return Casing.caseToString(this.plain);
        }
        String string = Casing.caseToString(this.plain) + "/" + Casing.caseToString(this.quoted);
        if (string == null) {
            Casing.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Casing of(@Nullable String str) {
        if (str == null) {
            Casing casing = EXACT;
            if (casing == null) {
                Casing.$$$reportNull$$$0(6);
            }
            return casing;
        }
        String[] items2 = str.split("/");
        int n = items2.length;
        Case c1 = n >= 1 ? Casing.caseFromString(items2[0]) : Case.EXACT;
        Case c2 = n >= 2 ? Casing.caseFromString(items2[1]) : Case.EXACT;
        return Casing.create(c1, c2);
    }

    @NotNull
    private static String caseToString(@NotNull Case caze) {
        if (caze == null) {
            Casing.$$$reportNull$$$0(7);
        }
        String string = StringUtil.toLowerCase((String)caze.name());
        if (string == null) {
            Casing.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static Case caseFromString(@NotNull String str) {
        if (str == null) {
            Casing.$$$reportNull$$$0(9);
        }
        char c2 = str.length() >= 1 ? Character.toLowerCase(str.charAt(0)) : (char)'\u0000';
        Case case_ = switch (c2) {
            case 'm' -> Case.MIXED;
            case 'u' -> Case.UPPER;
            case 'l' -> Case.LOWER;
            default -> Case.EXACT;
        };
        if (case_ == null) {
            Casing.$$$reportNull$$$0(10);
        }
        return case_;
    }

    public String toString() {
        return this.specification();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Casing casing = (Casing)o2;
        return this.plain == casing.plain && this.quoted == casing.quoted;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plain, this.quoted});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plain";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/Casing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caze";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/Casing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "specification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "caseToString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "caseFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "caseToString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "caseFromString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

