/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0012\u0010\u000f\u001a\f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u000eH\u0016J\u000f\u0010\u0011\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0012H\u0016J\u000f\u0010\u0013\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/types/DasTypeReferenceBase;", "Lcom/intellij/database/types/DasTypeReference;", "Lcom/intellij/database/types/DasTypeClass;", "dataType", "Lcom/intellij/database/model/DataType;", "(Lcom/intellij/database/model/DataType;)V", "getDataType", "()Lcom/intellij/database/model/DataType;", "equals", "", "other", "", "getDescription", "", "Lorg/jetbrains/annotations/NotNull;", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "getPackageName", "Lorg/jetbrains/annotations/Nullable;", "getSchemaName", "getTypeClass", "hashCode", "", "toDataType", "intellij.database.core.impl"})
public abstract class DasTypeReferenceBase
implements DasTypeReference,
DasTypeClass {
    @NotNull
    private final DataType dataType;

    protected DasTypeReferenceBase(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        this.dataType = dataType;
    }

    @NotNull
    protected final DataType getDataType() {
        return this.dataType;
    }

    @Override
    @NotNull
    public DataType toDataType() {
        return this.dataType;
    }

    @Override
    @NotNull
    public DasTypeReferenceBase getTypeClass() {
        return this;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.dataType.schemaName;
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.dataType.packageName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.dataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.getSpecification();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecification(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof DasTypeReferenceBase && Intrinsics.areEqual((Object)this.dataType, (Object)((DasTypeReferenceBase)other).dataType);
    }

    public int hashCode() {
        return this.dataType.hashCode();
    }
}

