/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeInternerKt;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\r\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecision;", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "typeClass", "precision", "", "scale", "(Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;II)V", "copy", "equals", "", "other", "", "getDescription", "", "getPrecision", "getScale", "getTypeClass", "hashCode", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "withTypeClass", "newTypeClass", "Companion", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithPrecisionImpl
implements DasBuiltinTypeWithPrecision<DasSimpleBuiltinTypeClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DasSimpleBuiltinTypeClass typeClass;
    private final int precision;
    private final int scale;

    private DasBuiltinTypeWithPrecisionImpl(DasSimpleBuiltinTypeClass typeClass, int precision, int scale) {
        this.typeClass = typeClass;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinTypeClass getTypeClass() {
        return this.typeClass;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @NotNull
    public DasBuiltinTypeWithPrecisionImpl copy(int precision, int scale) {
        return Companion.of(this.typeClass, precision, scale);
    }

    @NotNull
    public DasBuiltinTypeWithPrecisionImpl withTypeClass(@NotNull DasSimpleBuiltinTypeClass newTypeClass) {
        Intrinsics.checkNotNullParameter((Object)newTypeClass, (String)"newTypeClass");
        return Companion.of(newTypeClass, this.precision, this.scale);
    }

    @Override
    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        String string = DasTypeUtilsKt.renderSize(this.precision);
        if (string == null) {
            return DasTypeUtilsKt.getDebugName(this.typeClass);
        }
        String precisionStr = string;
        String scaleStr = DasTypeUtilsKt.renderScale(this.scale);
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append(DasTypeUtilsKt.getDebugName(this.typeClass));
        $this$getDescription_u24lambda_u240.append("(");
        $this$getDescription_u24lambda_u240.append(precisionStr);
        if (scaleStr != null) {
            $this$getDescription_u24lambda_u240.append(", ").append(scaleStr);
        }
        $this$getDescription_u24lambda_u240.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.typeClass.getName(), this.precision, this.scale, null, null, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.database.types.DasBuiltinTypeWithPrecisionImpl");
        DasBuiltinTypeWithPrecisionImpl cfr_ignored_0 = (DasBuiltinTypeWithPrecisionImpl)other;
        if (!Intrinsics.areEqual((Object)this.typeClass, (Object)((DasBuiltinTypeWithPrecisionImpl)other).typeClass)) {
            return false;
        }
        if (this.precision != ((DasBuiltinTypeWithPrecisionImpl)other).precision) {
            return false;
        }
        return this.scale == ((DasBuiltinTypeWithPrecisionImpl)other).scale;
    }

    public int hashCode() {
        int result2 = this.typeClass.hashCode();
        result2 = 31 * result2 + this.precision;
        result2 = 31 * result2 + this.scale;
        return result2;
    }

    public /* synthetic */ DasBuiltinTypeWithPrecisionImpl(DasSimpleBuiltinTypeClass typeClass, int precision, int scale, DefaultConstructorMarker $constructor_marker) {
        this(typeClass, precision, scale);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl$Companion;", "", "()V", "of", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "typeClass", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "precision", "", "scale", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasBuiltinTypeWithPrecisionImpl of(@NotNull DasSimpleBuiltinTypeClass typeClass, int precision, int scale) {
            Intrinsics.checkNotNullParameter((Object)typeClass, (String)"typeClass");
            return (DasBuiltinTypeWithPrecisionImpl)DasTypeInternerKt.intern((DasType)new DasBuiltinTypeWithPrecisionImpl(typeClass, precision, scale, null));
        }

        public static /* synthetic */ DasBuiltinTypeWithPrecisionImpl of$default(Companion companion, DasSimpleBuiltinTypeClass dasSimpleBuiltinTypeClass, int n, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n = -1;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.of(dasSimpleBuiltinTypeClass, n, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

