/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.panels.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "", "callback", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "uiOptions", "Ljava/util/SortedSet;", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$UiOption;", "uiOptionsModifying", "Ljava/util/concurrent/atomic/AtomicInteger;", "adjustOptionsUI", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "currentOptions", "Lcom/intellij/database/script/generator/ScriptingOptions;", "adjustOptionsVisibility", "changingUiOptions", "op", "gatherOptions", "prepareOptionComponents", "processOptionChange", "LabeledComponent", "OptionGroup", "UiOption", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nScriptOptionsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptOptionsPanel.kt\ncom/intellij/database/script/generator/ui/ScriptOptionsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,156:1\n1855#2,2:157\n37#3,2:159\n*S KotlinDebug\n*F\n+ 1 ScriptOptionsPanel.kt\ncom/intellij/database/script/generator/ui/ScriptOptionsPanel\n*L\n26#1:157,2\n82#1:159,2\n*E\n"})
public final class ScriptOptionsPanel {
    @NotNull
    private final Function0<Unit> callback;
    @NotNull
    private final JComponent component;
    @NotNull
    private final SortedSet<UiOption> uiOptions;
    @NotNull
    private final AtomicInteger uiOptionsModifying;

    public ScriptOptionsPanel(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
        this.component = new JPanel((LayoutManager)new VerticalLayout(4), false);
        this.uiOptionsModifying = new AtomicInteger(0);
        this.uiOptions = this.prepareOptionComponents();
        Iterable $this$forEach$iv = this.uiOptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UiOption it2 = (UiOption)element$iv;
            boolean bl = false;
            this.component.add(it2.getComponent());
        }
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void adjustOptionsVisibility(@Nullable ScriptingTask task) {
        this.changingUiOptions((Function0<Unit>)((Function0)new Function0<Unit>(task, this){
            final /* synthetic */ ScriptingTask $task;
            final /* synthetic */ ScriptOptionsPanel this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Set<ScriptingOption<?>> set;
                ScriptingTask scriptingTask = this.$task;
                Dbms dbms = scriptingTask != null ? ScriptingTaskKt.getDbms(scriptingTask) : null;
                ScriptingTask scriptingTask2 = this.$task;
                ScriptCategory category = scriptingTask2 != null ? scriptingTask2.getCategory() : null;
                ScriptingTask scriptingTask3 = this.$task;
                if (scriptingTask3 != null) {
                    ScriptingTask it2 = scriptingTask3;
                    boolean bl = false;
                    set = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(ScriptingTaskKt.getDbms(it2))).availableOptions(it2);
                } else {
                    set = null;
                }
                Set<ScriptingOption<?>> providedOptions = set;
                Iterable $this$forEach$iv = ScriptOptionsPanel.access$getUiOptions$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UiOption it3 = (UiOption)element$iv;
                    boolean bl = false;
                    JComponent component2 = it3.getComponent();
                    ScriptingOption<?> option = it3.getOption();
                    component2.setVisible(CollectionsKt.contains((Iterable)option.getApplicableCategories(), (Object)((Object)category)) && dbms != null && option.getApplicableDbs().value((Object)dbms) && (providedOptions == null || providedOptions.contains(option)));
                }
            }
        }));
        this.component.revalidate();
    }

    public final void adjustOptionsUI(@Nullable ScriptingTask task, @NotNull ScriptingOptions currentOptions) {
        Intrinsics.checkNotNullParameter((Object)currentOptions, (String)"currentOptions");
        this.changingUiOptions((Function0<Unit>)((Function0)new Function0<Unit>(this, task, currentOptions){
            final /* synthetic */ ScriptOptionsPanel this$0;
            final /* synthetic */ ScriptingTask $task;
            final /* synthetic */ ScriptingOptions $currentOptions;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                this.$currentOptions = $currentOptions;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                this.this$0.adjustOptionsVisibility(this.$task);
                Iterable iterable = ScriptOptionsPanel.access$getUiOptions$p(this.this$0);
                ScriptingOptions scriptingOptions = this.$currentOptions;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UiOption it2 = (UiOption)element$iv;
                    boolean bl = false;
                    JComponent component2 = it2.getComponent();
                    ScriptingOption<?> option = it2.getOption();
                    it2.setValue(scriptingOptions.get(option));
                    if (option.isBoolean()) {
                        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JCheckBox");
                        JCheckBox jCheckBox = (JCheckBox)component2;
                        Object object = it2.getValue();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                        jCheckBox.setSelected((Boolean)object);
                        continue;
                    }
                    if (!option.isEnum()) continue;
                    Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.database.script.generator.ui.ScriptOptionsPanel.LabeledComponent");
                    JComponent jComponent = ((LabeledComponent)component2).getComponent();
                    Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.ComboBox<*>");
                    ((ComboBox)jComponent).setSelectedItem(it2.getValue());
                }
            }
        }));
        this.component.revalidate();
    }

    @NotNull
    public final ScriptingOptions gatherOptions() {
        TreeMap map2 = new TreeMap();
        for (UiOption o2 : this.uiOptions) {
            if (Intrinsics.areEqual((Object)o2.getValue(), o2.getOption().getDefaultValue())) continue;
            ((Map)map2).put(o2.getOption(), o2.getValue());
        }
        return map2.isEmpty() ? (ScriptingOptions)DefaultScriptingOptions.INSTANCE : (ScriptingOptions)new CustomScriptingOptions(map2);
    }

    private final void processOptionChange() {
        if (this.uiOptionsModifying.get() > 0) {
            return;
        }
        this.callback.invoke();
    }

    private final SortedSet<UiOption> prepareOptionComponents() {
        TreeSet uiOptions = new TreeSet();
        for (ScriptingOption scriptingOption : ScriptingOptionStatic.SCRIPTING_OPTIONS) {
            Object o2;
            if (scriptingOption.isEnum()) {
                Collection $this$toTypedArray$iv = scriptingOption.getItems();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ComboBox itemSelector = new ComboBox(thisCollection$iv.toArray(new Object[0]));
                itemSelector.setToolTipText(scriptingOption.getDescription());
                LabeledComponent component2 = new LabeledComponent(scriptingOption.getDisplayName() + ":", (JComponent)itemSelector);
                component2.setVisible(false);
                Intrinsics.checkNotNull((Object)scriptingOption);
                o2 = new UiOption(OptionGroup.SELECTOR, scriptingOption, component2, scriptingOption.getDefaultValue());
                itemSelector.addActionListener(arg_0 -> ScriptOptionsPanel.prepareOptionComponents$lambda$1(o2, itemSelector, scriptingOption, this, arg_0));
                ((Collection)uiOptions).add(o2);
                continue;
            }
            if (!scriptingOption.isBoolean()) continue;
            o2 = scriptingOption.getDefaultValue();
            Boolean bl = o2 instanceof Boolean ? (Boolean)o2 : null;
            boolean checked = bl != null ? bl : false;
            JCheckBox checkbox = ComponentsKt.CheckBox$default((String)scriptingOption.getDisplayName(), (boolean)checked, null, (int)4, null);
            checkbox.setToolTipText(scriptingOption.getDescription());
            Intrinsics.checkNotNull((Object)scriptingOption);
            UiOption o3 = new UiOption(OptionGroup.CHECKBOX, scriptingOption, checkbox, scriptingOption.getDefaultValue());
            checkbox.setVisible(false);
            checkbox.addActionListener(arg_0 -> ScriptOptionsPanel.prepareOptionComponents$lambda$2(o3, checkbox, this, arg_0));
            ((Collection)uiOptions).add(o3);
        }
        return uiOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changingUiOptions(Function0<Unit> op) {
        this.uiOptionsModifying.incrementAndGet();
        try {
            op.invoke();
        }
        finally {
            this.uiOptionsModifying.decrementAndGet();
        }
    }

    private static final void prepareOptionComponents$lambda$1(UiOption $o, ComboBox $itemSelector, ScriptingOption $option, ScriptOptionsPanel this$0, ActionEvent it2) {
        Intrinsics.checkNotNullParameter((Object)$o, (String)"$o");
        Intrinsics.checkNotNullParameter((Object)$itemSelector, (String)"$itemSelector");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = $itemSelector.getSelectedItem();
        Enum enum_ = object instanceof Enum ? (Enum)object : null;
        if (enum_ == null) {
            enum_ = $option.getDefaultValue();
        }
        $o.setValue(enum_);
        this$0.processOptionChange();
    }

    private static final void prepareOptionComponents$lambda$2(UiOption $o, JCheckBox $checkbox, ScriptOptionsPanel this$0, ActionEvent it2) {
        Intrinsics.checkNotNullParameter((Object)$o, (String)"$o");
        Intrinsics.checkNotNullParameter((Object)$checkbox, (String)"$checkbox");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $o.setValue($checkbox.isSelected());
        this$0.processOptionChange();
    }

    public static final /* synthetic */ SortedSet access$getUiOptions$p(ScriptOptionsPanel $this) {
        return $this.uiOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$LabeledComponent;", "Ljavax/swing/JPanel;", "labelText", "", "component", "Ljavax/swing/JComponent;", "(Ljava/lang/String;Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "intellij.database.impl"})
    public static final class LabeledComponent
    extends JPanel {
        @NotNull
        private final JComponent component;
        @NotNull
        private final JLabel label;

        public LabeledComponent(@NlsContexts.Label @NotNull String labelText, @NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            super(new BorderLayout(), false);
            this.component = component2;
            this.label = new JLabel(labelText + " ");
            this.add((Component)this.label, "West");
            this.add((Component)this.component, "Center");
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@Nullable MouseEvent e2) {
                    this.getComponent().requestFocus();
                }
            });
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final JLabel getLabel() {
            return this.label;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$OptionGroup;", "", "(Ljava/lang/String;I)V", "SELECTOR", "CHECKBOX", "intellij.database.impl"})
    private static final class OptionGroup
    extends Enum<OptionGroup> {
        public static final /* enum */ OptionGroup SELECTOR = new OptionGroup();
        public static final /* enum */ OptionGroup CHECKBOX = new OptionGroup();
        private static final /* synthetic */ OptionGroup[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OptionGroup[] values() {
            return (OptionGroup[])$VALUES.clone();
        }

        public static OptionGroup valueOf(String value2) {
            return Enum.valueOf(OptionGroup.class, value2);
        }

        @NotNull
        public static EnumEntries<OptionGroup> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = optionGroupArray = new OptionGroup[]{OptionGroup.SELECTOR, OptionGroup.CHECKBOX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0016H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$UiOption;", "", "groupOrder", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$OptionGroup;", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "component", "Ljavax/swing/JComponent;", "value", "", "(Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$OptionGroup;Lcom/intellij/database/script/generator/ScriptingOption;Ljavax/swing/JComponent;Ljava/lang/Object;)V", "getComponent", "()Ljavax/swing/JComponent;", "getGroupOrder", "()Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel$OptionGroup;", "getOption", "()Lcom/intellij/database/script/generator/ScriptingOption;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "", "intellij.database.impl"})
    private static final class UiOption
    implements Comparable<UiOption> {
        @NotNull
        private final OptionGroup groupOrder;
        @NotNull
        private final ScriptingOption<?> option;
        @NotNull
        private final JComponent component;
        @NotNull
        private Object value;

        public UiOption(@NotNull OptionGroup groupOrder, @NotNull ScriptingOption<?> option, @NotNull JComponent component2, @NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)groupOrder), (String)"groupOrder");
            Intrinsics.checkNotNullParameter(option, (String)"option");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.groupOrder = groupOrder;
            this.option = option;
            this.component = component2;
            this.value = value2;
        }

        @NotNull
        public final OptionGroup getGroupOrder() {
            return this.groupOrder;
        }

        @NotNull
        public final ScriptingOption<?> getOption() {
            return this.option;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.value = object;
        }

        @Override
        public int compareTo(@NotNull UiOption other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        }

        @NotNull
        public final OptionGroup component1() {
            return this.groupOrder;
        }

        @NotNull
        public final ScriptingOption<?> component2() {
            return this.option;
        }

        @NotNull
        public final JComponent component3() {
            return this.component;
        }

        @NotNull
        public final Object component4() {
            return this.value;
        }

        @NotNull
        public final UiOption copy(@NotNull OptionGroup groupOrder, @NotNull ScriptingOption<?> option, @NotNull JComponent component2, @NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)groupOrder), (String)"groupOrder");
            Intrinsics.checkNotNullParameter(option, (String)"option");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new UiOption(groupOrder, option, component2, value2);
        }

        public static /* synthetic */ UiOption copy$default(UiOption uiOption, OptionGroup optionGroup, ScriptingOption scriptingOption, JComponent jComponent, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                optionGroup = uiOption.groupOrder;
            }
            if ((n & 2) != 0) {
                scriptingOption = uiOption.option;
            }
            if ((n & 4) != 0) {
                jComponent = uiOption.component;
            }
            if ((n & 8) != 0) {
                object = uiOption.value;
            }
            return uiOption.copy(optionGroup, scriptingOption, jComponent, object);
        }

        @NotNull
        public String toString() {
            return "UiOption(groupOrder=" + this.groupOrder + ", option=" + this.option + ", component=" + this.component + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.groupOrder.hashCode();
            result2 = result2 * 31 + this.option.hashCode();
            result2 = result2 * 31 + this.component.hashCode();
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UiOption)) {
                return false;
            }
            UiOption uiOption = (UiOption)other;
            if (this.groupOrder != uiOption.groupOrder) {
                return false;
            }
            if (!Intrinsics.areEqual(this.option, uiOption.option)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.component, (Object)uiOption.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)uiOption.value);
        }
    }
}

