/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ui.ScriptFileLayoutPanel;
import com.intellij.database.script.generator.ui.ScriptGeneratorSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0006*\u0001'\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u001bH\u0002J\r\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001f\u001a\u0004\u0018\u00010\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptFileLayoutPanel;", "", "settings", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "project", "Lcom/intellij/openapi/project/Project;", "generate", "Lkotlin/Function1;", "Lcom/intellij/database/script/generator/ScriptConsumer;", "", "onSettingsChanged", "Lkotlin/Function0;", "(Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "dumpBtn", "Ljavax/swing/JButton;", "layout", "", "getLayout", "()Ljava/lang/String;", "setLayout", "(Ljava/lang/String;)V", "layoutBox", "Lcom/intellij/openapi/ui/ComboBox;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "layoutModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "path", "getPath", "setPath", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "createConsumer", "layoutScript", "createLayoutActions", "com/intellij/database/script/generator/ui/ScriptFileLayoutPanel$createLayoutActions$1", "()Lcom/intellij/database/script/generator/ui/ScriptFileLayoutPanel$createLayoutActions$1;", "destination", "dump", "initializeOutputSettingsFields", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nScriptFileLayoutPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptFileLayoutPanel.kt\ncom/intellij/database/script/generator/ui/ScriptFileLayoutPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public final class ScriptFileLayoutPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<ScriptConsumer<?>, Unit> generate;
    @NotNull
    private final Function0<Unit> onSettingsChanged;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final CollectionComboBoxModel<Path> layoutModel;
    @NotNull
    private final ComboBox<Path> layoutBox;
    @NotNull
    private final JButton dumpBtn;
    @NotNull
    private final JComponent component;

    /*
     * WARNING - void declaration
     */
    public ScriptFileLayoutPanel(@NotNull ScriptGeneratorSettings settings, @NotNull Project project, @NotNull Function1<? super ScriptConsumer<?>, Unit> generate2, @NotNull Function0<Unit> onSettingsChanged) {
        void $this$pathField_u24lambda_u240;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(generate2, (String)"generate");
        Intrinsics.checkNotNullParameter(onSettingsChanged, (String)"onSettingsChanged");
        this.project = project;
        this.generate = generate2;
        this.onSettingsChanged = onSettingsChanged;
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        ScriptFileLayoutPanel scriptFileLayoutPanel = this;
        boolean bl = false;
        String[] stringArray = new String[]{"sql"};
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(DatabaseBundle.message("scriptGen.ui.dialog.title.selectFileToSaveScript", new Object[0]), "", stringArray);
        $this$pathField_u24lambda_u240.addBrowseFolderListener(descriptor2.getTitle(), descriptor2.getDescription(), this.project, (FileChooserDescriptor)descriptor2);
        scriptFileLayoutPanel.pathField = textFieldWithBrowseButton;
        List<Path> list = SchemaLayoutScripts.getScriptFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getScriptFiles(...)");
        this.layoutModel = new CollectionComboBoxModel(CollectionsKt.toMutableList((Collection)list));
        this.layoutBox = new ComboBox((ComboBoxModel)this.layoutModel);
        this.dumpBtn = new JButton(DatabaseBundle.message("button.dump", new Object[0]));
        String string = DatabaseBundle.message("unknown.in.angleBraces", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String unknownName = string;
        this.layoutBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)unknownName, arg_0 -> ScriptFileLayoutPanel._init_$lambda$1(1.INSTANCE, arg_0)));
        this.layoutBox.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e2) {
                List<Path> list = SchemaLayoutScripts.getScriptFiles();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getScriptFiles(...)");
                List<Path> files2 = list;
                if (Intrinsics.areEqual((Object)layoutModel.getItems(), files2)) {
                    return;
                }
                layoutModel.replaceAll(files2);
            }
        });
        JPanel layoutWrapper = new JPanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        layoutWrapper.add((Component)this.layoutBox);
        stringArray = new AnAction[]{this.createLayoutActions()};
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl("DbScriptGeneratorLayoutToolbar", (ActionGroup)new DefaultActionGroup((AnAction[])stringArray), true);
        layoutWrapper.add((Component)toolbar2);
        toolbar2.setTargetComponent((JComponent)toolbar2);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setForceMinimumSize(true);
        DataProvider dataProvider2 = new DataProvider(this){
            final /* synthetic */ ScriptFileLayoutPanel this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Object getData(@NotNull String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                return LangDataKeys.IDE_VIEW.is(dataId) ? this : null;
            }

            @NotNull
            public PsiDirectory[] getDirectories() {
                PsiDirectory[] psiDirectoryArray;
                PsiDirectory psiDirectory = this.getOrChooseDirectory();
                if (psiDirectory != null) {
                    PsiDirectory it2 = psiDirectory;
                    boolean bl = false;
                    PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[]{it2};
                    psiDirectoryArray = psiDirectoryArray2;
                } else {
                    boolean $i$f$emptyArray = false;
                    psiDirectoryArray = new PsiDirectory[]{};
                }
                return psiDirectoryArray;
            }

            @Nullable
            public PsiDirectory getOrChooseDirectory() {
                PsiDirectory psiDirectory;
                VirtualFile vDir;
                VirtualFile virtualFile;
                File dir;
                File file = dir = SchemaLayoutScripts.getScriptsDirectory();
                if (file != null) {
                    File it2 = file;
                    boolean bl = false;
                    virtualFile = LocalFileSystem.getInstance().findFileByIoFile(it2);
                } else {
                    virtualFile = null;
                }
                VirtualFile virtualFile2 = vDir = virtualFile;
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3 = virtualFile2;
                    ScriptFileLayoutPanel scriptFileLayoutPanel = this.this$0;
                    VirtualFile it3 = virtualFile3;
                    boolean bl = false;
                    psiDirectory = PsiManager.getInstance((Project)ScriptFileLayoutPanel.access$getProject$p(scriptFileLayoutPanel)).findDirectory(it3);
                } else {
                    psiDirectory = null;
                }
                return psiDirectory;
            }

            public void selectElement(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                PsiFile psiFile = element2 instanceof PsiFile ? (PsiFile)element2 : null;
                Object object = psiFile != null ? psiFile.getVirtualFile() : null;
                if (object == null) {
                    return;
                }
                VirtualFile vfile = object;
                new OpenFileDescriptor(ScriptFileLayoutPanel.access$getProject$p(this.this$0), vfile).navigate(true);
            }
        };
        DataManager.registerDataProvider((JComponent)((JComponent)toolbar2), (DataProvider)dataProvider2);
        JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.pathField)).withLabel(DatabaseBundle.message("scriptGen.ui.dialog.path", new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)layoutWrapper).withLabel(DatabaseBundle.message("scriptGen.ui.dialog.layout", new Object[0])).resizeX(false)).resize().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel properties2 = jPanel;
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToTop((Component)JBUI.Panels.simplePanel().addToTop((Component)properties2).addToLeft((Component)this.dumpBtn));
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToTop(...)");
        this.component = (JComponent)borderLayoutPanel;
        this.dumpBtn.addActionListener(arg_0 -> ScriptFileLayoutPanel._init_$lambda$2(this, arg_0));
        this.initializeOutputSettingsFields(settings);
        this.pathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                onSettingsChanged.invoke();
            }
        });
        this.layoutBox.addActionListener(arg_0 -> ScriptFileLayoutPanel._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final void initializeOutputSettingsFields(ScriptGeneratorSettings settings) {
        this.setPath(settings.getOutputPath());
        this.setLayout(settings.getOutputLayout());
    }

    private final createLayoutActions.1 createLayoutActions() {
        String string = DatabaseBundle.message("action.settings.text", new Object[0]);
        Icon icon = AllIcons.General.GearPlain;
        return new ActionGroup(this, string, icon){
            @NotNull
            private final AnAction[] c;
            {
                this.setPopup(true);
                AnAction[] anActionArray = new AnAction[2];
                anActionArray[0] = new CreateFileAction(DatabaseBundle.messagePointer("action.add.text", new Object[0]), DatabaseBundle.messagePointer("action.add.new.layout.script.description", new Object[0]), createLayoutActions.1::c$lambda$0);
                String string = DatabaseBundle.message("action.edit.text", new Object[0]);
                String string2 = DatabaseBundle.message("action.edit.layout.script.description", new Object[0]);
                Icon icon = AllIcons.Actions.EditSource;
                anActionArray[1] = new DumbAwareAction($receiver, string, string2, icon){
                    final /* synthetic */ ScriptFileLayoutPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }

                    public void update(@NotNull AnActionEvent e2) {
                        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                        e2.getPresentation().setEnabled(ScriptFileLayoutPanel.access$getLayoutBox$p(this.this$0).getItem() != null);
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.EDT;
                    }

                    public void actionPerformed(@NotNull AnActionEvent e2) {
                        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                        Path path = (Path)ScriptFileLayoutPanel.access$getLayoutBox$p(this.this$0).getItem();
                        if (path == null) {
                            return;
                        }
                        Path path2 = path;
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(path2);
                        if (virtualFile == null) {
                            return;
                        }
                        VirtualFile vfile = virtualFile;
                        new OpenFileDescriptor(ScriptFileLayoutPanel.access$getProject$p(this.this$0), vfile).navigate(true);
                    }
                };
                this.c = anActionArray;
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e2) {
                return this.c;
            }

            private static final Icon c$lambda$0() {
                return AllIcons.General.Add;
            }
        };
    }

    private final void dump() {
        Path path = (Path)this.layoutBox.getItem();
        if (path == null) {
            return;
        }
        Path script2 = path;
        ExtensionScriptsUtil.prepareScript((Path)script2);
        Project project = this.project;
        String string = DatabaseBundle.message("scriptGen.ui.generationStatus.generatingScriptToFile", new Object[0]);
        new Task.Backgroundable(this, script2, project, string){
            final /* synthetic */ ScriptFileLayoutPanel this$0;
            final /* synthetic */ Path $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    Notification notification;
                    VirtualFile virtualFile;
                    ScriptConsumer scriptConsumer = ScriptFileLayoutPanel.access$createConsumer(this.this$0, this.$script);
                    if (scriptConsumer == null) {
                        return;
                    }
                    ScriptConsumer consumer2 = scriptConsumer;
                    ScriptFileLayoutPanel.access$getGenerate$p(this.this$0).invoke((Object)consumer2);
                    VirtualFile virtualFile2 = VfsUtil.findFile((Path)ScriptFileLayoutPanel.access$destination(this.this$0), (boolean)true);
                    if (virtualFile2 != null) {
                        VirtualFile virtualFile3;
                        VirtualFile it2 = virtualFile3 = virtualFile2;
                        boolean bl = false;
                        VirtualFile[] virtualFileArray = new VirtualFile[]{it2};
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
                        virtualFile = virtualFile3;
                    } else {
                        virtualFile = null;
                    }
                    VirtualFile res2 = virtualFile;
                    String string = DatabaseBundle.message("scriptGen.ui.generationStatus.generationFinishedSuccessfully", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    Notification $this$run_u24lambda_u243 = notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, NotificationType.INFORMATION).setDisplayId("ScriptFileLayoutPanel.finished");
                    boolean bl = false;
                    VirtualFile virtualFile4 = res2;
                    if (virtualFile4 != null) {
                        VirtualFile it3 = virtualFile4;
                        boolean bl2 = false;
                        $this$run_u24lambda_u243.addAction((AnAction)DumbAwareAction.create((String)DatabaseBundle.message("action.open.folder.text", new Object[0]), arg_0 -> dump.1.run$lambda$3$lambda$2$lambda$1((Function1)new Function1<AnActionEvent, Unit>(res2){
                            final /* synthetic */ VirtualFile $res;
                            {
                                this.$res = $res;
                                super(1);
                            }

                            public final void invoke(AnActionEvent it2) {
                                RevealFileAction.openFile((Path)this.$res.toNioPath());
                            }
                        }, arg_0)));
                    }
                    notification.notify(this.getProject());
                }
                catch (Throwable t) {
                    String string = DatabaseBundle.message("scriptGen.ui.generationStatus.generationFinishedWithErrors", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String string2 = ExceptionUtil.getThrowableText((Throwable)t, (String)"com.intellij.");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
                    DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, string2, NotificationType.ERROR).setDisplayId("ScriptFileLayoutPanel.error").notify(this.getProject());
                }
            }

            private static final void run$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }.queue();
    }

    private final ScriptConsumer<?> createConsumer(Path layoutScript) {
        boolean bl;
        Path root2 = this.destination();
        if (Files.exists(root2, new LinkOption[0])) {
            bl = Files.isDirectory(root2, new LinkOption[0]);
        } else {
            String it2 = this.pathField.getText();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            bl = StringsKt.endsWith$default((String)it2, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it2, (String)"\\", (boolean)false, (int)2, null) || ((CharSequence)it2).length() == 0;
        }
        boolean isDirectory = bl;
        if (!isDirectory) {
            UIUtil.invokeLaterIfNeeded(() -> ScriptFileLayoutPanel.createConsumer$lambda$5(this));
            return null;
        }
        try {
            return ScriptedScriptConsumer.createScriptedConsumer(this.project, layoutScript, root2, (PairConsumer<Path, ScriptingResult>)((PairConsumer)ScriptFileLayoutPanel::createConsumer$lambda$6));
        }
        catch (IdeScriptException e2) {
            return null;
        }
    }

    private final Path destination() {
        Path path = Paths.get(FileUtil.toSystemDependentName((String)this.pathField.getText()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final String getPath() {
        return StringUtil.nullize((String)this.pathField.getText());
    }

    public final void setPath(@Nullable String path) {
        String string = path;
        if (string == null) {
            string = "";
        }
        this.pathField.setText(string);
    }

    @Nullable
    public final String getLayout() {
        Path path = (Path)this.layoutBox.getItem();
        return path != null ? PathsKt.getName((Path)path) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLayout(@Nullable String layout) {
        Path path;
        ComboBox<Path> comboBox = this.layoutBox;
        String string = layout;
        if (string != null) {
            void it2;
            String string2 = string;
            ComboBox<Path> comboBox2 = comboBox;
            boolean bl = false;
            path = SchemaLayoutScripts.findScript((String)it2);
            comboBox = comboBox2;
        } else {
            path = null;
        }
        comboBox.setItem(path);
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$2(ScriptFileLayoutPanel this$0, ActionEvent it2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dump();
    }

    private static final void _init_$lambda$3(ScriptFileLayoutPanel this$0, ActionEvent it2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onSettingsChanged.invoke();
    }

    private static final void createConsumer$lambda$5(ScriptFileLayoutPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JBLabel(DatabaseBundle.message("scriptGen.ui.wrongDirOFileSelected.expectedDirectory", new Object[0]))).setRequestFocus(false).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(RelativePoint.getSouthOf((JComponent)this$0.pathField.getChildComponent()), Balloon.Position.below);
    }

    private static final void createConsumer$lambda$6(Path file, ScriptingResult script2) {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(file, (CharSequence)script2.getScriptText(), StandardCharsets.UTF_8, openOptionArray);
    }

    public static final /* synthetic */ ComboBox access$getLayoutBox$p(ScriptFileLayoutPanel $this) {
        return $this.layoutBox;
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptFileLayoutPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ ScriptConsumer access$createConsumer(ScriptFileLayoutPanel $this, Path layoutScript) {
        return $this.createConsumer(layoutScript);
    }

    public static final /* synthetic */ Function1 access$getGenerate$p(ScriptFileLayoutPanel $this) {
        return $this.generate;
    }

    public static final /* synthetic */ Path access$destination(ScriptFileLayoutPanel $this) {
        return $this.destination();
    }
}

