/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H&J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020*2\b\u00101\u001a\u0004\u0018\u000102J\u000e\u00103\u001a\u00020*2\u0006\u00104\u001a\u000205R \u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u0082\u0001\u000267\u00a8\u00068"}, d2={"Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/model/basic/BasicModel;)V", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "setConsumer", "(Lcom/intellij/database/script/generator/ScriptConsumer;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "version", "Lcom/intellij/database/util/Version;", "getVersion", "()Lcom/intellij/database/util/Version;", "setVersion", "(Lcom/intellij/database/util/Version;)V", "build", "Lcom/intellij/database/script/generator/ScriptingTask;", "setCodeStyle", "", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "setCodeStyleFrom", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "setCurrentNamespace", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "setReformat", "fmt", "", "Lcom/intellij/database/script/generator/ScriptingAlterTaskBuilder;", "Lcom/intellij/database/script/generator/ScriptingSingleModelTaskBuilderBase;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nScriptingTaskBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingTaskBuilder.kt\ncom/intellij/database/script/generator/ScriptingTaskBuilder\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,125:1\n14#2:126\n14#2:127\n*S KotlinDebug\n*F\n+ 1 ScriptingTaskBuilder.kt\ncom/intellij/database/script/generator/ScriptingTaskBuilder\n*L\n60#1:126\n66#1:127\n*E\n"})
public abstract class ScriptingTaskBuilder {
    @NotNull
    private final BasicModel model;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private Version version;
    @Nullable
    private ScriptConsumer<?> consumer;
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;

    private ScriptingTaskBuilder(BasicModel model2) {
        this.model = model2;
        this.options = ScriptingTaskKt.defaultScriptingOptions(this.model);
        Version version = this.model.getRoot().getServerVersion();
        if (version == null) {
            Version version2 = Version.ZERO;
            version = version2;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"ZERO");
        }
        this.version = version;
        BasicDatabase basicDatabase = this.currentDatabase = this.model.getRoot().getCurrentDatabase();
        this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"<set-?>");
        this.version = version;
    }

    @Nullable
    public final ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    public final void setConsumer(@Nullable ScriptConsumer<?> scriptConsumer) {
        this.consumer = scriptConsumer;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = this.model.contains(db);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!Intrinsics.areEqual((Object)this.currentDatabase, (Object)db)) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s2) {
        if (s2 != null) {
            boolean bl = this.model.contains(s2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.setCurrentDatabase(s2.getDatabase());
            this.currentSchema = s2;
        } else {
            this.currentSchema = null;
        }
    }

    public final void setCurrentNamespace(@Nullable BasicNamespace nsp) {
        BasicNamespace basicNamespace = nsp;
        if (basicNamespace instanceof BasicSchema) {
            this.setCurrentSchema((BasicSchema)nsp);
        } else if (basicNamespace instanceof BasicDatabase) {
            this.setCurrentDatabase((BasicDatabase)nsp);
        } else {
            this.setCurrentSchema(null);
        }
    }

    public final void setCodeStyleFrom(@NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.setCodeStyle(ScriptingTaskBuilderKt.getCodeStyle(ds));
    }

    public final void setCodeStyle(@NotNull CodeStyleSettings codeStyleSettings) {
        DelegateScriptingOptions delegateScriptingOptions;
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        ScriptingOptions $this$asSafely$iv = this.options;
        boolean $i$f$asSafely = false;
        ScriptingOptions scriptingOptions = $this$asSafely$iv;
        if (!(scriptingOptions instanceof DelegateScriptingOptions)) {
            scriptingOptions = null;
        }
        if ((delegateScriptingOptions = (DelegateScriptingOptions)scriptingOptions) == null) {
            delegateScriptingOptions = new DelegateScriptingOptions(this.options);
        }
        DelegateScriptingOptions newOptions = delegateScriptingOptions;
        newOptions.set(ScriptingOptionStatic.CODE_STYLE, codeStyleSettings);
        this.options = newOptions;
    }

    public final void setReformat(boolean fmt) {
        DelegateScriptingOptions delegateScriptingOptions;
        ScriptingOptions $this$asSafely$iv = this.options;
        boolean $i$f$asSafely = false;
        ScriptingOptions scriptingOptions = $this$asSafely$iv;
        if (!(scriptingOptions instanceof DelegateScriptingOptions)) {
            scriptingOptions = null;
        }
        if ((delegateScriptingOptions = (DelegateScriptingOptions)scriptingOptions) == null) {
            delegateScriptingOptions = new DelegateScriptingOptions(this.options);
        }
        DelegateScriptingOptions newOptions = delegateScriptingOptions;
        newOptions.set(ScriptingOptionStatic.REFORMAT, fmt);
        this.options = newOptions;
    }

    @NotNull
    public abstract ScriptingTask build();

    public /* synthetic */ ScriptingTaskBuilder(BasicModel model2, DefaultConstructorMarker $constructor_marker) {
        this(model2);
    }
}

