/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.scopes.DbDataSourceScope;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.OffsetIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EmptyIcon;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSearchScopesProvider
implements SearchScopeProvider {
    @Nullable
    public String getDisplayName() {
        return DatabaseBundle.message("separator.data.sources", new Object[0]);
    }

    @NotNull
    public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(1);
        }
        ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
        JBTreeTraverser<Trie> traverser2 = DbSearchScopesProvider.buildTraverser(project);
        Trie rootNode = (Trie)traverser2.getRoot();
        int weight = 0;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        JBIterable forResolve = psiFile == null ? null : JBIterable.from((Iterable)SqlPsiFacade.getInstance((Project)project).getDataSources((PsiElement)psiFile));
        Set ids = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).append((Iterable)forResolve).map(o2 -> o2.getDataSource().getUniqueId()).toSet();
        int n = weight++;
        result2.add(DbSearchScopesProvider.dataSourceScope(project, DatabaseBundle.message("context.data.sources", new Object[0]), null, n, null, (Condition<String>)((Condition)ids::contains), Collections.emptySet()));
        Set ids2 = JBIterable.from(DatabaseConnectionManager.getInstance().getActiveConnections()).filterMap(o2 -> o2.getConnectionPoint().getDataSource().getUniqueId()).toSet();
        int n3 = weight++;
        result2.add(DbSearchScopesProvider.dataSourceScope(project, DatabaseBundle.message("connected.data.sources", new Object[0]), null, n3, null, (Condition<String>)((Condition)ids2::contains), Collections.emptySet()));
        for (Trie t : traverser2) {
            OffsetIcon icon;
            OffsetIcon offsetIcon = t == rootNode ? null : (icon = t.dataSource == null ? new OffsetIcon(20 * t.level, DatabaseIcons.ObjectGroup) : new OffsetIcon(20 * t.level, (Icon)ObjectUtils.notNull((Object)t.dataSource.getIcon(0), (Object)EmptyIcon.ICON_16)));
            if (t.dataSource == null) {
                JBIterable children2 = ((JBTreeTraverser)traverser2.withRoot((Object)t)).traverse().map(o2 -> o2.dataSource);
                Set ids3 = children2.filter(LocalDataSource.class).map(AbstractDataSource::getUniqueId).toSet();
                Set files2 = children2.filter(SqlDataSource.class).flatMap(SqlDataSource::getRoots).toSet();
                int n4 = weight++;
                result2.add(DbSearchScopesProvider.dataSourceScope(project, t == rootNode ? DatabaseBundle.message("all.data.sources", new Object[0]) : t.name, (Icon)icon, n4, null, (Condition<String>)((Condition)ids3::contains), files2));
                continue;
            }
            if (t.dataSource instanceof LocalDataSource) {
                String id = t.dataSource.getUniqueId();
                Color color = DatabaseColorManager.getColor(project, t.dataSource);
                result2.add(DbSearchScopesProvider.dataSourceScope(project, t.name, (Icon)icon, weight++, color, (Condition<String>)((Condition)o2 -> Objects.equals(id, o2)), Collections.emptySet()));
                continue;
            }
            if (!(t.dataSource instanceof SqlDataSource)) continue;
            JBIterable parents2 = JBIterable.generate((Object)t.dataSource, o2 -> DbImplUtilCore.unwrapDS(o2 instanceof SqlDataSource ? ((SqlDataSource)o2).getParentDataSource() : null));
            LocalDataSource parent2 = (LocalDataSource)parents2.filter(LocalDataSource.class).first();
            String parentId = parent2 == null ? null : parent2.getUniqueId();
            Set files3 = parents2.filter(SqlDataSource.class).flatMap(SqlDataSource::getRoots).toSet();
            Color color = DatabaseColorManager.getColor(project, t.dataSource);
            result2.add(DbSearchScopesProvider.dataSourceScope(project, t.name, (Icon)icon, weight++, color, (Condition<String>)(parentId == null ? Conditions.alwaysFalse() : o2 -> Objects.equals(parentId, o2)), files3));
        }
        ArrayList<SearchScope> arrayList = result2;
        if (arrayList == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static JBTreeTraverser<Trie> buildTraverser(@NotNull Project project) {
        if (project == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(3);
        }
        Trie trieRoot = DbSearchScopesProvider.buildTrie(project);
        JBTreeTraverser traverser2 = (JBTreeTraverser)JBTreeTraverser.of(o2 -> o2.nodes).withRoot((Object)trieRoot);
        Comparator nodesComparator = (o1, o2) -> {
            if (o1.dataSource == null != (o2.dataSource == null)) {
                return o1.dataSource == null ? -1 : 1;
            }
            return DbPresentation.NAMES_COMPARATOR.compare(o1.name, o2.name);
        };
        ArrayList<Trie> temp = new ArrayList<Trie>();
        for (Trie t : traverser2) {
            if (t.nodes == null) continue;
            temp.clear();
            for (Trie each : t.nodes) {
                if (each == null) continue;
                if (each.dataSource != null && each.nodes != null) {
                    Trie copy = new Trie(each.name, each.level);
                    copy.dataSource = each.dataSource;
                    temp.add(copy);
                    each.dataSource = null;
                }
                temp.add(each);
            }
            temp.sort(nodesComparator);
            t.nodes = temp.toArray(new Trie[0]);
        }
        JBTreeTraverser jBTreeTraverser = traverser2;
        if (jBTreeTraverser == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(4);
        }
        return jBTreeTraverser;
    }

    @NotNull
    private static Trie buildTrie(@NotNull Project project) {
        String groupName;
        if (project == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(5);
        }
        JBIterable dataSources2 = JBIterable.from(DbPsiFacade.getInstance(project).getDataSources()).map(DbImplUtilCore::unwrapDS).filter(RawDataSource.class).collect();
        TreeSet<String> set = new TreeSet<String>(DbPresentation.NAMES_COMPARATOR);
        for (RawDataSource o2 : dataSources2) {
            groupName = o2.getGroupName();
            if (StringUtil.isNotEmpty((String)groupName)) {
                ContainerUtil.addAll(set, (Object[])groupName.split("/"));
            }
            set.add(o2.getName());
        }
        String[] alphabet = new String[set.size()];
        set.toArray(alphabet);
        Trie trie = new Trie("", 0);
        trie.nodes = new Trie[alphabet.length];
        for (RawDataSource o2 : dataSources2) {
            groupName = o2.getGroupName();
            String[] parts = (String[])(StringUtil.isNotEmpty((String)groupName) ? JBIterable.of((Object[])groupName.split("/")) : JBIterable.empty()).append((Object)o2.getName()).toArray((Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
            Trie cur = trie;
            for (String part : parts) {
                Trie[] trieArray;
                int index2 = Arrays.binarySearch(alphabet, part, DbPresentation.NAMES_COMPARATOR);
                if (cur.nodes == null) {
                    trieArray = new Trie[alphabet.length];
                    cur.nodes = cur.nodes;
                } else {
                    trieArray = cur.nodes;
                }
                Trie next = trieArray[index2];
                cur = next == null ? new Trie(part, cur.level + 1) : next;
            }
            cur.dataSource = o2;
        }
        Trie trie2 = trie;
        if (trie2 == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(6);
        }
        return trie2;
    }

    @NotNull
    private static SearchScope dataSourceScope(@NotNull Project project, @Nls @NotNull String displayName, @Nullable Icon icon, int weight, @Nullable Color color, @NotNull Condition<String> condition2, @NotNull Set<VirtualFile> files2) {
        if (project == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(7);
        }
        if (displayName == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(8);
        }
        if (condition2 == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(9);
        }
        if (files2 == null) {
            DbSearchScopesProvider.$$$reportNull$$$0(10);
        }
        return new DbDataSourceScope(project, displayName, icon, weight, color, condition2, files2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DbSearchScopesProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DbSearchScopesProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScopes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTraverser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTrie";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScopes";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildTraverser";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTrie";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dataSourceScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static class Trie {
        @NlsSafe
        final String name;
        final int level;
        Trie[] nodes;
        RawDataSource dataSource;

        Trie(@NlsSafe String name2, int level) {
            this.name = name2;
            this.level = level;
        }
    }
}

