/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceScope
extends GlobalSearchScope
implements WeighedItem,
ColoredItem {
    @Nls
    private final String myDisplayName;
    private final Icon myIcon;
    private final int myWeight;
    private final Color myColor;
    private final Condition<? super String> myIdCondition;
    private final Set<VirtualFile> myDdlFiles;

    public DbDataSourceScope(@NotNull Project project, @Nls @NotNull String displayName, @Nullable Icon icon, int weight, @Nullable Color color, @NotNull Condition<? super String> myIdCondition, @NotNull Set<VirtualFile> myDdlFiles) {
        if (project == null) {
            DbDataSourceScope.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            DbDataSourceScope.$$$reportNull$$$0(1);
        }
        if (myIdCondition == null) {
            DbDataSourceScope.$$$reportNull$$$0(2);
        }
        if (myDdlFiles == null) {
            DbDataSourceScope.$$$reportNull$$$0(3);
        }
        super(project);
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myWeight = weight;
        this.myColor = color;
        this.myIdCondition = myIdCondition;
        this.myDdlFiles = myDdlFiles;
    }

    public boolean contains(DasDataSource dataSource2) {
        return this.myIdCondition.value((Object)dataSource2.getUniqueId());
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            DbDataSourceScope.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            DbDataSourceScope.$$$reportNull$$$0(5);
        }
        return !this.myDdlFiles.isEmpty();
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            DbDataSourceScope.$$$reportNull$$$0(6);
        }
        if (file instanceof DatabaseElementVirtualFileImpl && this.myIdCondition.value((Object)((DatabaseElementVirtualFileImpl)file).getDataSourceId())) {
            return true;
        }
        if (DbSrcUtilsCore.isDbSrcFile(file) && this.myIdCondition.value((Object)DbSrcUtilsCore.getDataSource(file))) {
            return true;
        }
        if (RootType.forFile((VirtualFile)file) instanceof DbConsoleRootType && this.myIdCondition.value((Object)DbVFSUtils.getDataSourceId(file))) {
            return true;
        }
        return ContainerUtil.exists(this.myDdlFiles, r -> VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)file, (boolean)false));
    }

    public int getWeight() {
        return this.myWeight;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myIdCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDdlFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DbDataSourceScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DbDataSourceScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

