/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DbEditorResetHelper
implements Disposable {
    private final Set<DbEditor<?, ?>> myNewObjects;
    private final DbEditorController myController;

    private DbEditorResetHelper(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbEditorResetHelper.$$$reportNull$$$0(0);
        }
        this.myNewObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.myController = controller;
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorListener(){

            @Override
            public void created(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbEditorResetHelper.this.myNewObjects.add(editor2);
            }

            @Override
            public void removed(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbEditorResetHelper.this.myNewObjects.remove(editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorResetHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public static void resetAll(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbEditorResetHelper.$$$reportNull$$$0(1);
        }
        DbEditorResetHelper.reset(controller, ContainerUtil.newArrayList(controller.getAllEditors()));
    }

    public static void reset(@NotNull DbEditorController controller, @NotNull Iterable<DbEditor<?, ?>> editors) {
        if (controller == null) {
            DbEditorResetHelper.$$$reportNull$$$0(2);
        }
        if (editors == null) {
            DbEditorResetHelper.$$$reportNull$$$0(3);
        }
        DbEditorResetHelper helper = new DbEditorResetHelper(controller);
        try {
            helper.resetTrackingNew(editors);
        }
        finally {
            Disposer.dispose((Disposable)helper);
        }
    }

    public void resetTrackingNew(@NotNull Iterable<DbEditor<?, ?>> editors) {
        if (editors == null) {
            DbEditorResetHelper.$$$reportNull$$$0(4);
        }
        this.resetEditors(editors);
        while (this.resetNewObjects()) {
        }
    }

    private boolean resetNewObjects() {
        ArrayList modified = new ArrayList(this.myNewObjects);
        modified.forEach(this.myNewObjects::remove);
        this.resetEditors(modified);
        return !modified.isEmpty();
    }

    private void resetEditors(@NotNull Iterable<DbEditor<?, ?>> editors) {
        DbEditor anyUnregistered;
        if (editors == null) {
            DbEditorResetHelper.$$$reportNull$$$0(5);
        }
        if ((anyUnregistered = (DbEditor)JBIterable.from(editors).find(e2 -> !this.myController.isEditorRegistered((DbEditor<?, ?>)e2))) != null) {
            throw new AssertionError((Object)("Told to reset unregistered editor: " + anyUnregistered));
        }
        for (DbEditor<?, ?> editor2 : editors) {
            if (!this.myController.isEditorRegistered(editor2)) continue;
            editor2.reset();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorResetHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetAll";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetTrackingNew";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

