/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbBoolEditor<E extends BasicElement, S extends DbSingleValueModelState<Boolean>>
extends DbVisualEditorBase<E, S> {
    private final ThreeStateCheckBox myBox;

    public DbBoolEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model2) {
        if (controller == null) {
            DbBoolEditor.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            DbBoolEditor.$$$reportNull$$$0(1);
        }
        super(controller, model2);
        this.myBox = new ThreeStateCheckBox(this.getModelTitle());
        DbFormCompoundEditor.installFieldPopupHandler((JComponent)this.myBox);
        this.myBox.setThirdStateEnabled(false);
        this.myBox.addItemListener(e2 -> this.modified());
    }

    @Override
    public void applyImpl() {
        DbSingleValueModelState state = (DbSingleValueModelState)this.getState();
        state.setValue(this.myBox.isSelected());
        state.setInconsistent(this.myBox.getState() == ThreeStateCheckBox.State.DONT_CARE);
    }

    @Override
    public void resetImpl() {
        DbSingleValueModelState state = (DbSingleValueModelState)this.getState();
        this.myBox.setState(state.isInconsistent() ? ThreeStateCheckBox.State.DONT_CARE : ((Boolean)state.getValue() != false ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED));
    }

    @Override
    protected void updateStatus(FileStatus status) {
        this.myBox.setForeground(status == FileStatus.NOT_CHANGED ? UIUtil.getLabelForeground() : status.getColor());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ThreeStateCheckBox threeStateCheckBox = this.myBox;
        if (threeStateCheckBox == null) {
            DbBoolEditor.$$$reportNull$$$0(2);
        }
        return threeStateCheckBox;
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        String title = this.myBox.getText();
        FieldSize fieldSize = title == null || title.length() < 30 ? FieldSize.SMALL : FieldSize.LARGE;
        if (fieldSize == null) {
            DbBoolEditor.$$$reportNull$$$0(3);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return Objects.equals(this.myBox.isSelected(), DbSingleValueModelState.getDefaultValue(this.getApplier()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbBoolEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbBoolEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

