/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.state.DbGenNameModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNameModelApplier<E extends BasicElement>
extends DbEditorModelBase.ApplierBase<E, DbSingleValueModelState<String>> {
    public DbNameModelApplier() {
        super(BasicModNamedElement.NAME);
    }

    @Override
    public void copyState(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> from, @NotNull DbEditorModel<E, DbSingleValueModelState<String>> to) {
        if (from == null) {
            DbNameModelApplier.$$$reportNull$$$0(0);
        }
        if (to == null) {
            DbNameModelApplier.$$$reportNull$$$0(1);
        }
        super.copyState(from, to);
        to.getState().setValue(from.getState().getValue());
        DbSingleValueModelState<String> dbSingleValueModelState = from.getState();
        if (dbSingleValueModelState instanceof DbGenNameModelState) {
            DbGenNameModelState fState = (DbGenNameModelState)dbSingleValueModelState;
            dbSingleValueModelState = to.getState();
            if (dbSingleValueModelState instanceof DbGenNameModelState) {
                DbGenNameModelState tState = (DbGenNameModelState)dbSingleValueModelState;
                tState.setGenerated(fState.isGenerated());
            }
        }
    }

    @Override
    public void applyImpl(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        BasicModNamedElement named;
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(3);
        }
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(4);
        }
        if ((named = (BasicModNamedElement)ObjectUtils.tryCast(e2, BasicModNamedElement.class)) == null) {
            return;
        }
        String text2 = StringUtil.notNullize((String)model2.getState().getValue());
        ElementMatcher matcher = model2.getController().getMatcher();
        ElementOwner oOwner = matcher.getOriginalOwner();
        BasicNamedElement editedNamed = oOwner == null ? null : (BasicNamedElement)ObjectUtils.tryCast(oOwner.find(model2.getIdentity()), BasicNamedElement.class);
        DasSchemaExporters.DeObjectExporter.setNameFromText(this.getNamingService(model2, (BasicElement)e2), named, editedNamed, text2, false);
    }

    @Override
    public void resolveImpl(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        DbGenNameModelState gState;
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(6);
        }
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(7);
        }
        super.resolveImpl(model2, owner, e2);
        DbSingleValueModelState<String> dbSingleValueModelState = model2.getState();
        if (dbSingleValueModelState instanceof DbGenNameModelState && (gState = (DbGenNameModelState)dbSingleValueModelState).isGenerated()) {
            gState.setText(DbNameModelApplier.generateName(e2, gState));
            this.applyImpl(model2, owner, e2);
        }
    }

    @NotNull
    private static String generateName(@NotNull BasicElement e2, DbGenNameModelState gState) {
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(8);
        }
        String generated = gState.getTemplate().getName((DasObject)e2);
        Family<? extends BasicElement> pf = e2.getParentFamily();
        return pf == null ? generated : DbNameModelApplier.generateUniqueName(generated, pf.jbi().filterMap(o2 -> o2 == e2 ? null : o2.getName()).toList());
    }

    @Override
    public void resetImpl(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(10);
        }
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(11);
        }
        String text2 = DasSchemaExporters.DeObjectExporter.getIdentifier(this.getNamingService(model2, (BasicElement)e2), e2);
        DbSingleValueModelState<String> state = model2.getState();
        state.setValue(text2);
        DbGenNameModelState gState = (DbGenNameModelState)ObjectUtils.tryCast(state, DbGenNameModelState.class);
        if (gState != null) {
            ElementOwner original = model2.getController().getMatcher().getOriginalOwner();
            boolean isNew = original == null || original.find(model2.getIdentity()) == null;
            gState.setGenerated(isNew && e2.getName().isEmpty() || DbNameModelApplier.nameMatchesGenerated(e2, gState));
        }
    }

    private static boolean nameMatchesGenerated(@NotNull BasicElement e2, DbGenNameModelState gState) {
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(12);
        }
        String genName = DbNameModelApplier.generateName(e2, gState);
        return genName.equals(e2.getName());
    }

    @Override
    public boolean differsFromImpl(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(14);
        }
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(15);
        }
        return !Objects.equals(DasSchemaExporters.DeObjectExporter.getIdentifier(this.getNamingService(model2, (BasicElement)e2), e2), model2.getState().getValue());
    }

    @Override
    public boolean isEnabled(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull ElementOwner owner, @Nullable E e2) {
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(16);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(17);
        }
        return DbNameModelApplier.isEnabledImpl(model2, owner, e2, BasicModNamedElement.NAME);
    }

    @NotNull
    protected NamingService getNamingService(@NotNull DbEditorModel<E, DbSingleValueModelState<String>> model2, @NotNull BasicElement e2) {
        if (model2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(18);
        }
        if (e2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(19);
        }
        NamingService namingService2 = NamingServices.getNamingService(model2.getDbms(), e2.getModel(), e2.getDatabase());
        if (namingService2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(20);
        }
        return namingService2;
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull Collection<String> existingNames) {
        if (defaultName == null) {
            DbNameModelApplier.$$$reportNull$$$0(21);
        }
        if (existingNames == null) {
            DbNameModelApplier.$$$reportNull$$$0(22);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)DbNameModelApplier.extractBase(defaultName), (String)"", (String)"", (String)"_", (String)"", x -> !existingNames.contains(x));
        if (string == null) {
            DbNameModelApplier.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String extractBase(@NotNull String name2) {
        if (name2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(24);
        }
        for (int i2 = name2.length() - 1; i2 > 0; --i2) {
            char c2 = name2.charAt(i2);
            if (Character.isDigit(c2)) continue;
            if (c2 != '_' || i2 == name2.length() - 1) break;
            String string = name2.substring(0, i2);
            if (string == null) {
                DbNameModelApplier.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            DbNameModelApplier.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 23, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbNameModelApplier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbNameModelApplier";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameMatchesGenerated";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamingService";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractBase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 23, 25, 26 -> new IllegalStateException(string);
        };
    }
}

