/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DataBus;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewHolder;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.run.session.MessageBusSessionState;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StateWatcher<T extends LogViewOwner>
extends DataAuditors.BusyCounter {
    protected StateWatcher(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            StateWatcher.$$$reportNull$$$0(0);
        }
        bus.addAuditor(this);
    }

    @Override
    protected void update(int current) {
        UIUtil.invokeLaterIfNeeded(() -> {
            LogView<?> view2 = this.getView();
            if (view2 == null) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            if (this.getCount() > 0) {
                view2.startLoading();
                return;
            }
            view2.stopLoading();
        });
    }

    public boolean isIdle() {
        return this.getCount() == 0;
    }

    abstract boolean isValid();

    @Nullable
    abstract LogView<?> getView();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/database/run/session/StateWatcher", "<init>"));
    }

    public static class ClientWatcher
    extends StateWatcher<DatabaseSessionClientWithFile> {
        private final DatabaseSessionClientWithFile myClient;

        public ClientWatcher(@NotNull DatabaseSessionClientWithFile client) {
            if (client == null) {
                ClientWatcher.$$$reportNull$$$0(0);
            }
            super(client.getMessageBus());
            this.myClient = client;
        }

        @Override
        boolean isValid() {
            return this.myClient.isValid();
        }

        @Override
        @Nullable
        LogView<DatabaseSessionClientWithFile> getView() {
            return DatabaseSessionViewService.getInstance().getClientViewIfAny(this.myClient);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/database/run/session/StateWatcher$ClientWatcher", "<init>"));
        }
    }

    public static class DatabaseSessionWatcher
    extends StateWatcher<DatabaseSession> {
        private final MessageBusSession mySession;

        public DatabaseSessionWatcher(@NotNull MessageBusSession session2) {
            if (session2 == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(0);
            }
            super(session2.getMessageBus());
            this.mySession = session2;
        }

        @Override
        boolean isValid() {
            return this.mySession.isValid();
        }

        @Override
        @Nullable
        LogView<?> getView() {
            return DatabaseSessionViewService.getInstance().getViewIfAny(this.mySession);
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(1);
            }
            if (producer == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(2);
            }
            long time = System.currentTimeMillis();
            super.jobSubmitted(request, producer);
            UIUtil.invokeLaterIfNeeded(() -> {
                MessageBusSessionState newState = this.getState().resetIfEmpty();
                this.mySession.setState(DatabaseSessionWatcher.isEnabledFor(request) ? newState.plus(request, time) : newState);
            });
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(3);
            }
            if (producer == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(4);
            }
            long time = System.currentTimeMillis();
            super.jobFinished(request, producer);
            if (!DatabaseSessionWatcher.isEnabledFor(request)) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().deactivate(time, request).update()));
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(5);
            }
            if (errorInfo == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(6);
            }
            DataRequest.CoupledWithEditor request = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)((Object)context.request), DataRequest.CoupledWithEditor.class);
            if (errorInfo instanceof JdbcEngineUtils.EngineWarningExceptionInfo) {
                JdbcEngineUtils.EngineWarningExceptionInfo warningInfo = (JdbcEngineUtils.EngineWarningExceptionInfo)errorInfo;
                if (request != null) {
                    request.onWarning(warningInfo);
                }
                if (!DatabaseSessionWatcher.isEnabledFor(context.request)) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().warning(context.request, warningInfo.getLogMessage())));
            } else {
                DataRequest.CoupledWithEditor.ErrorNavigator navigator;
                DataRequest.CoupledWithEditor.ErrorNavigator errorNavigator = navigator = request != null ? request.onError(errorInfo) : null;
                if (!DatabaseSessionWatcher.isEnabledFor(context.request)) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().error(context.request, navigator, errorInfo.getLogMessage())));
            }
        }

        @Override
        public void requestCancelStarted(@NotNull DataRequest.Context context, @Nullable DataRequest.Cancel cancelRequest) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(7);
            }
            if (!DatabaseSessionWatcher.isEnabledFor(context)) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().cancel(context.request)));
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(8);
            }
            long startTime = System.currentTimeMillis();
            if (!DatabaseSessionWatcher.isEnabledFor(context)) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().activate(startTime, context.request)));
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(9);
            }
            long finishTime = System.currentTimeMillis();
            if (!DatabaseSessionWatcher.isEnabledFor(context)) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().deactivate(finishTime, context.request)));
        }

        private static boolean isEnabledFor(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(10);
            }
            return !MeasuringDataAuditor.isSilent(context) && DatabaseSessionWatcher.isEnabledFor(context.request);
        }

        private static boolean isEnabledFor(@NotNull GridDataRequest request) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(11);
            }
            return !(request instanceof DataRequest.Cancel) && !(request instanceof DataRequest.Disconnect) && (!(request instanceof DataRequest.SchemaSwitchRequest) || ((DataRequest.SchemaSwitchRequest)request).forced) && !(request instanceof DataRequest.TxRequest);
        }

        @NotNull
        private MessageBusSessionState getState() {
            MessageBusSessionState messageBusSessionState = this.mySession.getState();
            if (messageBusSessionState == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(12);
            }
            return messageBusSessionState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/StateWatcher$DatabaseSessionWatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/StateWatcher$DatabaseSessionWatcher";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "jobSubmitted";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "jobFinished";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "requestCancelStarted";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "requestStarted";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFinished";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledFor";
                    break;
                }
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 12 -> new IllegalStateException(string);
            };
        }
    }

    public static class SessionWatcher
    extends StateWatcher<VisibleSession<?>> {
        private final VisibleSession<?> mySession;

        public SessionWatcher(@NotNull VisibleSession<?> session2) {
            if (session2 == null) {
                SessionWatcher.$$$reportNull$$$0(0);
            }
            super(session2.getMessageBus());
            this.mySession = session2;
        }

        @Override
        @Nullable
        LogView<VisibleSession<?>> getView() {
            LogViewHolder session2 = (LogViewHolder)ObjectUtils.tryCast(this.mySession, LogViewHolder.class);
            return session2 == null ? null : session2.getView();
        }

        @Override
        boolean isValid() {
            return this.mySession.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/run/session/StateWatcher$SessionWatcher", "<init>"));
        }
    }
}

