/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationTarget;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected boolean hasKeysToNavigate(DbDataSource databaseSystem, DasTable table) {
        return DataGridDocumentationTarget.hasNavigatableKeys(databaseSystem, table);
    }

    @NotNull
    protected EnumSet<DataGridDocumentationUtil.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationUtil.KeyType> enumSet = EnumSet.of(DataGridDocumentationUtil.KeyType.FOREIGN, DataGridDocumentationUtil.KeyType.EXPORTED);
        if (enumSet == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    private static List<DataGridDocumentationUtil.QueryInfo> getQueries(@NotNull DasDataSource dataSource2, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> types2) {
        if (dataSource2 == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        if (selectedRows == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        if (types2 == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        return DataGridDocumentationUtil.buildQueries(dataSource2, dataGrid, selectedRows, types2);
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            NavigateAction.$$$reportNull$$$0(6);
        }
        if (e2.getInputEvent() instanceof MouseEvent && (e2.getInputEvent().getModifiersEx() & (SystemInfo.isMac ? 256 : 128)) != 0) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource2 = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid);
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)dataGrid);
        boolean visible = e2.getProject() != null && table != null && dataSource2 != null;
        boolean enabled = visible && dataGrid.getSelectionModel().getSelectedRowCount() > 0 && table instanceof DasTable && this.hasKeysToNavigate(dataSource2, (DasTable)table);
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            NavigateAction.$$$reportNull$$$0(7);
        }
        Project project = e2.getProject();
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource2 = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid);
        if (dataGrid == null || dataSource2 == null || project == null) {
            return;
        }
        ModelIndexSet selectedRows = dataGrid.getSelectionModel().getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        for (ModelIndex selectedRow : selectedRows.asList()) {
            if (selectedRow.isValid((CoreGrid)dataGrid)) continue;
            return;
        }
        List<OpenDataFileDescriptor> descriptors = NavigateAction.convertDescriptors(project, NavigateAction.createDescriptorData(dataGrid, dataSource2, this.getKeyTypes()));
        if (descriptors.size() == 1) {
            descriptors.get(0).navigate(true);
            return;
        }
        BaseListPopupStep<OpenDataFileDescriptor> step2 = NavigateAction.createStep(descriptors, this.getKeyTypes());
        ColoredListCellRenderer<OpenDataFileDescriptor> wrapper = NavigateAction.createRenderer(descriptors);
        ListPopupImpl popup2 = new ListPopupImpl(project, (ListPopupStep)step2, (ColoredListCellRenderer)wrapper, descriptors){
            final /* synthetic */ ColoredListCellRenderer val$wrapper;
            final /* synthetic */ List val$descriptors;
            {
                this.val$wrapper = coloredListCellRenderer;
                this.val$descriptors = list;
                super(arg0, arg1);
            }

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer<OpenDataFileDescriptor>((ListPopupImpl)this){

                    protected JComponent createItemComponent() {
                        this.myTextLabel = new ErrorLabel();
                        return val$wrapper;
                    }

                    protected void customizeComponent(JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value2, boolean isSelected) {
                        val$wrapper.getListCellRendererComponent(list, (Object)value2, val$descriptors.indexOf((Object)value2), isSelected, true);
                    }
                };
            }
        };
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("QuickJavaDoc"));
        if (!descriptors.isEmpty() && StringUtil.isNotEmpty((String)shortcutText)) {
            popup2.setAdText(DatabaseBundle.message("popup.advertisement.use.in.table", shortcutText));
        }
        popup2.showInBestPositionFor(e2.getDataContext());
    }

    @NotNull
    public static List<OpenDataFileDescriptor> convertDescriptors(@NotNull Project project, @NotNull List<DescriptorData> descriptorData) {
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(8);
        }
        if (descriptorData == null) {
            NavigateAction.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.map(descriptorData, data -> new OpenDataFileDescriptor(project, data.file, data.columnNames, data.description, data.values, data.condition));
        if (list == null) {
            NavigateAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static ColoredListCellRenderer<OpenDataFileDescriptor> createRenderer(List<OpenDataFileDescriptor> descriptors) {
        HashSet<DbElement> elements2 = new HashSet<DbElement>(ContainerUtil.filter((Collection)ContainerUtil.map(descriptors, descriptor2 -> DbImplUtilCore.findElement(descriptor2.getProject(), descriptor2.getFile())), el -> el != null));
        final Map<DbElement, @NlsSafe String> uniqueTableNames = NavigateAction.calcUniqueTableNames(elements2);
        return new ColoredListCellRenderer<OpenDataFileDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clear();
                this.setIcon(DatabaseIcons.Table);
                DbElement element2 = DbImplUtilCore.findElement(value2.getProject(), value2.getFile());
                String uniqueName = (String)ObjectUtils.notNull((Object)((String)uniqueTableNames.get(element2)), (Object)value2.getFile().getName());
                this.append(uniqueName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.append(value2.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/run/actions/NavigateAction$2", "customizeCellRenderer"));
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static BaseListPopupStep<OpenDataFileDescriptor> createStep(final List<OpenDataFileDescriptor> descriptors, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> keyTypes) {
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(11);
        }
        final @NlsContexts.Separator Ref navigateToOnlyRowsSeparator = new Ref();
        final @NlsContexts.Separator Ref navigateToFirstRowSeparator = new Ref();
        if (keyTypes.contains((Object)DataGridDocumentationUtil.KeyType.FOREIGN)) {
            navigateToOnlyRowsSeparator.set((Object)DatabaseBundle.message("separator.referenced.rows.only", new Object[0]));
            navigateToFirstRowSeparator.set((Object)DatabaseBundle.message("separator.first.referenced.row", new Object[0]));
        } else {
            navigateToOnlyRowsSeparator.set((Object)DatabaseBundle.message("separator.referencing.rows.only", new Object[0]));
            navigateToFirstRowSeparator.set((Object)DatabaseBundle.message("separator.first.referencing.row", new Object[0]));
        }
        String popupTitle = DatabaseBundle.message("popup.title.choose.target", new Object[0]);
        BaseListPopupStep<OpenDataFileDescriptor> step2 = new BaseListPopupStep<OpenDataFileDescriptor>(popupTitle, descriptors){

            public PopupStep<?> onChosen(OpenDataFileDescriptor selectedValue, boolean finalChoice) {
                selectedValue.navigate(true);
                return FINAL_CHOICE;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(OpenDataFileDescriptor value2) {
                int idx = descriptors.indexOf((Object)value2);
                if (idx == 0) {
                    return new ListSeparator((String)navigateToOnlyRowsSeparator.get());
                }
                if (idx == descriptors.size() / 2) {
                    return new ListSeparator((String)navigateToFirstRowSeparator.get());
                }
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(OpenDataFileDescriptor value2) {
                String string = value2.getFile().getName() + ": " + value2.getDescription();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$3", "getTextFor"));
            }
        };
        step2.setDefaultOptionIndex(0);
        BaseListPopupStep<OpenDataFileDescriptor> baseListPopupStep = step2;
        if (baseListPopupStep == null) {
            NavigateAction.$$$reportNull$$$0(12);
        }
        return baseListPopupStep;
    }

    public static @NotNull Map<DbElement, @NlsSafe String> calcUniqueTableNames(@NotNull Set<DbElement> elements2) {
        if (elements2 == null) {
            NavigateAction.$$$reportNull$$$0(13);
        }
        Map nameToTables = CollectionFactory.createCaseInsensitiveStringMap();
        for (DbElement element2 : elements2) {
            nameToTables.computeIfAbsent(element2.getName(), e2 -> new HashSet()).add(element2);
        }
        HashMap<DbElement, String> map2 = new HashMap<DbElement, String>();
        for (DbElement element3 : elements2) {
            Set elementsWithSameName = (Set)nameToTables.get(element3.getName());
            if (elementsWithSameName == null || elementsWithSameName.size() == 1) {
                map2.put(element3, element3.getName());
                continue;
            }
            DbElement parent2 = element3.getParent();
            map2.put(element3, (String)(parent2 == null ? "" : parent2.getName() + ".") + element3.getName());
        }
        HashMap<DbElement, String> hashMap = map2;
        if (hashMap == null) {
            NavigateAction.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    public static List<DescriptorData> createDescriptorData(@NotNull DataGrid dataGrid, @NotNull DasDataSource dataSource2, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> keyTypes) {
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(15);
        }
        if (dataSource2 == null) {
            NavigateAction.$$$reportNull$$$0(16);
        }
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(17);
        }
        ModelIndexSet selectedRows = dataGrid.getSelectionModel().getSelectedRows();
        ArrayList<DescriptorData> descriptorData = new ArrayList<DescriptorData>();
        List<DataGridDocumentationUtil.QueryInfo> queries = NavigateAction.getQueries(dataSource2, dataGrid, (ModelIndexSet<GridRow>)selectedRows, keyTypes);
        for (DataGridDocumentationUtil.QueryInfo info2 : queries) {
            String path = DatabaseElementVirtualFileImpl.getPath(dataSource2, info2.table, false);
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
            if (file == null) continue;
            List<String[]> formattedValuesLists = DataGridUtil.formatValues(dataGrid, info2.sourceColumns, info2.values);
            DescriptorData descriptor2 = new DescriptorData(file, null, null, info2.keysAndColumns, DbImplUtil.defaultWhereCondition(info2.targetColumnNames, formattedValuesLists, dataSource2.getVersion()));
            descriptorData.add(descriptorData.size() / 2, descriptor2);
            descriptorData.add(new DescriptorData(file, info2.targetColumnNames, info2.values, info2.keysAndColumns, null));
        }
        ArrayList<DescriptorData> arrayList = descriptorData;
        if (arrayList == null) {
            NavigateAction.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRows";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorData";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStep";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUniqueTableNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptorData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStep";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcUniqueTableNames";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    public static class DescriptorData {
        public final VirtualFile file;
        public final String[] columnNames;
        public final List<Object[]> values;
        public final @NlsActions.ActionDescription String description;
        public final TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition;

        public DescriptorData(@NotNull VirtualFile file, String @Nullable [] names2, List<Object @Nullable []> values2, @NlsActions.ActionDescription @Nullable String description, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition2) {
            if (file == null) {
                DescriptorData.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.columnNames = names2;
            this.values = values2;
            this.description = description;
            this.condition = condition2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/NavigateAction$DescriptorData", "<init>"));
        }
    }

    public static class ExportedAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource2, DasTable table) {
            return !ModelRelationManager.getExportedKeys(dataSource2.getProject(), table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationUtil.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationUtil.KeyType> enumSet = EnumSet.of(DataGridDocumentationUtil.KeyType.EXPORTED);
            if (enumSet == null) {
                ExportedAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ExportedAction", "getKeyTypes"));
        }
    }

    public static class ForeignAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource2, DasTable table) {
            return !ModelRelationManager.getForeignKeys(dataSource2.getProject(), table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationUtil.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationUtil.KeyType> enumSet = EnumSet.of(DataGridDocumentationUtil.KeyType.FOREIGN);
            if (enumSet == null) {
                ForeignAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ForeignAction", "getKeyTypes"));
        }
    }
}

