/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/run/actions/CopyQueryToConsoleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
public final class CopyQueryToConsoleAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        e2.getPresentation().setEnabledAndVisible(DataGridUtil.getQueryText((DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        DatabaseGridDataHookUp databaseGridDataHookUp = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid));
        if (databaseGridDataHookUp == null) {
            return;
        }
        DatabaseGridDataHookUp databaseHookUp = databaseGridDataHookUp;
        String string = DataGridUtil.getQueryText((DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY));
        if (string == null) {
            return;
        }
        String query = string;
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        DbElement target2 = DbImplUtilCore.findElement(databaseHookUp.getDataSource(), table);
        if (target2 != null) {
            v3 = DbActionUtils.findOrCreateEditor(target2, true);
        } else {
            JdbcConsole jdbcConsole = DataGridUtil.findGridRelatedConsole(grid.getProject(), grid);
            if (jdbcConsole == null || (jdbcConsole = jdbcConsole.getVirtualFile()) == null) {
                return;
            }
            JdbcConsole consoleFile = jdbcConsole;
            FileEditor fileEditor = FileEditorManager.getInstance((Project)grid.getProject()).getSelectedEditor((VirtualFile)consoleFile);
            TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            v3 = editor2 = textEditor != null ? textEditor.getEditor() : null;
        }
        if (editor2 == null) {
            return;
        }
        DbActionUtils.moveCaretToEnd(editor2);
        WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), null, null, () -> CopyQueryToConsoleAction.actionPerformed$lambda$0(editor2, query), (PsiFile[])new PsiFile[0]);
    }

    private static final void actionPerformed$lambda$0(Editor $editor, String $query) {
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        $editor.getDocument().insertString($editor.getDocument().getTextLength(), (CharSequence)$query);
    }
}

