/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DeactivateBeforeRunTask
extends BeforeRunTask<DeactivateBeforeRunTask>
implements PersistentStateComponent<State> {
    private static final Key<DeactivateBeforeRunTask> ID = Key.create((String)"DeactivateBeforeRunTask");
    private State myState = new State();

    protected DeactivateBeforeRunTask() {
        super(ID);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DeactivateBeforeRunTask.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @Nullable
    private LocalDataSource getDataSource(@NotNull Project project) {
        if (project == null) {
            DeactivateBeforeRunTask.$$$reportNull$$$0(1);
        }
        return DataSourceStorage.getProjectStorage(project).getDataSourceById(this.myState.dataSourceId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/DeactivateBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        @Nullable
        public String dataSourceId;
    }

    public static final class Provider
    extends BeforeRunTaskProvider<DeactivateBeforeRunTask> {
        private final Project myProject;
        private final Icon mySmallSuspend;

        public Provider(@NotNull Project project) {
            if (project == null) {
                Provider.$$$reportNull$$$0(0);
            }
            this.mySmallSuspend = IconLoader.createLazy(() -> IconUtil.scale((Icon)AllIcons.Actions.Suspend, null, (float)0.5f));
            this.myProject = project;
        }

        public Key<DeactivateBeforeRunTask> getId() {
            return ID;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getName() {
            return DatabaseBundle.message("disconnect.data.source", new Object[0]);
        }

        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Suspend;
        }

        @Nullable
        public Icon getTaskIcon(DeactivateBeforeRunTask task) {
            LocalDataSource dataSource2 = task.getDataSource(this.myProject);
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(dataSource2 == null ? DatabaseIcons.Dbms : dataSource2.getIcon(), 0);
            icon.setIcon(this.mySmallSuspend, 1, 4);
            return icon;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDescription(DeactivateBeforeRunTask task) {
            LocalDataSource dataSource2 = task.getDataSource(this.myProject);
            return DatabaseBundle.message("disconnect.1.choice.0.unexistent.data.source.1.0", dataSource2 == null ? null : dataSource2.getName(), dataSource2 == null ? 0 : 1);
        }

        public boolean isConfigurable() {
            return true;
        }

        public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull DeactivateBeforeRunTask task) {
            if (context == null) {
                Provider.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                Provider.$$$reportNull$$$0(2);
            }
            if (task == null) {
                Provider.$$$reportNull$$$0(3);
            }
            List<LocalDataSource> dataSources2 = DataSourceStorage.getProjectStorage(this.myProject).getDataSources();
            ComboBox box = new ComboBox();
            DbUIUtil.configureDataSourceComboBox(this.myProject, box, dataSources2, task.getDataSource(this.myProject), true);
            DialogBuilder builder = new DialogBuilder(this.myProject);
            builder.setTitle(this.getName());
            JPanel panel2 = FormBuilder.createFormBuilder().addLabeledComponent(DatabaseBundle.message("label.data.source", new Object[0]), (JComponent)box).getPanel();
            builder.setCenterPanel((JComponent)panel2);
            if (!builder.showAndGet()) {
                return Promises.resolvedPromise((Object)false);
            }
            LocalDataSource selected = (LocalDataSource)ObjectUtils.tryCast((Object)box.getSelectedItem(), LocalDataSource.class);
            task.myState.dataSourceId = selected == null ? null : selected.getUniqueId();
            return Promises.resolvedPromise((Object)true);
        }

        @Nullable
        public DeactivateBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
            if (runConfiguration == null) {
                Provider.$$$reportNull$$$0(4);
            }
            return new DeactivateBeforeRunTask();
        }

        public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull DeactivateBeforeRunTask task) {
            if (configuration == null) {
                Provider.$$$reportNull$$$0(5);
            }
            if (task == null) {
                Provider.$$$reportNull$$$0(6);
            }
            return task.getDataSource(this.myProject) != null;
        }

        public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull DeactivateBeforeRunTask task) {
            LocalDataSource dataSource2;
            if (context == null) {
                Provider.$$$reportNull$$$0(7);
            }
            if (configuration == null) {
                Provider.$$$reportNull$$$0(8);
            }
            if (environment == null) {
                Provider.$$$reportNull$$$0(9);
            }
            if (task == null) {
                Provider.$$$reportNull$$$0(10);
            }
            if ((dataSource2 = task.getDataSource(this.myProject)) == null) {
                return false;
            }
            AsyncTask.Frame frame = AsyncTask.frame(DatabaseBundle.message("progress.title.deactivation", dataSource2.getName()));
            UIUtil.invokeAndWaitIfNeeded(() -> AsyncTask.withBgIndicatorIfNeeded(frame, this.myProject, null));
            return (Boolean)frame.sync(() -> {
                Promise<?> termination = DataSourceUtil.deactivate(this.myProject, dataSource2);
                try {
                    termination.blockingGet(30, TimeUnit.SECONDS);
                    return true;
                }
                catch (TimeoutException e2) {
                    return false;
                }
                catch (ExecutionException e3) {
                    ExceptionUtil.rethrow((Throwable)e3.getCause());
                    return false;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/DeactivateBeforeRunTask$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTask";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canExecuteTask";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

