/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element2) {
        DbElement psiElement;
        if (element2 == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        Project project = element2.getProject();
        DbElement extracted = DbNavigationUtils.extractDbElementFromPsi(element2);
        DasObject dasObject = extracted != null ? extracted : (psiElement = element2 instanceof DasObject ? (DasObject)element2 : (DasObject)SqlPsiFacade.getInstance((Project)project).findRelatedDbElements(element2, false).first());
        if (psiElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DbViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        LinkedHashMap<DasObject, GotoRelatedItem> result2 = new LinkedHashMap<DasObject, GotoRelatedItem>();
        ArrayList<GotoRelatedItem> resultExt = new ArrayList<GotoRelatedItem>();
        if (psiElement instanceof DasColumn) {
            DbViewGotoRelatedProvider.addForeignKeys(project, result2, (DasColumn)((Object)psiElement));
        } else if (psiElement instanceof DasTableChild) {
            if (psiElement instanceof DasForeignKey) {
                DbViewGotoRelatedProvider.addItems(result2, ((DasForeignKey)((Object)psiElement)).getRefColumns(), DatabaseBundle.message("separator.referenced", new Object[0]));
            }
            if (psiElement instanceof DasConstraint) {
                String group2 = psiElement instanceof DasForeignKey ? DatabaseBundle.message("separator.referring", new Object[0]) : "";
                DbViewGotoRelatedProvider.addItems(result2, ((DasConstraint)((Object)psiElement)).getColumnsRef(), group2);
            } else if (psiElement instanceof DasIndex) {
                DbViewGotoRelatedProvider.addItems(result2, ((DasIndex)((Object)psiElement)).getColumnsRef(), "");
            }
        } else if (psiElement instanceof DasSynonym) {
            DbViewGotoRelatedProvider.addItem(result2, ((DasSynonym)((Object)psiElement)).resolveTarget());
        } else if (psiElement instanceof DbDataSource) {
            DbDataSource dataSource2 = (DbDataSource)psiElement;
            DbViewGotoRelatedProvider.addAssociations(project, result2, dataSource2);
            DbViewGotoRelatedProvider.addDataSourceFiles(dataSource2, resultExt, element2.getManager());
        }
        DbViewGotoRelatedProvider.addPredecessors(psiElement, result2);
        DbViewGotoRelatedProvider.addSuccessors(psiElement, result2);
        ArrayList res2 = new ArrayList(result2.values());
        res2.addAll(resultExt);
        ArrayList arrayList = res2;
        if (arrayList == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addForeignKeys(Project project, Map<DasObject, GotoRelatedItem> result2, DasColumn columnInfo) {
        DbViewGotoRelatedProvider.addForeignKeys(project, result2, columnInfo, true);
        DbViewGotoRelatedProvider.addForeignKeys(project, result2, columnInfo, false);
    }

    private static void addForeignKeys(Project project, Map<DasObject, GotoRelatedItem> result2, DasColumn columnInfo, boolean direct) {
        JBIterable<DasForeignKey> keys2 = direct ? ModelRelationManager.getForeignKeys(project, columnInfo.getTable()) : ModelRelationManager.getExportedKeys(project, columnInfo.getTable());
        for (DasForeignKey keyInfo : keys2) {
            MultiRef<? extends DasTypedObject> r1 = keyInfo.getColumnsRef();
            MultiRef<? extends DasTypedObject> r2 = keyInfo.getRefColumns();
            MultiRef.It<? extends DasTypedObject> it2 = (direct ? r1 : r2).iterate();
            MultiRef.It<? extends DasTypedObject> it22 = (direct ? r2 : r1).iterate();
            while (it2.hasNext()) {
                String next = (String)it2.next();
                if (it22.hasNext()) {
                    it22.next();
                }
                if (!Objects.equals(next, columnInfo.getName())) continue;
                DbViewGotoRelatedProvider.addItem(result2, it22.resolve());
            }
        }
    }

    private static void addDataSourceFiles(DasDataSource dataSource2, final List<GotoRelatedItem> resultExt, final PsiManager psiManager) {
        VirtualFile dsRoot;
        String uniqueId = dataSource2.getUniqueId();
        final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
        VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
        VirtualFile virtualFile = dsRoot = root2 != null && root2.isDirectory() ? root2.findChild(uniqueId) : null;
        if (dsRoot == null || !dsRoot.isDirectory()) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dsRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(final @NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory()) {
                    return true;
                }
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile instanceof SqlFile) {
                    resultExt.add(new GotoRelatedItem((PsiElement)psiFile){

                        @NlsSafe
                        @Nullable
                        public String getCustomName() {
                            return rootType.substituteName(psiManager.getProject(), file);
                        }

                        @Nls
                        public String getCustomContainerName() {
                            return "(" + rootType.getDisplayName() + ")";
                        }

                        @Nullable
                        public Icon getCustomIcon() {
                            return rootType.substituteIcon(psiManager.getProject(), file);
                        }
                    });
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
            }
        });
    }

    private static void addAssociations(Project project, Map<DasObject, GotoRelatedItem> result2, DbDataSource dataSource2) {
        String uniqueId = dataSource2.getUniqueId();
        Set mapped = DdlMappingsManager.getInstance(project).iterateMappings().filter(m -> m.isDdlDataSourceId(uniqueId) || m.isDataSourceId(uniqueId)).filterMap(m -> m.isDataSourceId(uniqueId) ? m.getDdlDataSourceId() : m.getDataSourceId()).toSet();
        for (DbDataSource ds : DbPsiFacade.getInstance(project).getDataSources()) {
            DbDataSource parent2;
            if (mapped.contains(ds.getUniqueId())) {
                DbViewGotoRelatedProvider.addDataSourceItem(result2, ds, "", DatabaseBundle.message("mapped.data.source", new Object[0]));
            }
            if ((parent2 = DbViewGotoRelatedProvider.getParentDataSource(ds)) == null || !parent2.getUniqueId().equals(uniqueId)) continue;
            DbViewGotoRelatedProvider.addDataSourceItem(result2, ds, "", DatabaseBundle.message("derived.data.source", new Object[0]));
        }
        DbDataSource parent3 = DbViewGotoRelatedProvider.getParentDataSource(dataSource2);
        if (parent3 != null) {
            DbViewGotoRelatedProvider.addDataSourceItem(result2, parent3, "", DatabaseBundle.message("parent.data.source", new Object[0]));
        }
    }

    @Nullable
    private static DbDataSource getParentDataSource(DbDataSource ds) {
        RawDataSource delegate = ds.getDelegate();
        return delegate instanceof SqlDataSource ? ((SqlDataSource)delegate).getParentDataSource() : null;
    }

    private static void addPredecessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result2) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement basicElement : basic.getPredecessors()) {
                DbElement tgt = DbImplUtilCore.findElement(ds, basicElement);
                if (tgt == null) continue;
                DbViewGotoRelatedProvider.addItem(result2, tgt);
            }
        }
    }

    private static void addSuccessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result2) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement candidate : DbImplUtilCore.traverseVisibleObjects(ds).filter(BasicElement.class)) {
                DbElement tgt;
                if (candidate == basic || ContainerUtil.find(candidate.getPredecessors(), (Object)basic) == null || (tgt = DbImplUtilCore.findElement(ds, candidate)) == null) continue;
                DbViewGotoRelatedProvider.addItem(result2, tgt, DatabaseBundle.message("separator.referenced.by", new Object[0]));
            }
        }
    }

    private static void addItems(Map<DasObject, GotoRelatedItem> result2, MultiRef<? extends DasTypedObject> columns2, @NlsContexts.Separator String title) {
        for (DasTypedObject dasTypedObject : columns2.resolveObjects()) {
            DbViewGotoRelatedProvider.addItem(result2, dasTypedObject, title);
        }
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result2, DasObject target2) {
        DbViewGotoRelatedProvider.addItem(result2, target2, "");
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result2, DasObject target2, @NlsContexts.Separator String title) {
        if (result2.containsKey(target2)) {
            return;
        }
        if (target2 instanceof DbDataSource) {
            DbViewGotoRelatedProvider.addDataSourceItem(result2, (DbDataSource)target2, title, null);
        } else if (target2 instanceof DbElement) {
            result2.put(target2, new GotoRelatedItem((DbElement)target2, title){

                public void navigate() {
                    DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                    NavigationItem navElement = DatabaseTargetElementEvaluator.getGotoDeclarationTarget(dbElement);
                    Objects.requireNonNull(navElement).navigate(true);
                }

                @Nls
                @Nullable
                public String getCustomContainerName() {
                    DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                    DbElement parent2 = dbElement.getParent();
                    return parent2 == null ? null : parent2.getName();
                }
            });
        } else if (target2 instanceof PsiElement) {
            result2.put(target2, new GotoRelatedItem((PsiElement)target2, title));
        }
    }

    private static void addDataSourceItem(Map<DasObject, GotoRelatedItem> result2, DbDataSource target2, @NlsContexts.Separator String title, final @Nls @Nullable String containerName) {
        result2.put(target2, new GotoRelatedItem(target2, title){

            public void navigate() {
                DbElement dbElement = (DbElement)Objects.requireNonNull(this.getElement());
                DbNavigationUtils.navigateToDatabaseView(dbElement, true);
            }

            @Nls
            @Nullable
            public String getCustomContainerName() {
                return containerName;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

