/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGoToSymbolContributor;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.pom.Navigatable;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public final class DbGoToTableContributor
extends DbGoToSymbolContributor {
    @Override
    protected boolean processNamesInDataSource(@NotNull DbDataSource ds, @NotNull Processor<? super String> processor2) {
        if (ds == null) {
            DbGoToTableContributor.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(1);
        }
        if (!super.processNamesInDataSource(ds, processor2)) {
            return false;
        }
        return DbGoToTableContributor.getVirtualViewNames(ds).processEach(processor2);
    }

    @NotNull
    private static JBIterable<String> getVirtualViewNames(@NotNull DbDataSource ds) {
        LocalDataSource lds;
        if (ds == null) {
            DbGoToTableContributor.$$$reportNull$$$0(2);
        }
        if ((lds = DbImplUtilCore.getMaybeLocalDataSource(ds)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGoToTableContributor.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = ModelExternalData.getInstance().getDataSourceData(lds, false).flatten(d2 -> d2.objSet.values()).filter(ModelExternalData.ViewDesc.class).map(v2 -> v2.name);
        if (jBIterable == null) {
            DbGoToTableContributor.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<DasObject> filterObjects(@NotNull Iterable<DasObject> objects2) {
        if (objects2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = super.filterObjects(objects2).filter(o2 -> DbGoToTableContributor.isGoToTableTarget(o2));
        if (jBIterable == null) {
            DbGoToTableContributor.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    protected Iterable<DasObject> getObjectsByNameInDataSource(@NotNull DbDataSource dataSource2, @NotNull String name2) {
        if (dataSource2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(8);
        }
        Iterable<DasObject> objects2 = super.getObjectsByNameInDataSource(dataSource2, name2);
        JBIterable jBIterable = DbGoToTableContributor.getAllVirtualViewsInDataSource(dataSource2, name2).append(objects2);
        if (jBIterable == null) {
            DbGoToTableContributor.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getAllVirtualViewsInDataSource(@NotNull DbDataSource dataSource2, @NotNull String name2) {
        BasicModel model2;
        if (dataSource2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(11);
        }
        if ((model2 = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class)) == null || !DbGoToTableContributor.getVirtualViewNames(dataSource2).contains((Object)name2)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGoToTableContributor.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        DatabaseCoreUiService us = DatabaseCoreUiService.getInstance();
        JBIterable jBIterable = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)model2.getRoot()), DbImplUtilCore.getIntrospectionScope(dataSource2)).expandAndFilter(o2 -> o2 instanceof BasicRoot || o2 instanceof BasicNamespace)).traverse().filter(BasicElement.class).flatten(n -> DbGoToTableContributor.getVirtualViewsIn(us, dataSource2, n, name2));
        if (jBIterable == null) {
            DbGoToTableContributor.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getVirtualViewsIn(@NotNull DatabaseCoreUiService uiService, @NotNull DbDataSource dataSource2, @NotNull BasicElement namespace, @NotNull String name2) {
        if (uiService == null) {
            DbGoToTableContributor.$$$reportNull$$$0(14);
        }
        if (dataSource2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(15);
        }
        if (namespace == null) {
            DbGoToTableContributor.$$$reportNull$$$0(16);
        }
        if (name2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(17);
        }
        if (!DbGoToTableContributor.hasVirtualViewsWithName(dataSource2, namespace, name2)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGoToTableContributor.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        JBIterable jBIterable = uiService.treeChildren(dataSource2.getProject(), namespace, DvFamilyId.VIRTUAL_VIEW.getFakeKind()).filter(DasObject.class);
        if (jBIterable == null) {
            DbGoToTableContributor.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    private static boolean hasVirtualViewsWithName(@NotNull DbDataSource dataSource2, @NotNull BasicElement namespace, @NotNull String name2) {
        LocalDataSource lds;
        if (dataSource2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(20);
        }
        if (namespace == null) {
            DbGoToTableContributor.$$$reportNull$$$0(21);
        }
        if (name2 == null) {
            DbGoToTableContributor.$$$reportNull$$$0(22);
        }
        if ((lds = DbImplUtilCore.getMaybeLocalDataSource(dataSource2)) == null) {
            return false;
        }
        BasicMetaObject vvMeta = (BasicMetaObject)ContainerUtil.find(VmModelContextFactory.createContextVmMetaObjects(namespace.getMetaObject()), m -> m.kind == DvFamilyId.VIRTUAL_VIEW.getFakeKind());
        if (vvMeta == null) {
            return false;
        }
        VmModelContextFactory.VmExtractor extractor = VmModelContextFactory.createVirtualObjectsExtractor(vvMeta);
        if (extractor == null) {
            return false;
        }
        return extractor.extractData(lds, namespace).filter(ModelExternalData.ViewDesc.class).filter(vd -> vd.name.equals(name2)).isNotEmpty();
    }

    public static boolean isGoToTableTarget(DasObject o2) {
        if (o2 instanceof DasDataSource) {
            return true;
        }
        if (DbImplUtilCore.isDataTable(o2.getKind())) {
            return true;
        }
        if (o2.getKind() == ObjectKind.SYNONYM) {
            return true;
        }
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(o2);
        if (!(basic instanceof BasicSourceAware)) {
            return false;
        }
        BasicMetaObject<BasicSourceAware> parent2 = basic.getMetaObject().getParent();
        return parent2 == null || !parent2.kindOf(BasicSourceAware.class) || DbImplUtilCore.isDataTable(o2.getKind());
    }

    @Override
    @Nullable
    protected NavigationItem getNavigationItem(DbDataSource dataSource2, DasObject o2) {
        NavigationItem item = super.getNavigationItem(dataSource2, o2);
        DbElement element2 = item == null ? null : DbNavigationUtils.extractDbElement((Navigatable)item);
        return element2 == null ? item : DbNavigationUtils.createFromTreeNavigatable(element2);
    }

    @NotNull
    public String getElementKind() {
        String string = DatabaseBundle.message("go.to.table.kind.text", new Object[0]);
        if (string == null) {
            DbGoToTableContributor.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public List<String> getElementKindsPluralized() {
        List<String> list = List.of(DatabaseBundle.message("go.to.table.kind.text.pluralized.tables", new Object[0]), DatabaseBundle.message("go.to.table.kind.text.pluralized.views", new Object[0]), DatabaseBundle.message("go.to.table.kind.text.pluralized.routines", new Object[0]));
        if (list == null) {
            DbGoToTableContributor.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public String getTabTitlePluralized() {
        String string = DatabaseBundle.message("go.to.table.title", new Object[0]);
        if (string == null) {
            DbGoToTableContributor.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public Language getElementLanguage() {
        return SqlLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 9, 12, 13, 18, 19, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbGoToTableContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiService";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbGoToTableContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualViewNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterObjects";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInDataSource";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVirtualViewsInDataSource";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualViewsIn";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKindsPluralized";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitlePluralized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNamesInDataSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualViewNames";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterObjects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInDataSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllVirtualViewsInDataSource";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualViewsIn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasVirtualViewsWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 9, 12, 13, 18, 19, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

