/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbBookmark;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.view.DataSourceNode;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0019H\u0002J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/psi/DbBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "compare", "", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "Lcom/intellij/database/psi/DbBookmark;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "dasObject", "Lcom/intellij/database/model/DasObject;", "element", "Lcom/intellij/database/psi/DbElement;", "path", "Ljavax/swing/tree/TreePath;", "context", "", "url", "", "id", "Lcom/intellij/database/util/ObjectPath;", "map", "", "getProject", "getWeight", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbBookmarkProvider.kt\ncom/intellij/database/psi/DbBookmarkProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class DbBookmarkProvider
implements BookmarkProvider {
    @NotNull
    private final Project project;

    public DbBookmarkProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        SingleAlarm alarm2 = new SingleAlarm(() -> DbBookmarkProvider._init_$lambda$0(this), 300, (Disposable)this.project.getMessageBus(), null, null, 24, null);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<DbPsiFacade.Listener> topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> DbBookmarkProvider._init_$lambda$1(alarm2, arg_0));
    }

    public int getWeight() {
        return 300;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        DbBookmark dbBookmark = bookmark1 instanceof DbBookmark ? (DbBookmark)bookmark1 : null;
        if (dbBookmark == null) {
            return bookmark2 instanceof DbBookmark ? -1 : 0;
        }
        DbBookmark dbBookmark1 = dbBookmark;
        DbBookmark dbBookmark2 = bookmark2 instanceof DbBookmark ? (DbBookmark)bookmark2 : null;
        if (dbBookmark2 == null) {
            return 1;
        }
        DbBookmark dbBookmark22 = dbBookmark2;
        int result2 = StringUtil.naturalCompare((String)dbBookmark1.getDataSourceId(), (String)dbBookmark22.getDataSourceId());
        if (result2 != 0) {
            return result2;
        }
        ObjectPath objectPath = dbBookmark1.getPath();
        if (objectPath == null) {
            return dbBookmark22.getPath() != null ? -1 : 0;
        }
        ObjectPath path1 = objectPath;
        ObjectPath objectPath2 = dbBookmark22.getPath();
        if (objectPath2 == null) {
            return 1;
        }
        ObjectPath path2 = objectPath2;
        return 0;
    }

    @Nullable
    public DbBookmark createBookmark(@NotNull Map<String, String> map2) {
        DbBookmark dbBookmark;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        String string = map2.get("url");
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            dbBookmark = this.createBookmark(it2);
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    @Nullable
    public DbBookmark createBookmark(@Nullable Object context) {
        DbBookmark dbBookmark;
        Object object = context;
        if (object instanceof TreePath) {
            dbBookmark = this.createBookmark((TreePath)context);
        } else if (object instanceof DbElement) {
            dbBookmark = this.createBookmark((DbElement)context);
        } else if (object instanceof AbstractUrlFavoriteAdapter) {
            if (Intrinsics.areEqual((Object)((AbstractUrlFavoriteAdapter)context).getNodeProvider().getFavoriteTypeId(), (Object)"database")) {
                String string = ((AbstractUrlFavoriteAdapter)context).getURL();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
                dbBookmark = this.createBookmark(string);
            } else {
                dbBookmark = null;
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    private final DbBookmark createBookmark(String id, ObjectPath path) {
        return new DbBookmark(this, id, path);
    }

    private final DbBookmark createBookmark(DasDataSource dataSource2, DasObject dasObject) {
        String string = dataSource2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return this.createBookmark(string, ObjectPaths.of(dasObject));
    }

    private final DbBookmark createBookmark(String url) {
        DbBookmark dbBookmark;
        DatabaseVirtualFileSystem.FileDesc fileDesc = DatabaseVirtualFileSystem.parseUrl(url);
        if (fileDesc != null) {
            DatabaseVirtualFileSystem.FileDesc $this$createBookmark_u24lambda_u243 = fileDesc;
            boolean bl = false;
            if ($this$createBookmark_u24lambda_u243.family != null) {
                dbBookmark = null;
            } else {
                String string = $this$createBookmark_u24lambda_u243.dataSourceId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSourceId");
                dbBookmark = this.createBookmark(string, $this$createBookmark_u24lambda_u243.path);
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    private final DbBookmark createBookmark(TreePath path) {
        DbBookmark dbBookmark;
        Object node2 = path.getLastPathComponent();
        if (node2 instanceof DataSourceNode) {
            dbBookmark = this.createBookmark(((DataSourceNode)node2).rawDataSource, null);
        } else if (node2 instanceof DasObject) {
            DataSourceNode dataSourceNode = (DataSourceNode)TreeUtil.findObjectInPath((TreePath)path, DataSourceNode.class);
            if (dataSourceNode != null) {
                DataSourceNode $this$createBookmark_u24lambda_u244 = dataSourceNode;
                boolean bl = false;
                dbBookmark = this.createBookmark($this$createBookmark_u24lambda_u244.rawDataSource, (DasObject)node2);
            } else {
                dbBookmark = null;
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    /*
     * WARNING - void declaration
     */
    private final DbBookmark createBookmark(DbElement element2) {
        void it2;
        DbElement dbElement;
        DbDataSource dbDataSource = element2.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbElement dbElement2 = dbElement = element2;
        DasDataSource dasDataSource = dbDataSource;
        DbBookmarkProvider dbBookmarkProvider = this;
        boolean bl = false;
        boolean bl2 = !(it2 instanceof DbDataSource);
        return dbBookmarkProvider.createBookmark(dasDataSource, bl2 ? dbElement : null);
    }

    private static final void _init_$lambda$0(DbBookmarkProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((BookmarksListener)messageBus.syncPublisher(topic)).structureChanged(null);
    }

    private static final void _init_$lambda$1(SingleAlarm $alarm, DbDataSource it2) {
        Intrinsics.checkNotNullParameter((Object)$alarm, (String)"$alarm");
        SingleAlarm.cancelAndRequest$default((SingleAlarm)$alarm, (boolean)false, (int)1, null);
    }
}

