/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.serialization.ExportException;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelExporter {
    private static final Logger LOG = Logger.getInstance(ModelExporter.class);
    public boolean persistent;
    public Int2ObjectMap<Couple<Version>> versions;

    public void saveModel(@NotNull BasicModel model2, @NotNull HierarchicalStreamWriter writer, @Nullable TreePattern scope) throws ExportException {
        if (model2 == null) {
            ModelExporter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(1);
        }
        ModelMem modelMem = model2.read(r -> this.exportModel((BasicModel)r, scope));
        this.serializeModel(modelMem, writer);
    }

    public ModelMem exportModel(@NotNull BasicModel model2, @Nullable TreePattern scope) {
        if (model2 == null) {
            ModelExporter.$$$reportNull$$$0(2);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(model2.getDbms());
        mm.setVersion(ModelSerializationVersions.CURRENT_VERSION);
        Map<BasicElement, Integer> nodes = ModelExporter.orderNodes(model2.getRoot(), scope);
        for (BasicElement node2 : nodes.keySet()) {
            ModelElementMem om = this.exportElement(node2, nodes);
            mm.getNodes().add(om);
        }
        return mm;
    }

    private static Map<BasicElement, Integer> orderNodes(BasicRoot root2, @Nullable TreePattern scope) {
        int counter = 0;
        JBTreeTraverser<BasicElement> traverser2 = ModelExporter.traverser(root2, scope);
        LinkedHashMap<BasicElement, Integer> nodes = new LinkedHashMap<BasicElement, Integer>();
        for (BasicElement object : traverser2.bfsTraversal()) {
            Integer id = ++counter;
            nodes.put(object, id);
        }
        return nodes;
    }

    @NotNull
    private static JBTreeTraverser<BasicElement> traverser(BasicRoot root2, @Nullable TreePattern scope) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(e2 -> e2.getChildren()).withRoot((Object)root2)).expand(e2 -> DataSourceSchemaMapping.isIntrospected(scope, e2));
        if (jBTreeTraverser == null) {
            ModelExporter.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    private ModelElementMem exportElement(BasicElement element2, Map<BasicElement, Integer> nodes) {
        Integer parentId;
        Integer id = nodes.get(element2);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        BasicElement parentElement = element2.getParent();
        Integer n = parentId = parentElement != null ? nodes.get(parentElement) : null;
        assert (element2 instanceof BasicRoot == (parentElement == null));
        ImmutableList<MutableNameAndValue> properties2 = this.exportElementProperties(element2);
        String elementName = element2 instanceof BasicNamedElement ? element2.getRealName() : null;
        return new ModelElementMem(id, parentId, element2.getKind().code(), elementName, (List<MutableNameAndValue>)properties2);
    }

    public ImmutableList<MutableNameAndValue> exportElementProperties(BasicElement element2) {
        ImmutableList.Builder b2 = new ImmutableList.Builder();
        element2.exportProperties((name2, value2) -> {
            if (value2 != null) {
                if (this.acceptsProperty(element2, name2) && !name2.equalsIgnoreCase("name")) {
                    b2.add((Object)new MutableNameAndValue(name2, (String)value2));
                }
            } else {
                LOG.warn("Attempted to export null property " + name2 + " when exporting element " + element2.identity());
            }
        });
        return b2.build();
    }

    protected boolean acceptsProperty(BasicElement element2, String name2) {
        return true;
    }

    protected void serializeModel(@NotNull ModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            ModelExporter.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(5);
        }
        writer.startNode("database-model");
        writer.addAttribute("serializer", "dbm");
        writer.addAttribute("dbms", mem.getDbms().getName());
        writer.addAttribute("family-id", mem.getDbms().getName());
        if (!this.persistent) {
            writer.addAttribute("format-version", ModelSerializationVersions.CURRENT_VERSION.toString());
        }
        for (Map.Entry<String, String> property : mem.getProperties().entrySet()) {
            writer.addAttribute(property.getKey(), property.getValue());
        }
        if (!this.persistent) {
            for (ModelElementMem object : mem.getNodes()) {
                this.serializeNode(object, writer, null);
            }
        } else {
            List[] index2 = new List[mem.getNodes().size() + 1];
            for (ModelElementMem node2 : mem.getNodes()) {
                int idx = (Integer)ObjectUtils.notNull((Object)node2.getParentId(), (Object)0);
                ArrayList<ModelElementMem> children2 = index2[idx];
                if (children2 == null) {
                    children2 = index2[idx] = new ArrayList<ModelElementMem>();
                }
                children2.add(node2);
            }
            for (ModelElementMem root2 : ModelExporter.children(index2, null)) {
                this.serializeNode(root2, writer, (Function<ModelElementMem, Iterable<ModelElementMem>>)((Function)n -> ModelExporter.children(index2, n)));
            }
        }
        writer.endNode();
    }

    private static Iterable<ModelElementMem> children(List<ModelElementMem>[] index2, ModelElementMem obj2) {
        int idx = obj2 == null ? 0 : Objects.requireNonNull(obj2.getId());
        return (Iterable)ObjectUtils.notNull(index2[idx], Collections.emptyList());
    }

    private void serializeNode(ModelElementMem node2, HierarchicalStreamWriter writer, Function<ModelElementMem, Iterable<ModelElementMem>> children2) {
        writer.startNode(node2.getKind());
        if (!this.persistent) {
            writer.addAttribute("id", Integer.toString(Objects.requireNonNull(node2.getId())));
            Integer parentId = node2.getParentId();
            if (parentId != null) {
                writer.addAttribute("parent", Integer.toString(parentId));
            }
        } else {
            Couple parentVersions;
            Couple versions = this.versions == null ? null : (Couple)this.versions.get(Objects.requireNonNullElse(node2.getId(), 0).intValue());
            Couple couple = parentVersions = this.versions == null ? null : (Couple)this.versions.get(Objects.requireNonNullElse(node2.getParentId(), 0).intValue());
            if (Objects.equals(versions, parentVersions)) {
                versions = null;
            }
            if (versions != null && !((Version)versions.first).equals(Version.ZERO)) {
                writer.addAttribute("from-version", ((Version)versions.first).toString());
            }
            if (versions != null && !((Version)versions.second).equals(Version.INFINITY)) {
                writer.addAttribute("to-version", ((Version)versions.second).toString());
            }
        }
        if (node2.getName() != null) {
            writer.addAttribute("name", node2.getName());
        }
        for (MutableNameAndValue property : node2.getProperties()) {
            if (property.getName().equalsIgnoreCase("name")) continue;
            ModelExporter.serializeProperty(property, writer);
        }
        if (this.persistent && children2 != null) {
            for (ModelElementMem child : (Iterable)children2.fun((Object)node2)) {
                this.serializeNode(child, writer, children2);
            }
        }
        writer.endNode();
    }

    private static void serializeProperty(MutableNameAndValue property, HierarchicalStreamWriter writer) {
        writer.startNode(property.getName());
        writer.setValue(property.getValue());
        writer.endNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportModel";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

