/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.BasicPaths;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicInlineObjectReference
implements BasicReference {
    public final BasicDataObject myTarget;

    public static BasicInlineObjectReference create(@Nullable BasicElement target2) {
        return BasicInlineObjectReference.create((BasicDataObject)target2, true);
    }

    public static BasicInlineObjectReference createMutable(@Nullable BasicElement target2) {
        return BasicInlineObjectReference.create((BasicDataObject)target2, false);
    }

    private static BasicInlineObjectReference create(@Nullable BasicDataObject target2, boolean freeze) {
        if (target2 != null) {
            if (freeze != target2.isFrozen()) {
                target2 = target2.copy();
            }
            if (freeze) {
                target2.freeze();
            }
        }
        return target2 == null ? null : new BasicInlineObjectReference(target2);
    }

    private BasicInlineObjectReference(@NotNull BasicDataObject target2) {
        if (target2 == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(0);
        }
        this.myTarget = target2;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myTarget.getName();
    }

    @Override
    public boolean isPortable() {
        return true;
    }

    @Override
    public boolean isPlain() {
        return !BasicPaths.isQuoted(this.myTarget);
    }

    @Override
    @NotNull
    public ObjectKind getKind(@NotNull BasicMetaReferenceDesc<?, ?> meta) {
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(1);
        }
        ObjectKind objectKind = this.myTarget.getKind();
        if (objectKind == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(2);
        }
        return objectKind;
    }

    @Override
    public long getObjectId() {
        BasicIdentifiedElement identifiedElement = (BasicIdentifiedElement)ObjectUtils.tryCast((Object)this.myTarget, BasicIdentifiedElement.class);
        return identifiedElement != null ? identifiedElement.getObjectId() : Long.MIN_VALUE;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof BasicInlineObjectReference)) {
            return false;
        }
        BasicInlineObjectReference reference = (BasicInlineObjectReference)o2;
        return BasicMetaUtils.equals(this.myTarget, reference.myTarget) && this.myTarget.isFrozen() == reference.myTarget.isFrozen();
    }

    public int hashCode() {
        return BasicMetaUtils.hashCode(this.myTarget) + (this.myTarget.isFrozen() ? 1 : 0);
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        if (source == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(5);
        }
        return BasicMetaUtils.equals(this.myTarget, target2);
    }

    @Override
    @Nullable
    public <T extends BasicElement> T getInlineData(@NotNull BasicMetaReferenceDesc<?, T> meta) {
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(6);
        }
        boolean isOk = ArrayUtil.indexOf((Object[])meta.targets, this.myTarget.getMetaObject()) != -1;
        BasicDataObject res2 = isOk ? this.myTarget : null;
        return (T)res2;
    }

    @Override
    @Nullable
    public <S extends BasicElement, T extends BasicElement> T resolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(7);
        }
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(8);
        }
        if (assistant == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(10);
        }
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(11);
        }
        if (assistant == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer2) {
        if (consumer2 == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(14);
        }
        NameValueConsumer<String> wrapped = (name2, value2) -> consumer2.accept(name2, (String)value2);
        wrapped.accept("Inline", "1");
        this.myTarget.exportProperties(wrapped);
    }

    @Override
    public boolean isEquivalent(BasicReference ref2) {
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)ref2.getName());
    }

    public String toString() {
        return "resolved=" + this.myTarget;
    }

    @Nullable
    public static BasicInlineObjectReference importProperties(@NotNull BasicMetaObject<?> meta, @NotNull BasicMetaId refId, @NotNull NameValueGetter<String> properties2) {
        if (meta == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(15);
        }
        if (refId == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(16);
        }
        if (properties2 == null) {
            BasicInlineObjectReference.$$$reportNull$$$0(17);
        }
        if (properties2.get("Inline") == null) {
            return null;
        }
        BasicMetaReferenceDesc<?, ?> desc = BasicMetaUtils.getReferenceDesc(meta.getField(refId));
        if (desc == null) {
            throw new AssertionError((Object)("Reference expected, got " + refId));
        }
        if (desc.targets.length != 1) {
            throw new AssertionError((Object)("One target expected for " + refId + ", got " + Arrays.toString(desc.targets)));
        }
        BasicModElement res2 = (BasicModElement)desc.targets[0].newDataObject();
        res2.importProperties(properties2);
        BasicDataObject.freeze(res2);
        return BasicInlineObjectReference.create(res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicInlineObjectReference";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicInlineObjectReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInlineData";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13 -> new IllegalStateException(string);
        };
    }
}

